/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.codehaus.plexus.interpolation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.kotlin.org.codehaus.plexus.interpolation.InterpolationCycleException;
import org.jetbrains.kotlin.org.codehaus.plexus.interpolation.InterpolationException;
import org.jetbrains.kotlin.org.codehaus.plexus.interpolation.InterpolationPostProcessor;
import org.jetbrains.kotlin.org.codehaus.plexus.interpolation.RecursionInterceptor;
import org.jetbrains.kotlin.org.codehaus.plexus.interpolation.SimpleRecursionInterceptor;
import org.jetbrains.kotlin.org.codehaus.plexus.interpolation.ValueSource;

public class StringSearchInterpolator {
    private Map<String, Object> existingAnswers = new HashMap<String, Object>();
    private List<ValueSource> valueSources = new ArrayList<ValueSource>();
    private List<InterpolationPostProcessor> postProcessors = new ArrayList<InterpolationPostProcessor>();
    private boolean cacheAnswers = false;
    private String startExpr = "${";
    private String endExpr = "}";
    private String escapeString;

    public void addValueSource(ValueSource valueSource) {
        this.valueSources.add(valueSource);
    }

    public void addPostProcessor(InterpolationPostProcessor postProcessor) {
        this.postProcessors.add(postProcessor);
    }

    public String interpolate(String input) throws InterpolationException {
        return this.interpolate(input, new SimpleRecursionInterceptor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String interpolate(String input, RecursionInterceptor recursionInterceptor) throws InterpolationException {
        try {
            String string2 = this.interpolate(input, recursionInterceptor, new HashSet<String>());
            return string2;
        }
        finally {
            if (!this.cacheAnswers) {
                this.existingAnswers.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String interpolate(String input, RecursionInterceptor recursionInterceptor, Set<String> unresolvable) throws InterpolationException {
        if (input == null) {
            return "";
        }
        int endIdx = -1;
        int startIdx = input.indexOf(this.startExpr, endIdx + 1);
        if (startIdx > -1) {
            StringBuilder result2 = new StringBuilder(input.length() * 2);
            do {
                result2.append(input, endIdx + 1, startIdx);
                endIdx = input.indexOf(this.endExpr, startIdx + 1);
                if (endIdx < 0) break;
                String wholeExpr = input.substring(startIdx, endIdx + this.endExpr.length());
                String realExpr = wholeExpr.substring(this.startExpr.length(), wholeExpr.length() - this.endExpr.length());
                if (startIdx >= 0 && this.escapeString != null && this.escapeString.length() > 0) {
                    String escape;
                    int startEscapeIdx;
                    int n = startEscapeIdx = startIdx == 0 ? 0 : startIdx - this.escapeString.length();
                    if (startEscapeIdx >= 0 && this.escapeString.equals(escape = input.substring(startEscapeIdx, startIdx))) {
                        result2.append(wholeExpr);
                        result2.replace(startEscapeIdx, startEscapeIdx + this.escapeString.length(), "");
                        continue;
                    }
                }
                boolean resolved = false;
                if (!unresolvable.contains(wholeExpr)) {
                    if (realExpr.startsWith(".")) {
                        realExpr = realExpr.substring(1);
                    }
                    if (recursionInterceptor.hasRecursiveExpression(realExpr)) {
                        throw new InterpolationCycleException(recursionInterceptor, realExpr, wholeExpr);
                    }
                    recursionInterceptor.expressionResolutionStarted(realExpr);
                    try {
                        Object value2 = this.existingAnswers.get(realExpr);
                        Object bestAnswer = null;
                        for (ValueSource valueSource : this.valueSources) {
                            if (value2 != null) break;
                            value2 = valueSource.getValue(realExpr);
                            if (value2 == null || !value2.toString().contains(wholeExpr)) continue;
                            bestAnswer = value2;
                            value2 = null;
                        }
                        if (value2 == null && bestAnswer != null) {
                            throw new InterpolationCycleException(recursionInterceptor, realExpr, wholeExpr);
                        }
                        if (value2 != null) {
                            value2 = this.interpolate(String.valueOf(value2), recursionInterceptor, unresolvable);
                            if (this.postProcessors != null && !this.postProcessors.isEmpty()) {
                                for (InterpolationPostProcessor postProcessor : this.postProcessors) {
                                    Object newVal = postProcessor.execute(realExpr, value2);
                                    if (newVal == null) continue;
                                    value2 = newVal;
                                    break;
                                }
                            }
                            result2.append(String.valueOf(value2));
                            resolved = true;
                        } else {
                            unresolvable.add(wholeExpr);
                        }
                    }
                    finally {
                        recursionInterceptor.expressionResolutionFinished(realExpr);
                    }
                }
                if (!resolved) {
                    result2.append(wholeExpr);
                }
                if (endIdx <= -1) continue;
                endIdx += this.endExpr.length() - 1;
            } while ((startIdx = input.indexOf(this.startExpr, endIdx + 1)) > -1);
            if (endIdx == -1 && startIdx > -1) {
                result2.append(input, startIdx, input.length());
            } else if (endIdx < input.length()) {
                result2.append(input, endIdx + 1, input.length());
            }
            return result2.toString();
        }
        return input;
    }

    public void setCacheAnswers(boolean cacheAnswers) {
        this.cacheAnswers = cacheAnswers;
    }
}

