/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.internal.impl.synccontext.named;

import java.util.Map;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.synccontext.named.NameMapper;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.synccontext.named.NamedLockFactorySelector;
import org.jetbrains.kotlin.org.eclipse.aether.named.NamedLockFactory;

public abstract class NamedLockFactorySelectorSupport
implements NamedLockFactorySelector {
    private final NamedLockFactory namedLockFactory;
    private final NameMapper nameMapper;

    public NamedLockFactorySelectorSupport(Map<String, NamedLockFactory> factories, String defaultFactoryName, Map<String, NameMapper> nameMappers, String defaultNameMapperName) {
        this.namedLockFactory = this.selectNamedLockFactory(factories, this.getFactoryName(defaultFactoryName));
        this.nameMapper = this.selectNameMapper(nameMappers, this.getNameMapperName(defaultNameMapperName));
    }

    @Override
    public NamedLockFactory getSelectedNamedLockFactory() {
        return this.namedLockFactory;
    }

    @Override
    public NameMapper getSelectedNameMapper() {
        return this.nameMapper;
    }

    protected String getFactoryName(String defaultFactoryName) {
        return System.getProperty("aether.syncContext.named.factory", defaultFactoryName);
    }

    protected String getNameMapperName(String defaultNameMapperName) {
        return System.getProperty("aether.syncContext.named.nameMapper", defaultNameMapperName);
    }

    private NamedLockFactory selectNamedLockFactory(Map<String, NamedLockFactory> factories, String factoryName) {
        NamedLockFactory factory2 = factories.get(factoryName);
        if (factory2 == null) {
            throw new IllegalArgumentException("Unknown NamedLockFactory name: " + factoryName + ", known ones: " + factories.keySet());
        }
        return factory2;
    }

    private NameMapper selectNameMapper(Map<String, NameMapper> nameMappers, String mapperName) {
        NameMapper nameMapper = nameMappers.get(mapperName);
        if (nameMapper == null) {
            throw new IllegalArgumentException("Unknown NameMapper name: " + mapperName + ", known ones: " + nameMappers.keySet());
        }
        return nameMapper;
    }
}

