/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.util.graph.transformer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.jetbrains.kotlin.org.eclipse.aether.RepositoryException;
import org.jetbrains.kotlin.org.eclipse.aether.collection.UnsolvableVersionConflictException;
import org.jetbrains.kotlin.org.eclipse.aether.graph.DependencyNode;
import org.jetbrains.kotlin.org.eclipse.aether.util.graph.transformer.ConflictResolver;
import org.jetbrains.kotlin.org.eclipse.aether.util.graph.transformer.NearestVersionSelector$$Lambda$0;
import org.jetbrains.kotlin.org.eclipse.aether.util.graph.visitor.PathRecordingDependencyVisitor;
import org.jetbrains.kotlin.org.eclipse.aether.version.Version;
import org.jetbrains.kotlin.org.eclipse.aether.version.VersionConstraint;

public final class NearestVersionSelector
extends ConflictResolver.VersionSelector {
    @Override
    public void selectVersion(ConflictResolver.ConflictContext context) throws RepositoryException {
        ConflictGroup group = new ConflictGroup();
        for (ConflictResolver.ConflictItem item : context.getItems()) {
            boolean hardConstraint;
            DependencyNode node = item.getNode();
            VersionConstraint constraint2 = node.getVersionConstraint();
            boolean backtrack = false;
            boolean bl = hardConstraint = constraint2.getRange() != null;
            if (hardConstraint && group.constraints.add(constraint2) && group.winner != null && !constraint2.containsVersion(group.winner.getNode().getVersion())) {
                backtrack = true;
            }
            if (this.isAcceptable(group, node.getVersion())) {
                group.candidates.add(item);
                if (backtrack) {
                    this.backtrack(group, context);
                    continue;
                }
                if (group.winner != null && !this.isNearer(item, group.winner)) continue;
                group.winner = item;
                continue;
            }
            if (!backtrack) continue;
            this.backtrack(group, context);
        }
        context.setWinner(group.winner);
    }

    private void backtrack(ConflictGroup group, ConflictResolver.ConflictContext context) throws UnsolvableVersionConflictException {
        group.winner = null;
        Iterator<ConflictResolver.ConflictItem> it = group.candidates.iterator();
        while (it.hasNext()) {
            ConflictResolver.ConflictItem candidate2 = it.next();
            if (!this.isAcceptable(group, candidate2.getNode().getVersion())) {
                it.remove();
                continue;
            }
            if (group.winner != null && !this.isNearer(candidate2, group.winner)) continue;
            group.winner = candidate2;
        }
        if (group.winner == null) {
            throw this.newFailure(context);
        }
    }

    private boolean isAcceptable(ConflictGroup group, Version version) {
        for (VersionConstraint constraint2 : group.constraints) {
            if (constraint2.containsVersion(version)) continue;
            return false;
        }
        return true;
    }

    private boolean isNearer(ConflictResolver.ConflictItem item1, ConflictResolver.ConflictItem item2) {
        if (item1.isSibling(item2)) {
            return item1.getNode().getVersion().compareTo(item2.getNode().getVersion()) > 0;
        }
        return item1.getDepth() < item2.getDepth();
    }

    private UnsolvableVersionConflictException newFailure(ConflictResolver.ConflictContext context) {
        ConflictResolver.ConflictContext conflictContext = context;
        NearestVersionSelector$$Lambda$0 filter2 = new NearestVersionSelector$$Lambda$0(conflictContext);
        PathRecordingDependencyVisitor visitor2 = new PathRecordingDependencyVisitor(filter2);
        context.getRoot().accept(visitor2);
        return new UnsolvableVersionConflictException(visitor2.getPaths());
    }

    private static /* synthetic */ boolean lambda$newFailure$0(ConflictResolver.ConflictContext context, DependencyNode node, List parents2) {
        Objects.requireNonNull(node, "node cannot be null");
        Objects.requireNonNull(parents2, "parents cannot be null");
        return context.isIncluded(node);
    }

    static /* synthetic */ boolean accessor$NearestVersionSelector$lambda0(ConflictResolver.ConflictContext conflictContext, DependencyNode dependencyNode, List list2) {
        return NearestVersionSelector.lambda$newFailure$0(conflictContext, dependencyNode, list2);
    }

    static final class ConflictGroup {
        final Collection<VersionConstraint> constraints = new HashSet<VersionConstraint>();
        final Collection<ConflictResolver.ConflictItem> candidates = new ArrayList<ConflictResolver.ConflictItem>(64);
        ConflictResolver.ConflictItem winner;

        ConflictGroup() {
        }

        public String toString() {
            return String.valueOf(this.winner);
        }
    }
}

