/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.sisu.space;

import java.lang.annotation.Annotation;
import java.lang.annotation.IncompleteAnnotationException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.inject.Provider;
import org.jetbrains.kotlin.com.google.inject.Binder;
import org.jetbrains.kotlin.com.google.inject.Key;
import org.jetbrains.kotlin.com.google.inject.Module;
import org.jetbrains.kotlin.com.google.inject.Scopes;
import org.jetbrains.kotlin.com.google.inject.Singleton;
import org.jetbrains.kotlin.com.google.inject.TypeLiteral;
import org.jetbrains.kotlin.com.google.inject.binder.AnnotatedBindingBuilder;
import org.jetbrains.kotlin.com.google.inject.binder.ScopedBindingBuilder;
import org.jetbrains.kotlin.com.google.inject.name.Named;
import org.jetbrains.kotlin.com.google.inject.name.Names;
import org.jetbrains.kotlin.org.eclipse.sisu.EagerSingleton;
import org.jetbrains.kotlin.org.eclipse.sisu.Mediator;
import org.jetbrains.kotlin.org.eclipse.sisu.Typed;
import org.jetbrains.kotlin.org.eclipse.sisu.inject.Legacy;
import org.jetbrains.kotlin.org.eclipse.sisu.inject.TypeArguments;
import org.jetbrains.kotlin.org.eclipse.sisu.space.MediationListener;
import org.jetbrains.kotlin.org.eclipse.sisu.space.QualifiedTypeListener;
import org.jetbrains.kotlin.org.eclipse.sisu.space.WildcardKey;

public final class QualifiedTypeBinder
implements QualifiedTypeListener {
    private static final TypeLiteral<Object> OBJECT_TYPE_LITERAL;
    private static final boolean HAS_JSR299_TYPED;
    private final Binder rootBinder;
    private MediationListener mediationListener;
    private Object currentSource;
    private Binder binder;

    static {
        boolean hasJsr299Typed;
        try {
            hasJsr299Typed = javax.enterprise.inject.Typed.class.isAnnotation();
        }
        catch (LinkageError linkageError) {
            hasJsr299Typed = false;
        }
        HAS_JSR299_TYPED = hasJsr299Typed;
        OBJECT_TYPE_LITERAL = TypeLiteral.get(Object.class);
    }

    public QualifiedTypeBinder(Binder binder) {
        this.rootBinder = binder;
        this.binder = binder;
    }

    public void hear(Class qualifiedType, Object source) {
        if (this.currentSource != source) {
            if (source != null) {
                this.binder = this.rootBinder.withSource(source);
                this.currentSource = source;
            } else {
                this.binder = this.rootBinder;
                this.currentSource = null;
            }
        }
        if (!TypeArguments.isConcrete(qualifiedType)) {
            return;
        }
        if (Module.class.isAssignableFrom(qualifiedType)) {
            this.installModule(qualifiedType);
        } else if (Mediator.class.isAssignableFrom(qualifiedType)) {
            this.registerMediator(qualifiedType);
        } else if (org.jetbrains.kotlin.org.sonatype.inject.Mediator.class.isAssignableFrom(qualifiedType)) {
            this.registerLegacyMediator(qualifiedType);
        } else if (Provider.class.isAssignableFrom(qualifiedType)) {
            this.bindProviderType(qualifiedType);
        } else {
            this.bindQualifiedType(qualifiedType);
        }
    }

    private void installModule(Class<Module> moduleType) {
        Module module2 = this.newInstance(moduleType);
        if (module2 != null) {
            this.binder.install(module2);
        }
    }

    private void registerMediator(Class<Mediator> mediatorType) {
        TypeLiteral<?>[] args2 = QualifiedTypeBinder.resolveTypeArguments(mediatorType, Mediator.class);
        if (args2.length != 3) {
            this.binder.addError(mediatorType + " has wrong number of type arguments", new Object[0]);
        } else {
            Mediator mediator = this.newInstance(mediatorType);
            if (mediator != null) {
                this.mediate(QualifiedTypeBinder.watchedKey(args2[1], args2[0].getRawType()), mediator, args2[2].getRawType());
            }
        }
    }

    private void registerLegacyMediator(Class<org.jetbrains.kotlin.org.sonatype.inject.Mediator> mediatorType) {
        TypeLiteral<?>[] args2 = QualifiedTypeBinder.resolveTypeArguments(mediatorType, org.jetbrains.kotlin.org.sonatype.inject.Mediator.class);
        if (args2.length != 3) {
            this.binder.addError(mediatorType + " has wrong number of type arguments", new Object[0]);
        } else {
            Mediator mediator = Legacy.adapt(this.newInstance(mediatorType));
            if (mediator != null) {
                this.mediate(QualifiedTypeBinder.watchedKey(args2[1], args2[0].getRawType()), mediator, args2[2].getRawType());
            }
        }
    }

    private void mediate(Key watchedKey, Mediator mediator, Class watcherType) {
        if (this.mediationListener == null) {
            this.mediationListener = new MediationListener(this.binder);
            this.binder.bindListener(this.mediationListener, this.mediationListener);
        }
        this.mediationListener.mediate(watchedKey, mediator, watcherType);
    }

    private void bindProviderType(Class<?> providerType) {
        TypeLiteral<?>[] args2 = QualifiedTypeBinder.resolveTypeArguments(providerType, Provider.class);
        if (args2.length != 1) {
            this.binder.addError(providerType + " has wrong number of type arguments", new Object[0]);
        } else {
            this.binder.bind(providerType).in(Scopes.SINGLETON);
            Named bindingName = QualifiedTypeBinder.getBindingName(providerType);
            Class<?>[] types2 = QualifiedTypeBinder.getBindingTypes(providerType);
            Key<?> key = QualifiedTypeBinder.getBindingKey(args2[0], bindingName);
            ScopedBindingBuilder sbb = this.binder.bind(key).toProvider(providerType);
            if (QualifiedTypeBinder.isEagerSingleton(providerType)) {
                sbb.asEagerSingleton();
            } else if (QualifiedTypeBinder.isSingleton(providerType)) {
                sbb.in(Scopes.SINGLETON);
            }
            if (types2 != null) {
                Class<?>[] classArray = types2;
                int n = types2.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> bindingType = classArray[n2];
                    this.binder.bind(key.ofType(bindingType)).to(key);
                    ++n2;
                }
            }
        }
    }

    private void bindQualifiedType(Class<?> qualifiedType) {
        AnnotatedBindingBuilder<?> sbb = this.binder.bind(qualifiedType);
        if (QualifiedTypeBinder.isEagerSingleton(qualifiedType)) {
            sbb.asEagerSingleton();
        }
        Named bindingName = QualifiedTypeBinder.getBindingName(qualifiedType);
        Class<?>[] types2 = QualifiedTypeBinder.getBindingTypes(qualifiedType);
        if (types2 != null) {
            Key<Object> key = QualifiedTypeBinder.getBindingKey(OBJECT_TYPE_LITERAL, bindingName);
            Class<?>[] classArray = types2;
            int n = types2.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> bindingType = classArray[n2];
                this.binder.bind(key.ofType(bindingType)).to(qualifiedType);
                ++n2;
            }
        } else {
            this.binder.bind(WildcardKey.get(qualifiedType, bindingName)).to(qualifiedType);
        }
    }

    private <T> T newInstance(Class<T> type2) {
        try {
            final Constructor<T> ctor = type2.getDeclaredConstructor(new Class[0]);
            if (!ctor.isAccessible()) {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        ctor.setAccessible(true);
                        return null;
                    }
                });
            }
            return ctor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            Throwable cause = e instanceof InvocationTargetException ? e.getCause() : e;
            this.binder.addError("Error creating instance of: " + type2 + " reason: " + cause, new Object[0]);
            return null;
        }
        catch (LinkageError e) {
            this.binder.addError("Error creating instance of: " + type2 + " reason: " + e, new Object[0]);
            return null;
        }
    }

    private static TypeLiteral<?>[] resolveTypeArguments(Class<?> type2, Class<?> superType2) {
        return TypeArguments.get(TypeLiteral.get(type2).getSupertype(superType2));
    }

    private static <T> Key<T> getBindingKey(TypeLiteral<T> bindingType, Annotation qualifier) {
        return qualifier != null ? Key.get(bindingType, qualifier) : Key.get(bindingType);
    }

    private static Named getBindingName(Class<?> qualifiedType) {
        javax.inject.Named jsr330 = qualifiedType.getAnnotation(javax.inject.Named.class);
        if (jsr330 != null) {
            try {
                String name2 = jsr330.value();
                if (name2.length() > 0) {
                    return "default".equals(name2) ? null : Names.named(name2);
                }
            }
            catch (IncompleteAnnotationException incompleteAnnotationException) {}
        } else {
            String name3;
            Named guice = qualifiedType.getAnnotation(Named.class);
            if (guice != null && (name3 = guice.value()).length() > 0) {
                return "default".equals(name3) ? null : guice;
            }
        }
        if (qualifiedType.getSimpleName().startsWith("Default")) {
            return null;
        }
        return Names.named(qualifiedType.getName());
    }

    private static Class<?>[] getBindingTypes(Class<?> clazz) {
        Class<?> c = clazz;
        while (c != null && c != Object.class) {
            Object typed;
            if (HAS_JSR299_TYPED && (typed = c.getAnnotation(javax.enterprise.inject.Typed.class)) != null) {
                return typed.value().length > 0 ? typed.value() : c.getInterfaces();
            }
            typed = c.getAnnotation(Typed.class);
            if (typed != null) {
                return typed.value().length > 0 ? typed.value() : c.getInterfaces();
            }
            c = c.getSuperclass();
        }
        return null;
    }

    private static boolean isSingleton(Class<?> type2) {
        return type2.isAnnotationPresent(javax.inject.Singleton.class) || type2.isAnnotationPresent(Singleton.class);
    }

    private static boolean isEagerSingleton(Class<?> type2) {
        return type2.isAnnotationPresent(EagerSingleton.class) || type2.isAnnotationPresent(org.jetbrains.kotlin.org.sonatype.inject.EagerSingleton.class);
    }

    private static <T> Key<T> watchedKey(TypeLiteral<T> type2, Class qualifierType) {
        return qualifierType.isAnnotation() ? Key.get(type2, (Class<? extends Annotation>)qualifierType) : Key.get(type2);
    }
}

