/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.com.intellij.openapi.util.UserDataHolder;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtContextReceiverList;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDelegatedSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.checkers.InlineClassDeclarationCheckerKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\f\u0010\u000f\u001a\u00020\f*\u00020\u0010H\u0002J\f\u0010\u0011\u001a\u00020\f*\u00020\u0010H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/InlineClassDeclarationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "isParameterAcceptableForInlineClass", "", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "isGenericArrayOfTypeParameter", "Lorg/jetbrains/kotlin/types/KotlinType;", "isInapplicableParameterType", "frontend"})
public final class InlineClassDeclarationChecker
implements DeclarationChecker {
    @NotNull
    public static final InlineClassDeclarationChecker INSTANCE = new InlineClassDeclarationChecker();

    private InlineClassDeclarationChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        boolean bl;
        PsiElement inlineOrValueKeyword;
        BindingTrace trace;
        block25: {
            List<KotlinType> list2;
            PsiElement modalityModifier;
            PsiElement valueKeyword;
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
            Intrinsics.checkNotNullParameter(context, "context");
            if (!(declaration instanceof KtClass)) {
                return;
            }
            if (!(descriptor2 instanceof ClassDescriptor) || !((ClassDescriptor)descriptor2).isInline() && !((ClassDescriptor)descriptor2).isValue()) {
                return;
            }
            if (((ClassDescriptor)descriptor2).getKind() != ClassKind.CLASS) {
                return;
            }
            trace = context.getTrace();
            KtModifierList ktModifierList = ((KtClass)declaration).getModifierList();
            PsiElement psiElement = valueKeyword = ktModifierList != null ? ktModifierList.getModifier(KtTokens.VALUE_KEYWORD) : null;
            if (valueKeyword != null && !context.getLanguageVersionSettings().supportsFeature(LanguageFeature.JvmInlineValueClasses) && !context.getLanguageVersionSettings().supportsFeature(LanguageFeature.InlineClasses)) {
                trace.report(Errors.UNSUPPORTED_FEATURE.on(valueKeyword, TuplesKt.to(LanguageFeature.JvmInlineValueClasses, context.getLanguageVersionSettings())));
                return;
            }
            PsiElement psiElement2 = ((KtClass)declaration).getModifierList();
            if (psiElement2 == null || (psiElement2 = psiElement2.getModifier(KtTokens.INLINE_KEYWORD)) == null) {
                psiElement2 = valueKeyword;
            }
            if (!((inlineOrValueKeyword = psiElement2) != null)) {
                boolean $i$a$-require-InlineClassDeclarationChecker$check$232 = false;
                String $i$a$-require-InlineClassDeclarationChecker$check$232 = "Declaration of inline class must have 'inline' keyword";
                throw new IllegalArgumentException($i$a$-require-InlineClassDeclarationChecker$check$232.toString());
            }
            if (((ClassDescriptor)descriptor2).isInner() || DescriptorUtils.isLocal(descriptor2)) {
                trace.report(Errors.VALUE_CLASS_NOT_TOP_LEVEL.on(inlineOrValueKeyword));
                return;
            }
            if (!((Collection)((KtClass)declaration).getContextReceivers()).isEmpty()) {
                KtContextReceiverList contextReceiverList = ((KtClass)declaration).getContextReceiverList();
                if (contextReceiverList == null) {
                    boolean $i$a$-requireNotNull-InlineClassDeclarationChecker$check$332 = false;
                    String $i$a$-requireNotNull-InlineClassDeclarationChecker$check$332 = "Declaration cannot have context receivers with no context receiver list";
                    throw new IllegalArgumentException($i$a$-requireNotNull-InlineClassDeclarationChecker$check$332.toString());
                }
                trace.report(Errors.INLINE_CLASS_CANNOT_HAVE_CONTEXT_RECEIVERS.on((KtContextReceiverList)((PsiElement)contextReceiverList)));
            }
            if ((modalityModifier = KtPsiUtilKt.modalityModifier(declaration)) != null && ((ClassDescriptor)descriptor2).getModality() != Modality.FINAL) {
                trace.report(Errors.VALUE_CLASS_NOT_FINAL.on(modalityModifier));
                return;
            }
            KtPrimaryConstructor primaryConstructor2 = ((KtClass)declaration).getPrimaryConstructor();
            if (primaryConstructor2 == null) {
                trace.report(Errors.ABSENCE_OF_PRIMARY_CONSTRUCTOR_FOR_VALUE_CLASS.on(inlineOrValueKeyword));
                return;
            }
            if (context.getLanguageVersionSettings().supportsFeature(LanguageFeature.ValueClasses)) {
                if (primaryConstructor2.getValueParameters().isEmpty()) {
                    KtParameterList ktParameterList = primaryConstructor2.getValueParameterList();
                    KtElementImplStub it = ktParameterList != null ? (KtElementImplStub)ktParameterList : (KtElementImplStub)((Object)declaration);
                    boolean bl2 = false;
                    trace.report(Errors.VALUE_CLASS_EMPTY_CONSTRUCTOR.on((KtElement)((PsiElement)it)));
                    return;
                }
            } else if (primaryConstructor2.getValueParameters().size() != 1) {
                KtParameterList ktParameterList = primaryConstructor2.getValueParameterList();
                KtElementImplStub it = ktParameterList != null ? (KtElementImplStub)ktParameterList : (KtElementImplStub)((Object)declaration);
                boolean bl3 = false;
                trace.report(Errors.INLINE_CLASS_CONSTRUCTOR_WRONG_PARAMETERS_SIZE.on((KtElement)((PsiElement)it)));
                return;
            }
            boolean baseParametersOk = true;
            DeclarationDescriptor declarationDescriptor = descriptor2;
            boolean $i$f$safeAs = false;
            DeclarationDescriptor declarationDescriptor2 = declarationDescriptor;
            if (!(declarationDescriptor2 instanceof ClassDescriptor)) {
                declarationDescriptor2 = null;
            }
            if ((list2 = (ClassDescriptor)declarationDescriptor2) == null || (list2 = list2.getDefaultType()) == null || (list2 = InlineClassesUtilsKt.substitutedUnderlyingTypes((KotlinType)((Object)list2))) == null) {
                list2 = CollectionsKt.emptyList();
            }
            List<KotlinType> baseParameterTypes = list2;
            for (Pair pair : CollectionsKt.zip((Iterable)primaryConstructor2.getValueParameters(), (Iterable)baseParameterTypes)) {
                KtParameter baseParameter = (KtParameter)pair.component1();
                KotlinType baseParameterType = (KotlinType)pair.component2();
                Intrinsics.checkNotNullExpressionValue(baseParameter, "baseParameter");
                if (!this.isParameterAcceptableForInlineClass(baseParameter)) {
                    trace.report(Errors.VALUE_CLASS_CONSTRUCTOR_NOT_FINAL_READ_ONLY_PARAMETER.on((KtParameter)((PsiElement)baseParameter)));
                    baseParametersOk = false;
                    continue;
                }
                KtTypeReference baseParameterTypeReference = baseParameter.getTypeReference();
                if (baseParameterType == null || baseParameterTypeReference == null) continue;
                if (this.isInapplicableParameterType(baseParameterType) && (!context.getLanguageVersionSettings().supportsFeature(LanguageFeature.GenericInlineClassParameter) || !TypeUtilsKt.isTypeParameter(baseParameterType) && !this.isGenericArrayOfTypeParameter(baseParameterType))) {
                    trace.report(Errors.VALUE_CLASS_HAS_INAPPLICABLE_PARAMETER_TYPE.on((KtTypeReference)((PsiElement)baseParameterTypeReference), baseParameterType));
                    baseParametersOk = false;
                    continue;
                }
                if (!InlineClassesUtilsKt.isRecursiveInlineOrValueClassType(baseParameterType)) continue;
                trace.report(Errors.VALUE_CLASS_CANNOT_BE_RECURSIVE.on((KtTypeReference)((PsiElement)baseParameterTypeReference)));
                baseParametersOk = false;
            }
            if (!baseParametersOk) {
                return;
            }
            for (KtSuperTypeListEntry ktSuperTypeListEntry : ((KtClass)declaration).getSuperTypeListEntries()) {
                ClassifierDescriptor typeDescriptor;
                KotlinType type2;
                KtTypeReference typeReference;
                if (ktSuperTypeListEntry.getTypeReference() == null || (KotlinType)trace.get(BindingContext.TYPE, typeReference) == null) continue;
                if (ktSuperTypeListEntry instanceof KtDelegatedSuperTypeEntry) {
                    ResolvedCall<? extends CallableDescriptor> resolvedCall2;
                    KtElement ktElement = ((KtDelegatedSuperTypeEntry)ktSuperTypeListEntry).getDelegateExpression();
                    BindingContext bindingContext = trace.getBindingContext();
                    Intrinsics.checkNotNullExpressionValue(bindingContext, "trace.bindingContext");
                    if (CallUtilKt.getResolvedCall(ktElement, bindingContext) == null || context.getLanguageVersionSettings().supportsFeature(LanguageFeature.InlineClassImplementationByDelegation) && resolvedCall2.getResultingDescriptor() instanceof ValueParameterDescriptor && Intrinsics.areEqual(resolvedCall2.getResultingDescriptor().getContainingDeclaration(), trace.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, primaryConstructor2))) continue;
                    trace.report(Errors.VALUE_CLASS_CANNOT_IMPLEMENT_INTERFACE_BY_DELEGATION.on(ktSuperTypeListEntry));
                    return;
                }
                if (type2.getConstructor().getDeclarationDescriptor() == null || DescriptorUtils.isInterface(typeDescriptor)) continue;
                trace.report(Errors.VALUE_CLASS_CANNOT_EXTEND_CLASSES.on((KtTypeReference)((PsiElement)typeReference)));
                return;
            }
            Sequence<ClassifierDescriptor> $this$any$iv = DescriptorUtilsKt.getAllSuperClassifiers((ClassifierDescriptor)descriptor2);
            boolean bl2 = false;
            Iterator<ClassifierDescriptor> iterator2 = $this$any$iv.iterator();
            while (iterator2.hasNext()) {
                ClassifierDescriptor element$iv;
                ClassifierDescriptor it = element$iv = iterator2.next();
                boolean bl4 = false;
                if (!(Intrinsics.areEqual(DescriptorUtilsKt.getFqNameUnsafe(it), StandardNames.FqNames.cloneable) || Intrinsics.areEqual(DescriptorUtilsKt.getFqNameUnsafe(it), InlineClassDeclarationCheckerKt.access$getJavaLangCloneable$p()))) continue;
                bl = true;
                break block25;
            }
            bl = false;
        }
        if (bl) {
            trace.report(Errors.VALUE_CLASS_CANNOT_BE_CLONEABLE.on(inlineOrValueKeyword));
            return;
        }
    }

    private final boolean isInapplicableParameterType(KotlinType $this$isInapplicableParameterType) {
        return TypeUtilsKt.isUnit($this$isInapplicableParameterType) || TypeUtilsKt.isNothing($this$isInapplicableParameterType) || TypeUtilsKt.isTypeParameter($this$isInapplicableParameterType) || this.isGenericArrayOfTypeParameter($this$isInapplicableParameterType);
    }

    private final boolean isGenericArrayOfTypeParameter(KotlinType $this$isGenericArrayOfTypeParameter) {
        if (!KotlinBuiltIns.isArray($this$isGenericArrayOfTypeParameter)) {
            return false;
        }
        TypeProjection argument0 = $this$isGenericArrayOfTypeParameter.getArguments().get(0);
        if (argument0.isStarProjection()) {
            return false;
        }
        KotlinType kotlinType = argument0.getType();
        Intrinsics.checkNotNullExpressionValue(kotlinType, "argument0.type");
        KotlinType argument0type = kotlinType;
        return TypeUtilsKt.isTypeParameter(argument0type) || this.isGenericArrayOfTypeParameter(argument0type);
    }

    private final boolean isParameterAcceptableForInlineClass(KtParameter parameter) {
        UserDataHolder userDataHolder = KtPsiUtilKt.modalityModifier(parameter);
        boolean isOpen = Intrinsics.areEqual(userDataHolder != null && (userDataHolder = userDataHolder.getNode()) != null ? userDataHolder.getElementType() : null, KtTokens.OPEN_KEYWORD);
        return parameter.hasValOrVar() && !parameter.isMutable() && !parameter.isVarArg() && !isOpen;
    }
}

