/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fJ\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000f\u001a\u00020\u0005J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0010\u001a\u00020\fR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/types/FlexibleTypeBoundsChecker;", "", "()V", "baseTypesToMutableEquivalent", "", "Lorg/jetbrains/kotlin/name/FqName;", "fqNames", "Lorg/jetbrains/kotlin/builtins/StandardNames$FqNames;", "mutableToBaseMap", "areTypesMayBeLowerAndUpperBoundsOfSameFlexibleTypeByMutability", "", "a", "Lorg/jetbrains/kotlin/types/KotlinType;", "b", "getBaseBoundFqNameByMutability", "fqName", "type", "descriptors"})
public final class FlexibleTypeBoundsChecker {
    @NotNull
    public static final FlexibleTypeBoundsChecker INSTANCE;
    @NotNull
    private static final StandardNames.FqNames fqNames;
    @NotNull
    private static final Map<FqName, FqName> baseTypesToMutableEquivalent;
    @NotNull
    private static final Map<FqName, FqName> mutableToBaseMap;

    private FlexibleTypeBoundsChecker() {
    }

    public final boolean areTypesMayBeLowerAndUpperBoundsOfSameFlexibleTypeByMutability(@NotNull KotlinType a, @NotNull KotlinType b) {
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        Object object = a.getConstructor().getDeclarationDescriptor();
        if (object == null || (object = DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)object)) == null) {
            return false;
        }
        Object fqName2 = object;
        FqName fqName3 = baseTypesToMutableEquivalent.get(fqName2);
        if (fqName3 == null && (fqName3 = mutableToBaseMap.get(fqName2)) == null) {
            return false;
        }
        FqName possiblePairBound = fqName3;
        ClassifierDescriptor classifierDescriptor = b.getConstructor().getDeclarationDescriptor();
        return Intrinsics.areEqual(possiblePairBound, classifierDescriptor != null ? DescriptorUtilsKt.getFqNameSafe(classifierDescriptor) : null);
    }

    @Nullable
    public final FqName getBaseBoundFqNameByMutability(@NotNull KotlinType type2) {
        FqName fqName2;
        Intrinsics.checkNotNullParameter(type2, "type");
        Object object = type2.getConstructor().getDeclarationDescriptor();
        if (object != null && (object = DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)object)) != null) {
            Object p0 = object;
            boolean bl = false;
            fqName2 = this.getBaseBoundFqNameByMutability((FqName)p0);
        } else {
            fqName2 = null;
        }
        return fqName2;
    }

    @Nullable
    public final FqName getBaseBoundFqNameByMutability(@NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        return baseTypesToMutableEquivalent.containsKey(fqName2) ? fqName2 : mutableToBaseMap.get(fqName2);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$associateByTo$iv$iv;
        INSTANCE = new FlexibleTypeBoundsChecker();
        fqNames = StandardNames.FqNames.INSTANCE;
        Pair[] pairArray = new Pair[]{TuplesKt.to(StandardNames.FqNames.iterable, StandardNames.FqNames.mutableIterable), TuplesKt.to(StandardNames.FqNames.iterator, StandardNames.FqNames.mutableIterator), TuplesKt.to(StandardNames.FqNames.listIterator, StandardNames.FqNames.mutableListIterator), TuplesKt.to(StandardNames.FqNames.list, StandardNames.FqNames.mutableList), TuplesKt.to(StandardNames.FqNames.collection, StandardNames.FqNames.mutableCollection), TuplesKt.to(StandardNames.FqNames.set, StandardNames.FqNames.mutableSet), TuplesKt.to(StandardNames.FqNames.map, StandardNames.FqNames.mutableMap), TuplesKt.to(StandardNames.FqNames.mapEntry, StandardNames.FqNames.mutableMapEntry)};
        baseTypesToMutableEquivalent = MapsKt.mapOf(pairArray);
        Iterable $this$associateBy$iv = baseTypesToMutableEquivalent.entrySet();
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateBy$iv, 10)), 16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            Map.Entry entry = (Map.Entry)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry it = (Map.Entry)element$iv$iv;
            FqName fqName2 = (FqName)it.getValue();
            boolean bl2 = false;
            FqName fqName3 = (FqName)it.getKey();
            map2.put(fqName2, fqName3);
        }
        mutableToBaseMap = destination$iv$iv;
    }
}

