/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.psi.PsiElement;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.SourceFile;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.TypeAliasConstructorDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.components.ExpectActualTracker;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.ModulePath;
import org.jetbrains.kotlin.resolve.ModuleStructureOracle;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.checkers.ExpectedActualDeclarationChecker;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.multiplatform.ExpectActualCompatibility;
import org.jetbrains.kotlin.resolve.multiplatform.ExpectedActualResolver;
import org.jetbrains.kotlin.resolve.multiplatform.ModuleFilterUtilsKt;
import org.jetbrains.kotlin.resolve.multiplatform.OptionalAnnotationUtil;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElement;
import org.jetbrains.kotlin.resolve.source.PsiSourceFile;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 J2\u00020\u0001:\u0002IJB\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J@\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0016\u0010\u001c\u001a\u0012\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u00190\u001dj\u0002`\u001fH\u0002J@\u0010 \u001a\u00020\r2\u001e\u0010!\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170#\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170$0\"2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0017H\u0002J(\u0010%\u001a\u00020\r2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020)H\u0002J\\\u0010*\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010+\u001a\u00020\u00172\"\u0010,\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170#\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170$0\"j\u0002`-2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010.\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010/\u001a\u000200H\u0002JR\u00101\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010+\u001a\u00020\u00172\"\u0010,\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170#\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170$0\"j\u0002`-2\f\u00102\u001a\b\u0012\u0004\u0012\u0002030$2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J0\u00104\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010/\u001a\u000200H\u0002J&\u00105\u001a\b\u0012\u0002\b\u0003\u0018\u0001062\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<H\u0002J\u0010\u0010=\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u0017H\u0002J\"\u0010>\u001a\u00020\r2\u0006\u0010(\u001a\u00020\u00172\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010?\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u0017H\u0002J\u0012\u0010@\u001a\u0004\u0018\u00010A2\u0006\u0010\u0010\u001a\u00020\u0017H\u0002J,\u0010B\u001a\u00020\u0019*\u00020\u00172\u001e\u0010!\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170#\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170$0\"H\u0002J\f\u0010C\u001a\u00020\u0019*\u00020\u0017H\u0002J\u0012\u0010D\u001a\u00020\u0019*\b\u0012\u0004\u0012\u00020\u00170#H\u0002J\f\u0010E\u001a\u00020\u0019*\u00020\u0017H\u0002J\"\u0010F\u001a\u00020\r*\u0002002\u0006\u0010&\u001a\u00020\u00172\f\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00170HH\u0002R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006K"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ExpectedActualDeclarationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "moduleStructureOracle", "Lorg/jetbrains/kotlin/resolve/ModuleStructureOracle;", "argumentExtractors", "", "Lorg/jetbrains/kotlin/resolve/checkers/ExpectedActualDeclarationChecker$ActualAnnotationArgumentExtractor;", "(Lorg/jetbrains/kotlin/resolve/ModuleStructureOracle;Ljava/lang/Iterable;)V", "getArgumentExtractors", "()Ljava/lang/Iterable;", "getModuleStructureOracle", "()Lorg/jetbrains/kotlin/resolve/ModuleStructureOracle;", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "checkActualDeclarationHasExpected", "reportOn", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "Lorg/jetbrains/kotlin/descriptors/MemberDescriptor;", "checkActualModifier", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "moduleVisibilityFilter", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "Lorg/jetbrains/kotlin/resolve/multiplatform/ModuleFilter;", "checkAmbiguousExpects", "compatibility", "", "Lorg/jetbrains/kotlin/resolve/multiplatform/ExpectActualCompatibility;", "", "checkAnnotationConstructors", "expected", "Lorg/jetbrains/kotlin/descriptors/ConstructorDescriptor;", "actual", "Lcom/intellij/psi/PsiElement;", "checkExpectedDeclarationHasAtLeastOneActual", "expectDescriptor", "actuals", "Lorg/jetbrains/kotlin/resolve/checkers/ActualsMap;", "module", "expectActualTracker", "Lorg/jetbrains/kotlin/incremental/components/ExpectActualTracker;", "checkExpectedDeclarationHasAtMostOneActual", "modulePaths", "Lorg/jetbrains/kotlin/resolve/ModulePath;", "checkExpectedDeclarationHasProperActuals", "getActualAnnotationParameterValue", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "actualParameter", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "expectedType", "Lorg/jetbrains/kotlin/types/KotlinType;", "isUnderlyingPropertyOfInlineClass", "reportMissingActualModifier", "requireActualModifier", "sourceFile", "Ljava/io/File;", "hasNoActualWithDiagnostic", "isActualOrSomeContainerIsActual", "isCompatibleOrWeakCompatible", "isExplicitActualDeclaration", "reportExpectActual", "actualMembers", "Lkotlin/sequences/Sequence;", "ActualAnnotationArgumentExtractor", "Companion", "frontend"})
public final class ExpectedActualDeclarationChecker
implements DeclarationChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ModuleStructureOracle moduleStructureOracle;
    @NotNull
    private final Iterable<ActualAnnotationArgumentExtractor> argumentExtractors;

    public ExpectedActualDeclarationChecker(@NotNull ModuleStructureOracle moduleStructureOracle, @NotNull Iterable<? extends ActualAnnotationArgumentExtractor> argumentExtractors) {
        Intrinsics.checkNotNullParameter((Object)moduleStructureOracle, (String)"moduleStructureOracle");
        Intrinsics.checkNotNullParameter(argumentExtractors, (String)"argumentExtractors");
        this.moduleStructureOracle = moduleStructureOracle;
        this.argumentExtractors = argumentExtractors;
    }

    @NotNull
    public final ModuleStructureOracle getModuleStructureOracle() {
        return this.moduleStructureOracle;
    }

    @NotNull
    public final Iterable<ActualAnnotationArgumentExtractor> getArgumentExtractors() {
        return this.argumentExtractors;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        boolean checkActualModifier;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!context.getLanguageVersionSettings().supportsFeature(LanguageFeature.MultiPlatformProjects)) {
            return;
        }
        if (context.getLanguageVersionSettings().getFlag(AnalysisFlags.getExpectActualLinker()).booleanValue()) {
            return;
        }
        if (descriptor2 instanceof PropertyAccessorDescriptor) {
            return;
        }
        if (!(declaration instanceof KtNamedDeclaration)) {
            return;
        }
        if (!(descriptor2 instanceof MemberDescriptor) || DescriptorUtils.isEnumEntry(descriptor2)) {
            return;
        }
        boolean bl = checkActualModifier = context.getLanguageVersionSettings().getFlag(AnalysisFlags.getMultiPlatformDoNotCheckActual()) == false;
        if (((MemberDescriptor)descriptor2).isExpect()) {
            this.checkExpectedDeclarationHasProperActuals((KtNamedDeclaration)declaration, (MemberDescriptor)descriptor2, context.getTrace(), checkActualModifier, context.getExpectActualTracker());
        } else if (this.isActualOrSomeContainerIsActual((MemberDescriptor)descriptor2)) {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = this.moduleStructureOracle.findAllDependsOnPaths(DescriptorUtilsKt.getModule(descriptor2));
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                ModulePath it = (ModulePath)element$iv$iv;
                boolean bl2 = false;
                Iterable list$iv$iv = it.getNodes();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            HashSet allDependsOnModules = CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv));
            this.checkActualDeclarationHasExpected((KtNamedDeclaration)declaration, (MemberDescriptor)descriptor2, checkActualModifier, context.getTrace(), (Function1<? super ModuleDescriptor, Boolean>)((Function1)new Function1<ModuleDescriptor, Boolean>((HashSet<ModuleDescriptor>)allDependsOnModules){
                final /* synthetic */ HashSet<ModuleDescriptor> $allDependsOnModules;
                {
                    this.$allDependsOnModules = $allDependsOnModules;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull ModuleDescriptor it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return this.$allDependsOnModules.contains(it);
                }
            }));
        }
    }

    private final boolean isActualOrSomeContainerIsActual(MemberDescriptor $this$isActualOrSomeContainerIsActual) {
        MemberDescriptor declaration = $this$isActualOrSomeContainerIsActual;
        while (!declaration.isActual()) {
            DeclarationDescriptor declarationDescriptor = declaration.getContainingDeclaration();
            if ((declarationDescriptor instanceof MemberDescriptor ? (MemberDescriptor)declarationDescriptor : null) == null) {
                return false;
            }
            declaration = declaration;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkExpectedDeclarationHasProperActuals(KtNamedDeclaration reportOn, MemberDescriptor descriptor2, BindingTrace trace, boolean checkActualModifier, ExpectActualTracker expectActualTracker) {
        void $this$mapTo$iv$iv;
        List<ModulePath> allActualizationPaths = this.moduleStructureOracle.findAllReversedDependsOnPaths(DescriptorUtilsKt.getModule(descriptor2));
        Iterable $this$map$iv = allActualizationPaths;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ModulePath modulePath = (ModulePath)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((ModuleDescriptor)CollectionsKt.last(it.getNodes()));
        }
        Set allLeafModules = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $this$forEach$iv = allLeafModules;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map actuals;
            ModuleDescriptor leafModule = (ModuleDescriptor)element$iv;
            boolean bl = false;
            if (ExpectedActualResolver.findActualForExpected$default(ExpectedActualResolver.INSTANCE, descriptor2, leafModule, null, 4, null) == null) continue;
            this.checkExpectedDeclarationHasAtLeastOneActual(reportOn, descriptor2, actuals, trace, leafModule, checkActualModifier, expectActualTracker);
            this.checkExpectedDeclarationHasAtMostOneActual(reportOn, descriptor2, actuals, allActualizationPaths, trace);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkExpectedDeclarationHasAtMostOneActual(KtNamedDeclaration reportOn, MemberDescriptor expectDescriptor, Map<ExpectActualCompatibility<MemberDescriptor>, ? extends List<? extends MemberDescriptor>> actuals, List<ModulePath> modulePaths, BindingTrace trace) {
        Map actualsByModulePath;
        Iterable path2;
        Object object;
        void $this$filterKeys$iv;
        Map<ExpectActualCompatibility<MemberDescriptor>, ? extends List<? extends MemberDescriptor>> map = actuals;
        boolean $i$f$filterKeys = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
            ExpectActualCompatibility compatibility = (ExpectActualCompatibility)entry$iv.getKey();
            boolean bl = false;
            if (!this.isCompatibleOrWeakCompatible(compatibility)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        List atLeastWeaklyCompatibleActuals = CollectionsKt.flatten((Iterable)((Map)result$iv).values());
        if (atLeastWeaklyCompatibleActuals.size() <= 1) {
            return;
        }
        Iterable $this$associateWith$iv = modulePaths;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv2 = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void $this$filterTo$iv$iv;
            ModulePath modulePath = (ModulePath)element$iv$iv;
            Object t = element$iv$iv;
            Map map2 = result$iv2;
            boolean bl = false;
            Iterable $this$filter$iv = atLeastWeaklyCompatibleActuals;
            boolean $i$f$filter = false;
            object = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                MemberDescriptor it = (MemberDescriptor)element$iv$iv2;
                boolean bl2 = false;
                if (!((ModulePath)((Object)path2)).getNodes().contains(DescriptorUtilsKt.getModule(it))) continue;
                destination$iv$iv.add(element$iv$iv2);
            }
            List list2 = (List)destination$iv$iv;
            map2.put(t, list2);
        }
        Map $this$forEach$iv = actualsByModulePath = (Map)result$iv2;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void $this$sortedBy$iv;
            Collection<ModuleDescriptor> collection;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator2.next();
            boolean bl = false;
            List actualsInPath = (List)entry.getValue();
            if (actualsInPath.size() <= 1) continue;
            path2 = actualsInPath;
            MemberDescriptor memberDescriptor = expectDescriptor;
            PsiElement psiElement = reportOn;
            DiagnosticFactory2<KtNamedDeclaration, DeclarationDescriptor, Collection<ModuleDescriptor>> diagnosticFactory2 = Errors.AMBIGUOUS_ACTUALS;
            object = trace;
            boolean $i$f$map = false;
            void $i$f$filterTo = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                MemberDescriptor memberDescriptor2 = (MemberDescriptor)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(DescriptorUtilsKt.getModule((DeclarationDescriptor)it));
            }
            collection = (List)destination$iv$iv;
            $this$map$iv = collection;
            boolean $i$f$sortedBy = false;
            object.report(diagnosticFactory2.on((KtNamedDeclaration)psiElement, memberDescriptor, CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    ModuleDescriptor it = (ModuleDescriptor)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getName().asString());
                    it = (ModuleDescriptor)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName().asString())));
                }
            })));
        }
    }

    private final void checkExpectedDeclarationHasAtLeastOneActual(KtNamedDeclaration reportOn, MemberDescriptor expectDescriptor, Map<ExpectActualCompatibility<MemberDescriptor>, ? extends List<? extends MemberDescriptor>> actuals, BindingTrace trace, ModuleDescriptor module2, boolean checkActualModifier, ExpectActualTracker expectActualTracker) {
        if (!(expectDescriptor.getContainingDeclaration() instanceof PackageFragmentDescriptor)) {
            return;
        }
        if (Companion.allStrongIncompatibilities(actuals) && OptionalAnnotationUtil.isOptionalAnnotationClass(expectDescriptor)) {
            return;
        }
        if (Companion.allStrongIncompatibilities(actuals) || !actuals.containsKey(ExpectActualCompatibility.Compatible.INSTANCE) && this.hasNoActualWithDiagnostic(expectDescriptor, actuals)) {
            boolean $this$all$iv2;
            block9: {
                boolean bl;
                Iterable $this$all$iv2 = actuals.keySet();
                boolean $i$f$all = false;
                if ($this$all$iv2 instanceof Collection && ((Collection)$this$all$iv2).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv2) {
                        ExpectActualCompatibility it = (ExpectActualCompatibility)element$iv;
                        boolean bl2 = false;
                        if (it instanceof ExpectActualCompatibility.Incompatible) continue;
                        bl = false;
                        break block9;
                    }
                    bl = $this$all$iv2 = true;
                }
            }
            if (_Assertions.ENABLED && !$this$all$iv2) {
                String $i$f$all = "Assertion failed";
                throw new AssertionError((Object)$i$f$all);
            }
            Intrinsics.checkNotNull(actuals, (String)"null cannot be cast to non-null type kotlin.collections.Map<org.jetbrains.kotlin.resolve.multiplatform.ExpectActualCompatibility.Incompatible<org.jetbrains.kotlin.descriptors.MemberDescriptor>, kotlin.collections.Collection<org.jetbrains.kotlin.descriptors.MemberDescriptor>>");
            Map<ExpectActualCompatibility<MemberDescriptor>, ? extends List<? extends MemberDescriptor>> incompatibility = actuals;
            trace.report(Errors.NO_ACTUAL_FOR_EXPECT.on((KtNamedDeclaration)((PsiElement)reportOn), expectDescriptor, module2, incompatibility));
            return;
        }
        Sequence actualMembers2 = SequencesKt.flatMap((Sequence)SequencesKt.filter((Sequence)MapsKt.asSequence(actuals), (Function1)((Function1)new Function1<Map.Entry<? extends ExpectActualCompatibility<? extends MemberDescriptor>, ? extends List<? extends MemberDescriptor>>, Boolean>(this){
            final /* synthetic */ ExpectedActualDeclarationChecker this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Map.Entry<? extends ExpectActualCompatibility<? extends MemberDescriptor>, ? extends List<? extends MemberDescriptor>> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return ExpectedActualDeclarationChecker.access$isCompatibleOrWeakCompatible(this.this$0, it.getKey());
            }
        })), (Function1)checkExpectedDeclarationHasAtLeastOneActual.actualMembers.2.INSTANCE);
        if (checkActualModifier) {
            Sequence $this$forEach$iv = actualMembers2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MemberDescriptor it = (MemberDescriptor)element$iv;
                boolean bl = false;
                this.reportMissingActualModifier(it, null, trace);
            }
        }
        this.reportExpectActual(expectActualTracker, expectDescriptor, (Sequence<? extends MemberDescriptor>)actualMembers2);
    }

    private final void reportMissingActualModifier(MemberDescriptor actual, KtNamedDeclaration reportOn, BindingTrace trace) {
        if (actual.isActual()) {
            return;
        }
        KtNamedDeclaration ktNamedDeclaration = reportOn;
        if (ktNamedDeclaration == null) {
            SourceElement $this$safeAs$iv = actual.getSource();
            boolean $i$f$safeAs = false;
            SourceElement sourceElement = $this$safeAs$iv;
            if (!(sourceElement instanceof KotlinSourceElement)) {
                sourceElement = null;
            }
            KotlinSourceElement kotlinSourceElement = (KotlinSourceElement)sourceElement;
            KtElement $this$safeAs$iv2 = kotlinSourceElement != null ? kotlinSourceElement.getPsi() : null;
            boolean $i$f$safeAs2 = false;
            KtElement ktElement = $this$safeAs$iv2;
            if (!(ktElement instanceof KtNamedDeclaration)) {
                ktElement = null;
            }
            if ((ktNamedDeclaration = (KtNamedDeclaration)ktElement) == null) {
                return;
            }
        }
        KtNamedDeclaration reportOn2 = ktNamedDeclaration;
        if (this.requireActualModifier(actual)) {
            trace.report(Errors.ACTUAL_MISSING.on((KtNamedDeclaration)((PsiElement)reportOn2)));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hasNoActualWithDiagnostic(MemberDescriptor $this$hasNoActualWithDiagnostic, Map<ExpectActualCompatibility<MemberDescriptor>, ? extends List<? extends MemberDescriptor>> compatibility) {
        boolean bl;
        block4: {
            void destination$iv;
            void $this$flatMapTo$iv;
            Iterable iterable = compatibility.values();
            Collection collection = new HashSet();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv : $this$flatMapTo$iv) {
                List it = (List)element$iv;
                boolean bl2 = false;
                Iterable list$iv = it;
                CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
            }
            Iterable $this$all$iv = (Iterable)destination$iv;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    MemberDescriptor actual = (MemberDescriptor)element$iv;
                    boolean bl3 = false;
                    Map<ExpectActualCompatibility<MemberDescriptor>, List<MemberDescriptor>> expectedOnes = ExpectedActualResolver.INSTANCE.findExpectedForActual(actual, ModuleFilterUtilsKt.onlyFromThisModule(DescriptorUtilsKt.getModule($this$hasNoActualWithDiagnostic)));
                    if (expectedOnes != null && expectedOnes.keySet().contains(ExpectActualCompatibility.Compatible.INSTANCE)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final void reportExpectActual(ExpectActualTracker $this$reportExpectActual, MemberDescriptor expected, Sequence<? extends MemberDescriptor> actualMembers2) {
        if ($this$reportExpectActual instanceof ExpectActualTracker.DoNothing) {
            return;
        }
        File file2 = this.sourceFile(expected);
        if (file2 == null) {
            return;
        }
        File expectedFile = file2;
        for (MemberDescriptor actual : actualMembers2) {
            File actualFile;
            if (this.sourceFile(actual) == null) continue;
            $this$reportExpectActual.report(expectedFile, actualFile);
        }
    }

    private final File sourceFile(MemberDescriptor descriptor2) {
        File file2;
        PsiSourceFile psiSourceFile;
        SourceFile $this$safeAs$iv = descriptor2.getSource().getContainingFile();
        boolean $i$f$safeAs = false;
        SourceFile sourceFile = $this$safeAs$iv;
        if (!(sourceFile instanceof PsiSourceFile)) {
            sourceFile = null;
        }
        if ((psiSourceFile = (PsiSourceFile)sourceFile) != null) {
            PsiSourceFile $this$sourceFile_u24lambda_u2413 = psiSourceFile;
            boolean bl = false;
            file2 = VfsUtilCore.virtualToIoFile($this$sourceFile_u24lambda_u2413.getPsiFile().getVirtualFile());
        } else {
            file2 = null;
        }
        return file2;
    }

    private final void checkActualDeclarationHasExpected(KtNamedDeclaration reportOn, MemberDescriptor descriptor2, boolean checkActualModifier, BindingTrace trace, Function1<? super ModuleDescriptor, Boolean> moduleVisibilityFilter) {
        Object it;
        boolean $i$f$any;
        Map<ExpectActualCompatibility<MemberDescriptor>, List<MemberDescriptor>> map = ExpectedActualResolver.INSTANCE.findExpectedForActual(descriptor2, moduleVisibilityFilter);
        if (map == null) {
            return;
        }
        Map<ExpectActualCompatibility<MemberDescriptor>, List<MemberDescriptor>> compatibility = map;
        this.checkAmbiguousExpects(compatibility, trace, reportOn, descriptor2);
        if (checkActualModifier && !(descriptor2.getContainingDeclaration() instanceof PackageFragmentDescriptor)) {
            boolean bl;
            block22: {
                Map<ExpectActualCompatibility<MemberDescriptor>, List<MemberDescriptor>> $this$any$iv = compatibility;
                $i$f$any = false;
                if ($this$any$iv.isEmpty()) {
                    bl = false;
                } else {
                    for (Map.Entry<ExpectActualCompatibility<MemberDescriptor>, List<MemberDescriptor>> element$iv : $this$any$iv.entrySet()) {
                        it = element$iv;
                        boolean bl2 = false;
                        if (!this.isCompatibleOrWeakCompatible(it.getKey())) continue;
                        bl = true;
                        break block22;
                    }
                    bl = false;
                }
            }
            if (bl) {
                this.reportMissingActualModifier(descriptor2, reportOn, trace);
            }
        }
        if (!PsiUtilsKt.hasActualModifier(reportOn) && Companion.allStrongIncompatibilities(compatibility)) {
            return;
        }
        ExpectActualCompatibility singleIncompatibility = (ExpectActualCompatibility)CollectionsKt.firstOrNull((Iterable)compatibility.keySet());
        if (singleIncompatibility instanceof ExpectActualCompatibility.Incompatible.ClassScopes) {
            ClassifierDescriptor $this$filterNotTo$iv$iv;
            boolean bl = $i$f$any = descriptor2 instanceof ClassDescriptor || descriptor2 instanceof TypeAliasDescriptor;
            if (_Assertions.ENABLED && !$i$f$any) {
                boolean $i$a$-assert-ExpectedActualDeclarationChecker$checkActualDeclarationHasExpected$32 = false;
                String $i$a$-assert-ExpectedActualDeclarationChecker$checkActualDeclarationHasExpected$32 = "Incompatible.ClassScopes is only possible for a class or a typealias: " + descriptor2;
                throw new AssertionError((Object)$i$a$-assert-ExpectedActualDeclarationChecker$checkActualDeclarationHasExpected$32);
            }
            Iterable $this$filterNot$iv = ((ExpectActualCompatibility.Incompatible.ClassScopes)singleIncompatibility).getUnfulfilled();
            boolean $i$f$filterNot = false;
            it = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            Iterator iterator2 = $this$filterNotTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv$iv = iterator2.next();
                Pair p0 = (Pair)element$iv$iv;
                boolean bl3 = false;
                if (ExpectedActualDeclarationChecker.checkActualDeclarationHasExpected$hasSingleActualSuspect(this, (Pair<? extends MemberDescriptor, ? extends Map<ExpectActualCompatibility.Incompatible<MemberDescriptor>, ? extends Collection<? extends MemberDescriptor>>>)p0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List nonTrivialUnfulfilled = (List)destination$iv$iv;
            if (!((Collection)nonTrivialUnfulfilled).isEmpty()) {
                Object object = descriptor2 instanceof TypeAliasDescriptor ? (TypeAliasDescriptor)descriptor2 : null;
                ClassifierDescriptor classifierDescriptor = $this$filterNotTo$iv$iv = object != null && (object = object.getExpandedType()) != null && (object = ((KotlinType)object).getConstructor()) != null ? object.getDeclarationDescriptor() : null;
                ClassDescriptor classDescriptor2 = $this$filterNotTo$iv$iv instanceof ClassDescriptor ? (ClassDescriptor)$this$filterNotTo$iv$iv : null;
                if (classDescriptor2 == null) {
                    Intrinsics.checkNotNull((Object)descriptor2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
                    classDescriptor2 = (ClassDescriptor)descriptor2;
                }
                ClassDescriptor classDescriptor3 = classDescriptor2;
                trace.report(Errors.NO_ACTUAL_CLASS_MEMBER_FOR_EXPECTED_CLASS.on((KtNamedDeclaration)((PsiElement)reportOn), classDescriptor3, nonTrivialUnfulfilled));
            }
        } else if (!compatibility.containsKey(ExpectActualCompatibility.Compatible.INSTANCE)) {
            boolean $this$all$iv2;
            block23: {
                boolean bl;
                Iterable $this$all$iv2 = compatibility.keySet();
                boolean $i$f$all = false;
                if ($this$all$iv2 instanceof Collection && ((Collection)$this$all$iv2).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv2) {
                        ExpectActualCompatibility it2 = (ExpectActualCompatibility)element$iv;
                        boolean bl4 = false;
                        if (it2 instanceof ExpectActualCompatibility.Incompatible) continue;
                        bl = false;
                        break block23;
                    }
                    bl = $this$all$iv2 = true;
                }
            }
            if (_Assertions.ENABLED && !$this$all$iv2) {
                String $i$f$all = "Assertion failed";
                throw new AssertionError((Object)$i$f$all);
            }
            Map<ExpectActualCompatibility<MemberDescriptor>, List<MemberDescriptor>> incompatibility = compatibility;
            trace.report(Errors.ACTUAL_WITHOUT_EXPECT.on((KtNamedDeclaration)((PsiElement)reportOn), descriptor2, incompatibility));
        } else {
            List<MemberDescriptor> list2 = compatibility.get(ExpectActualCompatibility.Compatible.INSTANCE);
            Intrinsics.checkNotNull(list2);
            MemberDescriptor expected = (MemberDescriptor)CollectionsKt.first(list2);
            if (expected instanceof ClassDescriptor && ((ClassDescriptor)expected).getKind() == ClassKind.ANNOTATION_CLASS) {
                Object object = descriptor2 instanceof ClassDescriptor ? (ClassDescriptor)descriptor2 : null;
                if (object == null || (object = object.getConstructors()) == null || (object = (ClassConstructorDescriptor)CollectionsKt.singleOrNull((Iterable)((Iterable)object))) == null) {
                    Object object2 = descriptor2 instanceof TypeAliasDescriptor ? (TypeAliasDescriptor)descriptor2 : null;
                    object = object2 != null && (object2 = object2.getConstructors()) != null && (object2 = (TypeAliasConstructorDescriptor)CollectionsKt.singleOrNull((Iterable)((Iterable)object2))) != null ? object2.getUnderlyingConstructorDescriptor() : null;
                }
                Object actualConstructor = object;
                Collection<ClassConstructorDescriptor> collection = ((ClassDescriptor)expected).getConstructors();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"expected.constructors");
                ClassConstructorDescriptor expectedConstructor = (ClassConstructorDescriptor)CollectionsKt.singleOrNull((Iterable)collection);
                if (expectedConstructor != null && actualConstructor != null) {
                    this.checkAnnotationConstructors(expectedConstructor, (ConstructorDescriptor)actualConstructor, trace, reportOn);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkAmbiguousExpects(Map<ExpectActualCompatibility<MemberDescriptor>, ? extends List<? extends MemberDescriptor>> compatibility, BindingTrace trace, KtNamedDeclaration reportOn, MemberDescriptor descriptor2) {
        void $this$sortedBy$iv;
        Sequence sequence2 = SequencesKt.map((Sequence)SequencesKt.flattenSequenceOfIterable((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)MapsKt.asSequence(compatibility), (Function1)((Function1)new Function1<Map.Entry<? extends ExpectActualCompatibility<? extends MemberDescriptor>, ? extends List<? extends MemberDescriptor>>, Boolean>(this){
            final /* synthetic */ ExpectedActualDeclarationChecker this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Map.Entry<? extends ExpectActualCompatibility<? extends MemberDescriptor>, ? extends List<? extends MemberDescriptor>> entry) {
                Intrinsics.checkNotNullParameter(entry, (String)"<name for destructuring parameter 0>");
                ExpectActualCompatibility<? extends MemberDescriptor> compatibility = entry.getKey();
                return ExpectedActualDeclarationChecker.access$isCompatibleOrWeakCompatible(this.this$0, compatibility);
            }
        })), (Function1)checkAmbiguousExpects.filesWithAtLeastWeaklyCompatibleExpects.2.INSTANCE)), (Function1)checkAmbiguousExpects.filesWithAtLeastWeaklyCompatibleExpects.3.INSTANCE);
        boolean $i$f$sortedBy = false;
        List filesWithAtLeastWeaklyCompatibleExpects2 = SequencesKt.toList((Sequence)SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ModuleDescriptor it = (ModuleDescriptor)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName().asString());
                it = (ModuleDescriptor)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName().asString())));
            }
        }));
        if (filesWithAtLeastWeaklyCompatibleExpects2.size() > 1) {
            trace.report(Errors.AMBIGUOUS_EXPECTS.on((KtNamedDeclaration)((PsiElement)reportOn), descriptor2, filesWithAtLeastWeaklyCompatibleExpects2));
        }
    }

    private final boolean isCompatibleOrWeakCompatible(ExpectActualCompatibility<? extends MemberDescriptor> $this$isCompatibleOrWeakCompatible) {
        return $this$isCompatibleOrWeakCompatible instanceof ExpectActualCompatibility.Compatible || $this$isCompatibleOrWeakCompatible instanceof ExpectActualCompatibility.Incompatible && ((ExpectActualCompatibility.Incompatible)$this$isCompatibleOrWeakCompatible).getKind() == ExpectActualCompatibility.IncompatibilityKind.WEAK;
    }

    private final boolean requireActualModifier(MemberDescriptor descriptor2) {
        return !DescriptorUtilsKt.isAnnotationConstructor(descriptor2) && !DescriptorUtilsKt.isPrimaryConstructorOfInlineClass(descriptor2) && !this.isUnderlyingPropertyOfInlineClass(descriptor2);
    }

    private final boolean isUnderlyingPropertyOfInlineClass(MemberDescriptor descriptor2) {
        return descriptor2 instanceof PropertyDescriptor && InlineClassesUtilsKt.isUnderlyingPropertyOfInlineClass((VariableDescriptor)((Object)descriptor2));
    }

    private final boolean isExplicitActualDeclaration(MemberDescriptor $this$isExplicitActualDeclaration) {
        MemberDescriptor memberDescriptor = $this$isExplicitActualDeclaration;
        return memberDescriptor instanceof ConstructorDescriptor ? DescriptorToSourceUtils.getSourceFromDescriptor($this$isExplicitActualDeclaration) instanceof KtConstructor : (memberDescriptor instanceof CallableMemberDescriptor ? ((CallableMemberDescriptor)$this$isExplicitActualDeclaration).getKind() == CallableMemberDescriptor.Kind.DECLARATION : true);
    }

    private final void checkAnnotationConstructors(ConstructorDescriptor expected, ConstructorDescriptor actual, BindingTrace trace, PsiElement reportOn) {
        for (ValueParameterDescriptor expectedParameterDescriptor : expected.getValueParameters()) {
            PsiElement psiElement;
            ConstantValue constantValue;
            KtParameter expectedParameter;
            Object element$iv2;
            block7: {
                List<ValueParameterDescriptor> list2 = actual.getValueParameters();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"actual.valueParameters");
                Iterable $this$first$iv = list2;
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv2;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)expectedParameterDescriptor.getName())) continue;
                    break block7;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            ValueParameterDescriptor actualParameterDescriptor = (ValueParameterDescriptor)element$iv2;
            if (!expectedParameterDescriptor.declaresDefaultValue() || !actualParameterDescriptor.declaresDefaultValue()) continue;
            Intrinsics.checkNotNullExpressionValue((Object)expectedParameterDescriptor, (String)"expectedParameterDescriptor");
            Object object = DescriptorToSourceUtils.descriptorToDeclaration(expectedParameterDescriptor);
            if ((object instanceof KtParameter ? (KtParameter)object : null) == null) continue;
            expectedParameter = expectedParameter;
            object = (CompileTimeConstant)trace.getBindingContext().get(BindingContext.COMPILE_TIME_VALUE, expectedParameter.getDefaultValue());
            if (object != null) {
                KotlinType kotlinType = expectedParameterDescriptor.getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"expectedParameterDescriptor.type");
                constantValue = object.toConstantValue(kotlinType);
            } else {
                constantValue = null;
            }
            ConstantValue expectedValue = constantValue;
            Intrinsics.checkNotNullExpressionValue((Object)actualParameterDescriptor, (String)"actualParameterDescriptor");
            BindingContext bindingContext = trace.getBindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"trace.bindingContext");
            KotlinType kotlinType = expectedParameterDescriptor.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"expectedParameterDescriptor.type");
            ConstantValue<?> actualValue = this.getActualAnnotationParameterValue(actualParameterDescriptor, bindingContext, kotlinType);
            if (Intrinsics.areEqual(expectedValue, actualValue)) continue;
            PsiElement ktParameter = DescriptorToSourceUtils.descriptorToDeclaration(actualParameterDescriptor);
            KtExpression ktExpression = ktParameter instanceof KtParameter ? (KtParameter)ktParameter : null;
            if (ktExpression != null && (ktExpression = ktExpression.getDefaultValue()) != null) {
                psiElement = ktExpression;
            } else {
                KtTypeAlias ktTypeAlias = reportOn instanceof KtTypeAlias ? (KtTypeAlias)reportOn : null;
                psiElement = ktTypeAlias != null ? ktTypeAlias.getNameIdentifier() : null;
                if (psiElement == null) {
                    psiElement = reportOn;
                }
            }
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"(ktParameter as? KtParam\u2026ameIdentifier ?: reportOn");
            PsiElement target = psiElement;
            trace.report(Errors.ACTUAL_ANNOTATION_CONFLICTING_DEFAULT_ARGUMENT_VALUE.on(target, actualParameterDescriptor));
        }
    }

    private final ConstantValue<?> getActualAnnotationParameterValue(ValueParameterDescriptor actualParameter, BindingContext bindingContext, KotlinType expectedType) {
        PsiElement declaration = DescriptorToSourceUtils.descriptorToDeclaration(actualParameter);
        if (declaration instanceof KtParameter) {
            CompileTimeConstant compileTimeConstant = (CompileTimeConstant)bindingContext.get(BindingContext.COMPILE_TIME_VALUE, ((KtParameter)declaration).getDefaultValue());
            return compileTimeConstant != null ? compileTimeConstant.toConstantValue(expectedType) : null;
        }
        for (ActualAnnotationArgumentExtractor extractor : this.argumentExtractors) {
            ConstantValue<?> constantValue = extractor.extractDefaultValue(actualParameter, expectedType);
            if (constantValue == null) continue;
            ConstantValue<?> it = constantValue;
            boolean bl = false;
            return it;
        }
        return null;
    }

    private static final boolean checkActualDeclarationHasExpected$hasSingleActualSuspect(ExpectedActualDeclarationChecker this$0, Pair<? extends MemberDescriptor, ? extends Map<ExpectActualCompatibility.Incompatible<MemberDescriptor>, ? extends Collection<? extends MemberDescriptor>>> expectedWithIncompatibility) {
        List list2;
        Collection<List<MemberDescriptor>> collection;
        Map<ExpectActualCompatibility<MemberDescriptor>, List<MemberDescriptor>> map;
        MemberDescriptor actualMember;
        MemberDescriptor expectedMember = (MemberDescriptor)expectedWithIncompatibility.component1();
        Map incompatibility = (Map)expectedWithIncompatibility.component2();
        Collection collection2 = (Collection)CollectionsKt.singleOrNull((Iterable)incompatibility.values());
        MemberDescriptor memberDescriptor = actualMember = collection2 != null ? (MemberDescriptor)CollectionsKt.singleOrNull((Iterable)collection2) : null;
        return actualMember != null && this$0.isExplicitActualDeclaration(actualMember) && !Companion.allStrongIncompatibilities(incompatibility) && Intrinsics.areEqual((map = ExpectedActualResolver.INSTANCE.findExpectedForActual(actualMember, ModuleFilterUtilsKt.onlyFromThisModule(DescriptorUtilsKt.getModule(expectedMember)))) != null && (collection = map.values()) != null && (list2 = (List)CollectionsKt.singleOrNull((Iterable)collection)) != null ? (MemberDescriptor)CollectionsKt.singleOrNull((List)list2) : null, (Object)expectedMember);
    }

    public static final /* synthetic */ boolean access$isCompatibleOrWeakCompatible(ExpectedActualDeclarationChecker $this, ExpectActualCompatibility $receiver) {
        return $this.isCompatibleOrWeakCompatible($receiver);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u001e\u0010\u0002\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ExpectedActualDeclarationChecker$ActualAnnotationArgumentExtractor;", "", "extractDefaultValue", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "parameter", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "expectedType", "Lorg/jetbrains/kotlin/types/KotlinType;", "frontend"})
    public static interface ActualAnnotationArgumentExtractor {
        @Nullable
        public ConstantValue<?> extractDefaultValue(@NotNull ValueParameterDescriptor var1, @NotNull KotlinType var2);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u0004*\u001c\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\b0\u0005\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ExpectedActualDeclarationChecker$Companion;", "", "()V", "allStrongIncompatibilities", "", "", "Lorg/jetbrains/kotlin/resolve/multiplatform/ExpectActualCompatibility;", "Lorg/jetbrains/kotlin/descriptors/MemberDescriptor;", "", "frontend"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean allStrongIncompatibilities(@NotNull Map<? extends ExpectActualCompatibility<? extends MemberDescriptor>, ? extends Collection<? extends MemberDescriptor>> $this$allStrongIncompatibilities) {
            boolean bl;
            block3: {
                Intrinsics.checkNotNullParameter($this$allStrongIncompatibilities, (String)"<this>");
                Iterable $this$all$iv = $this$allStrongIncompatibilities.keySet();
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        ExpectActualCompatibility it = (ExpectActualCompatibility)element$iv;
                        boolean bl2 = false;
                        if (it instanceof ExpectActualCompatibility.Incompatible && ((ExpectActualCompatibility.Incompatible)it).getKind() == ExpectActualCompatibility.IncompatibilityKind.STRONG) continue;
                        bl = false;
                        break block3;
                    }
                    bl = true;
                }
            }
            return bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

