/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.plugins;

import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageCollectorUtil;
import org.jetbrains.kotlin.cli.jvm.BundledCompilerPlugins;
import org.jetbrains.kotlin.cli.jvm.plugins.PluginURLClassLoader;
import org.jetbrains.kotlin.compiler.plugin.CliOption;
import org.jetbrains.kotlin.compiler.plugin.CliOptionProcessingException;
import org.jetbrains.kotlin.compiler.plugin.CliOptionValue;
import org.jetbrains.kotlin.compiler.plugin.CliOptionsKt;
import org.jetbrains.kotlin.compiler.plugin.CommandLineProcessor;
import org.jetbrains.kotlin.compiler.plugin.ComponentRegistrar;
import org.jetbrains.kotlin.compiler.plugin.PluginCliOptionProcessingException;
import org.jetbrains.kotlin.config.CompilerConfiguration;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/plugins/PluginCliParser;", "", "()V", "loadPlugins", "", "arguments", "Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "loadPluginsSafe", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "processPluginOptions", "classLoader", "Ljava/lang/ClassLoader;", "cli"})
public final class PluginCliParser {
    public static final PluginCliParser INSTANCE;

    @JvmStatic
    @NotNull
    public static final ExitCode loadPluginsSafe(@NotNull CommonCompilerArguments arguments2, @NotNull CompilerConfiguration configuration) {
        Intrinsics.checkParameterIsNotNull(arguments2, "arguments");
        Intrinsics.checkParameterIsNotNull(configuration, "configuration");
        MessageCollector messageCollector2 = configuration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        try {
            PluginCliParser.loadPlugins(arguments2, configuration);
        }
        catch (PluginCliOptionProcessingException e) {
            String message = e.getMessage() + "\n\n" + CliOptionsKt.cliPluginUsageString(e.getPluginId(), e.getOptions());
            MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.ERROR, message, null, 4, null);
            return ExitCode.INTERNAL_ERROR;
        }
        catch (CliOptionProcessingException e) {
            String string = e.getMessage();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.ERROR, string, null, 4, null);
            return ExitCode.INTERNAL_ERROR;
        }
        catch (Throwable t) {
            MessageCollectorUtil.reportException(messageCollector2, t);
            return ExitCode.INTERNAL_ERROR;
        }
        return ExitCode.OK;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void loadPlugins(@NotNull CommonCompilerArguments arguments2, @NotNull CompilerConfiguration configuration) {
        Object[] objectArray;
        block6: {
            block5: {
                URL[] uRLArray;
                void $receiver$iv$iv;
                Intrinsics.checkParameterIsNotNull(arguments2, "arguments");
                Intrinsics.checkParameterIsNotNull(configuration, "configuration");
                objectArray = arguments2.getPluginClasspaths();
                if (objectArray == null) break block5;
                Object $receiver$iv = objectArray;
                Object[] objectArray2 = $receiver$iv;
                Collection destination$iv$iv = new ArrayList(((Object[])$receiver$iv).length);
                for (void item$iv$iv : $receiver$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    uRLArray = destination$iv$iv;
                    URL uRL = new File((String)it).toURI().toURL();
                    uRLArray.add(uRL);
                }
                uRLArray = (List)destination$iv$iv;
                $receiver$iv = (Collection)uRLArray;
                Object thisCollection$iv = $receiver$iv;
                URL[] uRLArray2 = thisCollection$iv.toArray(new URL[0]);
                if (uRLArray2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                uRLArray = uRLArray2;
                objectArray = uRLArray;
                if (uRLArray != null) break block6;
            }
            objectArray = new URL[]{};
        }
        ClassLoader classLoader = INSTANCE.getClass().getClassLoader();
        Intrinsics.checkExpressionValueIsNotNull(classLoader, "this::class.java.classLoader");
        ClassLoader classLoader2 = classLoader;
        Object[] objectArray3 = objectArray;
        PluginURLClassLoader classLoader3 = new PluginURLClassLoader((URL[])objectArray3, classLoader2);
        ServiceLoader<ComponentRegistrar> serviceLoader = ServiceLoader.load(ComponentRegistrar.class, classLoader3);
        Intrinsics.checkExpressionValueIsNotNull(serviceLoader, "ServiceLoader.load(Compo\u2026:class.java, classLoader)");
        List componentRegistrars = CollectionsKt.toMutableList((Iterable)serviceLoader);
        componentRegistrars.addAll((Collection)BundledCompilerPlugins.INSTANCE.getComponentRegistrars());
        configuration.addAll(ComponentRegistrar.Companion.getPLUGIN_COMPONENT_REGISTRARS(), componentRegistrars);
        INSTANCE.processPluginOptions(arguments2, configuration, classLoader3);
    }

    /*
     * WARNING - void declaration
     */
    private final void processPluginOptions(CommonCompilerArguments arguments2, CompilerConfiguration configuration, ClassLoader classLoader) {
        Object object;
        Object answer$iv$iv$iv;
        Object object2;
        Object object3;
        Iterator<CliOption> iterator2;
        String[] stringArray = arguments2.getPluginOptions();
        if (stringArray != null) {
            Object $receiver$iv$iv;
            Object $receiver$iv = stringArray;
            Object[] objectArray = $receiver$iv;
            Iterator destination$iv$iv = new ArrayList(((Object[])$receiver$iv).length);
            for (void item$iv$iv : $receiver$iv$iv) {
                void p1;
                iterator2 = (String)item$iv$iv;
                object3 = destination$iv$iv;
                object2 = CliOptionsKt.parsePluginOption((String)p1);
                object3.add(object2);
            }
            $receiver$iv = (List)((Object)destination$iv$iv);
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new LinkedHashMap();
            Iterator iterator3 = $receiver$iv$iv.iterator();
            while (iterator3.hasNext()) {
                Object object4;
                Object element$iv$iv = iterator3.next();
                CliOptionValue it = (CliOptionValue)element$iv$iv;
                if (it == null) {
                    throw (Throwable)new CliOptionProcessingException("Wrong plugin option format: " + it + ", should be plugin:<pluginId>:<optionName>=<value>", null, 2, null);
                }
                Iterator $receiver$iv$iv$iv = destination$iv$iv;
                String key$iv$iv = it.getPluginId();
                Object value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    answer$iv$iv$iv = new ArrayList();
                    $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object4 = answer$iv$iv$iv;
                } else {
                    object4 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object4;
                list$iv$iv.add(element$iv$iv);
            }
            object = destination$iv$iv;
        } else {
            object = MapsKt.emptyMap();
        }
        Map optionValuesByPlugin = object;
        ServiceLoader<CommandLineProcessor> serviceLoader = ServiceLoader.load(CommandLineProcessor.class, classLoader);
        Intrinsics.checkExpressionValueIsNotNull(serviceLoader, "ServiceLoader.load(Comma\u2026:class.java, classLoader)");
        List<CommandLineProcessor> commandLineProcessors = CollectionsKt.toMutableList((Iterable)serviceLoader);
        commandLineProcessors.addAll((Collection<CommandLineProcessor>)BundledCompilerPlugins.INSTANCE.getCommandLineProcessors());
        for (CommandLineProcessor processor : commandLineProcessors) {
            void $receiver$iv$iv;
            Iterable $receiver$iv = processor.getPluginOptions();
            int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10)), 16);
            Iterable $i$a$2$groupBy = $receiver$iv;
            List destination$iv$iv = new LinkedHashMap(capacity$iv);
            for (Object element$iv$iv : $receiver$iv$iv) {
                void it;
                answer$iv$iv$iv = (CliOption)element$iv$iv;
                object3 = destination$iv$iv;
                object2 = it.getName();
                object3.put(object2, element$iv$iv);
            }
            Map declaredOptions = destination$iv$iv;
            MultiMap<CliOption, CliOptionValue> optionsToValues = new MultiMap<CliOption, CliOptionValue>();
            destination$iv$iv = (List)optionValuesByPlugin.get(processor.getPluginId());
            List list2 = destination$iv$iv;
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
            iterator2 = list2.iterator();
            while (iterator2.hasNext()) {
                CliOption option;
                CliOptionValue optionValue;
                CliOptionValue cliOptionValue = optionValue = (CliOptionValue)iterator2.next();
                if (cliOptionValue == null) {
                    Intrinsics.throwNpe();
                }
                if ((CliOption)declaredOptions.get(cliOptionValue.getOptionName()) == null) {
                    throw (Throwable)new CliOptionProcessingException("Unsupported plugin option: " + optionValue, null, 2, null);
                }
                optionsToValues.putValue(option, optionValue);
            }
            for (CliOption option : processor.getPluginOptions()) {
                Collection values = optionsToValues.get(option);
                if (option.getRequired() && values.isEmpty()) {
                    throw (Throwable)new PluginCliOptionProcessingException(processor.getPluginId(), processor.getPluginOptions(), "Required plugin option not present: " + processor.getPluginId() + ':' + option.getName(), null, 8, null);
                }
                if (!option.getAllowMultipleOccurrences() && values.size() > 1) {
                    throw (Throwable)new PluginCliOptionProcessingException(processor.getPluginId(), processor.getPluginOptions(), "Multiple values are not allowed for plugin option " + processor.getPluginId() + ':' + option.getName(), null, 8, null);
                }
                for (CliOptionValue value : values) {
                    processor.processOption(option, value.getValue(), configuration);
                }
            }
        }
    }

    private PluginCliParser() {
    }

    static {
        PluginCliParser pluginCliParser;
        INSTANCE = pluginCliParser = new PluginCliParser();
    }
}

