/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.utils;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n*\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u001a \u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n*\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0006*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\b\u00a8\u0006\u0012"}, d2={"constructedClass", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "Lorg/jetbrains/kotlin/ir/symbols/IrConstructorSymbol;", "getConstructedClass", "(Lorg/jetbrains/kotlin/ir/symbols/IrConstructorSymbol;)Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "isAny", "", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "(Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;)Z", "getFunctions", "", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "packageFqName", "name", "Lorg/jetbrains/kotlin/name/Name;", "backend.js"})
public final class DescriptorBasedUtilsKt {
    @NotNull
    public static final ClassDescriptor getConstructedClass(@NotNull IrConstructorSymbol $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return ((ClassConstructorDescriptor)$receiver.getDescriptor()).getConstructedClass();
    }

    public static final boolean isAny(@NotNull IrClassSymbol $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return KotlinBuiltIns.isAny((ClassDescriptor)$receiver.getDescriptor());
    }

    @NotNull
    public static final List<FunctionDescriptor> getFunctions(@NotNull ModuleDescriptor $receiver, @NotNull FqName fqName2) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(fqName2, "fqName");
        FqName fqName3 = fqName2.parent();
        Intrinsics.checkExpressionValueIsNotNull(fqName3, "fqName.parent()");
        Name name = fqName2.shortName();
        Intrinsics.checkExpressionValueIsNotNull(name, "fqName.shortName()");
        return DescriptorBasedUtilsKt.getFunctions($receiver, fqName3, name);
    }

    @NotNull
    public static final List<FunctionDescriptor> getFunctions(@NotNull ModuleDescriptor $receiver, @NotNull FqName packageFqName, @NotNull Name name) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(packageFqName, "packageFqName");
        Intrinsics.checkParameterIsNotNull(name, "name");
        return CollectionsKt.toList((Iterable)$receiver.getPackage(packageFqName).getMemberScope().getContributedFunctions(name, NoLookupLocation.FROM_BACKEND));
    }
}

