/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.script;

import java.util.Iterator;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.script.CachingSequence;
import org.jetbrains.kotlin.script.KotlinScriptDefinition;
import org.jetbrains.kotlin.script.ScriptDefinitionProvider;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b&\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0004J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0014R\u0016\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0018\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0014\u0010\u000b\u001a\u00020\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/script/LazyScriptDefinitionProvider;", "Lorg/jetbrains/kotlin/script/ScriptDefinitionProvider;", "()V", "_cachedDefinitions", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/script/KotlinScriptDefinition;", "cachedDefinitions", "getCachedDefinitions", "()Lkotlin/sequences/Sequence;", "currentDefinitions", "getCurrentDefinitions", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "getLock", "()Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "clearCache", "", "findScriptDefinition", "fileName", "", "isScript", "", "nonScriptFileName", "Companion", "psi"})
public abstract class LazyScriptDefinitionProvider
implements ScriptDefinitionProvider {
    @NotNull
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private Sequence<? extends KotlinScriptDefinition> _cachedDefinitions;
    @NotNull
    private static final String[] nonScriptFilenameSuffixes;
    public static final Companion Companion;

    @NotNull
    protected final ReentrantReadWriteLock getLock() {
        return this.lock;
    }

    @NotNull
    protected abstract Sequence<KotlinScriptDefinition> getCurrentDefinitions();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Sequence<KotlinScriptDefinition> getCachedDefinitions() {
        boolean bl;
        boolean bl2 = bl = this.lock.getReadLockCount() > 0;
        if (_Assertions.ENABLED && !bl) {
            String string = "cachedDefinitions should only be used under the read lock";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        if (this._cachedDefinitions == null) {
            int n;
            ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            int n2 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
            int n3 = 0;
            int n4 = n2;
            while (n3 < n4) {
                n = n3++;
                readLock.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            writeLock.lock();
            try {
                this._cachedDefinitions = new CachingSequence<KotlinScriptDefinition>(SequencesKt.constrainOnce(this.getCurrentDefinitions()));
                Unit unit = Unit.INSTANCE;
            }
            finally {
                n = 0;
                int n5 = n2;
                while (n < n5) {
                    int n6 = n++;
                    readLock.lock();
                }
                writeLock.unlock();
            }
        }
        Sequence<KotlinScriptDefinition> sequence2 = this._cachedDefinitions;
        if (sequence2 == null) {
            Intrinsics.throwNpe();
        }
        return sequence2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void clearCache() {
        int n;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n2 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        int n3 = 0;
        int n4 = n2;
        while (n3 < n4) {
            n = n3++;
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            this._cachedDefinitions = null;
            Unit unit = Unit.INSTANCE;
        }
        finally {
            n = 0;
            int n5 = n2;
            while (n < n5) {
                int n6 = n++;
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    protected boolean nonScriptFileName(@NotNull String fileName) {
        boolean bl;
        block1: {
            Intrinsics.checkParameterIsNotNull(fileName, "fileName");
            for (String element$iv : nonScriptFilenameSuffixes) {
                String it = element$iv;
                if (!StringsKt.endsWith(fileName, it, true)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public KotlinScriptDefinition findScriptDefinition(@NotNull String fileName) {
        KotlinScriptDefinition kotlinScriptDefinition;
        Intrinsics.checkParameterIsNotNull(fileName, "fileName");
        if (this.nonScriptFileName(fileName)) {
            kotlinScriptDefinition = null;
        } else {
            ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            readLock.lock();
            try {
                KotlinScriptDefinition kotlinScriptDefinition2;
                block6: {
                    Sequence<KotlinScriptDefinition> $receiver$iv = this.getCachedDefinitions();
                    Iterator<KotlinScriptDefinition> iterator2 = $receiver$iv.iterator();
                    while (iterator2.hasNext()) {
                        KotlinScriptDefinition element$iv = iterator2.next();
                        KotlinScriptDefinition it = element$iv;
                        if (!it.isScript(fileName)) continue;
                        kotlinScriptDefinition2 = element$iv;
                        break block6;
                    }
                    kotlinScriptDefinition2 = null;
                }
                KotlinScriptDefinition kotlinScriptDefinition3 = kotlinScriptDefinition2;
                kotlinScriptDefinition = kotlinScriptDefinition3;
            }
            finally {
                readLock.unlock();
            }
        }
        return kotlinScriptDefinition;
    }

    @Override
    public boolean isScript(@NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull(fileName, "fileName");
        return this.findScriptDefinition(fileName) != null;
    }

    static {
        Companion = new Companion(null);
        nonScriptFilenameSuffixes = new String[]{".kt", ".java"};
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/script/LazyScriptDefinitionProvider$Companion;", "", "()V", "nonScriptFilenameSuffixes", "", "", "getNonScriptFilenameSuffixes", "()[Ljava/lang/String;", "[Ljava/lang/String;", "psi"})
    public static final class Companion {
        @NotNull
        protected final String[] getNonScriptFilenameSuffixes() {
            return nonScriptFilenameSuffixes;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

