/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitution;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B#\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0002\u0010\u0007B+\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\b\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0013\u001a\u00020\u000bH\u0016J\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0015\u001a\u00020\u0016H\u0096\u0002J\b\u0010\u0017\u001a\u00020\u000bH\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\b\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u0019\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\b\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/types/IndexedParametersSubstitution;", "Lorg/jetbrains/kotlin/types/TypeSubstitution;", "parameters", "", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "argumentsList", "Lorg/jetbrains/kotlin/types/TypeProjection;", "(Ljava/util/List;Ljava/util/List;)V", "", "arguments", "approximateCapturedTypes", "", "([Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;[Lorg/jetbrains/kotlin/types/TypeProjection;Z)V", "getArguments", "()[Lorg/jetbrains/kotlin/types/TypeProjection;", "[Lorg/jetbrains/kotlin/types/TypeProjection;", "getParameters", "()[Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "[Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "approximateContravariantCapturedTypes", "get", "key", "Lorg/jetbrains/kotlin/types/KotlinType;", "isEmpty", "descriptors"})
public final class IndexedParametersSubstitution
extends TypeSubstitution {
    @NotNull
    private final TypeParameterDescriptor[] parameters;
    @NotNull
    private final TypeProjection[] arguments;
    private final boolean approximateCapturedTypes;

    @Override
    public boolean isEmpty() {
        TypeProjection[] typeProjectionArray = this.arguments;
        return typeProjectionArray.length == 0;
    }

    @Override
    public boolean approximateContravariantCapturedTypes() {
        return this.approximateCapturedTypes;
    }

    @Override
    @Nullable
    public TypeProjection get(@NotNull KotlinType key) {
        Intrinsics.checkParameterIsNotNull(key, "key");
        ClassifierDescriptor classifierDescriptor = key.getConstructor().getDeclarationDescriptor();
        if (!(classifierDescriptor instanceof TypeParameterDescriptor)) {
            classifierDescriptor = null;
        }
        TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)classifierDescriptor;
        if (typeParameterDescriptor == null) {
            return null;
        }
        TypeParameterDescriptor parameter = typeParameterDescriptor;
        int index2 = parameter.getIndex();
        if (index2 < this.parameters.length && Intrinsics.areEqual(this.parameters[index2].getTypeConstructor(), parameter.getTypeConstructor())) {
            return this.arguments[index2];
        }
        return null;
    }

    @NotNull
    public final TypeParameterDescriptor[] getParameters() {
        return this.parameters;
    }

    @NotNull
    public final TypeProjection[] getArguments() {
        return this.arguments;
    }

    public IndexedParametersSubstitution(@NotNull TypeParameterDescriptor[] parameters2, @NotNull TypeProjection[] arguments2, boolean approximateCapturedTypes2) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(parameters2, "parameters");
        Intrinsics.checkParameterIsNotNull(arguments2, "arguments");
        this.parameters = parameters2;
        this.arguments = arguments2;
        this.approximateCapturedTypes = approximateCapturedTypes2;
        boolean bl2 = bl = this.parameters.length <= this.arguments.length;
        if (_Assertions.ENABLED && !bl) {
            String string = "Number of arguments should not be less then number of parameters, but: parameters=" + this.parameters.length + ", args=" + this.arguments.length;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
    }

    public /* synthetic */ IndexedParametersSubstitution(TypeParameterDescriptor[] typeParameterDescriptorArray, TypeProjection[] typeProjectionArray, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(typeParameterDescriptorArray, typeProjectionArray, bl);
    }

    public IndexedParametersSubstitution(@NotNull List<? extends TypeParameterDescriptor> parameters2, @NotNull List<? extends TypeProjection> argumentsList) {
        Collection $receiver$iv;
        Intrinsics.checkParameterIsNotNull(parameters2, "parameters");
        Intrinsics.checkParameterIsNotNull(argumentsList, "argumentsList");
        Collection collection = parameters2;
        IndexedParametersSubstitution indexedParametersSubstitution = this;
        Collection thisCollection$iv = $receiver$iv;
        TypeParameterDescriptor[] typeParameterDescriptorArray = thisCollection$iv.toArray(new TypeParameterDescriptor[0]);
        if (typeParameterDescriptorArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        TypeParameterDescriptor[] typeParameterDescriptorArray2 = typeParameterDescriptorArray;
        thisCollection$iv = $receiver$iv = (Collection)argumentsList;
        TypeProjection[] typeProjectionArray = thisCollection$iv.toArray(new TypeProjection[0]);
        if (typeProjectionArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        TypeProjection[] typeProjectionArray2 = typeProjectionArray;
        indexedParametersSubstitution(typeParameterDescriptorArray2, typeProjectionArray2, false, 4, null);
    }
}

