/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs.impl;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.impl.PsiElementFactoryImpl;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiAnnotationStub;
import com.intellij.psi.impl.source.CharTableImpl;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.reference.SoftReference;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.IncorrectOperationException;

public class PsiAnnotationStubImpl
extends StubBase<PsiAnnotation>
implements PsiAnnotationStub {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.java.stubs.impl.PsiAnnotationStubImpl");
    private final String myText;
    private SoftReference<PsiAnnotation> myParsedFromRepository;

    public PsiAnnotationStubImpl(StubElement parent2, String text2) {
        super(parent2, JavaStubElementTypes.ANNOTATION);
        CharSequence interned = CharTableImpl.getStaticInterned(text2);
        this.myText = interned == null ? text2 : interned.toString();
    }

    @Override
    public String getText() {
        return this.myText;
    }

    @Override
    public PsiAnnotation getPsiElement() {
        PsiAnnotation annotation2 = SoftReference.dereference(this.myParsedFromRepository);
        if (annotation2 != null) {
            return annotation2;
        }
        String text2 = this.getText();
        try {
            PsiJavaParserFacade facade = JavaPsiFacade.getInstance(this.getProject()).getParserFacade();
            annotation2 = facade instanceof PsiElementFactoryImpl ? ((PsiElementFactoryImpl)facade).createAnnotationFromText(text2, (PsiElement)this.getPsi(), false) : facade.createAnnotationFromText(text2, (PsiElement)this.getPsi());
            ((LightVirtualFile)annotation2.getContainingFile().getViewProvider().getVirtualFile()).setWritable(false);
            this.myParsedFromRepository = new SoftReference<PsiAnnotation>(annotation2);
            return annotation2;
        }
        catch (IncorrectOperationException e) {
            LOG.error("Bad annotation in " + this.fileName(), e);
            return null;
        }
    }

    private String fileName() {
        StubElement<PsiAnnotation> stub2 = this;
        while ((stub2 = stub2.getParentStub()) != null) {
            PsiAnnotation psi;
            if (!(stub2 instanceof PsiFileStub) || !((psi = stub2.getPsi()) instanceof PsiFile)) continue;
            VirtualFile file2 = ((PsiFile)((Object)psi)).getVirtualFile();
            return file2 != null ? file2.getUrl() : ((PsiFile)((Object)psi)).getName();
        }
        return "<unknown file>";
    }

    @Override
    public String toString() {
        return "PsiAnnotationStub[" + this.myText + ']';
    }

    static {
        CharTableImpl.addStringsFromClassToStatics(AnnotationUtil.class);
        CharTableImpl.staticIntern("@NotNull");
        CharTableImpl.staticIntern("@Nullable");
        CharTableImpl.staticIntern("@Override");
    }
}

