/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.clean;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsDefault;
import org.jetbrains.kotlin.js.backend.ast.JsEmpty;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsLabel;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsSwitch;
import org.jetbrains.kotlin.js.backend.ast.JsSwitchMember;
import org.jetbrains.kotlin.js.backend.ast.JsTry;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContextImpl;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\u0006R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/EmptyStatementElimination;", "", "root", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "(Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;)V", "hasChanges", "", "apply", "js.translator"})
public final class EmptyStatementElimination {
    private boolean hasChanges;
    private final JsStatement root;

    public final boolean apply() {
        new JsVisitorWithContextImpl(this){
            final /* synthetic */ EmptyStatementElimination this$0;

            public boolean visit(@NotNull JsFunction x, @NotNull JsContext<?> ctx) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                Intrinsics.checkParameterIsNotNull(ctx, "ctx");
                return false;
            }

            public void endVisit(@NotNull JsLabel x, @NotNull JsContext<JsNode> ctx) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                Intrinsics.checkParameterIsNotNull(ctx, "ctx");
                if (MetadataProperties.getSynthetic(x)) {
                    JsStatement jsStatement = x.getStatement();
                    Intrinsics.checkExpressionValueIsNotNull(jsStatement, "x.statement");
                    if (this.isEmpty(jsStatement)) {
                        ctx.replaceMe((JsNode)x.getStatement());
                        EmptyStatementElimination.access$setHasChanges$p(this.this$0, true);
                    }
                }
            }

            public void endVisit(@NotNull JsBlock x, @NotNull JsContext<?> ctx) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                Intrinsics.checkParameterIsNotNull(ctx, "ctx");
                List<JsStatement> list2 = x.getStatements();
                Intrinsics.checkExpressionValueIsNotNull(list2, "x.statements");
                this.processStatements(list2);
            }

            public void endVisit(@NotNull JsIf x, @NotNull JsContext<JsNode> ctx) {
                boolean elseEmpty;
                boolean bl;
                Intrinsics.checkParameterIsNotNull(x, "x");
                Intrinsics.checkParameterIsNotNull(ctx, "ctx");
                JsStatement jsStatement = x.getThenStatement();
                Intrinsics.checkExpressionValueIsNotNull(jsStatement, "x.thenStatement");
                boolean thenEmpty = this.isEmpty(jsStatement);
                JsStatement jsStatement2 = x.getElseStatement();
                if (jsStatement2 != null) {
                    JsStatement jsStatement3;
                    JsStatement it;
                    JsStatement jsStatement4 = it = (jsStatement3 = jsStatement2);
                    Intrinsics.checkExpressionValueIsNotNull(jsStatement4, "it");
                    bl = this.isEmpty(jsStatement4);
                } else {
                    bl = elseEmpty = true;
                }
                if (thenEmpty && elseEmpty) {
                    EmptyStatementElimination.access$setHasChanges$p(this.this$0, true);
                    ctx.replaceMe((JsNode)JsAstUtils.asSyntheticStatement(x.getIfExpression()));
                } else if (elseEmpty) {
                    if (x.getElseStatement() != null) {
                        EmptyStatementElimination.access$setHasChanges$p(this.this$0, true);
                        x.setElseStatement(null);
                    }
                } else if (thenEmpty) {
                    EmptyStatementElimination.access$setHasChanges$p(this.this$0, true);
                    JsStatement jsStatement5 = x.getElseStatement();
                    if (jsStatement5 == null) {
                        Intrinsics.throwNpe();
                    }
                    x.setThenStatement(jsStatement5);
                    x.setElseStatement(null);
                    x.setIfExpression(JsAstUtils.notOptimized(x.getIfExpression()));
                }
            }

            public void endVisit(@NotNull JsTry x, @NotNull JsContext<JsNode> ctx) {
                Intrinsics.checkParameterIsNotNull(x, "x");
                Intrinsics.checkParameterIsNotNull(ctx, "ctx");
                JsBlock finallyBlock = x.getFinallyBlock();
                JsBlock jsBlock = x.getTryBlock();
                Intrinsics.checkExpressionValueIsNotNull(jsBlock, "x.tryBlock");
                if (jsBlock.isEmpty()) {
                    EmptyStatementElimination.access$setHasChanges$p(this.this$0, true);
                    JsBlock jsBlock2 = finallyBlock;
                    ctx.replaceMe(jsBlock2 != null ? (JsNode)jsBlock2 : (JsNode)JsEmpty.INSTANCE);
                }
            }

            public void endVisit(@NotNull JsSwitch x, @NotNull JsContext<JsNode> ctx) {
                block16: {
                    Object object;
                    block15: {
                        boolean bl;
                        block13: {
                            JsSwitchMember element$iv;
                            JsSwitchMember it;
                            Iterable $receiver$iv;
                            block14: {
                                boolean bl2;
                                block12: {
                                    Intrinsics.checkParameterIsNotNull(x, "x");
                                    Intrinsics.checkParameterIsNotNull(ctx, "ctx");
                                    object = x.getCases().iterator();
                                    while (object.hasNext()) {
                                        JsSwitchMember jsSwitchMember;
                                        JsSwitchMember jsSwitchMember2 = jsSwitchMember = object.next();
                                        Intrinsics.checkExpressionValueIsNotNull(jsSwitchMember2, "case");
                                        List<JsStatement> list2 = jsSwitchMember2.getStatements();
                                        Intrinsics.checkExpressionValueIsNotNull(list2, "case.statements");
                                        this.processStatements(list2);
                                    }
                                    List<JsSwitchMember> list3 = x.getCases();
                                    Intrinsics.checkExpressionValueIsNotNull(list3, "x.cases");
                                    if (!(CollectionsKt.lastOrNull(list3) instanceof JsDefault)) break block14;
                                    List<JsSwitchMember> list4 = x.getCases();
                                    Intrinsics.checkExpressionValueIsNotNull(list4, "x.cases");
                                    $receiver$iv = CollectionsKt.dropLast(list4, 1);
                                    if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                                        bl2 = true;
                                    } else {
                                        object = $receiver$iv.iterator();
                                        while (object.hasNext()) {
                                            JsSwitchMember jsSwitchMember = it = (element$iv = object.next());
                                            Intrinsics.checkExpressionValueIsNotNull(jsSwitchMember, "it");
                                            if (jsSwitchMember.getStatements().isEmpty()) continue;
                                            bl2 = false;
                                            break block12;
                                        }
                                        bl2 = true;
                                    }
                                }
                                if (bl2) break block15;
                            }
                            List<JsSwitchMember> list5 = x.getCases();
                            Intrinsics.checkExpressionValueIsNotNull(list5, "x.cases");
                            $receiver$iv = list5;
                            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                                bl = true;
                            } else {
                                object = $receiver$iv.iterator();
                                while (object.hasNext()) {
                                    JsSwitchMember jsSwitchMember = it = (element$iv = object.next());
                                    Intrinsics.checkExpressionValueIsNotNull(jsSwitchMember, "it");
                                    if (jsSwitchMember.getStatements().isEmpty()) continue;
                                    bl = false;
                                    break block13;
                                }
                                bl = true;
                            }
                        }
                        if (!bl) break block16;
                    }
                    EmptyStatementElimination.access$setHasChanges$p(this.this$0, true);
                    List<JsStatement> replacement = CollectionsKt.mutableListOf(JsAstUtils.asSyntheticStatement(x.getExpression()));
                    List<JsSwitchMember> list6 = x.getCases();
                    Intrinsics.checkExpressionValueIsNotNull(list6, "x.cases");
                    JsSwitchMember jsSwitchMember = CollectionsKt.lastOrNull(list6);
                    if (jsSwitchMember != null) {
                        Object $receiver = object = jsSwitchMember;
                        List<JsStatement> list7 = ((JsSwitchMember)$receiver).getStatements();
                        Intrinsics.checkExpressionValueIsNotNull(list7, "statements");
                        replacement.addAll((Collection<JsStatement>)list7);
                    }
                    ctx.replaceMe((JsNode)new JsBlock(replacement));
                }
            }

            private final void processStatements(List<JsStatement> statements) {
                for (IndexedValue<T> indexedValue : CollectionsKt.reversed(CollectionsKt.withIndex((Iterable)statements))) {
                    int index2 = indexedValue.component1();
                    JsStatement statement2 = (JsStatement)indexedValue.component2();
                    if (statement2 instanceof JsEmpty) {
                        statements.remove(index2);
                        EmptyStatementElimination.access$setHasChanges$p(this.this$0, true);
                        continue;
                    }
                    if (!(statement2 instanceof JsBlock)) continue;
                    statements.remove(index2);
                    List<JsStatement> list2 = ((JsBlock)statement2).getStatements();
                    Intrinsics.checkExpressionValueIsNotNull(list2, "statement.statements");
                    statements.addAll(index2, (Collection<JsStatement>)list2);
                }
            }

            private final boolean isEmpty(JsStatement statement2) {
                return statement2 instanceof JsBlock && ((JsBlock)statement2).isEmpty() || statement2 instanceof JsEmpty;
            }
            {
                this.this$0 = $outer;
            }
        }.accept((JsNode)this.root);
        return this.hasChanges;
    }

    public EmptyStatementElimination(@NotNull JsStatement root2) {
        Intrinsics.checkParameterIsNotNull(root2, "root");
        this.root = root2;
    }

    public static final /* synthetic */ boolean access$getHasChanges$p(EmptyStatementElimination $this) {
        return $this.hasChanges;
    }

    public static final /* synthetic */ void access$setHasChanges$p(EmptyStatementElimination $this, boolean bl) {
        $this.hasChanges = bl;
    }
}

