/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.FindClassInModuleKt;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationArgumentVisitor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.resolve.constants.ClassLiteralValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001bB\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\r\u0012\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\tJ=\u0010\u000e\u001a\n \u0010*\u0004\u0018\u0001H\u000fH\u000f\"\u0004\b\u0000\u0010\u000f\"\u0004\b\u0001\u0010\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u0002H\u000f\u0012\u0004\u0012\u0002H\u00110\u00132\u0006\u0010\u0014\u001a\u0002H\u0011H\u0016\u00a2\u0006\u0002\u0010\u0015J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/resolve/constants/KClassValue;", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "Lorg/jetbrains/kotlin/resolve/constants/ClassLiteralValue;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "arrayDimensions", "", "(Lorg/jetbrains/kotlin/name/ClassId;I)V", "value", "(Lorg/jetbrains/kotlin/resolve/constants/ClassLiteralValue;)V", "getArrayDimensions", "()I", "getClassId", "()Lorg/jetbrains/kotlin/name/ClassId;", "accept", "R", "kotlin.jvm.PlatformType", "D", "visitor", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationArgumentVisitor;", "data", "(Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationArgumentVisitor;Ljava/lang/Object;)Ljava/lang/Object;", "getArgumentType", "Lorg/jetbrains/kotlin/types/KotlinType;", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "getType", "Companion", "descriptors"})
public final class KClassValue
extends ConstantValue<ClassLiteralValue> {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final ClassId getClassId() {
        return ((ClassLiteralValue)this.getValue()).getClassId();
    }

    public final int getArrayDimensions() {
        return ((ClassLiteralValue)this.getValue()).getArrayNestedness();
    }

    @Override
    @NotNull
    public KotlinType getType(@NotNull ModuleDescriptor module2) {
        Intrinsics.checkParameterIsNotNull(module2, "module");
        Annotations annotations2 = Annotations.Companion.getEMPTY();
        ClassDescriptor classDescriptor2 = module2.getBuiltIns().getKClass();
        Intrinsics.checkExpressionValueIsNotNull(classDescriptor2, "module.builtIns.kClass");
        return KotlinTypeFactory.simpleNotNullType(annotations2, classDescriptor2, CollectionsKt.listOf(new TypeProjectionImpl(this.getArgumentType(module2))));
    }

    @NotNull
    public final KotlinType getArgumentType(@NotNull ModuleDescriptor module2) {
        Intrinsics.checkParameterIsNotNull(module2, "module");
        ClassDescriptor classDescriptor2 = FindClassInModuleKt.findClassAcrossModuleDependencies(module2, this.getClassId());
        if (classDescriptor2 == null) {
            SimpleType simpleType2 = ErrorUtils.createErrorType("Unresolved type: " + this.getClassId() + " (arrayDimensions=" + this.getArrayDimensions() + ')');
            Intrinsics.checkExpressionValueIsNotNull(simpleType2, "ErrorUtils.createErrorTy\u2026sions=$arrayDimensions)\")");
            return simpleType2;
        }
        ClassDescriptor descriptor2 = classDescriptor2;
        SimpleType simpleType3 = descriptor2.getDefaultType();
        Intrinsics.checkExpressionValueIsNotNull(simpleType3, "descriptor.defaultType");
        KotlinType type2 = TypeUtilsKt.replaceArgumentsWithStarProjections(simpleType3);
        int n = this.getArrayDimensions();
        int n2 = 0;
        int n3 = n;
        while (n2 < n3) {
            int it = n2++;
            SimpleType simpleType4 = module2.getBuiltIns().getArrayType(Variance.INVARIANT, type2);
            Intrinsics.checkExpressionValueIsNotNull(simpleType4, "module.builtIns.getArray\u2026Variance.INVARIANT, type)");
            type2 = simpleType4;
        }
        return type2;
    }

    @Override
    public <R, D> R accept(@NotNull AnnotationArgumentVisitor<R, D> visitor2, D data) {
        Intrinsics.checkParameterIsNotNull(visitor2, "visitor");
        return visitor2.visitKClassValue(this, data);
    }

    public KClassValue(@NotNull ClassLiteralValue value) {
        Intrinsics.checkParameterIsNotNull(value, "value");
        super(value);
    }

    public KClassValue(@NotNull ClassId classId, int arrayDimensions) {
        Intrinsics.checkParameterIsNotNull(classId, "classId");
        this(new ClassLiteralValue(classId, arrayDimensions));
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/resolve/constants/KClassValue$Companion;", "", "()V", "create", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "argumentType", "Lorg/jetbrains/kotlin/types/KotlinType;", "descriptors"})
    public static final class Companion {
        @Nullable
        public final ConstantValue<?> create(@NotNull KotlinType argumentType) {
            ConstantValue constantValue;
            Intrinsics.checkParameterIsNotNull(argumentType, "argumentType");
            if (KotlinTypeKt.isError(argumentType)) {
                return null;
            }
            KotlinType type2 = argumentType;
            int arrayDimensions = 0;
            while (KotlinBuiltIns.isArray(type2)) {
                Intrinsics.checkExpressionValueIsNotNull(CollectionsKt.single(type2.getArguments()).getType(), "type.arguments.single().type");
                ++arrayDimensions;
            }
            ClassifierDescriptor descriptor2 = type2.getConstructor().getDeclarationDescriptor();
            if (descriptor2 instanceof ClassDescriptor) {
                ClassId classId = DescriptorUtilsKt.getClassId(descriptor2);
                if (classId == null) {
                    return null;
                }
                ClassId classId2 = classId;
                constantValue = new KClassValue(classId2, arrayDimensions);
            } else if (descriptor2 instanceof TypeParameterDescriptor) {
                ClassId classId = ClassId.topLevel(KotlinBuiltIns.FQ_NAMES.any.toSafe());
                Intrinsics.checkExpressionValueIsNotNull(classId, "ClassId.topLevel(KotlinB\u2026ns.FQ_NAMES.any.toSafe())");
                constantValue = new KClassValue(classId, 0);
            } else {
                constantValue = null;
            }
            return constantValue;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

