/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.load.java.components.JavaResolverCache;
import org.jetbrains.kotlin.load.java.lazy.LazyJavaPackageFragmentProvider;
import org.jetbrains.kotlin.load.java.lazy.descriptors.LazyJavaPackageFragment;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.load.java.structure.LightClassOriginKind;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/JavaDescriptorResolver;", "", "packageFragmentProvider", "Lorg/jetbrains/kotlin/load/java/lazy/LazyJavaPackageFragmentProvider;", "javaResolverCache", "Lorg/jetbrains/kotlin/load/java/components/JavaResolverCache;", "(Lorg/jetbrains/kotlin/load/java/lazy/LazyJavaPackageFragmentProvider;Lorg/jetbrains/kotlin/load/java/components/JavaResolverCache;)V", "getPackageFragmentProvider", "()Lorg/jetbrains/kotlin/load/java/lazy/LazyJavaPackageFragmentProvider;", "resolveClass", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "javaClass", "Lorg/jetbrains/kotlin/load/java/structure/JavaClass;", "descriptors.jvm"})
public final class JavaDescriptorResolver {
    @NotNull
    private final LazyJavaPackageFragmentProvider packageFragmentProvider;
    private final JavaResolverCache javaResolverCache;

    @Nullable
    public final ClassDescriptor resolveClass(@NotNull JavaClass javaClass) {
        Intrinsics.checkParameterIsNotNull(javaClass, "javaClass");
        FqName fqName2 = javaClass.getFqName();
        if (fqName2 != null && javaClass.getLightClassOriginKind() == LightClassOriginKind.SOURCE) {
            return this.javaResolverCache.getClassResolvedFromSource(fqName2);
        }
        JavaClass javaClass2 = javaClass.getOuterClass();
        if (javaClass2 != null) {
            MemberScope outerClassScope;
            JavaClass javaClass3 = javaClass2;
            boolean bl = false;
            boolean bl2 = false;
            JavaClass outerClass2 = javaClass3;
            boolean bl3 = false;
            ClassDescriptor classDescriptor2 = this.resolveClass(outerClass2);
            MemberScope memberScope2 = outerClassScope = classDescriptor2 != null ? classDescriptor2.getUnsubstitutedInnerClassesScope() : null;
            ClassifierDescriptor classifierDescriptor = memberScope2 != null ? memberScope2.getContributedClassifier(javaClass.getName(), NoLookupLocation.FROM_JAVA_LOADER) : null;
            if (!(classifierDescriptor instanceof ClassDescriptor)) {
                classifierDescriptor = null;
            }
            return (ClassDescriptor)classifierDescriptor;
        }
        if (fqName2 == null) {
            return null;
        }
        FqName fqName3 = fqName2.parent();
        Intrinsics.checkExpressionValueIsNotNull(fqName3, "fqName.parent()");
        LazyJavaPackageFragment lazyJavaPackageFragment = CollectionsKt.firstOrNull(this.packageFragmentProvider.getPackageFragments(fqName3));
        return lazyJavaPackageFragment != null ? lazyJavaPackageFragment.findClassifierByJavaClass$descriptors_jvm(javaClass) : null;
    }

    @NotNull
    public final LazyJavaPackageFragmentProvider getPackageFragmentProvider() {
        return this.packageFragmentProvider;
    }

    public JavaDescriptorResolver(@NotNull LazyJavaPackageFragmentProvider packageFragmentProvider, @NotNull JavaResolverCache javaResolverCache) {
        Intrinsics.checkParameterIsNotNull(packageFragmentProvider, "packageFragmentProvider");
        Intrinsics.checkParameterIsNotNull(javaResolverCache, "javaResolverCache");
        this.packageFragmentProvider = packageFragmentProvider;
        this.javaResolverCache = javaResolverCache;
    }
}

