/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization;

import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.SourceFile;
import org.jetbrains.kotlin.descriptors.konan.KlibModuleOriginKt;
import org.jetbrains.kotlin.library.metadata.DeserializedSourceFile;
import org.jetbrains.kotlin.library.metadata.KlibMetadataDeserializedPackageFragment;
import org.jetbrains.kotlin.library.metadata.KlibMetadataProtoBuf;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.checkers.ExpectedActualDeclarationChecker;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedPropertyDescriptor;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedSimpleFunctionDescriptor;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u00000\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\r\u0010\u000e\u001a\u00020\u000f*\u00020\u0002H\u0086\u0010\u001a\n\u0010\u0010\u001a\u00020\t*\u00020\u000b\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\"\u0015\u0010\u0004\u001a\u00020\u0001*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0006\"\u0018\u0010\u0007\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0003\u00a8\u0006\u0011"}, d2={"isExpectMember", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)Z", "isForwardDeclarationModule", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;)Z", "isSerializableExpectClass", "sourceByIndex", "Lorg/jetbrains/kotlin/descriptors/SourceFile;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "index", "", "findPackage", "Lorg/jetbrains/kotlin/descriptors/PackageFragmentDescriptor;", "findSourceFile", "ir.serialization.common"})
public final class LegacyDescriptorUtilsKt {
    public static final boolean isExpectMember(@NotNull DeclarationDescriptor $this$isExpectMember) {
        Intrinsics.checkNotNullParameter($this$isExpectMember, "$this$isExpectMember");
        return $this$isExpectMember instanceof MemberDescriptor && ((MemberDescriptor)$this$isExpectMember).isExpect();
    }

    public static final boolean isSerializableExpectClass(@NotNull DeclarationDescriptor $this$isSerializableExpectClass) {
        Intrinsics.checkNotNullParameter($this$isSerializableExpectClass, "$this$isSerializableExpectClass");
        return $this$isSerializableExpectClass instanceof ClassDescriptor && ExpectedActualDeclarationChecker.Companion.shouldGenerateExpectClass((ClassDescriptor)$this$isSerializableExpectClass);
    }

    @NotNull
    public static final PackageFragmentDescriptor findPackage(@NotNull DeclarationDescriptor $this$findPackage) {
        while (true) {
            Intrinsics.checkNotNullParameter($this$findPackage, "$this$findPackage");
            if ($this$findPackage instanceof PackageFragmentDescriptor) break;
            Intrinsics.checkNotNull($this$findPackage.getContainingDeclaration());
            Intrinsics.checkNotNullExpressionValue($this$findPackage, "this.containingDeclaration!!");
        }
        return (PackageFragmentDescriptor)$this$findPackage;
    }

    public static final boolean isForwardDeclarationModule(@NotNull ModuleDescriptor $this$isForwardDeclarationModule) {
        Intrinsics.checkNotNullParameter($this$isForwardDeclarationModule, "$this$isForwardDeclarationModule");
        return Intrinsics.areEqual($this$isForwardDeclarationModule.getName(), Name.special("<forward declarations>"));
    }

    private static final SourceFile sourceByIndex(CallableMemberDescriptor descriptor2, int index2) {
        String fileName;
        PackageFragmentDescriptor packageFragmentDescriptor = LegacyDescriptorUtilsKt.findPackage(descriptor2);
        if (packageFragmentDescriptor == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.library.metadata.KlibMetadataDeserializedPackageFragment");
        }
        KlibMetadataDeserializedPackageFragment fragment = (KlibMetadataDeserializedPackageFragment)packageFragmentDescriptor;
        ProtoBuf.StringTable stringTable = fragment.getProto().getStrings();
        Intrinsics.checkNotNullExpressionValue(stringTable, "fragment.proto.strings");
        String string2 = fileName = (String)stringTable.getStringList().get(index2);
        Intrinsics.checkNotNullExpressionValue(string2, "fileName");
        return new DeserializedSourceFile(string2, KlibModuleOriginKt.getKotlinLibrary(DescriptorUtilsKt.getModule(descriptor2)));
    }

    @NotNull
    public static final SourceFile findSourceFile(@NotNull CallableMemberDescriptor $this$findSourceFile) {
        SourceFile sourceFile;
        Intrinsics.checkNotNullParameter($this$findSourceFile, "$this$findSourceFile");
        SourceElement sourceElement = $this$findSourceFile.getSource();
        Intrinsics.checkNotNullExpressionValue(sourceElement, "this.source");
        SourceFile sourceFile2 = sourceElement.getContainingFile();
        Intrinsics.checkNotNullExpressionValue(sourceFile2, "this.source.containingFile");
        SourceFile source = sourceFile2;
        if (Intrinsics.areEqual(source, SourceFile.NO_SOURCE_FILE) ^ true) {
            return source;
        }
        if ($this$findSourceFile instanceof DeserializedSimpleFunctionDescriptor && ((DeserializedSimpleFunctionDescriptor)$this$findSourceFile).getProto().hasExtension(KlibMetadataProtoBuf.functionFile)) {
            Integer n = ((DeserializedSimpleFunctionDescriptor)$this$findSourceFile).getProto().getExtension(KlibMetadataProtoBuf.functionFile);
            Intrinsics.checkNotNullExpressionValue(n, "proto.getExtension(KlibM\u2026ataProtoBuf.functionFile)");
            sourceFile = LegacyDescriptorUtilsKt.sourceByIndex($this$findSourceFile, ((Number)n).intValue());
        } else if ($this$findSourceFile instanceof DeserializedPropertyDescriptor && ((DeserializedPropertyDescriptor)$this$findSourceFile).getProto().hasExtension(KlibMetadataProtoBuf.propertyFile)) {
            Integer n = ((DeserializedPropertyDescriptor)$this$findSourceFile).getProto().getExtension(KlibMetadataProtoBuf.propertyFile);
            Intrinsics.checkNotNullExpressionValue(n, "proto.getExtension(KlibM\u2026ataProtoBuf.propertyFile)");
            sourceFile = LegacyDescriptorUtilsKt.sourceByIndex($this$findSourceFile, ((Number)n).intValue());
        } else {
            boolean bl = false;
            throw (Throwable)new NotImplementedError(null, 1, null);
        }
        return sourceFile;
    }
}

