/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.components;

import kotlin.Metadata;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.calls.components.InferenceSession;
import org.jetbrains.kotlin.resolve.calls.components.ReceiverInfo;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilder;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilderKt;
import org.jetbrains.kotlin.resolve.calls.inference.components.NewTypeSubstitutor;
import org.jetbrains.kotlin.resolve.calls.inference.model.ArgumentConstraintPositionImpl;
import org.jetbrains.kotlin.resolve.calls.inference.model.ConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.inference.model.ReceiverConstraintPositionImpl;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentTypeMismatchDiagnostic;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallDiagnostic;
import org.jetbrains.kotlin.resolve.calls.model.KotlinDiagnosticsHolder;
import org.jetbrains.kotlin.resolve.calls.model.ResolutionCandidateKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedAtom;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedExpressionAtom;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedSubCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.SimpleKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.SubKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.UnsafeCallError;
import org.jetbrains.kotlin.resolve.calls.model.UnstableSmartCast;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.NotNullTypeVariable;
import org.jetbrains.kotlin.types.SpecialTypesKt;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.checker.NewCapturedTypeKt;
import org.jetbrains.kotlin.types.checker.NewKotlinTypeCheckerKt;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0001H\u0002\u001a<\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0003\u001a\u0004\u0018\u00010\u00012\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0002\u001aD\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0003\u001a\u0004\u0018\u00010\u00012\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u000e\u001a\u0004\u0018\u00010\u00012\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u001a<\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0003\u001a\u0004\u0018\u00010\u00012\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002\u00a8\u0006\u0019"}, d2={"captureFromTypeParameterUpperBoundIfNeeded", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "argumentType", "expectedType", "checkExpressionArgument", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedAtom;", "csBuilder", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystemBuilder;", "expressionArgument", "Lorg/jetbrains/kotlin/resolve/calls/model/ExpressionKotlinCallArgument;", "diagnosticsHolder", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinDiagnosticsHolder;", "isReceiver", "", "convertedType", "checkSimpleArgument", "argument", "Lorg/jetbrains/kotlin/resolve/calls/model/SimpleKotlinCallArgument;", "receiverInfo", "Lorg/jetbrains/kotlin/resolve/calls/components/ReceiverInfo;", "inferenceSession", "Lorg/jetbrains/kotlin/resolve/calls/components/InferenceSession;", "checkSubCallArgument", "subCallArgument", "Lorg/jetbrains/kotlin/resolve/calls/model/SubKotlinCallArgument;", "resolution"})
public final class SimpleArgumentsChecksKt {
    @NotNull
    public static final ResolvedAtom checkSimpleArgument(@NotNull ConstraintSystemBuilder csBuilder, @NotNull SimpleKotlinCallArgument argument, @Nullable UnwrappedType expectedType2, @NotNull KotlinDiagnosticsHolder diagnosticsHolder, @NotNull ReceiverInfo receiverInfo, @Nullable UnwrappedType convertedType, @Nullable InferenceSession inferenceSession) {
        ResolvedAtom resolvedAtom;
        Intrinsics.checkNotNullParameter(csBuilder, "csBuilder");
        Intrinsics.checkNotNullParameter(argument, "argument");
        Intrinsics.checkNotNullParameter(diagnosticsHolder, "diagnosticsHolder");
        Intrinsics.checkNotNullParameter(receiverInfo, "receiverInfo");
        SimpleKotlinCallArgument simpleKotlinCallArgument = argument;
        if (simpleKotlinCallArgument instanceof ExpressionKotlinCallArgument) {
            resolvedAtom = SimpleArgumentsChecksKt.checkExpressionArgument(csBuilder, (ExpressionKotlinCallArgument)argument, expectedType2, diagnosticsHolder, receiverInfo.isReceiver(), convertedType);
        } else if (simpleKotlinCallArgument instanceof SubKotlinCallArgument) {
            resolvedAtom = SimpleArgumentsChecksKt.checkSubCallArgument(csBuilder, (SubKotlinCallArgument)argument, expectedType2, diagnosticsHolder, receiverInfo, inferenceSession);
        } else {
            Void void_ = ArgumentsUtilsKt.unexpectedArgument(argument);
            throw null;
        }
        return resolvedAtom;
    }

    private static final ResolvedAtom checkExpressionArgument(ConstraintSystemBuilder csBuilder, ExpressionKotlinCallArgument expressionArgument, UnwrappedType expectedType2, KotlinDiagnosticsHolder diagnosticsHolder, boolean isReceiver, UnwrappedType convertedType) {
        ConstraintPosition position;
        ResolvedExpressionAtom resolvedExpression = new ResolvedExpressionAtom(expressionArgument);
        if (expectedType2 == null) {
            return resolvedExpression;
        }
        UnwrappedType unwrappedType = convertedType;
        if (unwrappedType == null) {
            unwrappedType = SimpleArgumentsChecksKt.captureFromTypeParameterUpperBoundIfNeeded(ArgumentsUtilsKt.getStableType(expressionArgument.getReceiver()), expectedType2);
        }
        UnwrappedType argumentType = unwrappedType;
        Function3<UnwrappedType, UnwrappedType, ConstraintPosition, KotlinCallDiagnostic> $fun$unstableSmartCastOrSubtypeError$1 = new Function3<UnwrappedType, UnwrappedType, ConstraintPosition, KotlinCallDiagnostic>(csBuilder, expressionArgument, isReceiver, argumentType){
            final /* synthetic */ ConstraintSystemBuilder $csBuilder;
            final /* synthetic */ ExpressionKotlinCallArgument $expressionArgument;
            final /* synthetic */ boolean $isReceiver;
            final /* synthetic */ UnwrappedType $argumentType;

            @Nullable
            public final KotlinCallDiagnostic invoke(@Nullable UnwrappedType unstableType, @NotNull UnwrappedType actualExpectedType, @NotNull ConstraintPosition position) {
                Intrinsics.checkNotNullParameter(actualExpectedType, "actualExpectedType");
                Intrinsics.checkNotNullParameter(position, "position");
                if (unstableType != null && ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible(this.$csBuilder, unstableType, actualExpectedType, position)) {
                    return UnstableSmartCast.Companion.invoke(this.$expressionArgument, unstableType, this.$isReceiver);
                }
                if (this.$argumentType.isMarkedNullable()) {
                    if (ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible(this.$csBuilder, this.$argumentType, actualExpectedType, position)) {
                        return null;
                    }
                    if (ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible(this.$csBuilder, TypeUtilsKt.makeNotNullable(this.$argumentType), actualExpectedType, position)) {
                        return new ArgumentTypeMismatchDiagnostic(actualExpectedType, this.$argumentType, this.$expressionArgument);
                    }
                }
                this.$csBuilder.addSubtypeConstraint(this.$argumentType, actualExpectedType, position);
                return null;
            }
            {
                this.$csBuilder = constraintSystemBuilder;
                this.$expressionArgument = expressionKotlinCallArgument;
                this.$isReceiver = bl;
                this.$argumentType = unwrappedType;
                super(3);
            }
        };
        ConstraintPosition constraintPosition = position = isReceiver ? new ReceiverConstraintPositionImpl(expressionArgument) : new ArgumentConstraintPositionImpl(expressionArgument);
        if (expectedType2 instanceof NotNullTypeVariable && argumentType.isMarkedNullable()) {
            diagnosticsHolder.addDiagnostic(new ArgumentTypeMismatchDiagnostic(expectedType2, argumentType, expressionArgument));
        }
        if (expressionArgument.isSafeCall()) {
            UnwrappedType expectedNullableType = expectedType2.makeNullableAsSpecified(true);
            if (!ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible(csBuilder, argumentType, expectedNullableType, position)) {
                ResolutionCandidateKt.addDiagnosticIfNotNull(diagnosticsHolder, $fun$unstableSmartCastOrSubtypeError$1.invoke(ArgumentsUtilsKt.getUnstableType(expressionArgument.getReceiver()), expectedNullableType, position));
            }
            return resolvedExpression;
        }
        if (!ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible(csBuilder, argumentType, expectedType2, position)) {
            if (!isReceiver) {
                ResolutionCandidateKt.addDiagnosticIfNotNull(diagnosticsHolder, $fun$unstableSmartCastOrSubtypeError$1.invoke(ArgumentsUtilsKt.getUnstableType(expressionArgument.getReceiver()), expectedType2, position));
                return resolvedExpression;
            }
            UnwrappedType unstableType = ArgumentsUtilsKt.getUnstableType(expressionArgument.getReceiver());
            UnwrappedType expectedNullableType = expectedType2.makeNullableAsSpecified(true);
            if (unstableType != null && ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible(csBuilder, unstableType, expectedType2, position)) {
                diagnosticsHolder.addDiagnostic(UnstableSmartCast.Companion.invoke(expressionArgument, unstableType, isReceiver));
            } else if (ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible(csBuilder, argumentType, expectedNullableType, position)) {
                diagnosticsHolder.addDiagnostic(new UnsafeCallError(expressionArgument, false, 2, null));
            } else {
                csBuilder.addSubtypeConstraint(argumentType, expectedType2, position);
            }
        }
        return resolvedExpression;
    }

    private static final UnwrappedType captureFromTypeParameterUpperBoundIfNeeded(UnwrappedType argumentType, UnwrappedType expectedType2) {
        TypeConstructor expectedTypeConstructor = FlexibleTypesKt.upperIfFlexible(expectedType2).getConstructor();
        if (FlexibleTypesKt.lowerIfFlexible(argumentType).getConstructor().getDeclarationDescriptor() instanceof TypeParameterDescriptor) {
            Object v0;
            block7: {
                Iterable $this$singleOrNull$iv = TypeUtilsKt.supertypes(FlexibleTypesKt.lowerIfFlexible(argumentType));
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    KotlinType it = (KotlinType)element$iv;
                    boolean bl = false;
                    if (!(it.getConstructor().getDeclarationDescriptor() instanceof ClassifierDescriptorWithTypeParameters && NewKotlinTypeCheckerKt.hasSupertypeWithGivenTypeConstructor(it.unwrap(), expectedTypeConstructor))) continue;
                    if (found$iv) {
                        v0 = null;
                        break block7;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v0 = !found$iv ? null : single$iv;
            }
            KotlinType chosenSupertype = v0;
            if (chosenSupertype != null) {
                UnwrappedType unwrappedType;
                UnwrappedType capturedType = NewCapturedTypeKt.captureFromExpression(chosenSupertype.unwrap());
                if (capturedType != null && SpecialTypesKt.isDefinitelyNotNullType(argumentType)) {
                    unwrappedType = SpecialTypesKt.makeDefinitelyNotNullOrNotNull$default(capturedType, false, 1, null);
                } else {
                    unwrappedType = capturedType;
                    if (unwrappedType == null) {
                        unwrappedType = argumentType;
                    }
                }
                return unwrappedType;
            }
        }
        return argumentType;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static final ResolvedAtom checkSubCallArgument(ConstraintSystemBuilder csBuilder, SubKotlinCallArgument subCallArgument, UnwrappedType expectedType, KotlinDiagnosticsHolder diagnosticsHolder, ReceiverInfo receiverInfo, InferenceSession inferenceSession) {
        if (!receiverInfo.isReceiver()) ** GOTO lbl-1000
        v0 = inferenceSession;
        if (v0 == null) ** GOTO lbl-1000
        if (v0.resolveReceiverIndependently()) {
            v1 = true;
        } else lbl-1000:
        // 3 sources

        {
            v1 = false;
        }
        subCallResult = new ResolvedSubCallArgument(subCallArgument, v1);
        if (expectedType == null) {
            return subCallResult;
        }
        expectedNullableType = expectedType.makeNullableAsSpecified(true);
        position /* !! */  = receiverInfo.isReceiver() != false ? new ReceiverConstraintPositionImpl(subCallArgument) : new ArgumentConstraintPositionImpl(subCallArgument);
        v2 = csBuilder.buildCurrentSubstitutor();
        if (v2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.resolve.calls.inference.components.NewTypeSubstitutor");
        }
        currentReturnType = ((NewTypeSubstitutor)v2).safeSubstitute(subCallArgument.getReceiver().getReceiverValue().getType().unwrap());
        if (subCallArgument.isSafeCall()) {
            csBuilder.addSubtypeConstraint(currentReturnType, expectedNullableType, position /* !! */ );
            return subCallResult;
        }
        if (receiverInfo.isReceiver() && !ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible(csBuilder, currentReturnType, expectedType, position /* !! */ ) && ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible(csBuilder, currentReturnType, expectedNullableType, position /* !! */ )) {
            if (receiverInfo.getShouldReportUnsafeCall()) {
                diagnosticsHolder.addDiagnostic(new UnsafeCallError(subCallArgument, receiverInfo.getReportUnsafeCallAsUnsafeImplicitInvoke()));
            }
            return subCallResult;
        }
        csBuilder.addSubtypeConstraint(currentReturnType, expectedType, position /* !! */ );
        return subCallResult;
    }
}

