/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.ivy.core.cache;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.ParseException;
import java.util.Properties;
import org.jetbrains.kotlin.org.apache.ivy.core.IvyPatternHelper;
import org.jetbrains.kotlin.org.apache.ivy.core.cache.ResolutionCacheManager;
import org.jetbrains.kotlin.org.apache.ivy.core.module.descriptor.ExtendsDescriptor;
import org.jetbrains.kotlin.org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.jetbrains.kotlin.org.apache.ivy.core.module.id.ModuleRevisionId;
import org.jetbrains.kotlin.org.apache.ivy.core.settings.IvySettings;
import org.jetbrains.kotlin.org.apache.ivy.plugins.IvySettingsAware;

public class DefaultResolutionCacheManager
implements ResolutionCacheManager,
IvySettingsAware {
    private String resolvedIvyPattern = "resolved-[organisation]-[module]-[revision].xml";
    private String resolvedIvyPropertiesPattern = "resolved-[organisation]-[module]-[revision].properties";
    private File basedir;
    private String name = "resolution-cache";
    private IvySettings settings;

    public DefaultResolutionCacheManager() {
    }

    public DefaultResolutionCacheManager(File basedir) {
        this.setBasedir(basedir);
    }

    @Override
    public void setSettings(IvySettings settings) {
        this.settings = settings;
    }

    public File getResolutionCacheRoot() {
        if (this.basedir == null) {
            if (this.settings == null) {
                throw new IllegalStateException("The 'basedir' or 'IvySettings' has not been set on the ResolutionCacheManager");
            }
            this.basedir = this.settings.getDefaultResolutionCacheBasedir();
        }
        return this.basedir;
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    public String getResolvedIvyPattern() {
        return this.resolvedIvyPattern;
    }

    public String getResolvedIvyPropertiesPattern() {
        return this.resolvedIvyPropertiesPattern;
    }

    public File getResolvedIvyFileInCache(ModuleRevisionId mrid) {
        String file = IvyPatternHelper.substitute(this.getResolvedIvyPattern(), mrid.getOrganisation(), mrid.getName(), mrid.getRevision(), "ivy", "ivy", "xml");
        return new File(this.getResolutionCacheRoot(), file);
    }

    @Override
    public File getResolvedIvyPropertiesInCache(ModuleRevisionId mrid) {
        String file = IvyPatternHelper.substitute(this.getResolvedIvyPropertiesPattern(), mrid.getOrganisation(), mrid.getName(), mrid.getRevision(), "ivy", "ivy", "xml");
        return new File(this.getResolutionCacheRoot(), file);
    }

    @Override
    public File getConfigurationResolveReportInCache(String resolveId, String conf) {
        return new File(this.getResolutionCacheRoot(), resolveId + "-" + conf + ".xml");
    }

    @Override
    public void saveResolvedModuleDescriptor(ModuleDescriptor md) throws ParseException, IOException {
        ModuleRevisionId mrevId = md.getResolvedModuleRevisionId();
        File ivyFileInCache = this.getResolvedIvyFileInCache(mrevId);
        md.toIvyFile(ivyFileInCache);
        Properties paths = new Properties();
        this.saveLocalParents(mrevId, md, ivyFileInCache, paths);
        if (!paths.isEmpty()) {
            File parentsFile = this.getResolvedIvyPropertiesInCache(ModuleRevisionId.newInstance(mrevId, mrevId.getRevision() + "-parents"));
            FileOutputStream out = new FileOutputStream(parentsFile);
            paths.store(out, null);
            out.close();
        }
    }

    private void saveLocalParents(ModuleRevisionId baseMrevId, ModuleDescriptor md, File mdFile, Properties paths) throws ParseException, IOException {
        for (ExtendsDescriptor parent : md.getInheritedDescriptors()) {
            if (!parent.isLocal()) continue;
            ModuleDescriptor parentMd = parent.getParentMd();
            ModuleRevisionId pRevId = ModuleRevisionId.newInstance(baseMrevId, baseMrevId.getRevision() + "-parent." + paths.size());
            File parentFile = this.getResolvedIvyFileInCache(pRevId);
            parentMd.toIvyFile(parentFile);
            paths.setProperty(mdFile.getName() + "|" + parent.getLocation(), parentFile.getAbsolutePath());
            this.saveLocalParents(baseMrevId, parentMd, parentFile, paths);
        }
    }

    public String toString() {
        return this.name;
    }
}

