/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.SupertypeUtilsKt;
import org.jetbrains.kotlin.fir.resolve.transformers.FirAbstractTreeTransformer;
import org.jetbrains.kotlin.fir.scopes.FirCompositeScope;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.scopes.ScopesKt;
import org.jetbrains.kotlin.fir.scopes.impl.FirDeclaredMemberScopeProviderKt;
import org.jetbrains.kotlin.fir.scopes.impl.FirMemberTypeParameterScope;
import org.jetbrains.kotlin.fir.scopes.impl.FirNestedClassifierScopeWithSubstitutionKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\u001e\u0010\u0017\u001a\u00020\u00182\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0002H\u0004J\u001a\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u00162\b\u0010\u001b\u001a\u0004\u0018\u00010\u0002H\u0016J'\u0010\u001e\u001a\u0002H\u001f\"\u0004\b\u0000\u0010\u001f2\u000e\b\u0004\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u001f0!H\u0084\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\"J\f\u0010#\u001a\u00020$*\u00020%H\u0004R\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirAbstractTreeTransformerWithSuperTypes;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirAbstractTreeTransformer;", "", "phase", "Lorg/jetbrains/kotlin/fir/declarations/FirResolvePhase;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "(Lorg/jetbrains/kotlin/fir/declarations/FirResolvePhase;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;)V", "getScopeSession", "()Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "scopes", "", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "getScopes", "()Ljava/util/List;", "towerScope", "Lorg/jetbrains/kotlin/fir/scopes/FirCompositeScope;", "getTowerScope", "()Lorg/jetbrains/kotlin/fir/scopes/FirCompositeScope;", "needReplacePhase", "", "firDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "resolveNestedClassesSupertypes", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "firClass", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "data", "transformDeclarationContent", "declaration", "withScopeCleanup", "T", "l", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "addTypeParametersScope", "", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "resolve"})
public abstract class FirAbstractTreeTransformerWithSuperTypes
extends FirAbstractTreeTransformer<Object> {
    @NotNull
    private final ScopeSession scopeSession;
    @NotNull
    private final List<FirScope> scopes;
    @NotNull
    private final FirCompositeScope towerScope;

    public FirAbstractTreeTransformerWithSuperTypes(@NotNull FirResolvePhase phase, @NotNull ScopeSession scopeSession) {
        Intrinsics.checkNotNullParameter((Object)phase, "phase");
        Intrinsics.checkNotNullParameter(scopeSession, "scopeSession");
        super(phase);
        this.scopeSession = scopeSession;
        boolean bl = false;
        this.scopes = new ArrayList();
        this.towerScope = new FirCompositeScope((Iterable<? extends FirScope>)CollectionsKt.asReversedMutable(this.scopes));
    }

    @NotNull
    protected final ScopeSession getScopeSession() {
        return this.scopeSession;
    }

    @NotNull
    protected final List<FirScope> getScopes() {
        return this.scopes;
    }

    @NotNull
    protected final FirCompositeScope getTowerScope() {
        return this.towerScope;
    }

    protected boolean needReplacePhase(@NotNull FirDeclaration firDeclaration) {
        Intrinsics.checkNotNullParameter(firDeclaration, "firDeclaration");
        return this.getTransformerPhase().compareTo((Enum)firDeclaration.getResolvePhase()) > 0;
    }

    protected final <T> T withScopeCleanup(@NotNull Function0<? extends T> l) {
        Intrinsics.checkNotNullParameter(l, "l");
        boolean $i$f$withScopeCleanup = false;
        int sizeBefore = this.scopes.size();
        T result2 = l.invoke();
        int size = this.scopes.size();
        int n = size >= sizeBefore ? 1 : 0;
        boolean bl = false;
        int n2 = 0;
        if (_Assertions.ENABLED && n == 0) {
            boolean bl2 = false;
            String string2 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        n = size - sizeBefore;
        bl = false;
        n2 = 0;
        n2 = 0;
        int n3 = n;
        while (n2 < n3) {
            int it = n2++;
            boolean bl3 = false;
            this.scopes.remove(CollectionsKt.getLastIndex(this.scopes));
        }
        return result2;
    }

    @NotNull
    protected final FirStatement resolveNestedClassesSupertypes(@NotNull FirClass<?> firClass, @Nullable Object data) {
        Object object;
        boolean bl;
        boolean bl2;
        Object object2;
        Object object3;
        Intrinsics.checkNotNullParameter(firClass, "firClass");
        if (this.needReplacePhase(firClass)) {
            firClass.replaceResolvePhase(this.getTransformerPhase());
        }
        FirAbstractTreeTransformerWithSuperTypes this_$iv = this;
        boolean $i$f$withScopeCleanup = false;
        int sizeBefore$iv = this_$iv.scopes.size();
        boolean bl3 = false;
        firClass.transformAnnotations(this, null);
        Object object4 = this.getSession();
        List superTypes2 = CollectionsKt.asReversed(SupertypeUtilsKt.lookupSuperTypes$default(firClass, false, true, (FirSession)object4, null, true, 16, null));
        object4 = superTypes2.iterator();
        while (object4.hasNext()) {
            ConeClassLikeType superType2 = (ConeClassLikeType)object4.next();
            object3 = ScopesKt.getNestedClassifierScope(superType2.getLookupTag(), this.getSession(), this.getScopeSession());
            if (object3 == null) continue;
            object2 = object3;
            bl2 = false;
            bl = false;
            FirScope nestedClassifierScope = object2;
            boolean bl4 = false;
            FirScope scope2 = FirNestedClassifierScopeWithSubstitutionKt.wrapNestedClassifierScopeWithSubstitutionForSuperType(nestedClassifierScope, superType2, this.getSession());
            this.getScopes().add(scope2);
        }
        if (firClass instanceof FirRegularClass) {
            this.addTypeParametersScope((FirMemberDeclaration)((Object)firClass));
            FirRegularClass companionObject = ((FirRegularClass)firClass).getCompanionObject();
            if (companionObject != null && (object = FirDeclaredMemberScopeProviderKt.nestedClassifierScope(this.getSession(), companionObject)) != null) {
                object3 = object;
                object2 = this.getScopes();
                bl2 = false;
                bl = false;
                FirScope p0 = (FirScope)object3;
                boolean bl5 = false;
                object2.add(p0);
            }
        }
        if ((object4 = FirDeclaredMemberScopeProviderKt.nestedClassifierScope(this.getSession(), firClass)) != null) {
            object = object4;
            object3 = this.getScopes();
            boolean bl6 = false;
            bl2 = false;
            FirScope p0 = (FirScope)object;
            boolean bl7 = false;
            object3.add(p0);
        }
        FirClass result$iv = (FirClass)this.transformDeclarationContent(firClass, data);
        int size$iv = this_$iv.scopes.size();
        int n = size$iv >= sizeBefore$iv ? 1 : 0;
        boolean bl8 = false;
        int n2 = 0;
        if (_Assertions.ENABLED && n == 0) {
            boolean bl9 = false;
            String string2 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        n = size$iv - sizeBefore$iv;
        bl8 = false;
        n2 = 0;
        n2 = 0;
        int n3 = n;
        while (n2 < n3) {
            int it$iv = n2++;
            boolean bl10 = false;
            this_$iv.scopes.remove(CollectionsKt.getLastIndex(this_$iv.scopes));
        }
        return result$iv;
    }

    protected final void addTypeParametersScope(@NotNull FirMemberDeclaration $this$addTypeParametersScope) {
        Intrinsics.checkNotNullParameter($this$addTypeParametersScope, "<this>");
        Collection collection = $this$addTypeParametersScope.getTypeParameters();
        boolean bl = false;
        if (!collection.isEmpty()) {
            this.scopes.add(new FirMemberTypeParameterScope($this$addTypeParametersScope));
        }
    }

    @NotNull
    public FirDeclaration transformDeclarationContent(@NotNull FirDeclaration declaration2, @Nullable Object data) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        return (FirDeclaration)this.transformElement((FirElement)declaration2, data);
    }
}

