/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirLightSourceElement;
import org.jetbrains.kotlin.fir.FirPsiSourceElement;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.LightTreeSourceNavigator;
import org.jetbrains.kotlin.fir.analysis.checkers.PsiSourceNavigator;
import org.jetbrains.kotlin.fir.types.FirTypeRef;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u0000 \u00062\u00020\u0001:\u0001\u0006J\f\u0010\u0002\u001a\u00020\u0003*\u00020\u0004H&J\f\u0010\u0005\u001a\u00020\u0003*\u00020\u0004H&\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/SourceNavigator;", "", "isInConstructorCallee", "", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "isInTypeConstraint", "Companion", "checkers"})
public interface SourceNavigator {
    @NotNull
    public static final Companion Companion = org.jetbrains.kotlin.fir.analysis.checkers.SourceNavigator$Companion.$$INSTANCE;

    public boolean isInConstructorCallee(@NotNull FirTypeRef var1);

    public boolean isInTypeConstraint(@NotNull FirTypeRef var1);

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ4\u0010\t\u001a\u0002H\n\"\u0004\b\u0000\u0010\n*\u00020\b2\u0017\u0010\u000b\u001a\u0013\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u0002H\n0\f\u00a2\u0006\u0002\b\rH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/SourceNavigator$Companion;", "", "()V", "lightTreeInstance", "Lorg/jetbrains/kotlin/fir/analysis/checkers/LightTreeSourceNavigator;", "forElement", "Lorg/jetbrains/kotlin/fir/analysis/checkers/SourceNavigator;", "e", "Lorg/jetbrains/kotlin/fir/FirElement;", "withNavigator", "R", "block", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "(Lorg/jetbrains/kotlin/fir/FirElement;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "checkers"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final LightTreeSourceNavigator lightTreeInstance;

        private Companion() {
        }

        @NotNull
        public final SourceNavigator forElement(@NotNull FirElement e) {
            SourceNavigator sourceNavigator;
            Intrinsics.checkNotNullParameter(e, "e");
            FirSourceElement firSourceElement = e.getSource();
            if (firSourceElement instanceof FirLightSourceElement) {
                sourceNavigator = lightTreeInstance;
            } else if (firSourceElement instanceof FirPsiSourceElement) {
                sourceNavigator = PsiSourceNavigator.INSTANCE;
            } else if (firSourceElement == null) {
                sourceNavigator = lightTreeInstance;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return sourceNavigator;
        }

        public final <R> R withNavigator(@NotNull FirElement $this$withNavigator, @NotNull Function1<? super SourceNavigator, ? extends R> block) {
            Intrinsics.checkNotNullParameter($this$withNavigator, "<this>");
            Intrinsics.checkNotNullParameter(block, "block");
            boolean $i$f$withNavigator = false;
            SourceNavigator sourceNavigator = this.forElement($this$withNavigator);
            boolean bl = false;
            boolean bl2 = false;
            return block.invoke(sourceNavigator);
        }

        static {
            $$INSTANCE = new Companion();
            lightTreeInstance = new LightTreeSourceNavigator();
        }
    }
}

