/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler;

import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.light.LightJavaModule;
import com.intellij.psi.search.GlobalSearchScope;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.config.ContentRoot;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageUtil;
import org.jetbrains.kotlin.cli.jvm.compiler.ClasspathRootsResolver;
import org.jetbrains.kotlin.cli.jvm.config.JavaSourceRoot;
import org.jetbrains.kotlin.cli.jvm.config.JvmClasspathRoot;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRoot;
import org.jetbrains.kotlin.cli.jvm.config.JvmModulePathRoot;
import org.jetbrains.kotlin.cli.jvm.index.JavaRoot;
import org.jetbrains.kotlin.cli.jvm.modules.CliJavaModuleFinder;
import org.jetbrains.kotlin.cli.jvm.modules.JavaModuleGraph;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.resolve.jvm.KotlinCliJavaFileManager;
import org.jetbrains.kotlin.resolve.jvm.modules.JavaModule;
import org.jetbrains.kotlin.resolve.jvm.modules.JavaModuleInfo;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 =2\u00020\u0001:\u0003=>?B]\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0014\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\n\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\f\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J$\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00072\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H\u0002J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J2\u0010$\u001a\u00020%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u00072\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\f0\u00072\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\f0\u0007H\u0002J\u0014\u0010*\u001a\u00020%2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020,0\u0007J\u001e\u0010-\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020/\u0018\u00010.2\u0006\u00100\u001a\u00020\fH\u0002J\u0012\u00101\u001a\u0004\u0018\u00010\u001f2\u0006\u00100\u001a\u00020\fH\u0002J\u001a\u00102\u001a\u0004\u0018\u0001032\u0006\u00100\u001a\u00020\f2\u0006\u00104\u001a\u00020\u0010H\u0002J\u0012\u00105\u001a\u0004\u0018\u0001062\u0006\u00107\u001a\u00020\fH\u0002J$\u00108\u001a\u00020\u001d2\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\b2\n\b\u0002\u0010<\u001a\u0004\u0018\u00010\fH\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0019\u001a\u00070\u001a\u00a2\u0006\u0002\b\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/compiler/ClasspathRootsResolver;", "", "psiManager", "Lcom/intellij/psi/PsiManager;", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "additionalModules", "", "", "contentRootToVirtualFile", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/cli/jvm/config/JvmContentRoot;", "Lcom/intellij/openapi/vfs/VirtualFile;", "javaModuleFinder", "Lorg/jetbrains/kotlin/cli/jvm/modules/CliJavaModuleFinder;", "requireStdlibModule", "", "outputDirectory", "javaFileManager", "Lorg/jetbrains/kotlin/resolve/jvm/KotlinCliJavaFileManager;", "(Lcom/intellij/psi/PsiManager;Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;Ljava/util/List;Lkotlin/jvm/functions/Function1;Lorg/jetbrains/kotlin/cli/jvm/modules/CliJavaModuleFinder;ZLcom/intellij/openapi/vfs/VirtualFile;Lorg/jetbrains/kotlin/resolve/jvm/KotlinCliJavaFileManager;)V", "javaModuleGraph", "Lorg/jetbrains/kotlin/cli/jvm/modules/JavaModuleGraph;", "getJavaModuleGraph", "()Lorg/jetbrains/kotlin/cli/jvm/modules/JavaModuleGraph;", "searchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "Lorg/jetbrains/annotations/NotNull;", "addModularRoots", "", "modules", "Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModule;", "result", "", "Lorg/jetbrains/kotlin/cli/jvm/index/JavaRoot;", "computeDefaultRootModules", "computeRoots", "Lorg/jetbrains/kotlin/cli/jvm/compiler/ClasspathRootsResolver$RootsAndModules;", "javaSourceRoots", "Lorg/jetbrains/kotlin/cli/jvm/compiler/ClasspathRootsResolver$RootWithPrefix;", "jvmClasspathRoots", "jvmModulePathRoots", "convertClasspathRoots", "contentRoots", "Lorg/jetbrains/kotlin/cli/common/config/ContentRoot;", "findSourceModuleInfo", "Lkotlin/Pair;", "Lcom/intellij/psi/PsiJavaModule;", "root", "modularBinaryRoot", "modularSourceRoot", "Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModule$Explicit;", "hasOutputDirectoryInClasspath", "readManifestAttributes", "Ljava/util/jar/Attributes;", "jarRoot", "report", "severity", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity;", "message", "file", "Companion", "RootWithPrefix", "RootsAndModules", "cli"})
public final class ClasspathRootsResolver {
    @NotNull
    private final JavaModuleGraph javaModuleGraph;
    private final GlobalSearchScope searchScope;
    private final PsiManager psiManager;
    private final MessageCollector messageCollector;
    private final List<String> additionalModules;
    private final Function1<JvmContentRoot, VirtualFile> contentRootToVirtualFile;
    private final CliJavaModuleFinder javaModuleFinder;
    private final boolean requireStdlibModule;
    private final VirtualFile outputDirectory;
    private final KotlinCliJavaFileManager javaFileManager;
    @Deprecated
    @NotNull
    public static final String MULTI_RELEASE_MODULE_INFO_CLS_FILE = "META-INF/versions/9/module-info.class";
    @Deprecated
    @NotNull
    public static final String AUTOMATIC_MODULE_NAME = "Automatic-Module-Name";
    @Deprecated
    @NotNull
    public static final String IS_MULTI_RELEASE = "Multi-Release";
    @NotNull
    private static final Companion Companion = new Companion(null);

    @NotNull
    public final JavaModuleGraph getJavaModuleGraph() {
        return this.javaModuleGraph;
    }

    @NotNull
    public final RootsAndModules convertClasspathRoots(@NotNull List<? extends ContentRoot> contentRoots) {
        Intrinsics.checkNotNullParameter(contentRoots, "contentRoots");
        List javaSourceRoots = new ArrayList();
        List jvmClasspathRoots = new ArrayList();
        List jvmModulePathRoots = new ArrayList();
        for (ContentRoot contentRoot : contentRoots) {
            VirtualFile root2;
            Object object;
            if (!(contentRoot instanceof JvmContentRoot)) continue;
            if (this.contentRootToVirtualFile.invoke((JvmContentRoot)contentRoot) == null) {
                continue;
            }
            ContentRoot contentRoot2 = contentRoot;
            if (contentRoot2 instanceof JavaSourceRoot) {
                object = javaSourceRoots;
                RootWithPrefix rootWithPrefix = new RootWithPrefix(root2, ((JavaSourceRoot)contentRoot).getPackagePrefix());
                object.add(rootWithPrefix);
                continue;
            }
            if (contentRoot2 instanceof JvmClasspathRoot) {
                object = jvmClasspathRoots;
                object.add(root2);
                continue;
            }
            if (contentRoot2 instanceof JvmModulePathRoot) {
                object = jvmModulePathRoots;
                object.add(root2);
                continue;
            }
            object = "Unknown root type: " + contentRoot;
            throw new IllegalStateException(object.toString());
        }
        return this.computeRoots(javaSourceRoots, jvmClasspathRoots, jvmModulePathRoots);
    }

    /*
     * WARNING - void declaration
     */
    private final RootsAndModules computeRoots(List<RootWithPrefix> javaSourceRoots, List<? extends VirtualFile> jvmClasspathRoots, List<? extends VirtualFile> jvmModulePathRoots) {
        boolean bl;
        List modules;
        List result2;
        block15: {
            Collection root2;
            Object packagePrefix;
            result2 = new ArrayList();
            modules = new ArrayList();
            boolean hasOutputDirectoryInClasspath = CollectionsKt.contains((Iterable)jvmClasspathRoots, this.outputDirectory) || CollectionsKt.contains((Iterable)jvmModulePathRoots, this.outputDirectory);
            for (RootWithPrefix rootWithPrefix : javaSourceRoots) {
                FqName fqName2;
                Object object;
                Collection collection;
                VirtualFile virtualFile2 = rootWithPrefix.component1();
                packagePrefix = rootWithPrefix.component2();
                JavaModule.Explicit modularRoot = this.modularSourceRoot((VirtualFile)((Object)root2), hasOutputDirectoryInClasspath);
                if (modularRoot != null) {
                    collection = modules;
                    collection.add(modularRoot);
                    continue;
                }
                collection = result2;
                Collection collection2 = root2;
                JavaRoot.RootType rootType = JavaRoot.RootType.SOURCE;
                Object object2 = packagePrefix;
                if (object2 != null) {
                    FqName fqName3;
                    void prefix;
                    Object object3 = object = object2;
                    JavaRoot.RootType rootType2 = rootType;
                    Collection collection3 = collection2;
                    boolean bl2 = false;
                    if (FqNamesUtilKt.isValidJavaFqName((String)prefix)) {
                        fqName3 = new FqName((String)prefix);
                    } else {
                        Iterator iterator2 = null;
                        Void it = (Void)((Object)iterator2);
                        boolean bl3 = false;
                        ClasspathRootsResolver.report$default(this, CompilerMessageSeverity.STRONG_WARNING, "Invalid package prefix name is ignored: " + (String)prefix, null, 4, null);
                        fqName3 = (FqName)((Object)iterator2);
                    }
                    FqName fqName4 = fqName3;
                    collection2 = collection3;
                    rootType = rootType2;
                    fqName2 = fqName4;
                } else {
                    fqName2 = null;
                }
                FqName fqName5 = fqName2;
                JavaRoot.RootType rootType3 = rootType;
                Collection collection4 = collection2;
                object = new JavaRoot((VirtualFile)((Object)collection4), rootType3, fqName5);
                collection.add(object);
            }
            for (VirtualFile virtualFile3 : jvmClasspathRoots) {
                root2 = result2;
                packagePrefix = new JavaRoot(virtualFile3, JavaRoot.RootType.BINARY, null, 4, null);
                root2.add(packagePrefix);
            }
            Iterable iterable = modules;
            boolean $i$f$any = false;
            if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : iterable) {
                    boolean bl2;
                    block14: {
                        JavaModule module2 = (JavaModule)element$iv;
                        boolean bl5 = false;
                        Iterable $this$any$iv2 = module2.getModuleRoots();
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                JavaModule.Root it = (JavaModule.Root)element$iv2;
                                boolean bl6 = false;
                                if (!Intrinsics.areEqual(it.getFile(), this.outputDirectory)) continue;
                                bl2 = true;
                                break block14;
                            }
                            bl2 = false;
                        }
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block15;
                }
                bl = false;
            }
        }
        boolean bl3 = bl;
        for (VirtualFile virtualFile4 : jvmModulePathRoots) {
            JavaModule module3;
            if (bl3 && Intrinsics.areEqual(virtualFile4, this.outputDirectory) || (module3 = this.modularBinaryRoot(virtualFile4)) == null) continue;
            Collection collection = modules;
            collection.add(module3);
        }
        this.addModularRoots(modules, result2);
        return new RootsAndModules(result2, modules);
    }

    private final Pair<VirtualFile, PsiJavaModule> findSourceModuleInfo(VirtualFile root2) {
        PsiElement psiElement;
        PsiElement psiElement2;
        VirtualFile moduleInfoFile;
        block6: {
            VirtualFile virtualFile2 = root2.isDirectory() ? root2.findChild("module-info.java") : (Intrinsics.areEqual(root2.getName(), "module-info.java") ? root2 : null);
            if (virtualFile2 == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue(virtualFile2, "when {\n                r\u2026         } ?: return null");
            moduleInfoFile = virtualFile2;
            PsiFile psiFile = this.psiManager.findFile(moduleInfoFile);
            if (psiFile == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue(psiFile, "psiManager.findFile(moduleInfoFile) ?: return null");
            PsiFile psiFile2 = psiFile;
            PsiElement[] psiElementArray = psiFile2.getChildren();
            Intrinsics.checkNotNullExpressionValue(psiElementArray, "psiFile.children");
            PsiElement[] $this$singleOrNull$iv = psiElementArray;
            boolean $i$f$singleOrNull = false;
            PsiElement single$iv = null;
            boolean found$iv = false;
            for (PsiElement element$iv : $this$singleOrNull$iv) {
                PsiElement it = element$iv;
                boolean bl = false;
                if (!(it instanceof PsiJavaModule)) continue;
                if (found$iv) {
                    psiElement2 = null;
                    break block6;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            psiElement2 = psiElement = !found$iv ? null : single$iv;
        }
        if (!(psiElement2 instanceof PsiJavaModule)) {
            psiElement = null;
        }
        PsiJavaModule psiJavaModule = (PsiJavaModule)psiElement;
        if (psiJavaModule == null) {
            return null;
        }
        PsiJavaModule psiJavaModule2 = psiJavaModule;
        return TuplesKt.to(moduleInfoFile, psiJavaModule2);
    }

    /*
     * WARNING - void declaration
     */
    private final JavaModule.Explicit modularSourceRoot(VirtualFile root2, boolean hasOutputDirectoryInClasspath) {
        void moduleInfoFile;
        List<JavaModule.Root> list2;
        Pair<VirtualFile, PsiJavaModule> pair = this.findSourceModuleInfo(root2);
        if (pair == null) {
            return null;
        }
        Pair<VirtualFile, PsiJavaModule> pair2 = pair;
        VirtualFile virtualFile2 = pair2.component1();
        PsiJavaModule psiJavaModule = pair2.component2();
        JavaModule.Root sourceRoot = new JavaModule.Root(root2, false);
        if (hasOutputDirectoryInClasspath) {
            JavaModule.Root[] rootArray = new JavaModule.Root[2];
            rootArray[0] = sourceRoot;
            VirtualFile virtualFile3 = this.outputDirectory;
            Intrinsics.checkNotNull(virtualFile3);
            rootArray[1] = new JavaModule.Root(virtualFile3, true);
            list2 = CollectionsKt.listOf(rootArray);
        } else {
            list2 = CollectionsKt.listOf(sourceRoot);
        }
        List<JavaModule.Root> roots2 = list2;
        return new JavaModule.Explicit(JavaModuleInfo.Companion.create(psiJavaModule), roots2, (VirtualFile)moduleInfoFile);
    }

    private final JavaModule modularBinaryRoot(VirtualFile root2) {
        VirtualFile moduleInfoFile;
        CharSequence charSequence2;
        Lazy lazy;
        VirtualFileSystem virtualFileSystem = root2.getFileSystem();
        Intrinsics.checkNotNullExpressionValue(virtualFileSystem, "root.fileSystem");
        boolean isJar = Intrinsics.areEqual(virtualFileSystem.getProtocol(), "jar");
        Object var4_3 = null;
        Lazy manifest2 = LazyKt.lazy(LazyThreadSafetyMode.NONE, (Function0)new Function0<Attributes>(this, root2){
            final /* synthetic */ ClasspathRootsResolver this$0;
            final /* synthetic */ VirtualFile $root;

            @Nullable
            public final Attributes invoke() {
                return ClasspathRootsResolver.access$readManifestAttributes(this.this$0, this.$root);
            }
            {
                this.this$0 = classpathRootsResolver;
                this.$root = virtualFile2;
                super(0);
            }
        });
        VirtualFile virtualFile2 = root2.findChild("module-info.class");
        if (virtualFile2 == null) {
            VirtualFile virtualFile3;
            VirtualFile it = virtualFile3 = root2;
            boolean bl = false;
            VirtualFile virtualFile4 = isJar ? virtualFile3 : null;
            if (virtualFile4 != null && (virtualFile4 = virtualFile4.findFileByRelativePath(MULTI_RELEASE_MODULE_INFO_CLS_FILE)) != null) {
                it = virtualFile3 = virtualFile4;
                boolean bl2 = false;
                lazy = manifest2;
                charSequence2 = null;
                Object var11_11 = var4_3;
                Object object = (Attributes)lazy.getValue();
                virtualFile2 = object != null && (object = ((Attributes)object).getValue(IS_MULTI_RELEASE)) != null && StringsKt.equals((String)object, "true", true) ? virtualFile3 : null;
            } else {
                virtualFile2 = moduleInfoFile = null;
            }
        }
        if (moduleInfoFile != null) {
            JavaModuleInfo javaModuleInfo = JavaModuleInfo.Companion.read(moduleInfoFile, this.javaFileManager, this.searchScope);
            if (javaModuleInfo == null) {
                return null;
            }
            JavaModuleInfo moduleInfo2 = javaModuleInfo;
            return new JavaModule.Explicit(moduleInfo2, CollectionsKt.listOf(new JavaModule.Root(root2, true)), moduleInfoFile);
        }
        if (isJar) {
            String automaticModuleName;
            List<JavaModule.Root> moduleRoot = CollectionsKt.listOf(new JavaModule.Root(root2, true));
            Lazy bl2 = manifest2;
            lazy = null;
            Attributes attributes2 = (Attributes)bl2.getValue();
            String string2 = automaticModuleName = attributes2 != null ? attributes2.getValue(AUTOMATIC_MODULE_NAME) : null;
            if (automaticModuleName != null) {
                return new JavaModule.Automatic(automaticModuleName, moduleRoot);
            }
            File file2 = VfsUtilCore.virtualToIoFile(root2);
            Intrinsics.checkNotNullExpressionValue(file2, "VfsUtilCore.virtualToIoFile(root)");
            File originalFile = file2;
            String string3 = LightJavaModule.moduleName(FilesKt.getNameWithoutExtension(originalFile));
            Intrinsics.checkNotNullExpressionValue(string3, "LightJavaModule.moduleNa\u2026ile.nameWithoutExtension)");
            String moduleName = string3;
            charSequence2 = moduleName;
            if (charSequence2.length() == 0) {
                VirtualFile virtualFile5 = VfsUtilCore.getVirtualFileForJar(root2);
                if (virtualFile5 == null) {
                    virtualFile5 = root2;
                }
                this.report(CompilerMessageSeverity.ERROR, "Cannot infer automatic module name for the file", virtualFile5);
                return null;
            }
            return new JavaModule.Automatic(moduleName, moduleRoot);
        }
        return null;
    }

    private final Attributes readManifestAttributes(VirtualFile jarRoot) {
        Object object;
        VirtualFile virtualFile2 = jarRoot.findChild("META-INF");
        VirtualFile manifestFile2 = virtualFile2 != null ? virtualFile2.findChild("MANIFEST.MF") : null;
        try {
            Object object2;
            Object object3 = manifestFile2;
            if (object3 != null && (object3 = ((VirtualFile)object3).getInputStream()) != null) {
                Object p1 = object = object3;
                boolean bl = false;
                object2 = new Manifest((InputStream)p1).getMainAttributes();
            } else {
                object2 = null;
            }
            object = object2;
        }
        catch (IOException e) {
            object = null;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final void addModularRoots(List<? extends JavaModule> modules, List<JavaRoot> result2) {
        boolean bl;
        LinkedHashSet<String> allDependencies;
        Object destination$iv$iv;
        JavaModule.Explicit explicit;
        block22: {
            List list2;
            Object existingFile;
            void $this$filterTo$iv$iv;
            Iterable $this$filterIsInstanceTo$iv$iv;
            Iterable iterable = modules;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable2 = iterable;
            Collection destination$iv$iv2 = new ArrayList();
            boolean bl2 = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof JavaModule.Explicit)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            Iterable iterable3 = (List)destination$iv$iv2;
            boolean $i$f$filter = false;
            $this$filterIsInstanceTo$iv$iv = iterable3;
            Collection destination$iv$iv3 = new ArrayList();
            boolean bl3 = false;
            Iterator iterator2 = $this$filterTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv$iv;
                Object receiver = element$iv$iv = iterator2.next();
                boolean bl22 = false;
                if (!((JavaModule)receiver).isSourceModule()) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            List sourceModules = (List)destination$iv$iv3;
            if (sourceModules.size() > 1) {
                for (JavaModule.Explicit explicit2 : sourceModules) {
                    this.report(CompilerMessageSeverity.ERROR, "Too many source module declarations found", explicit2.getModuleInfoFile());
                }
                return;
            }
            for (JavaModule javaModule : modules) {
                JavaModule existing = this.javaModuleFinder.findModule(javaModule.getName());
                if (existing == null) {
                    this.javaModuleFinder.addUserModule(javaModule);
                    continue;
                }
                if (!(Intrinsics.areEqual(javaModule.getModuleRoots(), existing.getModuleRoots()) ^ true)) continue;
                addModularRoots.1 $fun$getRootFile$1 = addModularRoots.1.INSTANCE;
                VirtualFile virtualFile2 = $fun$getRootFile$1.invoke(javaModule);
                existingFile = $fun$getRootFile$1.invoke(existing);
                String atExistingPath = existingFile == null ? "" : " at: " + ((VirtualFile)existingFile).getPath();
                this.report(CompilerMessageSeverity.STRONG_WARNING, "The root is ignored because a module with the same name '" + javaModule.getName() + "' " + "has been found earlier on the module path" + atExistingPath, virtualFile2);
            }
            if (SequencesKt.none(this.javaModuleFinder.getAllObservableModules())) {
                return;
            }
            explicit = (JavaModule.Explicit)CollectionsKt.singleOrNull(sourceModules);
            boolean addAllModulePathToRoots = this.additionalModules.contains("ALL-MODULE-PATH");
            if (addAllModulePathToRoots && explicit != null) {
                ClasspathRootsResolver.report$default(this, CompilerMessageSeverity.ERROR, "-Xadd-modules=ALL-MODULE-PATH can only be used when compiling the unnamed module", null, 4, null);
                return;
            }
            if (explicit != null) {
                list2 = CollectionsKt.plus((Collection)CollectionsKt.listOf(explicit.getName()), (Iterable)this.additionalModules);
            } else if (addAllModulePathToRoots) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = modules;
                boolean bl4 = false;
                existingFile = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                Iterator bl22 = $this$mapTo$iv$iv.iterator();
                while (bl22.hasNext()) {
                    void receiver;
                    Object item$iv$iv;
                    Object t = item$iv$iv = bl22.next();
                    Object object = destination$iv$iv;
                    boolean bl32 = false;
                    String string2 = ((JavaModule)receiver).getName();
                    object.add(string2);
                }
                list2 = (List)destination$iv$iv;
            } else {
                list2 = CollectionsKt.plus((Collection)this.computeDefaultRootModules(), (Iterable)this.additionalModules);
            }
            List rootModules = list2;
            allDependencies = this.javaModuleGraph.getAllDependencies(rootModules);
            Iterable iterable4 = allDependencies;
            boolean $i$f$any = false;
            if (iterable4 instanceof Collection && ((Collection)iterable4).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : iterable4) {
                    String moduleName = (String)element$iv;
                    boolean bl4 = false;
                    if (!(this.javaModuleFinder.findModule(moduleName) instanceof JavaModule.Automatic)) continue;
                    bl = true;
                    break block22;
                }
                bl = false;
            }
        }
        if (bl) {
            for (JavaModule javaModule : modules) {
                if (!(javaModule instanceof JavaModule.Automatic)) continue;
                destination$iv$iv = allDependencies;
                String string3 = javaModule.getName();
                destination$iv$iv.add(string3);
            }
        }
        ClasspathRootsResolver.report$default(this, CompilerMessageSeverity.LOGGING, "Loading modules: " + allDependencies, null, 4, null);
        Iterator iterator3 = allDependencies.iterator();
        while (iterator3.hasNext()) {
            String string4;
            String string5 = string4 = (String)iterator3.next();
            Intrinsics.checkNotNullExpressionValue(string5, "moduleName");
            JavaModule module4 = this.javaModuleFinder.findModule(string5);
            if (module4 == null) {
                ClasspathRootsResolver.report$default(this, CompilerMessageSeverity.ERROR, "Module " + string4 + " cannot be found in the module graph", null, 4, null);
                continue;
            }
            for (JavaModule.Root root2 : module4.getModuleRoots()) {
                void root3;
                VirtualFile bl4 = root2.component1();
                boolean isBinary = root2.component2();
                result2.add(new JavaRoot((VirtualFile)root3, isBinary ? JavaRoot.RootType.BINARY : JavaRoot.RootType.SOURCE, null, 4, null));
            }
        }
        if (this.requireStdlibModule && explicit != null && !this.javaModuleGraph.reads(explicit.getName(), "kotlin.stdlib")) {
            this.report(CompilerMessageSeverity.ERROR, "The Kotlin standard library is not found in the module graph. Please ensure you have the 'requires kotlin.stdlib' clause in your module definition", explicit.getModuleInfoFile());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> computeDefaultRootModules() {
        JavaModule.Explicit module2;
        Map.Entry entry;
        void $this$associateByTo$iv$iv;
        ArrayList<Object> result2 = new ArrayList<Object>();
        Sequence<JavaModule.Explicit> $this$associateBy$iv = this.javaModuleFinder.getSystemModules();
        boolean $i$f$associateBy22 = false;
        Object object = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$associateByTo2 = false;
        Iterator iterator2 = $this$associateByTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void receiver;
            Object element$iv$iv;
            Object t = element$iv$iv = iterator2.next();
            Map map = destination$iv$iv;
            boolean bl = false;
            String string2 = ((JavaModule)receiver).getName();
            map.put(string2, element$iv$iv);
        }
        Map systemModules2 = destination$iv$iv;
        Map $i$f$associateBy22 = systemModules2;
        Object object2 = $i$f$associateBy22;
        object = "java.se";
        boolean javaSeExists = object2.containsKey(object);
        if (javaSeExists) {
            result2.add("java.se");
        }
        computeDefaultRootModules.1 $fun$exportsAtLeastOnePackageUnqualified$1 = computeDefaultRootModules.1.INSTANCE;
        if (!javaSeExists) {
            Object $i$f$associateByTo2 = systemModules2;
            object2 = $i$f$associateByTo2.entrySet().iterator();
            while (object2.hasNext()) {
                void name;
                entry = object = object2.next();
                $i$f$associateByTo2 = (String)entry.getKey();
                entry = object;
                module2 = (JavaModule.Explicit)entry.getValue();
                if (!StringsKt.startsWith$default((String)name, "java.", false, 2, null) || !$fun$exportsAtLeastOnePackageUnqualified$1.invoke(module2)) continue;
                result2.add(name);
            }
        }
        Object name = systemModules2;
        object2 = name.entrySet().iterator();
        while (object2.hasNext()) {
            entry = object = object2.next();
            name = (String)entry.getKey();
            entry = object;
            module2 = (JavaModule.Explicit)entry.getValue();
            if (StringsKt.startsWith$default((String)name, "java.", false, 2, null) || !$fun$exportsAtLeastOnePackageUnqualified$1.invoke(module2)) continue;
            result2.add(name);
        }
        return result2;
    }

    private final void report(CompilerMessageSeverity severity, String message2, VirtualFile file2) {
        if (this.messageCollector == null) {
            throw (Throwable)new IllegalStateException((file2 != null ? file2.getPath() + ":" : "") + (Object)((Object)severity) + ": " + message2 + " (no MessageCollector configured)");
        }
        this.messageCollector.report(severity, message2, file2 == null ? null : CompilerMessageLocation.Companion.create(MessageUtil.virtualFileToPath(file2)));
    }

    static /* synthetic */ void report$default(ClasspathRootsResolver classpathRootsResolver, CompilerMessageSeverity compilerMessageSeverity, String string2, VirtualFile virtualFile2, int n, Object object) {
        if ((n & 4) != 0) {
            virtualFile2 = null;
        }
        classpathRootsResolver.report(compilerMessageSeverity, string2, virtualFile2);
    }

    public ClasspathRootsResolver(@NotNull PsiManager psiManager, @Nullable MessageCollector messageCollector, @NotNull List<String> additionalModules, @NotNull Function1<? super JvmContentRoot, ? extends VirtualFile> contentRootToVirtualFile, @NotNull CliJavaModuleFinder javaModuleFinder, boolean requireStdlibModule, @Nullable VirtualFile outputDirectory, @NotNull KotlinCliJavaFileManager javaFileManager) {
        Intrinsics.checkNotNullParameter(psiManager, "psiManager");
        Intrinsics.checkNotNullParameter(additionalModules, "additionalModules");
        Intrinsics.checkNotNullParameter(contentRootToVirtualFile, "contentRootToVirtualFile");
        Intrinsics.checkNotNullParameter(javaModuleFinder, "javaModuleFinder");
        Intrinsics.checkNotNullParameter(javaFileManager, "javaFileManager");
        this.psiManager = psiManager;
        this.messageCollector = messageCollector;
        this.additionalModules = additionalModules;
        this.contentRootToVirtualFile = contentRootToVirtualFile;
        this.javaModuleFinder = javaModuleFinder;
        this.requireStdlibModule = requireStdlibModule;
        this.outputDirectory = outputDirectory;
        this.javaFileManager = javaFileManager;
        this.javaModuleGraph = new JavaModuleGraph(this.javaModuleFinder);
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope(this.psiManager.getProject());
        Intrinsics.checkNotNullExpressionValue(globalSearchScope, "GlobalSearchScope.allScope(psiManager.project)");
        this.searchScope = globalSearchScope;
    }

    public static final /* synthetic */ Attributes access$readManifestAttributes(ClasspathRootsResolver $this, VirtualFile jarRoot) {
        return $this.readManifestAttributes(jarRoot);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0003J)\u0010\r\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/compiler/ClasspathRootsResolver$RootsAndModules;", "", "roots", "", "Lorg/jetbrains/kotlin/cli/jvm/index/JavaRoot;", "modules", "Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModule;", "(Ljava/util/List;Ljava/util/List;)V", "getModules", "()Ljava/util/List;", "getRoots", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "cli"})
    public static final class RootsAndModules {
        @NotNull
        private final List<JavaRoot> roots;
        @NotNull
        private final List<JavaModule> modules;

        @NotNull
        public final List<JavaRoot> getRoots() {
            return this.roots;
        }

        @NotNull
        public final List<JavaModule> getModules() {
            return this.modules;
        }

        public RootsAndModules(@NotNull List<JavaRoot> roots2, @NotNull List<? extends JavaModule> modules) {
            Intrinsics.checkNotNullParameter(roots2, "roots");
            Intrinsics.checkNotNullParameter(modules, "modules");
            this.roots = roots2;
            this.modules = modules;
        }

        @NotNull
        public final List<JavaRoot> component1() {
            return this.roots;
        }

        @NotNull
        public final List<JavaModule> component2() {
            return this.modules;
        }

        @NotNull
        public final RootsAndModules copy(@NotNull List<JavaRoot> roots2, @NotNull List<? extends JavaModule> modules) {
            Intrinsics.checkNotNullParameter(roots2, "roots");
            Intrinsics.checkNotNullParameter(modules, "modules");
            return new RootsAndModules(roots2, modules);
        }

        public static /* synthetic */ RootsAndModules copy$default(RootsAndModules rootsAndModules, List list2, List list3, int n, Object object) {
            if ((n & 1) != 0) {
                list2 = rootsAndModules.roots;
            }
            if ((n & 2) != 0) {
                list3 = rootsAndModules.modules;
            }
            return rootsAndModules.copy(list2, list3);
        }

        @NotNull
        public String toString() {
            return "RootsAndModules(roots=" + this.roots + ", modules=" + this.modules + ")";
        }

        public int hashCode() {
            List<JavaRoot> list2 = this.roots;
            List<JavaModule> list3 = this.modules;
            return (list2 != null ? ((Object)list2).hashCode() : 0) * 31 + (list3 != null ? ((Object)list3).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof RootsAndModules)) break block3;
                    RootsAndModules rootsAndModules = (RootsAndModules)object;
                    if (!Intrinsics.areEqual(this.roots, rootsAndModules.roots) || !Intrinsics.areEqual(this.modules, rootsAndModules.modules)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/compiler/ClasspathRootsResolver$RootWithPrefix;", "", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "packagePrefix", "", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/String;)V", "getPackagePrefix", "()Ljava/lang/String;", "getRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "cli"})
    private static final class RootWithPrefix {
        @NotNull
        private final VirtualFile root;
        @Nullable
        private final String packagePrefix;

        @NotNull
        public final VirtualFile getRoot() {
            return this.root;
        }

        @Nullable
        public final String getPackagePrefix() {
            return this.packagePrefix;
        }

        public RootWithPrefix(@NotNull VirtualFile root2, @Nullable String packagePrefix) {
            Intrinsics.checkNotNullParameter(root2, "root");
            this.root = root2;
            this.packagePrefix = packagePrefix;
        }

        @NotNull
        public final VirtualFile component1() {
            return this.root;
        }

        @Nullable
        public final String component2() {
            return this.packagePrefix;
        }

        @NotNull
        public final RootWithPrefix copy(@NotNull VirtualFile root2, @Nullable String packagePrefix) {
            Intrinsics.checkNotNullParameter(root2, "root");
            return new RootWithPrefix(root2, packagePrefix);
        }

        public static /* synthetic */ RootWithPrefix copy$default(RootWithPrefix rootWithPrefix, VirtualFile virtualFile2, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                virtualFile2 = rootWithPrefix.root;
            }
            if ((n & 2) != 0) {
                string2 = rootWithPrefix.packagePrefix;
            }
            return rootWithPrefix.copy(virtualFile2, string2);
        }

        @NotNull
        public String toString() {
            return "RootWithPrefix(root=" + this.root + ", packagePrefix=" + this.packagePrefix + ")";
        }

        public int hashCode() {
            VirtualFile virtualFile2 = this.root;
            String string2 = this.packagePrefix;
            return (virtualFile2 != null ? virtualFile2.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof RootWithPrefix)) break block3;
                    RootWithPrefix rootWithPrefix = (RootWithPrefix)object;
                    if (!Intrinsics.areEqual(this.root, rootWithPrefix.root) || !Intrinsics.areEqual(this.packagePrefix, rootWithPrefix.packagePrefix)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/compiler/ClasspathRootsResolver$Companion;", "", "()V", "AUTOMATIC_MODULE_NAME", "", "IS_MULTI_RELEASE", "MULTI_RELEASE_MODULE_INFO_CLS_FILE", "cli"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

