/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.declaration;

import java.util.List;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.fir.FirFakeSourceElementKind;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.FirRealSourceElementKind;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnnotatedDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmRecordChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirRegularClassChecker;", "()V", "JAVA_RECORD_CLASS_ID", "Lorg/jetbrains/kotlin/name/ClassId;", "JVM_RECORD_ANNOTATION_FQ_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkers.jvm"})
public final class FirJvmRecordChecker
extends FirDeclarationChecker<FirRegularClass> {
    @NotNull
    public static final FirJvmRecordChecker INSTANCE = new FirJvmRecordChecker();
    @NotNull
    private static final FqName JVM_RECORD_ANNOTATION_FQ_NAME = new FqName("kotlin.jvm.JvmRecord");
    @NotNull
    private static final ClassId JAVA_RECORD_CLASS_ID;

    private FirJvmRecordChecker() {
    }

    @Override
    public void check(@NotNull FirRegularClass declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Object modality$iv;
        Object object;
        Object $this$coneTypeSafe$iv;
        FirPureAbstractElement typeRef;
        Object object2;
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        FirTypeRef firTypeRef = CollectionsKt.firstOrNull(declaration2.getSuperTypeRefs());
        if (firTypeRef != null) {
            ConeClassLikeType coneClassLikeType;
            object2 = firTypeRef;
            typeRef = object2;
            boolean bl = false;
            $this$coneTypeSafe$iv = typeRef;
            boolean $i$f$coneTypeSafe = false;
            object = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
            ConeKotlinType coneKotlinType = object == null ? null : ((FirResolvedTypeRef)object).getType();
            if (!(coneKotlinType instanceof ConeClassLikeType)) {
                coneKotlinType = null;
            }
            if (Intrinsics.areEqual((coneClassLikeType = (ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType))) == null ? null : ConeTypeUtilsKt.getClassId(coneClassLikeType), JAVA_RECORD_CLASS_ID)) {
                DiagnosticReporterKt.reportOn$default(reporter, ((FirTypeRef)typeRef).getSource(), FirJvmErrors.INSTANCE.getILLEGAL_JAVA_LANG_RECORD_SUPERTYPE(), context2, null, 8, null);
                return;
            }
        }
        typeRef = FirAnnotationUtilsKt.getAnnotationByFqName(declaration2, JVM_RECORD_ANNOTATION_FQ_NAME);
        Object object3 = object2 = typeRef == null ? null : ((FirAnnotationCall)typeRef).getSource();
        if (object2 == null) {
            return;
        }
        Object annotationSource = object2;
        LanguageVersionSettings languageVersionSettings = FirLanguageSettingsComponentKt.getLanguageVersionSettings(context2.getSession());
        if (!languageVersionSettings.supportsFeature(LanguageFeature.JvmRecordSupport)) {
            DiagnosticReporterKt.reportOn$default(reporter, (FirSourceElement)annotationSource, FirErrors.INSTANCE.getUNSUPPORTED_FEATURE(), TuplesKt.to(LanguageFeature.JvmRecordSupport, languageVersionSettings), context2, null, 16, null);
            return;
        }
        FirClassLikeDeclaration $this$isLocal$iv = declaration2;
        boolean $i$f$isLocal = false;
        if ($this$isLocal$iv.getSymbol().getClassId().isLocal()) {
            DiagnosticReporterKt.reportOn$default(reporter, (FirSourceElement)annotationSource, FirJvmErrors.INSTANCE.getLOCAL_JVM_RECORD(), context2, null, 8, null);
            return;
        }
        FirMemberDeclaration $this$isInner$iv = declaration2;
        boolean $i$f$isInner = false;
        if ($this$isInner$iv.getStatus().isInner()) {
            DiagnosticReporterKt.reportOn$default(reporter, declaration2.getSource(), FirJvmErrors.INSTANCE.getINNER_JVM_RECORD(), context2, null, 8, null);
            return;
        }
        FirMemberDeclaration $this$isFinal$iv = declaration2;
        boolean $i$f$isFinal = false;
        $this$coneTypeSafe$iv = $this$isFinal$iv.getStatus().getModality();
        if (!($this$coneTypeSafe$iv == null ? true : (modality$iv = $this$coneTypeSafe$iv) == Modality.FINAL)) {
            DiagnosticReporterKt.reportOn$default(reporter, declaration2.getSource(), FirJvmErrors.INSTANCE.getNON_FINAL_JVM_RECORD(), context2, null, 8, null);
            return;
        }
        FirClass $this$isEnumClass$iv = declaration2;
        boolean $i$f$isEnumClass = false;
        Object $this$isEnumClass$iv$iv = $this$isEnumClass$iv.getClassKind();
        boolean $i$f$isEnumClass2 = false;
        boolean bl = $this$isEnumClass$iv$iv == ClassKind.ENUM_CLASS;
        if (bl) {
            DiagnosticReporterKt.reportOn$default(reporter, declaration2.getSource(), FirJvmErrors.INSTANCE.getENUM_JVM_RECORD(), context2, null, 8, null);
            return;
        }
        FirAnnotatedDeclaration $this$isData$iv = declaration2;
        boolean $i$f$isData2 = false;
        if (!((FirRegularClass)$this$isData$iv).getStatus().isData()) {
            DiagnosticReporterKt.reportOn$default(reporter, (FirSourceElement)annotationSource, FirJvmErrors.INSTANCE.getNON_DATA_CLASS_JVM_RECORD(), context2, null, 8, null);
            return;
        }
        $this$isData$iv = FirDeclarationUtilKt.getPrimaryConstructor(declaration2);
        if ($this$isData$iv != null) {
            List<FirValueParameter> $i$f$isData2 = ((FirConstructor)$this$isData$iv).getValueParameters();
            Object params = $this$isEnumClass$iv$iv = $i$f$isData2;
            boolean bl2 = false;
            if (params.isEmpty()) {
                DiagnosticReporterKt.reportOn$default(reporter, (FirSourceElement)annotationSource, FirJvmErrors.INSTANCE.getJVM_RECORD_WITHOUT_PRIMARY_CONSTRUCTOR_PARAMETERS(), context2, null, 8, null);
                return;
            }
            Iterable $this$forEach$iv = CollectionsKt.dropLast(params, 1);
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                FirValueParameter param = (FirValueParameter)element$iv;
                boolean bl3 = false;
                if (!param.isVararg()) continue;
                DiagnosticReporterKt.reportOn$default(reporter, param.getSource(), FirJvmErrors.INSTANCE.getJVM_RECORD_NOT_LAST_VARARG_PARAMETER(), context2, null, 8, null);
            }
        }
        Iterable $this$forEach$iv = declaration2.getDeclarations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirDeclaration decl = (FirDeclaration)element$iv;
            boolean bl4 = false;
            if (decl instanceof FirProperty) {
                FirSourceElement $i$f$forEach2 = decl.getSource();
                boolean fromConstructor = Intrinsics.areEqual($i$f$forEach2 == null ? null : $i$f$forEach2.getKind(), FirFakeSourceElementKind.PropertyFromParameter.INSTANCE);
                if (((FirProperty)decl).isVar() && fromConstructor) {
                    DiagnosticReporterKt.reportOn$default(reporter, decl.getSource(), FirJvmErrors.INSTANCE.getJVM_RECORD_NOT_VAL_PARAMETER(), context2, null, 8, null);
                    continue;
                }
                if (fromConstructor || !DeclarationAttributesKt.getHasBackingField((FirProperty)decl) && ((FirProperty)decl).getDelegateFieldSymbol() == null) continue;
                DiagnosticReporterKt.reportOn$default(reporter, decl.getSource(), FirJvmErrors.INSTANCE.getFIELD_IN_JVM_RECORD(), context2, null, 8, null);
                continue;
            }
            if (!(decl instanceof FirField)) continue;
            FirDeclaration $this$isSynthetic$iv = decl;
            boolean $i$f$isSynthetic = false;
            if (!Intrinsics.areEqual($this$isSynthetic$iv.getOrigin(), FirDeclarationOrigin.Synthetic.INSTANCE)) continue;
            DiagnosticReporterKt.reportOn$default(reporter, decl.getSource(), FirJvmErrors.INSTANCE.getDELEGATION_BY_IN_JVM_RECORD(), context2, null, 8, null);
        }
        FirTypeRef firTypeRef2 = CollectionsKt.firstOrNull(declaration2.getSuperTypeRefs());
        if (firTypeRef2 != null) {
            FirTypeRef firTypeRef3;
            FirTypeRef typeRef2 = firTypeRef3 = firTypeRef2;
            boolean bl5 = false;
            object = typeRef2.getSource();
            if (Intrinsics.areEqual(object == null ? null : ((FirSourceElement)object).getKind(), FirRealSourceElementKind.INSTANCE) && ((object = FirHelpersKt.toRegularClassSymbol(typeRef2, context2.getSession())) == null ? null : ((FirClassSymbol)object).getClassKind()) == ClassKind.CLASS) {
                DiagnosticReporterKt.reportOn$default(reporter, declaration2.getSource(), FirJvmErrors.INSTANCE.getJVM_RECORD_EXTENDS_CLASS(), (Object)FirTypeUtilsKt.getConeType(typeRef2), context2, null, 16, null);
            }
        }
    }

    static {
        ClassId classId = ClassId.fromString("java/lang/Record");
        Intrinsics.checkNotNullExpressionValue(classId, "fromString(\"java/lang/Record\")");
        JAVA_RECORD_CLASS_ID = classId;
    }
}

