/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.inference;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.resolve.calls.inference.CapturedTypeConstructor;
import org.jetbrains.kotlin.resolve.calls.inference.CapturedTypeConstructorImpl;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.SubtypingRepresentatives;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeRefinement;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.KotlinTypeRefiner;
import org.jetbrains.kotlin.types.model.CapturedTypeMarker;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B+\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\"\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\tH\u0016J\u0010\u0010$\u001a\u00020\u00002\u0006\u0010%\u001a\u00020&H\u0017J\u0010\u0010'\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\u000bH\u0016J\u0018\u0010)\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u001bH\u0002J\u0010\u0010-\u001a\u00020\t2\u0006\u0010.\u001a\u00020\u001bH\u0016J\b\u0010/\u001a\u000200H\u0016R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001dR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u00061"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/inference/CapturedType;", "Lorg/jetbrains/kotlin/types/SimpleType;", "Lorg/jetbrains/kotlin/types/SubtypingRepresentatives;", "Lorg/jetbrains/kotlin/types/model/CapturedTypeMarker;", "typeProjection", "Lorg/jetbrains/kotlin/types/TypeProjection;", "constructor", "Lorg/jetbrains/kotlin/resolve/calls/inference/CapturedTypeConstructor;", "isMarkedNullable", "", "annotations", "Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;", "(Lorg/jetbrains/kotlin/types/TypeProjection;Lorg/jetbrains/kotlin/resolve/calls/inference/CapturedTypeConstructor;ZLorg/jetbrains/kotlin/descriptors/annotations/Annotations;)V", "getAnnotations", "()Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;", "arguments", "", "getArguments", "()Ljava/util/List;", "getConstructor", "()Lorg/jetbrains/kotlin/resolve/calls/inference/CapturedTypeConstructor;", "()Z", "memberScope", "Lorg/jetbrains/kotlin/resolve/scopes/MemberScope;", "getMemberScope", "()Lorg/jetbrains/kotlin/resolve/scopes/MemberScope;", "subTypeRepresentative", "Lorg/jetbrains/kotlin/types/KotlinType;", "getSubTypeRepresentative", "()Lorg/jetbrains/kotlin/types/KotlinType;", "superTypeRepresentative", "getSuperTypeRepresentative", "getTypeProjection", "()Lorg/jetbrains/kotlin/types/TypeProjection;", "makeNullableAsSpecified", "newNullability", "refine", "kotlinTypeRefiner", "Lorg/jetbrains/kotlin/types/checker/KotlinTypeRefiner;", "replaceAnnotations", "newAnnotations", "representative", "variance", "Lorg/jetbrains/kotlin/types/Variance;", "default", "sameTypeConstructor", "type", "toString", "", "descriptors"})
public final class CapturedType
extends SimpleType
implements SubtypingRepresentatives,
CapturedTypeMarker {
    @NotNull
    private final TypeProjection typeProjection;
    @NotNull
    private final CapturedTypeConstructor constructor;
    private final boolean isMarkedNullable;
    @NotNull
    private final Annotations annotations;

    public CapturedType(@NotNull TypeProjection typeProjection, @NotNull CapturedTypeConstructor constructor2, boolean isMarkedNullable, @NotNull Annotations annotations2) {
        Intrinsics.checkNotNullParameter(typeProjection, "typeProjection");
        Intrinsics.checkNotNullParameter(constructor2, "constructor");
        Intrinsics.checkNotNullParameter(annotations2, "annotations");
        this.typeProjection = typeProjection;
        this.constructor = constructor2;
        this.isMarkedNullable = isMarkedNullable;
        this.annotations = annotations2;
    }

    public /* synthetic */ CapturedType(TypeProjection typeProjection, CapturedTypeConstructor capturedTypeConstructor, boolean bl, Annotations annotations2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            capturedTypeConstructor = new CapturedTypeConstructorImpl(typeProjection);
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            annotations2 = Annotations.Companion.getEMPTY();
        }
        this(typeProjection, capturedTypeConstructor, bl, annotations2);
    }

    @NotNull
    public final TypeProjection getTypeProjection() {
        return this.typeProjection;
    }

    @Override
    @NotNull
    public CapturedTypeConstructor getConstructor() {
        return this.constructor;
    }

    @Override
    public boolean isMarkedNullable() {
        return this.isMarkedNullable;
    }

    @Override
    @NotNull
    public Annotations getAnnotations() {
        return this.annotations;
    }

    @Override
    @NotNull
    public List<TypeProjection> getArguments() {
        return CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public MemberScope getMemberScope() {
        MemberScope memberScope2 = ErrorUtils.createErrorScope("No member resolution should be done on captured type, it used only during constraint system resolution", true);
        Intrinsics.checkNotNullExpressionValue(memberScope2, "createErrorScope(\n      \u2026solution\", true\n        )");
        return memberScope2;
    }

    @Override
    @NotNull
    public KotlinType getSubTypeRepresentative() {
        SimpleType simpleType2 = TypeUtilsKt.getBuiltIns(this).getNullableAnyType();
        Intrinsics.checkNotNullExpressionValue(simpleType2, "builtIns.nullableAnyType");
        return this.representative(Variance.OUT_VARIANCE, simpleType2);
    }

    @Override
    @NotNull
    public KotlinType getSuperTypeRepresentative() {
        SimpleType simpleType2 = TypeUtilsKt.getBuiltIns(this).getNothingType();
        Intrinsics.checkNotNullExpressionValue(simpleType2, "builtIns.nothingType");
        return this.representative(Variance.IN_VARIANCE, simpleType2);
    }

    private final KotlinType representative(Variance variance, KotlinType kotlinType) {
        KotlinType kotlinType2 = this.typeProjection.getProjectionKind() == variance ? this.typeProjection.getType() : kotlinType;
        Intrinsics.checkNotNullExpressionValue(kotlinType2, "if (typeProjection.proje\u2026jection.type else default");
        return kotlinType2;
    }

    @Override
    public boolean sameTypeConstructor(@NotNull KotlinType type2) {
        Intrinsics.checkNotNullParameter(type2, "type");
        return this.getConstructor() == type2.getConstructor();
    }

    @Override
    @NotNull
    public String toString() {
        return "Captured(" + this.typeProjection + ')' + (this.isMarkedNullable() ? "?" : "");
    }

    @Override
    @NotNull
    public CapturedType makeNullableAsSpecified(boolean newNullability) {
        if (newNullability == this.isMarkedNullable()) {
            return this;
        }
        return new CapturedType(this.typeProjection, this.getConstructor(), newNullability, this.getAnnotations());
    }

    @Override
    @NotNull
    public CapturedType replaceAnnotations(@NotNull Annotations newAnnotations) {
        Intrinsics.checkNotNullParameter(newAnnotations, "newAnnotations");
        return new CapturedType(this.typeProjection, this.getConstructor(), this.isMarkedNullable(), newAnnotations);
    }

    @Override
    @TypeRefinement
    @NotNull
    public CapturedType refine(@NotNull KotlinTypeRefiner kotlinTypeRefiner) {
        Intrinsics.checkNotNullParameter(kotlinTypeRefiner, "kotlinTypeRefiner");
        TypeProjection typeProjection = this.typeProjection.refine(kotlinTypeRefiner);
        Intrinsics.checkNotNullExpressionValue(typeProjection, "typeProjection.refine(kotlinTypeRefiner)");
        return new CapturedType(typeProjection, this.getConstructor(), this.isMarkedNullable(), this.getAnnotations());
    }
}

