/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.application.impl.ModalityStateEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.CoreAwareIconManager;
import com.intellij.ui.IconManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.Stack;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbstractProgressIndicatorBase
extends UserDataHolderBase
implements ProgressIndicator {
    private static final Logger LOG = Logger.getInstance(AbstractProgressIndicatorBase.class);
    private volatile String myText;
    private volatile double myFraction;
    private volatile String myText2;
    private volatile boolean myCanceled;
    private volatile boolean myRunning;
    private volatile boolean myStopped;
    private volatile boolean myIndeterminate = Registry.is("ide.progress.indeterminate.by.default", true);
    private volatile Runnable myMacActivity;
    private volatile boolean myShouldStartActivity = SystemInfoRt.isMac && Registry.is("idea.mac.prevent.app.nap", false);
    private Stack<String> myTextStack;
    private DoubleArrayList myFractionStack;
    private Stack<String> myText2Stack;
    private ProgressIndicator myModalityProgress;
    private volatile ModalityState myModalityState = ModalityState.NON_MODAL;
    private volatile int myNonCancelableSectionCount;
    private final Object lock = ObjectUtils.sentinel("APIB lock");
    private static final Set<Class<?>> ourReportedReuseExceptions = Collections.newSetFromMap(new ConcurrentHashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Object object = this.getLock();
        synchronized (object) {
            LOG.assertTrue(!this.isRunning(), "Attempt to start ProgressIndicator which is already running");
            if (this.myStopped) {
                if (this.myCanceled && !this.isReuseable() && ourReportedReuseExceptions.add(this.getClass())) {
                    LOG.error("Attempt to start ProgressIndicator which is cancelled and already stopped:" + this + "," + this.getClass());
                }
                this.myCanceled = false;
                this.myStopped = false;
            }
            this.myText = "";
            this.myFraction = 0.0;
            this.myText2 = "";
            if (this.myShouldStartActivity) {
                IconManager iconManager = IconManager.getInstance();
                if (iconManager instanceof CoreAwareIconManager) {
                    this.myMacActivity = ((CoreAwareIconManager)((Object)iconManager)).wakeUpNeo(this);
                }
            } else {
                this.myMacActivity = null;
            }
            this.myRunning = true;
        }
    }

    protected boolean isReuseable() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.getLock();
        synchronized (object) {
            LOG.assertTrue(this.myRunning, "stop() should be called only if start() called before");
            this.myRunning = false;
            this.myStopped = true;
            this.stopSystemActivity();
        }
    }

    void stopSystemActivity() {
        Runnable macActivity = this.myMacActivity;
        if (macActivity != null) {
            macActivity.run();
            this.myMacActivity = null;
        }
    }

    @Override
    public boolean isRunning() {
        return this.myRunning;
    }

    @Override
    public void cancel() {
        this.myCanceled = true;
        this.stopSystemActivity();
        if (ApplicationManager.getApplication() != null) {
            ProgressManager.canceled(this);
        }
    }

    @Override
    public boolean isCanceled() {
        return this.myCanceled;
    }

    @Override
    public void checkCanceled() {
        this.throwIfCanceled();
        if (CoreProgressManager.runCheckCanceledHooks(this)) {
            this.throwIfCanceled();
        }
    }

    private void throwIfCanceled() {
        if (this.isCanceled() && this.isCancelable()) {
            Throwable trace = this.getCancellationTrace();
            throw trace instanceof ProcessCanceledException ? (ProcessCanceledException)trace : new ProcessCanceledException(trace);
        }
    }

    @Nullable
    protected Throwable getCancellationTrace() {
        if (this instanceof Disposable) {
            return Disposer.getDisposalTrace((Disposable)((Object)this));
        }
        return null;
    }

    @Override
    public void setText(String text2) {
        this.myText = text2;
    }

    @Override
    public String getText() {
        return this.myText;
    }

    @Override
    public void setText2(String text2) {
        this.myText2 = text2;
    }

    @Override
    public String getText2() {
        return this.myText2;
    }

    @Override
    public double getFraction() {
        return this.myFraction;
    }

    @Override
    public void setFraction(double fraction) {
        if (this.isIndeterminate()) {
            StackTraceElement[] trace = new Throwable().getStackTrace();
            Optional<StackTraceElement> first = Arrays.stream(trace).filter(element -> !element.getClassName().startsWith("com.intellij.openapi.progress.util")).findFirst();
            @NonNls String message2 = "This progress indicator is indeterminate, this may lead to visual inconsistency. Please call setIndeterminate(false) before you start progress.";
            if (first.isPresent()) {
                message2 = message2 + "\n" + first.get();
            }
            LOG.warn(message2);
            this.setIndeterminate(false);
        }
        this.myFraction = fraction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pushState() {
        Object object = this.getLock();
        synchronized (object) {
            this.getTextStack().push(this.myText);
            this.getFractionStack().add(this.myFraction);
            this.getText2Stack().push(this.myText2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void popState() {
        Object object = this.getLock();
        synchronized (object) {
            LOG.assertTrue(!this.myTextStack.isEmpty());
            String oldText = this.myTextStack.pop();
            String oldText2 = this.myText2Stack.pop();
            this.setText(oldText);
            this.setText2(oldText2);
            double oldFraction = this.myFractionStack.removeDouble(this.myFractionStack.size() - 1);
            if (!this.isIndeterminate()) {
                this.setFraction(oldFraction);
            }
        }
    }

    public void startNonCancelableSection() {
        ++this.myNonCancelableSectionCount;
    }

    public void finishNonCancelableSection() {
        --this.myNonCancelableSectionCount;
    }

    protected boolean isCancelable() {
        return this.myNonCancelableSectionCount == 0 && !ProgressManager.getInstance().isInNonCancelableSection();
    }

    @Override
    public final boolean isModal() {
        return this.myModalityProgress != null;
    }

    @Override
    @NotNull
    public ModalityState getModalityState() {
        ModalityState modalityState = this.myModalityState;
        if (modalityState == null) {
            AbstractProgressIndicatorBase.$$$reportNull$$$0(0);
        }
        return modalityState;
    }

    public void setModalityProgress(@Nullable ProgressIndicator modalityProgress) {
        LOG.assertTrue(!this.isRunning());
        this.myModalityProgress = modalityProgress;
        this.setModalityState(modalityProgress);
    }

    private void setModalityState(@Nullable ProgressIndicator modalityProgress) {
        ModalityState modalityState = ModalityState.defaultModalityState();
        if (modalityProgress != null) {
            modalityState = ((ModalityStateEx)modalityState).appendProgress(modalityProgress);
            ((TransactionGuardImpl)TransactionGuard.getInstance()).enteredModality(modalityState);
        }
        this.myModalityState = modalityState;
    }

    @Override
    public boolean isIndeterminate() {
        return this.myIndeterminate;
    }

    @Override
    public void setIndeterminate(boolean indeterminate) {
        this.myIndeterminate = indeterminate;
    }

    @NonNls
    public String toString() {
        return "ProgressIndicator " + System.identityHashCode(this) + ": running=" + this.isRunning() + "; canceled=" + this.isCanceled();
    }

    public boolean isPopupWasShown() {
        return true;
    }

    public boolean isShowing() {
        return this.isModal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initStateFrom(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            AbstractProgressIndicatorBase.$$$reportNull$$$0(1);
        }
        Object object = this.getLock();
        synchronized (object) {
            this.myRunning = indicator.isRunning();
            this.myCanceled = indicator.isCanceled();
            boolean indeterminate = indicator.isIndeterminate();
            this.setIndeterminate(indeterminate);
            if (!indeterminate || indicator.getFraction() != 0.0) {
                this.setFraction(indicator.getFraction());
            }
            this.setText(indicator.getText());
            this.setText2(indicator.getText2());
            if (indicator instanceof AbstractProgressIndicatorBase) {
                AbstractProgressIndicatorBase stacked = (AbstractProgressIndicatorBase)indicator;
                this.myTextStack = stacked.myTextStack == null ? null : new Stack<String>((Collection<String>)stacked.getTextStack());
                this.myText2Stack = stacked.myText2Stack == null ? null : new Stack<String>((Collection<String>)stacked.getText2Stack());
                this.myFractionStack = stacked.myFractionStack == null ? null : new DoubleArrayList(stacked.getFractionStack().toDoubleArray());
            }
            this.dontStartActivity();
        }
    }

    protected void dontStartActivity() {
        this.myShouldStartActivity = false;
    }

    @NotNull
    private Stack<String> getTextStack() {
        Stack<String> stack = this.myTextStack;
        if (stack == null) {
            this.myTextStack = stack = new Stack(2);
        }
        Stack<String> stack2 = stack;
        if (stack2 == null) {
            AbstractProgressIndicatorBase.$$$reportNull$$$0(2);
        }
        return stack2;
    }

    @NotNull
    private DoubleArrayList getFractionStack() {
        DoubleArrayList stack = this.myFractionStack;
        if (stack == null) {
            this.myFractionStack = stack = new DoubleArrayList(2);
        }
        DoubleArrayList doubleArrayList = stack;
        if (doubleArrayList == null) {
            AbstractProgressIndicatorBase.$$$reportNull$$$0(3);
        }
        return doubleArrayList;
    }

    @NotNull
    private Stack<String> getText2Stack() {
        Stack<String> stack = this.myText2Stack;
        if (stack == null) {
            this.myText2Stack = stack = new Stack(2);
        }
        Stack<String> stack2 = stack;
        if (stack2 == null) {
            AbstractProgressIndicatorBase.$$$reportNull$$$0(4);
        }
        return stack2;
    }

    @NotNull
    protected Object getLock() {
        Object object = this.lock;
        if (object == null) {
            AbstractProgressIndicatorBase.$$$reportNull$$$0(5);
        }
        return object;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/progress/util/AbstractProgressIndicatorBase";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getModalityState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/progress/util/AbstractProgressIndicatorBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextStack";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFractionStack";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getText2Stack";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLock";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "initStateFrom";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

