/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.BackendContext;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.backend.common.lower.InnerClassesSupport;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpressionKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrDelegatingConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrFunctionReferenceImpl;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/InnerClassConstructorCallsLowering;", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/common/BackendContext;", "innerClassesSupport", "Lorg/jetbrains/kotlin/backend/common/lower/InnerClassesSupport;", "(Lorg/jetbrains/kotlin/backend/common/BackendContext;Lorg/jetbrains/kotlin/backend/common/lower/InnerClassesSupport;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/BackendContext;", "getInnerClassesSupport", "()Lorg/jetbrains/kotlin/backend/common/lower/InnerClassesSupport;", "lower", "", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "ir.backend.common"})
public final class InnerClassConstructorCallsLowering
implements BodyLoweringPass {
    @NotNull
    private final BackendContext context;
    @NotNull
    private final InnerClassesSupport innerClassesSupport;

    public InnerClassConstructorCallsLowering(@NotNull BackendContext context2, @NotNull InnerClassesSupport innerClassesSupport) {
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(innerClassesSupport, "innerClassesSupport");
        this.context = context2;
        this.innerClassesSupport = innerClassesSupport;
    }

    @NotNull
    public final BackendContext getContext() {
        return this.context;
    }

    @NotNull
    public final InnerClassesSupport getInnerClassesSupport() {
        return this.innerClassesSupport;
    }

    @Override
    public void lower(@NotNull IrBody irBody, @NotNull IrDeclaration container) {
        Intrinsics.checkNotNullParameter(irBody, "irBody");
        Intrinsics.checkNotNullParameter(container, "container");
        IrElementTransformerVoidKt.transformChildrenVoid(irBody, new IrElementTransformerVoid(this){
            final /* synthetic */ InnerClassConstructorCallsLowering this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public IrExpression visitConstructorCall(@NotNull IrConstructorCall expression2) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                IrExpression irExpression = expression2.getDispatchReceiver();
                if (irExpression == null) {
                    return expression2;
                }
                IrExpression dispatchReceiver = irExpression;
                IrConstructorSymbol callee = expression2.getSymbol();
                IrClass parent2 = IrUtilsKt.getParentAsClass((IrDeclaration)callee.getOwner());
                if (!parent2.isInner()) {
                    return expression2;
                }
                IrConstructor newCallee = this.this$0.getInnerClassesSupport().getInnerClassConstructorWithOuterThisParameter((IrConstructor)callee.getOwner());
                int classTypeParametersCount = expression2.getTypeArgumentsCount() - expression2.getConstructorTypeArgumentsCount();
                IrConstructorCallImpl newCall = IrConstructorCallImpl.Companion.fromSymbolOwner(expression2.getStartOffset(), expression2.getEndOffset(), expression2.getType(), newCallee.getSymbol(), classTypeParametersCount, expression2.getOrigin());
                IrMemberAccessExpressionKt.copyTypeArgumentsFrom$default(newCall, expression2, 0, 2, null);
                newCall.putValueArgument(0, dispatchReceiver);
                int n = 1;
                int n2 = CollectionsKt.getLastIndex(newCallee.getValueParameters());
                if (n <= n2) {
                    int i;
                    do {
                        i = n++;
                        newCall.putValueArgument(i, expression2.getValueArgument(i - 1));
                    } while (i != n2);
                }
                return newCall;
            }

            @NotNull
            public IrExpression visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
                IrDelegatingConstructorCallImpl irDelegatingConstructorCallImpl;
                Intrinsics.checkNotNullParameter(expression2, "expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                IrExpression irExpression = expression2.getDispatchReceiver();
                if (irExpression == null) {
                    return expression2;
                }
                IrExpression dispatchReceiver = irExpression;
                IrConstructor classConstructor = (IrConstructor)expression2.getSymbol().getOwner();
                if (!IrUtilsKt.getParentAsClass(classConstructor).isInner()) {
                    return expression2;
                }
                IrConstructor newCallee = this.this$0.getInnerClassesSupport().getInnerClassConstructorWithOuterThisParameter(classConstructor);
                IrDelegatingConstructorCallImpl $this$visitDelegatingConstructorCall_u24lambda_u2d0 = irDelegatingConstructorCallImpl = new IrDelegatingConstructorCallImpl(expression2.getStartOffset(), expression2.getEndOffset(), this.this$0.getContext().getIrBuiltIns().getUnitType(), newCallee.getSymbol(), expression2.getTypeArgumentsCount(), newCallee.getValueParameters().size());
                boolean bl = false;
                IrMemberAccessExpressionKt.copyTypeArgumentsFrom$default($this$visitDelegatingConstructorCall_u24lambda_u2d0, expression2, 0, 2, null);
                IrDelegatingConstructorCallImpl newCall = irDelegatingConstructorCallImpl;
                newCall.putValueArgument(0, dispatchReceiver);
                int n = 1;
                int n2 = CollectionsKt.getLastIndex(newCallee.getValueParameters());
                if (n <= n2) {
                    int i;
                    do {
                        i = n++;
                        newCall.putValueArgument(i, expression2.getValueArgument(i - 1));
                    } while (i != n2);
                }
                return newCall;
            }

            @NotNull
            public IrExpression visitFunctionReference(@NotNull IrFunctionReference expression2) {
                Object object;
                IrConstructor irConstructor2;
                IrConstructorSymbol irConstructorSymbol;
                Intrinsics.checkNotNullParameter(expression2, "expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                Object object2 = expression2.getSymbol();
                IrConstructorSymbol irConstructorSymbol2 = irConstructorSymbol = object2 instanceof IrConstructorSymbol ? (IrConstructorSymbol)object2 : null;
                if (irConstructorSymbol == null) {
                    return expression2;
                }
                IrConstructorSymbol callee = irConstructorSymbol;
                IrDeclarationParent irDeclarationParent = ((IrConstructor)callee.getOwner()).getParent();
                IrClass irClass2 = object2 = irDeclarationParent instanceof IrClass ? (IrClass)irDeclarationParent : null;
                if (object2 == null) {
                    return expression2;
                }
                Object parent2 = object2;
                if (!((IrClass)parent2).isInner()) {
                    return expression2;
                }
                IrConstructor newCallee = this.this$0.getInnerClassesSupport().getInnerClassConstructorWithOuterThisParameter((IrConstructor)callee.getOwner());
                IrFunctionSymbol irFunctionSymbol = expression2.getReflectionTarget();
                if (irFunctionSymbol == null) {
                    irConstructor2 = null;
                } else {
                    object = irFunctionSymbol;
                    InnerClassConstructorCallsLowering innerClassConstructorCallsLowering = this.this$0;
                    Object reflectionTarget = object;
                    boolean bl = false;
                    irConstructor2 = reflectionTarget instanceof IrConstructorSymbol ? innerClassConstructorCallsLowering.getInnerClassesSupport().getInnerClassConstructorWithOuterThisParameter((IrConstructor)((IrConstructorSymbol)reflectionTarget).getOwner()) : (IrConstructor)null;
                }
                IrConstructor newReflectionTarget = irConstructor2;
                Object $this$visitFunctionReference_u24lambda_u2d2 = object = expression2;
                boolean bl = false;
                IrConstructor irConstructor3 = newReflectionTarget;
                IrFunctionReferenceImpl newReference = new IrFunctionReferenceImpl($this$visitFunctionReference_u24lambda_u2d2.getStartOffset(), $this$visitFunctionReference_u24lambda_u2d2.getEndOffset(), ((IrExpression)$this$visitFunctionReference_u24lambda_u2d2).getType(), newCallee.getSymbol(), ((IrMemberAccessExpression)$this$visitFunctionReference_u24lambda_u2d2).getTypeArgumentsCount(), newCallee.getValueParameters().size(), irConstructor3 == null ? null : irConstructor3.getSymbol(), ((IrMemberAccessExpression)$this$visitFunctionReference_u24lambda_u2d2).getOrigin());
                Object it = object = newReference;
                boolean bl2 = false;
                IrMemberAccessExpressionKt.copyTypeArgumentsFrom$default((IrMemberAccessExpression)it, expression2, 0, 2, null);
                ((IrMemberAccessExpression)it).setDispatchReceiver(expression2.getDispatchReceiver());
                ((IrMemberAccessExpression)it).setExtensionReceiver(expression2.getExtensionReceiver());
                int n = 0;
                int n2 = expression2.getValueArgumentsCount();
                while (n < n2) {
                    int v = n++;
                    ((IrFunctionReferenceImpl)it).putValueArgument(v, expression2.getValueArgument(v));
                }
                return newReference;
            }
        });
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        BodyLoweringPass.DefaultImpls.lower(this, irFile);
    }
}

