/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler.jarfs;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.zip.Inflater;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.jvm.compiler.jarfs.ByteArrayCharSequence;
import org.jetbrains.kotlin.cli.jvm.compiler.jarfs.ZipEntryDescription;
import org.jetbrains.kotlin.cli.jvm.compiler.jarfs.ZipImplementationKt$WhenMappings;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\u001a\u0012\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u0014\u0010\t\u001a\u00020\u0001*\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\r*\u00020\u0006\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"END_OF_CENTRAL_DIR_SIZE", "", "LOCAL_FILE_HEADER_EXTRA_OFFSET", "LOCAL_FILE_HEADER_SIZE", "contentsToByteArray", "", "Ljava/nio/MappedByteBuffer;", "zipEntryDescription", "Lorg/jetbrains/kotlin/cli/jvm/compiler/jarfs/ZipEntryDescription;", "getUnsignedShort", "Ljava/nio/ByteBuffer;", "offset", "parseCentralDirectory", "", "cli"})
public final class ZipImplementationKt {
    @NotNull
    public static final byte[] contentsToByteArray(@NotNull MappedByteBuffer $this$contentsToByteArray, @NotNull ZipEntryDescription zipEntryDescription) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter($this$contentsToByteArray, "$this$contentsToByteArray");
        Intrinsics.checkNotNullParameter(zipEntryDescription, "zipEntryDescription");
        $this$contentsToByteArray.order(ByteOrder.LITTLE_ENDIAN);
        int extraSize = ZipImplementationKt.getUnsignedShort($this$contentsToByteArray, zipEntryDescription.getOffsetInFile() + 28);
        $this$contentsToByteArray.position(zipEntryDescription.getOffsetInFile() + 30 + zipEntryDescription.getFileNameSize() + extraSize);
        byte[] compressed = new byte[zipEntryDescription.getCompressedSize() + 1];
        $this$contentsToByteArray.get(compressed, 0, zipEntryDescription.getCompressedSize());
        switch (ZipImplementationKt$WhenMappings.$EnumSwitchMapping$0[zipEntryDescription.getCompressionKind().ordinal()]) {
            case 1: {
                Inflater inflater = new Inflater(true);
                inflater.setInput(compressed, 0, zipEntryDescription.getCompressedSize());
                byte[] result2 = new byte[zipEntryDescription.getUncompressedSize()];
                inflater.inflate(result2);
                byArray = result2;
                break;
            }
            case 2: {
                byte[] byArray2 = compressed;
                int n = zipEntryDescription.getCompressedSize();
                byte[] byArray3 = Arrays.copyOf(byArray2, n);
                Intrinsics.checkNotNullExpressionValue(byArray3, "copyOf(this, newSize)");
                byArray = byArray3;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ZipEntryDescription> parseCentralDirectory(@NotNull MappedByteBuffer $this$parseCentralDirectory) {
        int offsetOfCentralDirectory;
        int endOfCentralDirectoryOffset;
        Intrinsics.checkNotNullParameter($this$parseCentralDirectory, "$this$parseCentralDirectory");
        $this$parseCentralDirectory.order(ByteOrder.LITTLE_ENDIAN);
        for (endOfCentralDirectoryOffset = $this$parseCentralDirectory.capacity() - 22; endOfCentralDirectoryOffset >= 0 && $this$parseCentralDirectory.getInt(endOfCentralDirectoryOffset) != 101010256; --endOfCentralDirectoryOffset) {
        }
        int entriesNumber = ZipImplementationKt.getUnsignedShort($this$parseCentralDirectory, endOfCentralDirectoryOffset + 10);
        int currentOffset = offsetOfCentralDirectory = $this$parseCentralDirectory.getInt(endOfCentralDirectoryOffset + 16);
        List result2 = new ArrayList();
        int n = 0;
        int n2 = entriesNumber;
        while (n < n2) {
            ZipEntryDescription.CompressionKind compressionKind;
            boolean $this$all$iv22;
            CharSequence charSequence2;
            boolean bl;
            Object $this$all$iv22;
            byte[] bytesForName;
            int offsetOfFileData;
            int fileCommentLength;
            int extraLength;
            int fileNameLength;
            int uncompressedSize;
            int compressedSize;
            short compressionMethod;
            short versionNeededToExtract;
            void i;
            block11: {
                boolean bl2;
                int headerConst = $this$parseCentralDirectory.getInt(currentOffset);
                boolean bl3 = bl2 = headerConst == 33639248;
                if (!bl2) {
                    boolean $i$a$-require-ZipImplementationKt$parseCentralDirectory$332 = false;
                    String $i$a$-require-ZipImplementationKt$parseCentralDirectory$332 = (int)i + ": " + headerConst;
                    throw new IllegalArgumentException($i$a$-require-ZipImplementationKt$parseCentralDirectory$332.toString());
                }
                versionNeededToExtract = $this$parseCentralDirectory.getShort(currentOffset + 6);
                compressionMethod = $this$parseCentralDirectory.getShort(currentOffset + 10);
                compressedSize = $this$parseCentralDirectory.getInt(currentOffset + 20);
                uncompressedSize = $this$parseCentralDirectory.getInt(currentOffset + 24);
                fileNameLength = ZipImplementationKt.getUnsignedShort($this$parseCentralDirectory, currentOffset + 28);
                extraLength = ZipImplementationKt.getUnsignedShort($this$parseCentralDirectory, currentOffset + 30);
                fileCommentLength = ZipImplementationKt.getUnsignedShort($this$parseCentralDirectory, currentOffset + 32);
                offsetOfFileData = $this$parseCentralDirectory.getInt(currentOffset + 42);
                bytesForName = new byte[fileNameLength];
                $this$parseCentralDirectory.position(currentOffset + 46);
                $this$parseCentralDirectory.get(bytesForName);
                $this$all$iv22 = bytesForName;
                boolean $i$f$all = false;
                for (byte element$iv : $this$all$iv22) {
                    byte it = element$iv;
                    boolean bl4 = false;
                    if (it >= 0) continue;
                    bl = false;
                    break block11;
                }
                bl = true;
            }
            if (bl) {
                charSequence2 = new ByteArrayCharSequence(bytesForName, 0, 0, 6, null);
            } else {
                $this$all$iv22 = Charsets.UTF_8;
                charSequence2 = new String(bytesForName, (Charset)$this$all$iv22);
            }
            CharSequence name = charSequence2;
            currentOffset += 46 + fileNameLength + extraLength + fileCommentLength;
            boolean bl4 = $this$all$iv22 = versionNeededToExtract == 10 || versionNeededToExtract == 20;
            if (!$this$all$iv22) {
                boolean bl6 = false;
                String string2 = "Unexpected versionNeededToExtract (" + versionNeededToExtract + ") at " + name;
                throw new IllegalArgumentException(string2.toString());
            }
            switch (compressionMethod) {
                case 0: {
                    compressionKind = ZipEntryDescription.CompressionKind.PLAIN;
                    break;
                }
                case 8: {
                    compressionKind = ZipEntryDescription.CompressionKind.DEFLATE;
                    break;
                }
                default: {
                    String string3 = "Unexpected compression method (" + compressionMethod + ") at " + name;
                    throw new IllegalStateException(string3.toString());
                }
            }
            ZipEntryDescription.CompressionKind compressionKind2 = compressionKind;
            Collection collection = result2;
            ZipEntryDescription object = new ZipEntryDescription(name, compressedSize, uncompressedSize, offsetOfFileData, compressionKind2, fileNameLength);
            collection.add(object);
            ++i;
        }
        return result2;
    }

    private static final int getUnsignedShort(ByteBuffer $this$getUnsignedShort, int offset2) {
        return Short.toUnsignedInt($this$getUnsignedShort.getShort(offset2));
    }
}

