/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers;

import java.util.Iterator;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.declarations.FirAnnotatedDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.types.ConeCapturedType;
import org.jetbrains.kotlin.fir.types.ConeClassErrorType;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralType;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeConflictingProjection;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionIn;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionOut;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeStubType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0007H\u0016J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\bH\u0016J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\tH\u0016J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f*\u00060\rj\u0002`\u000e2\u0006\u0010\u0004\u001a\u00020\bH\u0016J\u0018\u0010\u000f\u001a\u00020\f*\u00060\rj\u0002`\u000e2\u0006\u0010\u0004\u001a\u00020\u0010H\u0016J\u0018\u0010\u000f\u001a\u00020\f*\u00060\rj\u0002`\u000e2\u0006\u0010\u0004\u001a\u00020\u0011H\u0016J\u0018\u0010\u000f\u001a\u00020\f*\u00060\rj\u0002`\u000e2\u0006\u0010\u0004\u001a\u00020\u0012H\u0016J\u0018\u0010\u000f\u001a\u00020\f*\u00060\rj\u0002`\u000e2\u0006\u0010\u0004\u001a\u00020\u0013H\u0016J\u0018\u0010\u000f\u001a\u00020\f*\u00060\rj\u0002`\u000e2\u0006\u0010\u0004\u001a\u00020\u0014H\u0016J\u0018\u0010\u000f\u001a\u00020\f*\u00060\rj\u0002`\u000e2\u0006\u0010\u0004\u001a\u00020\u0015H\u0016J\u0018\u0010\u000f\u001a\u00020\f*\u00060\rj\u0002`\u000e2\u0006\u0010\u0004\u001a\u00020\u0016H\u0016J\u0018\u0010\u000f\u001a\u00020\f*\u00060\rj\u0002`\u000e2\u0006\u0010\u0004\u001a\u00020\u0017H\u0016\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/FirDeclarationPresenter;", "", "represent", "", "it", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "owner", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "Lorg/jetbrains/kotlin/fir/declarations/FirVariable;", "appendOperatorTag", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "appendRepresentation", "Lorg/jetbrains/kotlin/fir/FirElement;", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameter;", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "Lorg/jetbrains/kotlin/name/CallableId;", "Lorg/jetbrains/kotlin/name/ClassId;", "checkers"})
public interface FirDeclarationPresenter {
    public void appendRepresentation(@NotNull StringBuilder var1, @NotNull FirElement var2);

    public void appendRepresentation(@NotNull StringBuilder var1, @NotNull ClassId var2);

    public void appendRepresentation(@NotNull StringBuilder var1, @NotNull CallableId var2);

    public void appendRepresentation(@NotNull StringBuilder var1, @NotNull ConeTypeProjection var2);

    public void appendRepresentation(@NotNull StringBuilder var1, @NotNull ConeKotlinType var2);

    public void appendRepresentation(@NotNull StringBuilder var1, @NotNull FirTypeRef var2);

    public void appendRepresentation(@NotNull StringBuilder var1, @NotNull FirTypeParameter var2);

    public void appendRepresentation(@NotNull StringBuilder var1, @NotNull FirValueParameter var2);

    @NotNull
    public String represent(@NotNull FirVariable var1);

    public void appendOperatorTag(@NotNull StringBuilder var1, @NotNull FirSimpleFunction var2);

    @NotNull
    public String represent(@NotNull FirSimpleFunction var1);

    @NotNull
    public String represent(@NotNull FirTypeAlias var1);

    @NotNull
    public String represent(@NotNull FirRegularClass var1);

    @NotNull
    public String represent(@NotNull FirConstructor var1, @NotNull FirRegularClass var2);

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        public static void appendRepresentation(@NotNull FirDeclarationPresenter this_, @NotNull StringBuilder receiver, @NotNull FirElement it) {
            Intrinsics.checkNotNullParameter(this_, "this");
            Intrinsics.checkNotNullParameter(receiver, "receiver");
            Intrinsics.checkNotNullParameter(it, "it");
            receiver.append("NO_REPRESENTATION");
        }

        public static void appendRepresentation(@NotNull FirDeclarationPresenter this_, @NotNull StringBuilder receiver, @NotNull ClassId it) {
            Intrinsics.checkNotNullParameter(this_, "this");
            Intrinsics.checkNotNullParameter(receiver, "receiver");
            Intrinsics.checkNotNullParameter(it, "it");
            receiver.append(it.getPackageFqName().asString());
            receiver.append('/');
            receiver.append(it.getRelativeClassName().asString());
        }

        public static void appendRepresentation(@NotNull FirDeclarationPresenter this_, @NotNull StringBuilder receiver, @NotNull CallableId it) {
            Intrinsics.checkNotNullParameter(this_, "this");
            Intrinsics.checkNotNullParameter(receiver, "receiver");
            Intrinsics.checkNotNullParameter(it, "it");
            if (it.getClassName() != null) {
                receiver.append(it.getPackageName().asString());
                receiver.append('/');
                receiver.append(it.getClassName());
                receiver.append('.');
                receiver.append(it.getCallableName());
            } else {
                receiver.append(it.getPackageName().asString());
                receiver.append('/');
                receiver.append(it.getCallableName());
            }
        }

        public static void appendRepresentation(@NotNull FirDeclarationPresenter this_, @NotNull StringBuilder receiver, @NotNull ConeTypeProjection it) {
            Intrinsics.checkNotNullParameter(this_, "this");
            Intrinsics.checkNotNullParameter(receiver, "receiver");
            Intrinsics.checkNotNullParameter(it, "it");
            ConeTypeProjection coneTypeProjection = it;
            if (Intrinsics.areEqual(coneTypeProjection, ConeStarProjection.INSTANCE)) {
                receiver.append('*');
            } else if (coneTypeProjection instanceof ConeKotlinTypeProjectionIn) {
                receiver.append("in ");
                this_.appendRepresentation(receiver, ((ConeKotlinTypeProjectionIn)it).getType());
            } else if (coneTypeProjection instanceof ConeKotlinTypeProjectionOut) {
                receiver.append("out ");
                this_.appendRepresentation(receiver, ((ConeKotlinTypeProjectionOut)it).getType());
            } else if (coneTypeProjection instanceof ConeKotlinType) {
                this_.appendRepresentation(receiver, (ConeKotlinType)it);
            } else if (coneTypeProjection instanceof ConeKotlinTypeConflictingProjection) {
                // empty if block
            }
        }

        public static void appendRepresentation(@NotNull FirDeclarationPresenter this_, @NotNull StringBuilder receiver, @NotNull ConeKotlinType it) {
            Intrinsics.checkNotNullParameter(this_, "this");
            Intrinsics.checkNotNullParameter(receiver, "receiver");
            Intrinsics.checkNotNullParameter(it, "it");
            ConeKotlinType coneKotlinType = it;
            if (coneKotlinType instanceof ConeDefinitelyNotNullType) {
                this_.appendRepresentation(receiver, ((ConeDefinitelyNotNullType)it).getOriginal());
                receiver.append(it.getNullability().getSuffix());
            } else if (coneKotlinType instanceof ConeClassErrorType) {
                receiver.append("ERROR(");
                receiver.append(((ConeClassErrorType)it).getDiagnostic().getReason());
                receiver.append(')');
            } else if (coneKotlinType instanceof ConeCapturedType) {
                receiver.append(((ConeCapturedType)it).getConstructor().getProjection());
                receiver.append(it.getNullability().getSuffix());
            } else if (coneKotlinType instanceof ConeClassLikeType) {
                this_.appendRepresentation(receiver, ((ConeClassLikeType)it).getLookupTag().getClassId());
                if (!(it.getTypeArguments().length == 0)) {
                    receiver.append('<');
                    ConeTypeProjection[] $this$forEach$iv = it.getTypeArguments();
                    boolean $i$f$forEach = false;
                    for (ConeTypeProjection element$iv : $this$forEach$iv) {
                        ConeTypeProjection that = element$iv;
                        boolean bl = false;
                        this_.appendRepresentation(receiver, that);
                        receiver.append(',');
                    }
                    receiver.append('>');
                }
                receiver.append(it.getNullability().getSuffix());
            } else if (coneKotlinType instanceof ConeLookupTagBasedType) {
                receiver.append(((ConeLookupTagBasedType)it).getLookupTag().getName());
                receiver.append(it.getNullability().getSuffix());
            } else if (coneKotlinType instanceof ConeIntegerLiteralType) {
                receiver.append(((ConeIntegerLiteralType)it).getValue());
                receiver.append(it.getNullability().getSuffix());
            } else if ((coneKotlinType instanceof ConeFlexibleType ? true : coneKotlinType instanceof ConeIntersectionType) ? true : coneKotlinType instanceof ConeStubType) {
                receiver.append("ERROR");
            }
        }

        public static void appendRepresentation(@NotNull FirDeclarationPresenter this_, @NotNull StringBuilder receiver, @NotNull FirTypeRef it) {
            Intrinsics.checkNotNullParameter(this_, "this");
            Intrinsics.checkNotNullParameter(receiver, "receiver");
            Intrinsics.checkNotNullParameter(it, "it");
            FirTypeRef firTypeRef = it;
            if (firTypeRef instanceof FirResolvedTypeRef) {
                this_.appendRepresentation(receiver, ((FirResolvedTypeRef)it).getType());
            } else if (firTypeRef instanceof FirErrorTypeRef) {
                receiver.append("ERROR");
            } else {
                receiver.append("?");
            }
        }

        /*
         * WARNING - void declaration
         */
        public static void appendRepresentation(@NotNull FirDeclarationPresenter this_, @NotNull StringBuilder receiver, @NotNull FirTypeParameter it) {
            Intrinsics.checkNotNullParameter(this_, "this");
            Intrinsics.checkNotNullParameter(receiver, "receiver");
            Intrinsics.checkNotNullParameter(it, "it");
            receiver.append(it.getName().asString());
            receiver.append(':');
            int n = it.getBounds().size();
            switch (n) {
                case 0: {
                    break;
                }
                case 1: {
                    this_.appendRepresentation(receiver, it.getBounds().get(0));
                    break;
                }
                default: {
                    Object that;
                    TreeSet<String> set = SetsKt.sortedSetOf(new String[0]);
                    Iterable $this$forEach$iv = it.getBounds();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        void $this$appendRepresentation_u24lambda_u2d2_u24lambda_u2d1;
                        StringBuilder stringBuilder2;
                        that = (FirTypeRef)element$iv;
                        boolean bl = false;
                        StringBuilder stringBuilder3 = stringBuilder2 = new StringBuilder();
                        TreeSet<String> treeSet = set;
                        boolean bl2 = false;
                        this_.appendRepresentation((StringBuilder)$this$appendRepresentation_u24lambda_u2d2_u24lambda_u2d1, (FirTypeRef)that);
                        Unit unit2 = Unit.INSTANCE;
                        String string2 = stringBuilder2.toString();
                        Intrinsics.checkNotNullExpressionValue(string2, "StringBuilder().apply(builderAction).toString()");
                        treeSet.add(string2);
                    }
                    $this$forEach$iv = set;
                    $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        that = (String)element$iv;
                        boolean bl = false;
                        receiver.append((String)that);
                        receiver.append(',');
                    }
                }
            }
        }

        public static void appendRepresentation(@NotNull FirDeclarationPresenter this_, @NotNull StringBuilder receiver, @NotNull FirValueParameter it) {
            Intrinsics.checkNotNullParameter(this_, "this");
            Intrinsics.checkNotNullParameter(receiver, "receiver");
            Intrinsics.checkNotNullParameter(it, "it");
            if (it.isVararg()) {
                receiver.append("vararg ");
            }
            this_.appendRepresentation(receiver, it.getReturnTypeRef());
        }

        @NotNull
        public static String represent(@NotNull FirDeclarationPresenter this_, @NotNull FirVariable it) {
            StringBuilder stringBuilder2;
            Intrinsics.checkNotNullParameter(this_, "this");
            Intrinsics.checkNotNullParameter(it, "it");
            StringBuilder $this$represent_u24lambda_u2d5 = stringBuilder2 = new StringBuilder();
            boolean bl = false;
            $this$represent_u24lambda_u2d5.append('[');
            FirTypeRef firTypeRef = it.getReceiverTypeRef();
            if (firTypeRef != null) {
                FirTypeRef firTypeRef2;
                FirTypeRef it2 = firTypeRef2 = firTypeRef;
                boolean bl2 = false;
                this_.appendRepresentation($this$represent_u24lambda_u2d5, it2);
            }
            $this$represent_u24lambda_u2d5.append(']');
            this_.appendRepresentation($this$represent_u24lambda_u2d5, it.getSymbol().getCallableId());
            String string2 = stringBuilder2.toString();
            Intrinsics.checkNotNullExpressionValue(string2, "StringBuilder().apply(builderAction).toString()");
            return string2;
        }

        public static void appendOperatorTag(@NotNull FirDeclarationPresenter this_, @NotNull StringBuilder receiver, @NotNull FirSimpleFunction it) {
            Intrinsics.checkNotNullParameter(this_, "this");
            Intrinsics.checkNotNullParameter(receiver, "receiver");
            Intrinsics.checkNotNullParameter(it, "it");
            FirMemberDeclaration $this$isOperator$iv = it;
            boolean $i$f$isOperator = false;
            if ($this$isOperator$iv.getStatus().isOperator()) {
                receiver.append("operator ");
            }
        }

        @NotNull
        public static String represent(@NotNull FirDeclarationPresenter this_, @NotNull FirSimpleFunction it) {
            FirAnnotatedDeclaration it2;
            StringBuilder stringBuilder2;
            Intrinsics.checkNotNullParameter(this_, "this");
            Intrinsics.checkNotNullParameter(it, "it");
            StringBuilder $this$represent_u24lambda_u2d9 = stringBuilder2 = new StringBuilder();
            boolean bl = false;
            $this$represent_u24lambda_u2d9.append('<');
            Object $this$forEach$iv = it.getTypeParameters();
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                it2 = (FirTypeParameter)element$iv;
                boolean bl2 = false;
                this_.appendRepresentation($this$represent_u24lambda_u2d9, (FirTypeParameter)it2);
                $this$represent_u24lambda_u2d9.append(',');
            }
            $this$represent_u24lambda_u2d9.append('>');
            $this$represent_u24lambda_u2d9.append('[');
            $this$forEach$iv = it.getReceiverTypeRef();
            if ($this$forEach$iv != null) {
                Object it3 = $i$f$forEach = $this$forEach$iv;
                boolean bl3 = false;
                this_.appendRepresentation($this$represent_u24lambda_u2d9, (FirTypeRef)it3);
            }
            $this$represent_u24lambda_u2d9.append(']');
            this_.appendOperatorTag($this$represent_u24lambda_u2d9, it);
            this_.appendRepresentation($this$represent_u24lambda_u2d9, it.getSymbol().getCallableId());
            $this$represent_u24lambda_u2d9.append('(');
            $this$forEach$iv = it.getValueParameters();
            $i$f$forEach = false;
            iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                it2 = (FirValueParameter)element$iv;
                boolean bl4 = false;
                this_.appendRepresentation($this$represent_u24lambda_u2d9, (FirValueParameter)it2);
                $this$represent_u24lambda_u2d9.append(',');
            }
            $this$represent_u24lambda_u2d9.append(')');
            String string2 = stringBuilder2.toString();
            Intrinsics.checkNotNullExpressionValue(string2, "StringBuilder().apply(builderAction).toString()");
            return string2;
        }

        @NotNull
        public static String represent(@NotNull FirDeclarationPresenter this_, @NotNull FirTypeAlias it) {
            StringBuilder stringBuilder2;
            Intrinsics.checkNotNullParameter(this_, "this");
            Intrinsics.checkNotNullParameter(it, "it");
            StringBuilder $this$represent_u24lambda_u2d10 = stringBuilder2 = new StringBuilder();
            boolean bl = false;
            $this$represent_u24lambda_u2d10.append('[');
            $this$represent_u24lambda_u2d10.append(']');
            this_.appendRepresentation($this$represent_u24lambda_u2d10, it.getSymbol().getClassId());
            String string2 = stringBuilder2.toString();
            Intrinsics.checkNotNullExpressionValue(string2, "StringBuilder().apply(builderAction).toString()");
            return string2;
        }

        @NotNull
        public static String represent(@NotNull FirDeclarationPresenter this_, @NotNull FirRegularClass it) {
            StringBuilder stringBuilder2;
            Intrinsics.checkNotNullParameter(this_, "this");
            Intrinsics.checkNotNullParameter(it, "it");
            StringBuilder $this$represent_u24lambda_u2d11 = stringBuilder2 = new StringBuilder();
            boolean bl = false;
            $this$represent_u24lambda_u2d11.append('[');
            $this$represent_u24lambda_u2d11.append(']');
            this_.appendRepresentation($this$represent_u24lambda_u2d11, it.getSymbol().getClassId());
            String string2 = stringBuilder2.toString();
            Intrinsics.checkNotNullExpressionValue(string2, "StringBuilder().apply(builderAction).toString()");
            return string2;
        }

        @NotNull
        public static String represent(@NotNull FirDeclarationPresenter this_, @NotNull FirConstructor it, @NotNull FirRegularClass owner) {
            FirElement it2;
            StringBuilder stringBuilder2;
            Intrinsics.checkNotNullParameter(this_, "this");
            Intrinsics.checkNotNullParameter(it, "it");
            Intrinsics.checkNotNullParameter(owner, "owner");
            StringBuilder $this$represent_u24lambda_u2d14 = stringBuilder2 = new StringBuilder();
            boolean bl = false;
            $this$represent_u24lambda_u2d14.append('<');
            Iterable $this$forEach$iv = it.getTypeParameters();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it2 = (FirTypeParameterRef)element$iv;
                boolean bl2 = false;
                this_.appendRepresentation($this$represent_u24lambda_u2d14, it2);
                $this$represent_u24lambda_u2d14.append(',');
            }
            $this$represent_u24lambda_u2d14.append('>');
            $this$represent_u24lambda_u2d14.append('[');
            $this$represent_u24lambda_u2d14.append(']');
            this_.appendRepresentation($this$represent_u24lambda_u2d14, owner.getSymbol().getClassId());
            $this$represent_u24lambda_u2d14.append('(');
            $this$forEach$iv = it.getValueParameters();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it2 = (FirValueParameter)element$iv;
                boolean bl3 = false;
                this_.appendRepresentation($this$represent_u24lambda_u2d14, (FirValueParameter)it2);
                $this$represent_u24lambda_u2d14.append(',');
            }
            $this$represent_u24lambda_u2d14.append(')');
            String string2 = stringBuilder2.toString();
            Intrinsics.checkNotNullExpressionValue(string2, "StringBuilder().apply(builderAction).toString()");
            return string2;
        }
    }
}

