/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.Check;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.Checks;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.symbols.impl.ConeClassLikeLookupTagImpl;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.impl.ConeClassLikeTypeImpl;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0018\u0019B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0018\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0012J\"\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0017R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0005R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0005R\u0011\u0010\n\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0005R\u0011\u0010\f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0005\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/Checks;", "", "()V", "isKProperty", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/Check;", "()Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/Check;", "kPropertyType", "Lorg/jetbrains/kotlin/fir/types/impl/ConeClassLikeTypeImpl;", "member", "getMember", "memberOrExtension", "getMemberOrExtension", "noDefaultAndVarargs", "getNoDefaultAndVarargs", "full", "message", "", "predicate", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "", "simple", "Lkotlin/Function1;", "Returns", "ValueParametersCount", "checkers"})
public final class Checks {
    @NotNull
    public static final Checks INSTANCE = new Checks();
    @NotNull
    private static final Check memberOrExtension = INSTANCE.simple("must be a member or an extension function", memberOrExtension.1.INSTANCE);
    @NotNull
    private static final Check member = INSTANCE.simple("must be a member function", member.1.INSTANCE);
    @NotNull
    private static final Check noDefaultAndVarargs = INSTANCE.simple("should not have varargs or parameters with default values", noDefaultAndVarargs.1.INSTANCE);
    @NotNull
    private static final ConeClassLikeTypeImpl kPropertyType;
    @NotNull
    private static final Check isKProperty;

    private Checks() {
    }

    @NotNull
    public final Check simple(@NotNull String message2, @NotNull Function1<? super FirSimpleFunction, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(message2, "message");
        Intrinsics.checkNotNullParameter(predicate, "predicate");
        return new Check(message2, predicate){
            final /* synthetic */ String $message;
            final /* synthetic */ Function1<FirSimpleFunction, Boolean> $predicate;
            {
                this.$message = $message;
                this.$predicate = $predicate;
            }

            @Nullable
            public String check(@NotNull CheckerContext context2, @NotNull FirSimpleFunction function2) {
                Intrinsics.checkNotNullParameter(context2, "context");
                Intrinsics.checkNotNullParameter(function2, "function");
                String string2 = this.$message;
                Function1<FirSimpleFunction, Boolean> function1 = this.$predicate;
                String it = string2;
                boolean bl = false;
                return function1.invoke(function2) == false ? string2 : null;
            }

            @Nullable
            public String apply(@NotNull CheckerContext t1, @NotNull FirSimpleFunction t2) {
                return Check.DefaultImpls.apply(this, t1, t2);
            }
        };
    }

    @NotNull
    public final Check full(@NotNull String message2, @NotNull Function2<? super CheckerContext, ? super FirSimpleFunction, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(message2, "message");
        Intrinsics.checkNotNullParameter(predicate, "predicate");
        return new Check(message2, predicate){
            final /* synthetic */ String $message;
            final /* synthetic */ Function2<CheckerContext, FirSimpleFunction, Boolean> $predicate;
            {
                this.$message = $message;
                this.$predicate = $predicate;
            }

            @Nullable
            public String check(@NotNull CheckerContext context2, @NotNull FirSimpleFunction function2) {
                Intrinsics.checkNotNullParameter(context2, "context");
                Intrinsics.checkNotNullParameter(function2, "function");
                String string2 = this.$message;
                Function2<CheckerContext, FirSimpleFunction, Boolean> function22 = this.$predicate;
                String it = string2;
                boolean bl = false;
                return function22.invoke(context2, function2) == false ? string2 : null;
            }

            @Nullable
            public String apply(@NotNull CheckerContext t1, @NotNull FirSimpleFunction t2) {
                return Check.DefaultImpls.apply(this, t1, t2);
            }
        };
    }

    @NotNull
    public final Check getMemberOrExtension() {
        return memberOrExtension;
    }

    @NotNull
    public final Check getMember() {
        return member;
    }

    @NotNull
    public final Check getNoDefaultAndVarargs() {
        return noDefaultAndVarargs;
    }

    @NotNull
    public final Check isKProperty() {
        return isKProperty;
    }

    public static final /* synthetic */ ConeClassLikeTypeImpl access$getKPropertyType$p() {
        return kPropertyType;
    }

    static {
        ConeStarProjection[] coneStarProjectionArray = new ConeStarProjection[]{ConeStarProjection.INSTANCE};
        kPropertyType = new ConeClassLikeTypeImpl(new ConeClassLikeLookupTagImpl(StandardNames.FqNames.kProperty), coneStarProjectionArray, false, null, 8, null);
        isKProperty = INSTANCE.full("second parameter must be of type KProperty<*> or its supertype", isKProperty.1.INSTANCE);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/Checks$ValueParametersCount;", "", "()V", "none", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/Check;", "getNone", "()Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/Check;", "single", "getSingle", "atLeast", "n", "", "exactly", "checkers"})
    public static final class ValueParametersCount {
        @NotNull
        public static final ValueParametersCount INSTANCE = new ValueParametersCount();
        @NotNull
        private static final Check single = INSTANCE.simple("must have a single value parameter", single.1.INSTANCE);
        @NotNull
        private static final Check none = INSTANCE.simple("must have no value parameters", none.1.INSTANCE);

        private ValueParametersCount() {
        }

        @NotNull
        public final Check atLeast(int n) {
            return INSTANCE.simple("must have at least " + n + " value parameter" + (n > 1 ? "s" : ""), (Function1<? super FirSimpleFunction, Boolean>)new Function1<FirSimpleFunction, Boolean>(n){
                final /* synthetic */ int $n;
                {
                    this.$n = $n;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull FirSimpleFunction it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return it.getValueParameters().size() >= this.$n;
                }
            });
        }

        @NotNull
        public final Check exactly(int n) {
            return INSTANCE.simple("must have exactly " + n + " value parameters", (Function1<? super FirSimpleFunction, Boolean>)new Function1<FirSimpleFunction, Boolean>(n){
                final /* synthetic */ int $n;
                {
                    this.$n = $n;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull FirSimpleFunction it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return it.getValueParameters().size() == this.$n;
                }
            });
        }

        @NotNull
        public final Check getSingle() {
            return single;
        }

        @NotNull
        public final Check getNone() {
            return none;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/Checks$Returns;", "", "()V", "boolean", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/Check;", "getBoolean", "()Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/Check;", "int", "getInt", "unit", "getUnit", "checkers"})
    public static final class Returns {
        @NotNull
        public static final Returns INSTANCE = new Returns();
        @NotNull
        private static final Check boolean = INSTANCE.simple("must return Boolean", boolean.1.INSTANCE);
        @NotNull
        private static final Check int = INSTANCE.simple("must return Int", int.1.INSTANCE);
        @NotNull
        private static final Check unit = INSTANCE.simple("must return Unit", unit.1.INSTANCE);

        private Returns() {
        }

        @NotNull
        public final Check getBoolean() {
            return boolean;
        }

        @NotNull
        public final Check getInt() {
            return int;
        }

        @NotNull
        public final Check getUnit() {
            return unit;
        }
    }
}

