/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.deserialization;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.builder.FirConstExpressionBuilderKt;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.Flags;
import org.jetbrains.kotlin.metadata.deserialization.NameResolver;
import org.jetbrains.kotlin.metadata.deserialization.ProtoBufUtilKt;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.serialization.deserialization.builtins.BuiltInSerializerProtocol;
import org.jetbrains.kotlin.types.ConstantValueKind;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J.\u0010\r\u001a\u0004\u0018\u00010\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J \u0010\u0015\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014J\u0014\u0010\u0019\u001a\u00020\t*\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/fir/deserialization/FirConstDeserializer;", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "binaryClass", "Lorg/jetbrains/kotlin/load/kotlin/KotlinJvmBinaryClass;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/load/kotlin/KotlinJvmBinaryClass;)V", "constantCache", "", "Lorg/jetbrains/kotlin/name/CallableId;", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "buildFirConstant", "protoValue", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Annotation$Argument$Value;", "sourceValue", "constKind", "", "nameResolver", "Lorg/jetbrains/kotlin/metadata/deserialization/NameResolver;", "loadConstant", "propertyProto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Property;", "callableId", "replaceName", "newName", "Lorg/jetbrains/kotlin/name/Name;", "fir-deserialization"})
public final class FirConstDeserializer {
    @NotNull
    private final FirSession session;
    @Nullable
    private final KotlinJvmBinaryClass binaryClass;
    @NotNull
    private final Map<CallableId, FirExpression> constantCache;

    public FirConstDeserializer(@NotNull FirSession session2, @Nullable KotlinJvmBinaryClass binaryClass) {
        Intrinsics.checkNotNullParameter(session2, "session");
        this.session = session2;
        this.binaryClass = binaryClass;
        this.constantCache = new LinkedHashMap();
    }

    public /* synthetic */ FirConstDeserializer(FirSession firSession, KotlinJvmBinaryClass kotlinJvmBinaryClass2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            kotlinJvmBinaryClass2 = null;
        }
        this(firSession, kotlinJvmBinaryClass2);
    }

    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    @Nullable
    public final FirExpression loadConstant(@NotNull ProtoBuf.Property propertyProto, @NotNull CallableId callableId, @NotNull NameResolver nameResolver2) {
        Intrinsics.checkNotNullParameter(propertyProto, "propertyProto");
        Intrinsics.checkNotNullParameter(callableId, "callableId");
        Intrinsics.checkNotNullParameter(nameResolver2, "nameResolver");
        if (!Flags.HAS_CONSTANT.get(propertyProto.getFlags()).booleanValue()) {
            return null;
        }
        FirExpression firExpression2 = this.constantCache.get(callableId);
        if (firExpression2 != null) {
            FirExpression firExpression3;
            FirExpression it = firExpression3 = firExpression2;
            boolean bl = false;
            return it;
        }
        if (this.binaryClass == null) {
            Object object;
            Object object2 = ProtoBufUtilKt.getExtensionOrNull(propertyProto, BuiltInSerializerProtocol.INSTANCE.getCompileTimeValue());
            if (object2 == null) {
                return null;
            }
            Object value2 = object2;
            if ((object2 = this.buildFirConstant((ProtoBuf.Annotation.Argument.Value)value2, null, ((ProtoBuf.Annotation.Argument.Value)value2).getType().name(), nameResolver2)) == null) {
                object = null;
            } else {
                Object object3;
                Object $this$loadConstant_u24lambda_u2d1 = object3 = object2;
                boolean bl = false;
                Map<CallableId, FirExpression> map = this.constantCache;
                map.put(callableId, (FirExpression)$this$loadConstant_u24lambda_u2d1);
                object = object3;
            }
            return object;
        }
        this.binaryClass.visitMembers(new KotlinJvmBinaryClass.MemberVisitor(this, nameResolver2, callableId){
            final /* synthetic */ FirConstDeserializer this$0;
            final /* synthetic */ NameResolver $nameResolver;
            final /* synthetic */ CallableId $callableId;
            {
                this.this$0 = $receiver;
                this.$nameResolver = $nameResolver;
                this.$callableId = $callableId;
            }

            @Nullable
            public KotlinJvmBinaryClass.MethodAnnotationVisitor visitMethod(@NotNull Name name, @NotNull String desc) {
                Intrinsics.checkNotNullParameter(name, "name");
                Intrinsics.checkNotNullParameter(desc, "desc");
                return null;
            }

            @Nullable
            public KotlinJvmBinaryClass.AnnotationVisitor visitField(@NotNull Name name, @NotNull String desc, @Nullable Object initializer2) {
                FirExpression constant;
                FirExpression firExpression2;
                Intrinsics.checkNotNullParameter(name, "name");
                Intrinsics.checkNotNullParameter(desc, "desc");
                if (initializer2 != null && (firExpression2 = (constant = FirConstDeserializer.access$buildFirConstant(this.this$0, null, initializer2, desc, this.$nameResolver))) != null) {
                    FirExpression firExpression3 = firExpression2;
                    FirConstDeserializer firConstDeserializer = this.this$0;
                    CallableId callableId = this.$callableId;
                    FirExpression it = firExpression3;
                    boolean bl = false;
                    Map map = FirConstDeserializer.access$getConstantCache$p(firConstDeserializer);
                    CallableId callableId2 = FirConstDeserializer.access$replaceName(firConstDeserializer, callableId, name);
                    map.put(callableId2, it);
                }
                return null;
            }
        }, null);
        return this.constantCache.get(callableId);
    }

    /*
     * WARNING - void declaration
     */
    private final FirExpression buildFirConstant(ProtoBuf.Annotation.Argument.Value protoValue, Object sourceValue, String constKind, NameResolver nameResolver2) {
        FirExpression firExpression2;
        switch (constKind) {
            case "B": 
            case "BYTE": {
                Object object;
                ProtoBuf.Annotation.Argument.Value value2 = protoValue;
                Object object2 = object = value2 == null ? sourceValue : Long.valueOf(value2.getIntValue());
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
                }
                firExpression2 = FirConstExpressionBuilderKt.buildConstExpression$default(null, ConstantValueKind.Byte.INSTANCE, ((Number)object).byteValue(), null, false, 24, null);
                break;
            }
            case "C": 
            case "CHAR": {
                Object object;
                ProtoBuf.Annotation.Argument.Value value3 = protoValue;
                Object object3 = object = value3 == null ? sourceValue : Long.valueOf(value3.getIntValue());
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
                }
                firExpression2 = FirConstExpressionBuilderKt.buildConstExpression$default(null, ConstantValueKind.Char.INSTANCE, Character.valueOf((char)((Number)object).intValue()), null, false, 24, null);
                break;
            }
            case "SHORT": 
            case "S": {
                Object object;
                ProtoBuf.Annotation.Argument.Value value4 = protoValue;
                Object object4 = object = value4 == null ? sourceValue : Long.valueOf(value4.getIntValue());
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
                }
                firExpression2 = FirConstExpressionBuilderKt.buildConstExpression$default(null, ConstantValueKind.Short.INSTANCE, ((Number)object).shortValue(), null, false, 24, null);
                break;
            }
            case "I": 
            case "INT": {
                int n;
                ConstantValueKind constantValueKind = ConstantValueKind.Int.INSTANCE;
                ProtoBuf.Annotation.Argument.Value value5 = protoValue;
                if (value5 == null) {
                    if (sourceValue == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                    }
                    n = (Integer)sourceValue;
                } else {
                    long l = value5.getIntValue();
                    n = (int)l;
                }
                firExpression2 = FirConstExpressionBuilderKt.buildConstExpression$default(null, constantValueKind, n, null, false, 24, null);
                break;
            }
            case "J": 
            case "LONG": {
                long l;
                ConstantValueKind constantValueKind = ConstantValueKind.Long.INSTANCE;
                ProtoBuf.Annotation.Argument.Value value6 = protoValue;
                if (value6 == null) {
                    if (sourceValue == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                    }
                    l = (Long)sourceValue;
                } else {
                    l = value6.getIntValue();
                }
                firExpression2 = FirConstExpressionBuilderKt.buildConstExpression$default(null, constantValueKind, l, null, false, 24, null);
                break;
            }
            case "FLOAT": 
            case "F": {
                float f;
                ConstantValueKind constantValueKind = ConstantValueKind.Float.INSTANCE;
                ProtoBuf.Annotation.Argument.Value value7 = protoValue;
                if (value7 == null) {
                    if (sourceValue == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                    }
                    f = ((Float)sourceValue).floatValue();
                } else {
                    f = value7.getFloatValue();
                }
                firExpression2 = FirConstExpressionBuilderKt.buildConstExpression$default(null, constantValueKind, Float.valueOf(f), null, false, 24, null);
                break;
            }
            case "D": 
            case "DOUBLE": {
                double d;
                ConstantValueKind constantValueKind = ConstantValueKind.Double.INSTANCE;
                ProtoBuf.Annotation.Argument.Value value8 = protoValue;
                if (value8 == null) {
                    if (sourceValue == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                    }
                    d = (Double)sourceValue;
                } else {
                    d = value8.getDoubleValue();
                }
                firExpression2 = FirConstExpressionBuilderKt.buildConstExpression$default(null, constantValueKind, d, null, false, 24, null);
                break;
            }
            case "BOOLEAN": 
            case "Z": {
                Object object;
                ConstantValueKind constantValueKind = ConstantValueKind.Boolean.INSTANCE;
                ProtoBuf.Annotation.Argument.Value value9 = protoValue;
                if (value9 == null) {
                    object = sourceValue;
                } else {
                    long l = value9.getIntValue();
                    object = (int)l;
                }
                firExpression2 = FirConstExpressionBuilderKt.buildConstExpression$default(null, constantValueKind, !Intrinsics.areEqual(object, (Object)0), null, false, 24, null);
                break;
            }
            case "Ljava/lang/String;": 
            case "STRING": {
                String string2;
                FirSourceElement firSourceElement = null;
                ConstantValueKind constantValueKind = ConstantValueKind.String.INSTANCE;
                ProtoBuf.Annotation.Argument.Value value10 = protoValue;
                if (value10 == null) {
                    if (sourceValue == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    string2 = (String)sourceValue;
                } else {
                    void it;
                    int n;
                    int n2;
                    int n3 = n2 = (n = value10.getStringValue());
                    ConstantValueKind constantValueKind2 = constantValueKind;
                    FirSourceElement firSourceElement2 = firSourceElement;
                    boolean bl = false;
                    String string3 = nameResolver2.getString((int)it);
                    firSourceElement = firSourceElement2;
                    constantValueKind = constantValueKind2;
                    string2 = string3;
                }
                firExpression2 = FirConstExpressionBuilderKt.buildConstExpression$default(firSourceElement, constantValueKind, string2, null, false, 24, null);
                break;
            }
            default: {
                firExpression2 = null;
            }
        }
        return firExpression2;
    }

    private final CallableId replaceName(CallableId $this$replaceName, Name newName2) {
        return new CallableId($this$replaceName.getPackageName(), $this$replaceName.getClassName(), newName2, null, 8, null);
    }

    public static final /* synthetic */ FirExpression access$buildFirConstant(FirConstDeserializer $this, ProtoBuf.Annotation.Argument.Value protoValue, Object sourceValue, String constKind, NameResolver nameResolver2) {
        return $this.buildFirConstant(protoValue, sourceValue, constKind, nameResolver2);
    }

    public static final /* synthetic */ Map access$getConstantCache$p(FirConstDeserializer $this) {
        return $this.constantCache;
    }

    public static final /* synthetic */ CallableId access$replaceName(FirConstDeserializer $this, CallableId $receiver, Name newName2) {
        return $this.replaceName($receiver, newName2);
    }
}

