/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.transformers.irToJs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsAstUtils;
import org.jetbrains.kotlin.ir.backend.js.utils.StableNamesCollectorKt;
import org.jetbrains.kotlin.js.backend.ast.JsArrayAccess;
import org.jetbrains.kotlin.js.backend.ast.JsArrayLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsConditional;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsImportedModule;
import org.jetbrains.kotlin.js.backend.ast.JsImportedModuleKt;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNew;
import org.jetbrains.kotlin.js.backend.ast.JsObjectLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsObjectScope;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsProgram;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsThisRef;
import org.jetbrains.kotlin.js.backend.ast.JsThrow;
import org.jetbrains.kotlin.js.backend.ast.SourceInfoAwareJsNode;
import org.jetbrains.kotlin.js.backend.ast.metadata.HasMetadata;
import org.jetbrains.kotlin.js.naming.NameSuggestionKt;
import org.jetbrains.kotlin.serialization.js.ModuleKind;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001aB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J.\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002J:\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u00112\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015J,\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0002J,\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0002J4\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u00112\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0002J4\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00040\u00112\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/ModuleWrapperTranslation;", "", "()V", "addModuleValidation", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "currentModuleId", "", "program", "Lorg/jetbrains/kotlin/js/backend/ast/JsProgram;", "module", "Lorg/jetbrains/kotlin/js/backend/ast/JsImportedModule;", "makePlainInvocation", "Lorg/jetbrains/kotlin/js/backend/ast/JsInvocation;", "moduleId", "function", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "importedModules", "", "makePlainModuleRef", "wrap", "kind", "Lorg/jetbrains/kotlin/serialization/js/ModuleKind;", "wrapAmd", "wrapCommonJs", "wrapPlain", "wrapUmd", "Namer", "backend.js"})
public final class ModuleWrapperTranslation {
    @NotNull
    public static final ModuleWrapperTranslation INSTANCE = new ModuleWrapperTranslation();

    private ModuleWrapperTranslation() {
    }

    @NotNull
    public final List<JsStatement> wrap(@NotNull String moduleId, @NotNull JsExpression function2, @NotNull List<JsImportedModule> importedModules, @NotNull JsProgram program, @NotNull ModuleKind kind) {
        List<JsStatement> list2;
        Intrinsics.checkNotNullParameter(moduleId, "moduleId");
        Intrinsics.checkNotNullParameter(function2, "function");
        Intrinsics.checkNotNullParameter(importedModules, "importedModules");
        Intrinsics.checkNotNullParameter(program, "program");
        Intrinsics.checkNotNullParameter((Object)kind, "kind");
        ModuleKind moduleKind = kind;
        int n = WhenMappings.$EnumSwitchMapping$0[moduleKind.ordinal()];
        switch (n) {
            case 1: {
                list2 = this.wrapAmd(function2, importedModules, program);
                break;
            }
            case 2: {
                list2 = this.wrapCommonJs(function2, importedModules, program);
                break;
            }
            case 3: {
                list2 = this.wrapUmd(moduleId, function2, importedModules, program);
                break;
            }
            case 4: {
                list2 = this.wrapPlain(moduleId, function2, importedModules, program);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return list2;
    }

    private final List<JsStatement> wrapUmd(String moduleId, JsExpression function2, List<JsImportedModule> importedModules, JsProgram program) {
        JsExpression[] jsExpressionArray;
        JsObjectScope scope2 = program.getScope();
        JsName jsName = scope2.declareName("define");
        Intrinsics.checkNotNullExpressionValue(jsName, "scope.declareName(\"define\")");
        JsName defineName = jsName;
        JsName jsName2 = scope2.declareName("exports");
        Intrinsics.checkNotNullExpressionValue(jsName2, "scope.declareName(\"exports\")");
        JsName exportsName = jsName2;
        JsBlock adapterBody = new JsBlock();
        JsFunction adapter = new JsFunction((JsScope)program.getScope(), adapterBody, "Adapter");
        JsName jsName3 = adapter.getScope().declareName("root");
        Intrinsics.checkNotNullExpressionValue(jsName3, "adapter.scope.declareName(\"root\")");
        JsName rootName = jsName3;
        HasMetadata hasMetadata = adapter.getScope().declareName("factory");
        Intrinsics.checkNotNullExpressionValue(hasMetadata, "adapter.scope.declareName(\"factory\")");
        JsName factoryName = hasMetadata;
        hasMetadata = adapter;
        Object object = ((JsFunction)hasMetadata).getParameters();
        Intrinsics.checkNotNullExpressionValue(object, "adapter.parameters");
        object = (Collection)object;
        SourceInfoAwareJsNode sourceInfoAwareJsNode = new JsParameter(rootName);
        object.add((JsParameter)sourceInfoAwareJsNode);
        hasMetadata = adapter;
        object = ((JsFunction)hasMetadata).getParameters();
        Intrinsics.checkNotNullExpressionValue(object, "adapter.parameters");
        sourceInfoAwareJsNode = new JsParameter(factoryName);
        object.add((JsParameter)sourceInfoAwareJsNode);
        object = defineName.makeRef();
        Intrinsics.checkNotNullExpressionValue(object, "defineName.makeRef()");
        JsBinaryOperation amdTest = JsAstUtils.INSTANCE.and(JsAstUtils.INSTANCE.typeOfIs((JsExpression)object, new JsStringLiteral("function")), new JsNameRef("amd", (JsExpression)defineName.makeRef()));
        sourceInfoAwareJsNode = exportsName.makeRef();
        Intrinsics.checkNotNullExpressionValue(sourceInfoAwareJsNode, "exportsName.makeRef()");
        JsBinaryOperation commonJsTest = JsAstUtils.INSTANCE.typeOfIs((JsExpression)sourceInfoAwareJsNode, new JsStringLiteral("object"));
        JsNameRef jsNameRef = factoryName.makeRef();
        Intrinsics.checkNotNullExpressionValue(jsNameRef, "factoryName.makeRef()");
        JsBlock amdBody = new JsBlock(this.wrapAmd(jsNameRef, importedModules, program));
        JsNameRef jsNameRef2 = factoryName.makeRef();
        Intrinsics.checkNotNullExpressionValue(jsNameRef2, "factoryName.makeRef()");
        JsBlock commonJsBody = new JsBlock(this.wrapCommonJs(jsNameRef2, importedModules, program));
        JsNameRef jsNameRef3 = factoryName.makeRef();
        Intrinsics.checkNotNullExpressionValue(jsNameRef3, "factoryName.makeRef()");
        JsInvocation plainInvocation = this.makePlainInvocation(moduleId, jsNameRef3, importedModules, program);
        JsExpression lhs = Namer.INSTANCE.requiresEscaping(moduleId) ? (JsExpression)new JsArrayAccess(rootName.makeRef(), new JsStringLiteral(moduleId)) : (JsExpression)new JsNameRef(scope2.declareName(moduleId), (JsExpression)rootName.makeRef());
        JsBlock plainBlock = new JsBlock();
        for (JsImportedModule importedModule : importedModules) {
            jsExpressionArray = plainBlock;
            Collection<JsStatement> collection = jsExpressionArray.getStatements();
            Intrinsics.checkNotNullExpressionValue(collection, "plainBlock.statements");
            collection = collection;
            JsStatement jsStatement = this.addModuleValidation(moduleId, program, importedModule);
            collection.add(jsStatement);
        }
        JsBlock jsBlock = plainBlock;
        Object object2 = jsBlock.getStatements();
        Intrinsics.checkNotNullExpressionValue(object2, "plainBlock.statements");
        object2 = (Collection)object2;
        jsExpressionArray = JsAstUtils.INSTANCE.assignment(lhs, plainInvocation).makeStmt();
        object2.add((JsStatement)jsExpressionArray);
        JsIf selector = JsAstUtils.INSTANCE.newJsIf(amdTest, amdBody, JsAstUtils.INSTANCE.newJsIf(commonJsTest, commonJsBody, plainBlock));
        object2 = adapterBody;
        jsExpressionArray = ((JsBlock)object2).getStatements();
        Intrinsics.checkNotNullExpressionValue(jsExpressionArray, "adapterBody.statements");
        jsExpressionArray = (Collection)jsExpressionArray;
        jsExpressionArray.add(selector);
        jsExpressionArray = new JsExpression[]{new JsThisRef(), function2};
        object2 = new JsInvocation((JsExpression)adapter, jsExpressionArray).makeStmt();
        Intrinsics.checkNotNullExpressionValue(object2, "JsInvocation(adapter, Js\u2026f(), function).makeStmt()");
        return CollectionsKt.listOf(object2);
    }

    /*
     * WARNING - void declaration
     */
    private final List<JsStatement> wrapAmd(JsExpression function2, List<JsImportedModule> importedModules, JsProgram program) {
        Collection<JsStringLiteral> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        JsObjectScope scope2 = program.getScope();
        JsName jsName = scope2.declareName("define");
        Intrinsics.checkNotNullExpressionValue(jsName, "scope.declareName(\"define\")");
        JsName defineName = jsName;
        JsExpression[] jsExpressionArray = new JsExpression[2];
        Object object = importedModules;
        Collection collection2 = CollectionsKt.listOf(new JsStringLiteral("exports"));
        int n = 0;
        JsExpression[] jsExpressionArray2 = jsExpressionArray;
        boolean $i$f$map = false;
        void var10_13 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JsImportedModule jsImportedModule = (JsImportedModule)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            JsStringLiteral jsStringLiteral = new JsStringLiteral(JsImportedModuleKt.getRequireName((JsImportedModule)it));
            collection.add(jsStringLiteral);
        }
        collection = (List)destination$iv$iv;
        List<JsExpression> list2 = CollectionsKt.plus(collection2, (Iterable)collection);
        jsExpressionArray2[n] = new JsArrayLiteral(list2);
        jsExpressionArray[1] = function2;
        List<JsExpression> invocationArgs = CollectionsKt.listOf(jsExpressionArray);
        JsInvocation invocation = new JsInvocation((JsExpression)defineName.makeRef(), invocationArgs);
        object = invocation.makeStmt();
        Intrinsics.checkNotNullExpressionValue(object, "invocation.makeStmt()");
        return CollectionsKt.listOf(object);
    }

    /*
     * WARNING - void declaration
     */
    private final List<JsStatement> wrapCommonJs(JsExpression function2, List<JsImportedModule> importedModules, JsProgram program) {
        void $this$mapTo$iv$iv;
        JsObjectScope scope2 = program.getScope();
        JsName jsName = scope2.declareName("module");
        Intrinsics.checkNotNullExpressionValue(jsName, "scope.declareName(\"module\")");
        JsName moduleName = jsName;
        JsName jsName2 = scope2.declareName("require");
        Intrinsics.checkNotNullExpressionValue(jsName2, "scope.declareName(\"require\")");
        JsName requireName = jsName2;
        Iterable $this$map$iv = importedModules;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JsImportedModule jsImportedModule = (JsImportedModule)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            JsExpression[] jsExpressionArray = new JsExpression[]{new JsStringLiteral(JsImportedModuleKt.getRequireName((JsImportedModule)it))};
            JsInvocation jsInvocation = new JsInvocation((JsExpression)requireName.makeRef(), jsExpressionArray);
            collection.add(jsInvocation);
        }
        List invocationArgs = (List)destination$iv$iv;
        JsInvocation invocation = new JsInvocation(function2, CollectionsKt.plus((Collection)CollectionsKt.listOf(new JsNameRef("exports", (JsExpression)moduleName.makeRef())), (Iterable)invocationArgs));
        JsStatement jsStatement = invocation.makeStmt();
        Intrinsics.checkNotNullExpressionValue(jsStatement, "invocation.makeStmt()");
        return CollectionsKt.listOf(jsStatement);
    }

    private final List<JsStatement> wrapPlain(String moduleId, JsExpression function2, List<JsImportedModule> importedModules, JsProgram program) {
        JsStatement jsStatement;
        JsInvocation invocation = this.makePlainInvocation(moduleId, function2, importedModules, program);
        List statements2 = new ArrayList();
        for (JsImportedModule importedModule : importedModules) {
            ((Collection)statements2).add(this.addModuleValidation(moduleId, program, importedModule));
        }
        Collection collection = statements2;
        if (Namer.INSTANCE.requiresEscaping(moduleId)) {
            jsStatement = JsAstUtils.INSTANCE.assignment(this.makePlainModuleRef(moduleId, program), invocation).makeStmt();
        } else {
            JsName jsName = program.getRootScope().declareName(moduleId);
            Intrinsics.checkNotNullExpressionValue(jsName, "program.rootScope.declareName(moduleId)");
            jsStatement = JsAstUtils.INSTANCE.newVar(jsName, invocation);
        }
        collection.add(jsStatement);
        return statements2;
    }

    private final JsStatement addModuleValidation(String currentModuleId, JsProgram program, JsImportedModule module2) {
        JsExpression moduleRef = this.makePlainModuleRef(module2, program);
        JsBinaryOperation moduleExistsCond = JsAstUtils.INSTANCE.typeOfIs(moduleRef, new JsStringLiteral("undefined"));
        JsStringLiteral moduleNotFoundMessage = new JsStringLiteral("Error loading module '" + currentModuleId + "'. Its dependency '" + module2.getExternalName() + "' was not found. Please, check whether '" + module2.getExternalName() + "' is loaded prior to '" + currentModuleId + "'.");
        JsThrow moduleNotFoundThrow = new JsThrow(new JsNew(new JsNameRef("Error"), CollectionsKt.listOf(moduleNotFoundMessage)));
        return new JsIf(moduleExistsCond, new JsBlock((JsStatement)moduleNotFoundThrow));
    }

    /*
     * WARNING - void declaration
     */
    private final JsInvocation makePlainInvocation(String moduleId, JsExpression function2, List<JsImportedModule> importedModules, JsProgram program) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = importedModules;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JsImportedModule jsImportedModule = (JsImportedModule)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            JsExpression jsExpression = INSTANCE.makePlainModuleRef((JsImportedModule)it, program);
            collection.add(jsExpression);
        }
        List invocationArgs = (List)destination$iv$iv;
        JsExpression moduleRef = this.makePlainModuleRef(moduleId, program);
        JsBinaryOperation testModuleDefined = JsAstUtils.INSTANCE.typeOfIs(moduleRef, new JsStringLiteral("undefined"));
        JsConditional selfArg = new JsConditional(testModuleDefined, new JsObjectLiteral(false), moduleRef.deepCopy());
        return new JsInvocation(function2, CollectionsKt.plus((Collection)CollectionsKt.listOf(selfArg), (Iterable)invocationArgs));
    }

    private final JsExpression makePlainModuleRef(JsImportedModule module2, JsProgram program) {
        JsExpression jsExpression = module2.getPlainReference();
        return jsExpression == null ? this.makePlainModuleRef(module2.getExternalName(), program) : jsExpression;
    }

    private final JsExpression makePlainModuleRef(String moduleId, JsProgram program) {
        JsExpression jsExpression;
        if (Namer.INSTANCE.requiresEscaping(moduleId)) {
            jsExpression = new JsArrayAccess(new JsThisRef(), new JsStringLiteral(moduleId));
        } else {
            JsNameRef jsNameRef = program.getScope().declareName(moduleId).makeRef();
            Intrinsics.checkNotNullExpressionValue(jsNameRef, "{\n            program.sc\u2026leId).makeRef()\n        }");
            jsExpression = jsNameRef;
        }
        return jsExpression;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/ModuleWrapperTranslation$Namer;", "", "()V", "requiresEscaping", "", "name", "", "backend.js"})
    public static final class Namer {
        @NotNull
        public static final Namer INSTANCE = new Namer();

        private Namer() {
        }

        public final boolean requiresEscaping(@NotNull String name) {
            Intrinsics.checkNotNullParameter(name, "name");
            return !NameSuggestionKt.isValidES5Identifier(name) || StableNamesCollectorKt.getRESERVED_IDENTIFIERS().contains(name);
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ModuleKind.values().length];
            nArray[ModuleKind.AMD.ordinal()] = 1;
            nArray[ModuleKind.COMMON_JS.ordinal()] = 2;
            nArray[ModuleKind.UMD.ordinal()] = 3;
            nArray[ModuleKind.PLAIN.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

