/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.Comparing;
import com.intellij.util.ArrayUtilRt;
import gnu.trove.THashMap;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SmartFMap<K, V>
implements Map<K, V> {
    private static final SmartFMap<?, ?> EMPTY = new SmartFMap(ArrayUtilRt.EMPTY_OBJECT_ARRAY);
    private final Object myMap;

    private SmartFMap(Object map) {
        this.myMap = map;
    }

    @NotNull
    public static <K, V> SmartFMap<K, V> emptyMap() {
        SmartFMap<?, ?> smartFMap = EMPTY;
        if (smartFMap == null) {
            SmartFMap.$$$reportNull$$$0(0);
        }
        return smartFMap;
    }

    @NotNull
    public SmartFMap<K, V> plus(@NotNull K key, V value2) {
        if (key == null) {
            SmartFMap.$$$reportNull$$$0(1);
        }
        return new SmartFMap<K, V>(SmartFMap.doPlus(this.myMap, key, value2));
    }

    private static Object doPlus(Object oldMap2, Object key, Object value2) {
        if (oldMap2 instanceof Map) {
            THashMap newMap2 = new THashMap((Map)oldMap2);
            newMap2.put(key, value2);
            return newMap2;
        }
        Object[] array2 = (Object[])oldMap2;
        for (int i = 0; i < array2.length; i += 2) {
            if (!key.equals(array2[i])) continue;
            Object[] newArray = new Object[array2.length];
            System.arraycopy(array2, 0, newArray, 0, array2.length);
            newArray[i + 1] = value2;
            return newArray;
        }
        if (array2.length == 16) {
            THashMap map = new THashMap();
            for (int i = 0; i < array2.length; i += 2) {
                map.put(array2[i], array2[i + 1]);
            }
            map.put(key, value2);
            return map;
        }
        Object[] newArray = new Object[array2.length + 2];
        System.arraycopy(array2, 0, newArray, 0, array2.length);
        newArray[array2.length] = key;
        newArray[array2.length + 1] = value2;
        return newArray;
    }

    public SmartFMap<K, V> plusAll(Map<? extends K, ? extends V> m) {
        SmartFMap<K, V> result2 = this;
        for (Map.Entry<K, V> e : m.entrySet()) {
            result2 = result2.plus(e.getKey(), e.getValue());
        }
        return result2;
    }

    @Override
    public boolean equals(Object obj) {
        if (this.myMap instanceof Map) {
            return this.myMap.equals(obj);
        }
        if (!(obj instanceof Map)) {
            return false;
        }
        Map map = (Map)obj;
        if (this.size() != map.size()) {
            return false;
        }
        Object[] array2 = (Object[])this.myMap;
        for (int i = 0; i < array2.length; i += 2) {
            if (Comparing.equal(array2[i + 1], map.get(array2[i]))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return this.entrySet().hashCode();
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            return false;
        }
        if (this.myMap instanceof Map) {
            return this.asMap().containsKey(key);
        }
        Object[] array2 = (Object[])this.myMap;
        for (int i = 0; i < array2.length; i += 2) {
            if (!key.equals(array2[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value2) {
        return false;
    }

    @Override
    @Nullable
    public V get(Object key) {
        if (key == null) {
            return null;
        }
        if (this.myMap instanceof Map) {
            return this.asMap().get(key);
        }
        Object[] array2 = (Object[])this.myMap;
        for (int i = 0; i < array2.length; i += 2) {
            if (!key.equals(array2[i])) continue;
            return (V)array2[i + 1];
        }
        return null;
    }

    @Override
    @Deprecated
    public V put(K key, V value2) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void putAll(@NotNull Map<? extends K, ? extends V> m) {
        if (m == null) {
            SmartFMap.$$$reportNull$$$0(4);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        if (this.isEmpty()) {
            Set set = Collections.emptySet();
            if (set == null) {
                SmartFMap.$$$reportNull$$$0(5);
            }
            return set;
        }
        LinkedHashSet<K> result2 = new LinkedHashSet<K>();
        for (Map.Entry<K, V> entry : this.entrySet()) {
            result2.add(entry.getKey());
        }
        Set set = Collections.unmodifiableSet(result2);
        if (set == null) {
            SmartFMap.$$$reportNull$$$0(6);
        }
        return set;
    }

    @Override
    @NotNull
    public Collection<V> values() {
        if (this.isEmpty()) {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                SmartFMap.$$$reportNull$$$0(7);
            }
            return list2;
        }
        ArrayList<V> result2 = new ArrayList<V>();
        for (Map.Entry<K, V> entry : this.entrySet()) {
            result2.add(entry.getValue());
        }
        Collection collection = Collections.unmodifiableCollection(result2);
        if (collection == null) {
            SmartFMap.$$$reportNull$$$0(8);
        }
        return collection;
    }

    @Override
    @Deprecated
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        if (this.myMap instanceof Map) {
            return this.asMap().size();
        }
        return ((Object[])this.myMap).length >> 1;
    }

    private Map<K, V> asMap() {
        return (Map)this.myMap;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.isEmpty()) {
            Set<Map.Entry<K, V>> set = Collections.emptySet();
            if (set == null) {
                SmartFMap.$$$reportNull$$$0(9);
            }
            return set;
        }
        LinkedHashSet<AbstractMap.SimpleImmutableEntry<K, V>> set = new LinkedHashSet<AbstractMap.SimpleImmutableEntry<K, V>>();
        if (this.myMap instanceof Map) {
            for (Map.Entry<K, V> entry : this.asMap().entrySet()) {
                set.add(new AbstractMap.SimpleImmutableEntry<K, V>(entry));
            }
        } else {
            Object[] array2 = (Object[])this.myMap;
            for (int i = 0; i < array2.length; i += 2) {
                set.add(new AbstractMap.SimpleImmutableEntry<Object, Object>(array2[i], array2[i + 1]));
            }
        }
        Set<Map.Entry<K, V>> set2 = Collections.unmodifiableSet(set);
        if (set2 == null) {
            SmartFMap.$$$reportNull$$$0(10);
        }
        return set2;
    }

    @Override
    public void forEach(@NotNull BiConsumer<? super K, ? super V> action) {
        if (action == null) {
            SmartFMap.$$$reportNull$$$0(11);
        }
        if (this.myMap instanceof Map) {
            this.asMap().forEach(action);
        } else {
            Object[] array2 = (Object[])this.myMap;
            for (int i = 0; i < array2.length; i += 2) {
                action.accept(array2[i], array2[i + 1]);
            }
        }
    }

    public String toString() {
        Iterator<Map.Entry<K, V>> i = this.entrySet().iterator();
        if (!i.hasNext()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        while (true) {
            Map.Entry<K, V> e = i.next();
            K key = e.getKey();
            V value2 = e.getValue();
            sb.append((Object)(key == this ? "(this Map)" : key));
            sb.append('=');
            sb.append((Object)(value2 == this ? "(this Map)" : value2));
            if (!i.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(", ");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 11: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/SmartFMap";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "emptyMap";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/SmartFMap";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "keySet";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "values";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "entrySet";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "plus";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "minus";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "minusAll";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "putAll";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "forEach";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 11: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

