/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.TransformationMethodVisitor;
import org.jetbrains.kotlin.codegen.coroutines.UninitializedStoresProcessor;
import org.jetbrains.kotlin.codegen.inline.InplaceArgumentsMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.CapturedVarsOptimizationMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.ConstantConditionEliminationMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.DeadCodeEliminationMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.FixStackWithLabelNormalizationMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.MethodVerifier;
import org.jetbrains.kotlin.codegen.optimization.NegatedJumpsMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.RedundantCheckCastEliminationMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.RedundantGotoMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.RedundantNopsCleanupMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.boxing.PopBackwardPropagationTransformer;
import org.jetbrains.kotlin.codegen.optimization.boxing.RedundantBoxingMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.boxing.StackPeepholeOptimizationsTransformer;
import org.jetbrains.kotlin.codegen.optimization.common.UtilKt;
import org.jetbrains.kotlin.codegen.optimization.nullCheck.RedundantNullCheckMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.temporaryVals.TemporaryVariablesEliminationTransformer;
import org.jetbrains.kotlin.codegen.optimization.transformer.CompositeMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.transformer.MethodTransformer;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.TryCatchBlockNode;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\t\u0012\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/OptimizationMethodVisitor;", "Lorg/jetbrains/kotlin/codegen/TransformationMethodVisitor;", "delegate", "Lorg/jetbrains/org/objectweb/asm/MethodVisitor;", "generationState", "Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "access", "", "name", "", "desc", "signature", "exceptions", "", "(Lorg/jetbrains/org/objectweb/asm/MethodVisitor;Lorg/jetbrains/kotlin/codegen/state/GenerationState;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "normalizationMethodTransformer", "Lorg/jetbrains/kotlin/codegen/optimization/transformer/CompositeMethodTransformer;", "getNormalizationMethodTransformer", "()Lorg/jetbrains/kotlin/codegen/optimization/transformer/CompositeMethodTransformer;", "optimizationTransformer", "getOptimizationTransformer", "performTransformations", "", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "Companion", "backend"})
public final class OptimizationMethodVisitor
extends TransformationMethodVisitor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GenerationState generationState;
    @NotNull
    private final CompositeMethodTransformer normalizationMethodTransformer;
    @NotNull
    private final CompositeMethodTransformer optimizationTransformer;
    public static final int MEMORY_LIMIT_BY_METHOD_MB = 50;

    public OptimizationMethodVisitor(@NotNull MethodVisitor delegate2, @NotNull GenerationState generationState, int access, @NotNull String name, @NotNull String desc, @Nullable String signature2, @Nullable String[] exceptions) {
        Intrinsics.checkNotNullParameter(delegate2, "delegate");
        Intrinsics.checkNotNullParameter(generationState, "generationState");
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(desc, "desc");
        super(delegate2, access, name, desc, signature2, exceptions, 0, 64, null);
        this.generationState = generationState;
        MethodTransformer[] methodTransformerArray = new MethodTransformer[]{new InplaceArgumentsMethodTransformer(), new FixStackWithLabelNormalizationMethodTransformer(), new MethodVerifier("AFTER mandatory stack transformations", this.generationState)};
        this.normalizationMethodTransformer = new CompositeMethodTransformer(methodTransformerArray);
        methodTransformerArray = new MethodTransformer[]{new CapturedVarsOptimizationMethodTransformer(), new RedundantNullCheckMethodTransformer(this.generationState), new RedundantCheckCastEliminationMethodTransformer(), new ConstantConditionEliminationMethodTransformer(), new RedundantBoxingMethodTransformer(this.generationState), new TemporaryVariablesEliminationTransformer(this.generationState), new StackPeepholeOptimizationsTransformer(), new PopBackwardPropagationTransformer(), new DeadCodeEliminationMethodTransformer(), new RedundantGotoMethodTransformer(), new RedundantNopsCleanupMethodTransformer(), new NegatedJumpsMethodTransformer(), new MethodVerifier("AFTER optimizations", this.generationState)};
        this.optimizationTransformer = new CompositeMethodTransformer(methodTransformerArray);
    }

    @NotNull
    public final CompositeMethodTransformer getNormalizationMethodTransformer() {
        return this.normalizationMethodTransformer;
    }

    @NotNull
    public final CompositeMethodTransformer getOptimizationTransformer() {
        return this.optimizationTransformer;
    }

    @Override
    protected void performTransformations(@NotNull MethodNode methodNode) {
        Intrinsics.checkNotNullParameter(methodNode, "methodNode");
        this.normalizationMethodTransformer.transform("fake", methodNode);
        new UninitializedStoresProcessor(methodNode).run();
        if (Companion.canBeOptimized(methodNode) && !this.generationState.getDisableOptimization()) {
            this.optimizationTransformer.transform("fake", methodNode);
        }
        new DeadCodeEliminationMethodTransformer().transform("fake", methodNode);
        UtilKt.prepareForEmitting(methodNode);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/OptimizationMethodVisitor$Companion;", "", "()V", "MEMORY_LIMIT_BY_METHOD_MB", "", "TRY_CATCH_BLOCKS_SOFT_LIMIT", "canBeOptimized", "", "node", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "canBeOptimizedUsingSourceInterpreter", "getTotalFramesWeight", "", "size", "getTotalTcbSize", "backend"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean canBeOptimized(@NotNull MethodNode node) {
            Intrinsics.checkNotNullParameter(node, "node");
            if (node.tryCatchBlocks.size() > 16 && this.getTotalFramesWeight(this.getTotalTcbSize(node), node) > 50L) {
                return false;
            }
            return this.getTotalFramesWeight(node.instructions.size(), node) < 50L;
        }

        public final boolean canBeOptimizedUsingSourceInterpreter(@NotNull MethodNode node) {
            Intrinsics.checkNotNullParameter(node, "node");
            int methodSize = node.instructions.size();
            if (node.tryCatchBlocks.size() > 16 && this.getTotalFramesWeight(this.getTotalTcbSize(node) * methodSize, node) > 50L) {
                return false;
            }
            return this.getTotalFramesWeight(methodSize * methodSize, node) < 50L;
        }

        private final long getTotalFramesWeight(int size, MethodNode node) {
            return (long)size * (long)(node.maxLocals + node.maxStack) / (long)0x100000;
        }

        /*
         * WARNING - void declaration
         */
        private final int getTotalTcbSize(MethodNode node) {
            List<TryCatchBlockNode> list2 = node.tryCatchBlocks;
            Intrinsics.checkNotNullExpressionValue(list2, "node.tryCatchBlocks");
            Iterable iterable = list2;
            int n = 0;
            for (Object t : iterable) {
                void it;
                TryCatchBlockNode tryCatchBlockNode = (TryCatchBlockNode)t;
                int n2 = n;
                boolean bl = false;
                int n3 = node.instructions.indexOf(it.end) - node.instructions.indexOf(it.start);
                n = n2 + n3;
            }
            return n;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

