/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.serialization.constant;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirRendererKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirArgumentList;
import org.jetbrains.kotlin.fir.expressions.FirArrayOfCall;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirConstExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirGetClassCall;
import org.jetbrains.kotlin.fir.expressions.FirNamedArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirVarargArgumentsExpression;
import org.jetbrains.kotlin.fir.expressions.builder.FirAnnotationArgumentMappingBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirAnnotationCallBuilder;
import org.jetbrains.kotlin.fir.expressions.impl.FirResolvedArgumentList;
import org.jetbrains.kotlin.fir.references.builder.FirSimpleNamedReferenceBuilder;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.serialization.constant.AnnotationValue;
import org.jetbrains.kotlin.fir.serialization.constant.ArrayValue;
import org.jetbrains.kotlin.fir.serialization.constant.BooleanValue;
import org.jetbrains.kotlin.fir.serialization.constant.ByteValue;
import org.jetbrains.kotlin.fir.serialization.constant.CharValue;
import org.jetbrains.kotlin.fir.serialization.constant.ConstantValue;
import org.jetbrains.kotlin.fir.serialization.constant.DoubleValue;
import org.jetbrains.kotlin.fir.serialization.constant.EnumValue;
import org.jetbrains.kotlin.fir.serialization.constant.FloatValue;
import org.jetbrains.kotlin.fir.serialization.constant.IntValue;
import org.jetbrains.kotlin.fir.serialization.constant.KClassValue;
import org.jetbrains.kotlin.fir.serialization.constant.LongValue;
import org.jetbrains.kotlin.fir.serialization.constant.NullValue;
import org.jetbrains.kotlin.fir.serialization.constant.ShortValue;
import org.jetbrains.kotlin.fir.serialization.constant.StringValue;
import org.jetbrains.kotlin.fir.serialization.constant.UByteValue;
import org.jetbrains.kotlin.fir.serialization.constant.UIntValue;
import org.jetbrains.kotlin.fir.serialization.constant.ULongValue;
import org.jetbrains.kotlin.fir.serialization.constant.UShortValue;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.visitors.FirDefaultVisitor;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.types.ConstantValueKind;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u0014\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u001c\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u001c\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u0003H\u0016J*\u0010\u000f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0002\"\u0004\b\u0000\u0010\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00100\u00122\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u001e\u0010\u0013\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u001e\u0010\u0016\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u001e\u0010\u0019\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u001e\u0010\u001c\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u001e\u0010\u001f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010 \u001a\u00020!2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u001e\u0010\"\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010#\u001a\u00020$2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u001c\u0010%\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010&\u001a\u00020'2\u0006\u0010\b\u001a\u00020\u0003H\u0016\u00a8\u0006(\u00b2\u0006\u0010\u0010)\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0002X\u008a\u0084\u0002"}, d2={"Lorg/jetbrains/kotlin/fir/serialization/constant/FirToConstantValueTransformer;", "Lorg/jetbrains/kotlin/fir/visitors/FirDefaultVisitor;", "Lorg/jetbrains/kotlin/fir/serialization/constant/ConstantValue;", "Lorg/jetbrains/kotlin/fir/FirSession;", "()V", "visitAnnotation", "annotation", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "data", "visitAnnotationCall", "annotationCall", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;", "visitArrayOfCall", "arrayOfCall", "Lorg/jetbrains/kotlin/fir/expressions/FirArrayOfCall;", "visitConstExpression", "T", "constExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirConstExpression;", "visitElement", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "visitFunctionCall", "functionCall", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "visitGetClassCall", "getClassCall", "Lorg/jetbrains/kotlin/fir/expressions/FirGetClassCall;", "visitNamedArgumentExpression", "namedArgumentExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirNamedArgumentExpression;", "visitPropertyAccessExpression", "propertyAccessExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirPropertyAccessExpression;", "visitQualifiedAccessExpression", "qualifiedAccessExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "visitVarargArgumentsExpression", "varargArgumentsExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirVarargArgumentsExpression;", "fir-serialization", "dispatchReceiverValue"})
public final class FirToConstantValueTransformer
extends FirDefaultVisitor<ConstantValue<?>, FirSession> {
    @NotNull
    public static final FirToConstantValueTransformer INSTANCE = new FirToConstantValueTransformer();

    private FirToConstantValueTransformer() {
    }

    @Override
    @Nullable
    public ConstantValue<?> visitElement(@NotNull FirElement element, @NotNull FirSession data) {
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter(data, "data");
        throw new IllegalStateException(("Illegal element as annotation argument: " + Reflection.getOrCreateKotlinClass(element.getClass()).getQualifiedName() + " -> " + FirRendererKt.render$default(element, null, 1, null)).toString());
    }

    @Override
    @Nullable
    public <T> ConstantValue<?> visitConstExpression(@NotNull FirConstExpression<T> constExpression, @NotNull FirSession data) {
        ConstantValue constantValue;
        Intrinsics.checkNotNullParameter(constExpression, "constExpression");
        Intrinsics.checkNotNullParameter(data, "data");
        T value2 = constExpression.getValue();
        ConstantValueKind<T> constantValueKind = constExpression.getKind();
        if (Intrinsics.areEqual(constantValueKind, ConstantValueKind.Boolean.INSTANCE)) {
            Intrinsics.checkNotNull(value2, "null cannot be cast to non-null type kotlin.Boolean");
            constantValue = new BooleanValue((Boolean)value2);
        } else if (Intrinsics.areEqual(constantValueKind, ConstantValueKind.Char.INSTANCE)) {
            Intrinsics.checkNotNull(value2, "null cannot be cast to non-null type kotlin.Char");
            constantValue = new CharValue(((Character)value2).charValue());
        } else if (Intrinsics.areEqual(constantValueKind, ConstantValueKind.Byte.INSTANCE)) {
            Intrinsics.checkNotNull(value2, "null cannot be cast to non-null type kotlin.Number");
            constantValue = new ByteValue(((Number)value2).byteValue());
        } else if (Intrinsics.areEqual(constantValueKind, ConstantValueKind.UnsignedByte.INSTANCE)) {
            Intrinsics.checkNotNull(value2, "null cannot be cast to non-null type kotlin.Number");
            constantValue = new UByteValue(((Number)value2).byteValue());
        } else if (Intrinsics.areEqual(constantValueKind, ConstantValueKind.Short.INSTANCE)) {
            Intrinsics.checkNotNull(value2, "null cannot be cast to non-null type kotlin.Number");
            constantValue = new ShortValue(((Number)value2).shortValue());
        } else if (Intrinsics.areEqual(constantValueKind, ConstantValueKind.UnsignedShort.INSTANCE)) {
            Intrinsics.checkNotNull(value2, "null cannot be cast to non-null type kotlin.Number");
            constantValue = new UShortValue(((Number)value2).shortValue());
        } else if (Intrinsics.areEqual(constantValueKind, ConstantValueKind.Int.INSTANCE)) {
            Intrinsics.checkNotNull(value2, "null cannot be cast to non-null type kotlin.Number");
            constantValue = new IntValue(((Number)value2).intValue());
        } else if (Intrinsics.areEqual(constantValueKind, ConstantValueKind.UnsignedInt.INSTANCE)) {
            Intrinsics.checkNotNull(value2, "null cannot be cast to non-null type kotlin.Number");
            constantValue = new UIntValue(((Number)value2).intValue());
        } else if (Intrinsics.areEqual(constantValueKind, ConstantValueKind.Long.INSTANCE)) {
            Intrinsics.checkNotNull(value2, "null cannot be cast to non-null type kotlin.Long");
            constantValue = new LongValue((Long)value2);
        } else if (Intrinsics.areEqual(constantValueKind, ConstantValueKind.UnsignedLong.INSTANCE)) {
            Intrinsics.checkNotNull(value2, "null cannot be cast to non-null type kotlin.Long");
            constantValue = new ULongValue((Long)value2);
        } else if (Intrinsics.areEqual(constantValueKind, ConstantValueKind.String.INSTANCE)) {
            Intrinsics.checkNotNull(value2, "null cannot be cast to non-null type kotlin.String");
            constantValue = new StringValue((String)value2);
        } else if (Intrinsics.areEqual(constantValueKind, ConstantValueKind.Float.INSTANCE)) {
            Intrinsics.checkNotNull(value2, "null cannot be cast to non-null type kotlin.Float");
            constantValue = new FloatValue(((Float)value2).floatValue());
        } else if (Intrinsics.areEqual(constantValueKind, ConstantValueKind.Double.INSTANCE)) {
            Intrinsics.checkNotNull(value2, "null cannot be cast to non-null type kotlin.Double");
            constantValue = new DoubleValue((Double)value2);
        } else {
            constantValue = Intrinsics.areEqual(constantValueKind, ConstantValueKind.Null.INSTANCE) ? (ConstantValue)NullValue.INSTANCE : null;
        }
        return constantValue;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ConstantValue<?> visitArrayOfCall(@NotNull FirArrayOfCall arrayOfCall, @NotNull FirSession data) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(arrayOfCall, "arrayOfCall");
        Intrinsics.checkNotNullParameter(data, "data");
        Iterable $this$mapNotNull$iv = arrayOfCall.getArgumentList().getArguments();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ConstantValue it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            FirExpression it = (FirExpression)element$iv$iv;
            boolean bl2 = false;
            if ((ConstantValue)it.accept(this, data) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        return new ArrayValue(list2);
    }

    @Override
    @NotNull
    public ConstantValue<?> visitAnnotation(@NotNull FirAnnotation annotation2, @NotNull FirSession data) {
        Intrinsics.checkNotNullParameter(annotation2, "annotation");
        Intrinsics.checkNotNullParameter(data, "data");
        return new AnnotationValue(annotation2);
    }

    @Override
    @NotNull
    public ConstantValue<?> visitAnnotationCall(@NotNull FirAnnotationCall annotationCall, @NotNull FirSession data) {
        Intrinsics.checkNotNullParameter(annotationCall, "annotationCall");
        Intrinsics.checkNotNullParameter(data, "data");
        return this.visitAnnotation((FirAnnotation)annotationCall, data);
    }

    @Override
    @Nullable
    public ConstantValue<?> visitGetClassCall(@NotNull FirGetClassCall getClassCall, @NotNull FirSession data) {
        Intrinsics.checkNotNullParameter(getClassCall, "getClassCall");
        Intrinsics.checkNotNullParameter(data, "data");
        FirTypeRef $this$coneTypeUnsafe$iv = getClassCall.getArgument().getTypeRef();
        boolean $i$f$coneTypeUnsafe = false;
        ConeKotlinType coneKotlinType = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv).getType();
        if (coneKotlinType == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
        }
        return KClassValue.Companion.create(coneKotlinType);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public ConstantValue<?> visitQualifiedAccessExpression(@NotNull FirQualifiedAccessExpression qualifiedAccessExpression, @NotNull FirSession data) {
        ConstantValue constantValue;
        block40: {
            block41: {
                FirCallableSymbol<?> symbol2;
                block39: {
                    Object object;
                    Intrinsics.checkNotNullParameter(qualifiedAccessExpression, "qualifiedAccessExpression");
                    Intrinsics.checkNotNullParameter(data, "data");
                    FirCallableSymbol<?> firCallableSymbol = FirExpressionUtilKt.toResolvedCallableSymbol(qualifiedAccessExpression);
                    if (firCallableSymbol == null) {
                        return null;
                    }
                    symbol2 = firCallableSymbol;
                    if (!(symbol2.getFir() instanceof FirEnumEntry)) break block39;
                    FirTypeRef $this$coneTypeSafe$iv = ((FirCallableDeclaration)symbol2.getFir()).getReturnTypeRef();
                    boolean $i$f$coneTypeSafe = false;
                    FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
                    ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
                    if (!(coneKotlinType instanceof ConeClassLikeType)) {
                        coneKotlinType = null;
                    }
                    if ((object = (ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType))) == null || (object = ConeTypeUtilsKt.getClassId((ConeKotlinType)object)) == null) {
                        return null;
                    }
                    Object classId = object;
                    Object e = symbol2.getFir();
                    Intrinsics.checkNotNull(e, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirEnumEntry");
                    constantValue = new EnumValue((ClassId)classId, ((FirEnumEntry)e).getName());
                    break block40;
                }
                if (symbol2 instanceof FirConstructorSymbol) {
                    ConstantValue constantValue2;
                    FirFunctionCall constructorCall = (FirFunctionCall)qualifiedAccessExpression;
                    Object object = ClassMembersKt.containingClass(symbol2);
                    if (object == null || (object = LookupTagUtilsKt.toFirRegularClassSymbol((ConeClassLikeLookupTag)object, data)) == null) {
                        return null;
                    }
                    Object constructedClassSymbol = object;
                    if (((FirClassSymbol)constructedClassSymbol).getClassKind() == ClassKind.ANNOTATION_CLASS) {
                        void $this$visitQualifiedAccessExpression_u24lambda_u2d4_u24lambda_u2d3;
                        Object $this$visitQualifiedAccessExpression_u24lambda_u2d4_u24lambda_u2d2;
                        FirAnnotationCallBuilder $i$f$coneTypeSafe;
                        boolean $i$f$buildAnnotationCall = false;
                        FirAnnotationCallBuilder $this$visitQualifiedAccessExpression_u24lambda_u2d4 = $i$f$coneTypeSafe = new FirAnnotationCallBuilder();
                        boolean bl = false;
                        boolean $i$f$buildAnnotationArgumentMapping = false;
                        Object object2 = new FirAnnotationArgumentMappingBuilder();
                        FirAnnotationArgumentMappingBuilder firAnnotationArgumentMappingBuilder = object2;
                        FirAnnotationCallBuilder firAnnotationCallBuilder = $this$visitQualifiedAccessExpression_u24lambda_u2d4;
                        boolean bl2 = false;
                        FirCall $this$argumentMapping$iv = constructorCall;
                        boolean $i$f$getArgumentMapping = false;
                        FirArgumentList argumentList$iv = $this$argumentMapping$iv.getArgumentList();
                        LinkedHashMap<FirExpression, FirValueParameter> linkedHashMap = argumentList$iv instanceof FirResolvedArgumentList ? ((FirResolvedArgumentList)argumentList$iv).getMapping() : null;
                        if (linkedHashMap != null) {
                            Map $this$forEach$iv = linkedHashMap;
                            boolean $i$f$forEach = false;
                            Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
                            while (iterator2.hasNext()) {
                                Map.Entry element$iv;
                                Map.Entry entry = element$iv = iterator2.next();
                                boolean bl3 = false;
                                FirExpression firExpression2 = (FirExpression)entry.getKey();
                                FirValueParameter firValueParameter = (FirValueParameter)entry.getValue();
                                ((FirAnnotationArgumentMappingBuilder)$this$visitQualifiedAccessExpression_u24lambda_u2d4_u24lambda_u2d2).getMapping().put(firValueParameter.getName(), firExpression2);
                            }
                        }
                        firAnnotationCallBuilder.setArgumentMapping(((FirAnnotationArgumentMappingBuilder)object2).build());
                        $this$visitQualifiedAccessExpression_u24lambda_u2d4.setAnnotationTypeRef(qualifiedAccessExpression.getTypeRef());
                        boolean $i$f$buildSimpleNamedReference = false;
                        $this$visitQualifiedAccessExpression_u24lambda_u2d4_u24lambda_u2d2 = object2 = new FirSimpleNamedReferenceBuilder();
                        firAnnotationCallBuilder = $this$visitQualifiedAccessExpression_u24lambda_u2d4;
                        boolean bl4 = false;
                        $this$visitQualifiedAccessExpression_u24lambda_u2d4_u24lambda_u2d3.setSource(qualifiedAccessExpression.getSource());
                        $this$visitQualifiedAccessExpression_u24lambda_u2d4_u24lambda_u2d3.setName(((FirFunctionCall)qualifiedAccessExpression).getCalleeReference().getName());
                        firAnnotationCallBuilder.setCalleeReference(((FirSimpleNamedReferenceBuilder)object2).build());
                        FirAnnotation firAnnotation = $i$f$coneTypeSafe.build();
                        constantValue2 = new AnnotationValue(firAnnotation);
                    } else {
                        constantValue2 = null;
                    }
                    return constantValue2;
                }
                if (!Intrinsics.areEqual(symbol2.getCallableId().getPackageName().asString(), "kotlin")) break block41;
                FirExpression dispatchReceiver = qualifiedAccessExpression.getDispatchReceiver();
                Lazy dispatchReceiverValue$delegate = LazyKt.lazy(new Function0<ConstantValue<?>>(dispatchReceiver, this, data){
                    final /* synthetic */ FirExpression $dispatchReceiver;
                    final /* synthetic */ FirToConstantValueTransformer this$0;
                    final /* synthetic */ FirSession $data;
                    {
                        this.$dispatchReceiver = $dispatchReceiver;
                        this.this$0 = $receiver;
                        this.$data = $data;
                        super(0);
                    }

                    @Nullable
                    public final ConstantValue<?> invoke() {
                        return (ConstantValue)this.$dispatchReceiver.accept(this.this$0, this.$data);
                    }
                });
                switch (symbol2.getCallableId().getCallableName().asString()) {
                    case "toByte": {
                        ConstantValue<?> constantValue3 = FirToConstantValueTransformer.visitQualifiedAccessExpression$lambda-5(dispatchReceiverValue$delegate);
                        Intrinsics.checkNotNull(constantValue3);
                        Object obj = constantValue3.getValue();
                        Intrinsics.checkNotNull(obj, "null cannot be cast to non-null type kotlin.Number");
                        constantValue = new ByteValue(((Number)obj).byteValue());
                        break;
                    }
                    case "toLong": {
                        ConstantValue<?> constantValue4 = FirToConstantValueTransformer.visitQualifiedAccessExpression$lambda-5(dispatchReceiverValue$delegate);
                        Intrinsics.checkNotNull(constantValue4);
                        Object obj = constantValue4.getValue();
                        Intrinsics.checkNotNull(obj, "null cannot be cast to non-null type kotlin.Number");
                        constantValue = new LongValue(((Number)obj).longValue());
                        break;
                    }
                    case "toShort": {
                        ConstantValue<?> constantValue5 = FirToConstantValueTransformer.visitQualifiedAccessExpression$lambda-5(dispatchReceiverValue$delegate);
                        Intrinsics.checkNotNull(constantValue5);
                        Object obj = constantValue5.getValue();
                        Intrinsics.checkNotNull(obj, "null cannot be cast to non-null type kotlin.Number");
                        constantValue = new ShortValue(((Number)obj).shortValue());
                        break;
                    }
                    case "toFloat": {
                        ConstantValue<?> constantValue6 = FirToConstantValueTransformer.visitQualifiedAccessExpression$lambda-5(dispatchReceiverValue$delegate);
                        Intrinsics.checkNotNull(constantValue6);
                        Object obj = constantValue6.getValue();
                        Intrinsics.checkNotNull(obj, "null cannot be cast to non-null type kotlin.Number");
                        constantValue = new FloatValue(((Number)obj).floatValue());
                        break;
                    }
                    case "toDouble": {
                        ConstantValue<?> constantValue7 = FirToConstantValueTransformer.visitQualifiedAccessExpression$lambda-5(dispatchReceiverValue$delegate);
                        Intrinsics.checkNotNull(constantValue7);
                        Object obj = constantValue7.getValue();
                        Intrinsics.checkNotNull(obj, "null cannot be cast to non-null type kotlin.Number");
                        constantValue = new DoubleValue(((Number)obj).doubleValue());
                        break;
                    }
                    case "toChar": {
                        ConstantValue<?> constantValue8 = FirToConstantValueTransformer.visitQualifiedAccessExpression$lambda-5(dispatchReceiverValue$delegate);
                        Intrinsics.checkNotNull(constantValue8);
                        Object obj = constantValue8.getValue();
                        Intrinsics.checkNotNull(obj, "null cannot be cast to non-null type kotlin.Number");
                        constantValue = new CharValue((char)((Number)obj).intValue());
                        break;
                    }
                    case "unaryMinus": {
                        ConstantValue<?> receiverValue = FirToConstantValueTransformer.visitQualifiedAccessExpression$lambda-5(dispatchReceiverValue$delegate);
                        if (receiverValue instanceof ByteValue) {
                            constantValue = new ByteValue(-((Number)((ByteValue)receiverValue).getValue()).byteValue());
                            break;
                        }
                        if (receiverValue instanceof LongValue) {
                            constantValue = new LongValue(-((Number)((LongValue)receiverValue).getValue()).longValue());
                            break;
                        }
                        if (receiverValue instanceof ShortValue) {
                            constantValue = new ShortValue(-((Number)((ShortValue)receiverValue).getValue()).shortValue());
                            break;
                        }
                        if (receiverValue instanceof FloatValue) {
                            constantValue = new FloatValue(-((Number)((FloatValue)receiverValue).getValue()).floatValue());
                            break;
                        }
                        if (receiverValue instanceof DoubleValue) {
                            constantValue = new DoubleValue(-((Number)((DoubleValue)receiverValue).getValue()).doubleValue());
                            break;
                        }
                        constantValue = null;
                        break;
                    }
                    default: {
                        constantValue = null;
                        break;
                    }
                }
                break block40;
            }
            constantValue = null;
        }
        return constantValue;
    }

    @Override
    @Nullable
    public ConstantValue<?> visitPropertyAccessExpression(@NotNull FirPropertyAccessExpression propertyAccessExpression, @NotNull FirSession data) {
        Intrinsics.checkNotNullParameter(propertyAccessExpression, "propertyAccessExpression");
        Intrinsics.checkNotNullParameter(data, "data");
        return this.visitQualifiedAccessExpression((FirQualifiedAccessExpression)propertyAccessExpression, data);
    }

    @Override
    @Nullable
    public ConstantValue<?> visitFunctionCall(@NotNull FirFunctionCall functionCall, @NotNull FirSession data) {
        Intrinsics.checkNotNullParameter(functionCall, "functionCall");
        Intrinsics.checkNotNullParameter(data, "data");
        return this.visitQualifiedAccessExpression((FirQualifiedAccessExpression)functionCall, data);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ConstantValue<?> visitVarargArgumentsExpression(@NotNull FirVarargArgumentsExpression varargArgumentsExpression, @NotNull FirSession data) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(varargArgumentsExpression, "varargArgumentsExpression");
        Intrinsics.checkNotNullParameter(data, "data");
        Iterable $this$mapNotNull$iv = varargArgumentsExpression.getArguments();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ConstantValue it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            FirExpression it = (FirExpression)element$iv$iv;
            boolean bl2 = false;
            if ((ConstantValue)it.accept(this, data) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        return new ArrayValue(list2);
    }

    @Override
    @Nullable
    public ConstantValue<?> visitNamedArgumentExpression(@NotNull FirNamedArgumentExpression namedArgumentExpression, @NotNull FirSession data) {
        Intrinsics.checkNotNullParameter(namedArgumentExpression, "namedArgumentExpression");
        Intrinsics.checkNotNullParameter(data, "data");
        return (ConstantValue)namedArgumentExpression.getExpression().accept(this, data);
    }

    private static final ConstantValue<?> visitQualifiedAccessExpression$lambda-5(Lazy<? extends ConstantValue<?>> $dispatchReceiverValue$delegate) {
        Lazy<ConstantValue<?>> lazy = $dispatchReceiverValue$delegate;
        return lazy.getValue();
    }
}

