/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.ic;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.serialization.IrModuleDeserializer;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.backend.js.JsLibraryResolverKt;
import org.jetbrains.kotlin.ir.backend.js.KlibKt;
import org.jetbrains.kotlin.ir.backend.js.ic.CacheExecutor;
import org.jetbrains.kotlin.ir.backend.js.ic.CacheUpdateStatus;
import org.jetbrains.kotlin.ir.backend.js.ic.HashCalculatorForICKt;
import org.jetbrains.kotlin.ir.backend.js.ic.ICHash;
import org.jetbrains.kotlin.ir.backend.js.ic.IncrementalCache;
import org.jetbrains.kotlin.ir.backend.js.ic.InlineFunctionFlatHashBuilder;
import org.jetbrains.kotlin.ir.backend.js.ic.InlineFunctionHashBuilder;
import org.jetbrains.kotlin.ir.backend.js.ic.InlineFunctionHashProvider;
import org.jetbrains.kotlin.ir.backend.js.ic.JsIrLinkerLoader;
import org.jetbrains.kotlin.ir.backend.js.ic.ModuleArtifact;
import org.jetbrains.kotlin.ir.backend.js.lower.serialization.ir.JsIrLinker;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.ir.util.IrMessageLogger;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.konan.properties.PropertiesKt;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.library.resolver.KotlinLibraryResolveResult;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001\u001dBW\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J&\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\r2\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00160\u0014J.\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\r0\u00182\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J\u0014\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J\f\u0010\u001c\u001a\u00020\u0003*\u00020\u0019H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/ic/CacheUpdater;", "", "rootModule", "", "allModules", "", "compilerConfiguration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "icCachePaths", "irFactory", "Lkotlin/Function0;", "Lorg/jetbrains/kotlin/ir/declarations/IrFactory;", "mainArguments", "", "executor", "Lorg/jetbrains/kotlin/ir/backend/js/ic/CacheExecutor;", "(Ljava/lang/String;Ljava/util/Collection;Lorg/jetbrains/kotlin/config/CompilerConfiguration;Ljava/util/Collection;Lkotlin/jvm/functions/Function0;Ljava/util/List;Lorg/jetbrains/kotlin/ir/backend/js/ic/CacheExecutor;)V", "actualizeCaches", "Lorg/jetbrains/kotlin/ir/backend/js/ic/ModuleArtifact;", "callback", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/ir/backend/js/ic/CacheUpdateStatus;", "", "buildDependenciesGraph", "", "Lorg/jetbrains/kotlin/library/KotlinLibrary;", "libraries", "loadLibraries", "moduleCanonicalName", "KLibCacheUpdater", "backend.js"})
public final class CacheUpdater {
    @NotNull
    private final String rootModule;
    @NotNull
    private final Collection<String> allModules;
    @NotNull
    private final CompilerConfiguration compilerConfiguration;
    @NotNull
    private final Collection<String> icCachePaths;
    @NotNull
    private final Function0<IrFactory> irFactory;
    @Nullable
    private final List<String> mainArguments;
    @NotNull
    private final CacheExecutor executor;

    public CacheUpdater(@NotNull String rootModule, @NotNull Collection<String> allModules2, @NotNull CompilerConfiguration compilerConfiguration, @NotNull Collection<String> icCachePaths, @NotNull Function0<? extends IrFactory> irFactory, @Nullable List<String> mainArguments, @NotNull CacheExecutor executor) {
        Intrinsics.checkNotNullParameter(rootModule, "rootModule");
        Intrinsics.checkNotNullParameter(allModules2, "allModules");
        Intrinsics.checkNotNullParameter(compilerConfiguration, "compilerConfiguration");
        Intrinsics.checkNotNullParameter(icCachePaths, "icCachePaths");
        Intrinsics.checkNotNullParameter(irFactory, "irFactory");
        Intrinsics.checkNotNullParameter(executor, "executor");
        this.rootModule = rootModule;
        this.allModules = allModules2;
        this.compilerConfiguration = compilerConfiguration;
        this.icCachePaths = icCachePaths;
        this.irFactory = irFactory;
        this.mainArguments = mainArguments;
        this.executor = executor;
    }

    private final String moduleCanonicalName(KotlinLibrary $this$moduleCanonicalName) {
        return $this$moduleCanonicalName.getLibraryFile().getCanonicalPath();
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, KotlinLibrary> loadLibraries() {
        void $this$associateByTo$iv$iv;
        Collection collection = this.compilerConfiguration.get(JSConfigurationKeys.REPOSITORIES);
        if (collection == null) {
            collection = CollectionsKt.emptyList();
        }
        KotlinLibraryResolveResult allResolvedDependencies = JsLibraryResolverKt.jsResolveLibraries(this.allModules, collection, KlibKt.toResolverLogger(this.compilerConfiguration.get(IrMessageLogger.Companion.getIR_MESSAGE_LOGGER())));
        Iterable $this$associateBy$iv = KotlinLibraryResolveResult.DefaultImpls.getFullList$default(allResolvedDependencies, null, 1, null);
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateBy$iv, 10)), 16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            KotlinLibrary kotlinLibrary = (KotlinLibrary)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(this.moduleCanonicalName((KotlinLibrary)it), element$iv$iv);
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<KotlinLibrary, List<KotlinLibrary>> buildDependenciesGraph(Map<String, ? extends KotlinLibrary> libraries) {
        Map map;
        void $this$associateByTo$iv$iv;
        Iterable $this$associateBy$iv = libraries.values();
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateBy$iv, 10)), 16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv2 : $this$associateByTo$iv$iv) {
            void it;
            KotlinLibrary kotlinLibrary = (KotlinLibrary)element$iv$iv2;
            map = destination$iv$iv;
            boolean bl = false;
            map.put(KlibKt.getModuleName((KotlinLibrary)it), element$iv$iv2);
        }
        Map nameToKotlinLibrary = destination$iv$iv;
        Iterable $this$associateWith$iv = libraries.values();
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateWith$iv, 10)), 16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void $this$mapTo$iv$iv;
            void it;
            Object element$iv$iv2;
            element$iv$iv2 = (KotlinLibrary)element$iv$iv;
            Object t = element$iv$iv;
            map = result$iv;
            boolean bl = false;
            Iterable $this$map$iv = PropertiesKt.propertyList$default(it.getManifestProperties(), "depends", null, true, 2, null);
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void depName;
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                KotlinLibrary kotlinLibrary = (KotlinLibrary)nameToKotlinLibrary.get(depName);
                if (kotlinLibrary == null) {
                    throw new IllegalStateException(("No Library found for " + (String)depName).toString());
                }
                collection.add(kotlinLibrary);
            }
            List list2 = (List)destination$iv$iv2;
            map.put(t, list2);
        }
        return result$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ModuleArtifact> actualizeCaches(@NotNull Function2<? super CacheUpdateStatus, ? super String, Unit> callback) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(callback, "callback");
        Map<String, KotlinLibrary> libraries = this.loadLibraries();
        Map<KotlinLibrary, List<KotlinLibrary>> dependencyGraph = this.buildDependenciesGraph(libraries);
        long configHash = HashCalculatorForICKt.configHashForIC(this.compilerConfiguration);
        Map<KotlinLibrary, String> cacheMap = MapsKt.toMap(CollectionsKt.zip((Iterable)libraries.values(), (Iterable)this.icCachePaths));
        Map klibIncrementalCaches = new LinkedHashMap();
        Set visitedLibraries = new LinkedHashSet();
        String rootModuleCanonical = new File(this.rootModule).getCanonicalPath();
        KotlinLibrary kotlinLibrary = libraries.get(rootModuleCanonical);
        if (kotlinLibrary == null) {
            throw new IllegalStateException(("Main library not found in libraries: " + rootModuleCanonical).toString());
        }
        KotlinLibrary mainLibrary = kotlinLibrary;
        CacheUpdater.actualizeCaches$visitDependency(visitedLibraries, dependencyGraph, cacheMap, klibIncrementalCaches, configHash, this, callback, mainLibrary);
        Map $this$map$iv = klibIncrementalCaches;
        boolean $i$f$map = false;
        Map map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((IncrementalCache)it.getValue()).fetchArtifacts());
        }
        return (List)destination$iv$iv;
    }

    private static final void actualizeCaches$visitDependency(Set<KotlinLibrary> visitedLibraries, Map<KotlinLibrary, ? extends List<? extends KotlinLibrary>> dependencyGraph, Map<KotlinLibrary, String> cacheMap, Map<KotlinLibrary, IncrementalCache> klibIncrementalCaches, long configHash, CacheUpdater this$0, Function2<? super CacheUpdateStatus, ? super String, Unit> $callback, KotlinLibrary library) {
        if (visitedLibraries.contains(library)) {
            return;
        }
        visitedLibraries.add(library);
        List<? extends KotlinLibrary> list2 = dependencyGraph.get(library);
        if (list2 == null) {
            throw new IllegalStateException(("Unknown library " + library.getLibraryName()).toString());
        }
        List<? extends KotlinLibrary> libraryDeps = list2;
        Iterable $this$forEach$iv = libraryDeps;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KotlinLibrary it = (KotlinLibrary)element$iv;
            boolean bl = false;
            CacheUpdater.actualizeCaches$visitDependency(visitedLibraries, dependencyGraph, cacheMap, klibIncrementalCaches, configHash, this$0, $callback, it);
        }
        String string2 = cacheMap.get(library);
        if (string2 == null) {
            throw new IllegalStateException(("Unknown cache for library " + library.getLibraryName()).toString());
        }
        String cachePath = string2;
        IncrementalCache incrementalCache = new IncrementalCache(library, cachePath);
        klibIncrementalCaches.put(library, incrementalCache);
        incrementalCache.invalidateCacheForNewConfig-ycJ14Ss(configHash);
        KLibCacheUpdater cacheUpdater2 = this$0.new KLibCacheUpdater(library, dependencyGraph, incrementalCache, klibIncrementalCaches);
        CacheUpdateStatus updateStatus = cacheUpdater2.checkLibrariesHash() ? (CacheUpdateStatus)CacheUpdateStatus.FastPath.INSTANCE : cacheUpdater2.actualizeCacheForModule();
        $callback.invoke(updateStatus, library.getLibraryFile().getPath());
    }

    public static final /* synthetic */ CacheExecutor access$getExecutor$p(CacheUpdater $this) {
        return $this.executor;
    }

    public static final /* synthetic */ List access$getMainArguments$p(CacheUpdater $this) {
        return $this.mainArguments;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u000b\u001a\u00020\fJ_\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00142\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u00052\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00190\u0005H\u0002\u00f8\u0001\u0000J\u0006\u0010\u001b\u001a\u00020\u001cJ\u001a\u0010\u001d\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00060\u0005H\u0002J=\u0010\u001e\u001a \u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160 \u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00190\u00050\u001f2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0005H\u0002\u00f8\u0001\u0000R \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/ic/CacheUpdater$KLibCacheUpdater;", "", "library", "Lorg/jetbrains/kotlin/library/KotlinLibrary;", "dependencyGraph", "", "", "incrementalCache", "Lorg/jetbrains/kotlin/ir/backend/js/ic/IncrementalCache;", "klibIncrementalCaches", "(Lorg/jetbrains/kotlin/ir/backend/js/ic/CacheUpdater;Lorg/jetbrains/kotlin/library/KotlinLibrary;Ljava/util/Map;Lorg/jetbrains/kotlin/ir/backend/js/ic/IncrementalCache;Ljava/util/Map;)V", "actualizeCacheForModule", "Lorg/jetbrains/kotlin/ir/backend/js/ic/CacheUpdateStatus;", "buildCacheForModule", "", "irModule", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "deserializer", "Lorg/jetbrains/kotlin/ir/backend/js/lower/serialization/ir/JsIrLinker;", "dependencies", "", "dirtyFiles", "", "cleanInlineHashes", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "Lorg/jetbrains/kotlin/ir/backend/js/ic/ICHash;", "fileFingerPrints", "checkLibrariesHash", "", "getDependencySubGraph", "invalidateCacheForModule", "Lkotlin/Pair;", "", "externalHashes", "backend.js"})
    private final class KLibCacheUpdater {
        @NotNull
        private final KotlinLibrary library;
        @NotNull
        private final Map<KotlinLibrary, List<KotlinLibrary>> dependencyGraph;
        @NotNull
        private final IncrementalCache incrementalCache;
        @NotNull
        private final Map<KotlinLibrary, IncrementalCache> klibIncrementalCaches;

        public KLibCacheUpdater(@NotNull KotlinLibrary library, @NotNull Map<KotlinLibrary, ? extends List<? extends KotlinLibrary>> dependencyGraph, @NotNull IncrementalCache incrementalCache, Map<KotlinLibrary, IncrementalCache> klibIncrementalCaches) {
            Intrinsics.checkNotNullParameter(library, "library");
            Intrinsics.checkNotNullParameter(dependencyGraph, "dependencyGraph");
            Intrinsics.checkNotNullParameter(incrementalCache, "incrementalCache");
            Intrinsics.checkNotNullParameter(klibIncrementalCaches, "klibIncrementalCaches");
            this.library = library;
            this.dependencyGraph = dependencyGraph;
            this.incrementalCache = incrementalCache;
            this.klibIncrementalCaches = klibIncrementalCaches;
        }

        private final Pair<Set<String>, Map<String, ICHash>> invalidateCacheForModule(Map<IdSignature, ICHash> externalHashes) {
            Map fileFingerPrints = new LinkedHashMap();
            Set dirtyFiles = new LinkedHashSet();
            if (this.incrementalCache.getKlibUpdated()) {
                Iterator<String> iterator2 = this.incrementalCache.getSrcFilesInOrderFromKLib().iterator();
                int n = 0;
                while (iterator2.hasNext()) {
                    long fileNewFingerprint;
                    ICHash fileOldFingerprint;
                    int index2 = n++;
                    String file2 = iterator2.next();
                    Object object = this.incrementalCache.getSrcFingerprints().get(file2);
                    if (object == null) {
                        object = 0;
                    }
                    if (Intrinsics.areEqual(fileOldFingerprint = object, ICHash.box-impl(fileNewFingerprint = HashCalculatorForICKt.fingerprint(this.library, index2)))) continue;
                    ICHash iCHash = ICHash.box-impl(fileNewFingerprint);
                    fileFingerPrints.put(file2, iCHash);
                    this.incrementalCache.invalidateForSrcFile(file2);
                    dirtyFiles.add(file2);
                }
            }
            while (dirtyFiles.size() != this.incrementalCache.getSrcFilesInOrderFromKLib().size()) {
                int oldSize = dirtyFiles.size();
                block2: for (String file3 : this.incrementalCache.getSrcFilesInOrderFromKLib()) {
                    if (dirtyFiles.contains(file3)) continue;
                    Map<IdSignature, ICHash> map = this.incrementalCache.getUsedFunctions().get(file3);
                    if (map == null) {
                        map = MapsKt.emptyMap();
                    }
                    Map<IdSignature, ICHash> usedInlineFunctions = map;
                    for (Map.Entry<IdSignature, ICHash> entry : usedInlineFunctions.entrySet()) {
                        ICHash actualHash;
                        ICHash iCHash;
                        long oldHash;
                        block11: {
                            IdSignature sig = entry.getKey();
                            oldHash = entry.getValue().unbox-impl();
                            iCHash = externalHashes.get(sig);
                            if (iCHash == null) {
                                for (Map it : (Iterable)this.incrementalCache.getImplementedFunctions()) {
                                    boolean bl = false;
                                    ICHash iCHash2 = (ICHash)it.get(sig);
                                    if (iCHash2 == null) continue;
                                    iCHash = iCHash2;
                                    break block11;
                                }
                                iCHash = null;
                            }
                        }
                        if ((actualHash = iCHash) != null && ICHash.equals-impl(oldHash, actualHash)) continue;
                        Map map2 = fileFingerPrints;
                        ICHash iCHash3 = this.incrementalCache.getSrcFingerprints().get(file3);
                        if (iCHash3 == null) {
                            throw new IllegalStateException(("Cannot find fingerprint for " + file3).toString());
                        }
                        ICHash iCHash4 = ICHash.box-impl(iCHash3.unbox-impl());
                        map2.put(file3, iCHash4);
                        this.incrementalCache.invalidateForSrcFile(file3);
                        dirtyFiles.add(file3);
                        continue block2;
                    }
                }
                if (oldSize != dirtyFiles.size()) continue;
            }
            for (String deleted : this.incrementalCache.getDeletedSrcFiles()) {
                this.incrementalCache.invalidateForSrcFile(deleted);
            }
            return TuplesKt.to(dirtyFiles, fileFingerPrints);
        }

        private final Map<KotlinLibrary, List<KotlinLibrary>> getDependencySubGraph() {
            Map subGraph = new LinkedHashMap();
            KLibCacheUpdater.getDependencySubGraph$addDependsFor(subGraph, this, this.library);
            return subGraph;
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        private final void buildCacheForModule(IrModuleFragment irModule, JsIrLinker deserializer, Collection<? extends IrModuleFragment> dependencies, Collection<String> dirtyFiles, Map<IdSignature, ICHash> cleanInlineHashes, Map<String, ICHash> fileFingerPrints) {
            $this$filter$iv = irModule.getFiles();
            $i$f$filter = false;
            var10_10 = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (IrFile)element$iv$iv;
                $i$a$-filter-CacheUpdater$KLibCacheUpdater$buildCacheForModule$dirtyIrFiles$1 = false;
                if (!dirtyFiles.contains(it.getFileEntry().getName())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            dirtyIrFiles = (List)destination$iv$iv;
            $this$buildCacheForModule_u24lambda_u2d3 = $i$f$filter = new InlineFunctionFlatHashBuilder();
            $i$a$-apply-CacheUpdater$KLibCacheUpdater$buildCacheForModule$flatHashes$1 = false;
            $this$forEach$iv = dirtyIrFiles;
            $i$f$forEach = false;
            for (E element$iv : $this$forEach$iv) {
                it = (IrFile)element$iv /* !! */ ;
                $i$a$-forEach-CacheUpdater$KLibCacheUpdater$buildCacheForModule$flatHashes$1$1 = false;
                IrVisitorsKt.acceptVoid(it, $this$buildCacheForModule_u24lambda_u2d3);
            }
            flatHashes = $i$f$filter.getFlatHashes();
            hashProvider = new InlineFunctionHashProvider(cleanInlineHashes){
                final /* synthetic */ Map<IdSignature, ICHash> $cleanInlineHashes;
                {
                    this.$cleanInlineHashes = $cleanInlineHashes;
                }

                @Nullable
                public ICHash hashForExternalFunction-Z1Gnr_Y(@NotNull IrFunction declaration) {
                    ICHash iCHash;
                    Intrinsics.checkNotNullParameter(declaration, "declaration");
                    IdSignature idSignature = declaration.getSymbol().getSignature();
                    if (idSignature != null) {
                        IdSignature idSignature2 = idSignature;
                        Map<IdSignature, ICHash> map = this.$cleanInlineHashes;
                        IdSignature it = idSignature2;
                        boolean bl = false;
                        iCHash = map.get(it);
                    } else {
                        iCHash = null;
                    }
                    return iCHash;
                }
            };
            hashBuilder = new InlineFunctionHashBuilder(hashProvider, flatHashes);
            hashes = hashBuilder.buildHashes(dirtyIrFiles);
            $this$filter$iv = hashes.entrySet();
            $i$f$filter = false;
            element$iv /* !! */  = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (T element$iv$iv : $this$filterTo$iv$iv) {
                it = (Map.Entry)element$iv$iv;
                $i$a$-filter-CacheUpdater$KLibCacheUpdater$buildCacheForModule$splitPerFiles$1 = false;
                if (IrFakeOverrideUtilsKt.isFakeOverride((IrDeclaration)it.getKey())) ** GOTO lbl-1000
                v0 = ((IrFunction)it.getKey()).getSymbol().getSignature();
                if (v0 != null ? v0.getVisibleCrossFile() : false) {
                    v1 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = false;
                }
                if (!v1) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$groupBy = false;
            $this$filterTo$iv$iv = $this$groupBy$iv;
            destination$iv$iv = new LinkedHashMap<K, V>();
            $i$f$groupByTo = false;
            for (T element$iv$iv : $this$groupByTo$iv$iv) {
                it = (Map.Entry)element$iv$iv;
                $i$a$-groupBy-CacheUpdater$KLibCacheUpdater$buildCacheForModule$splitPerFiles$2 = false;
                key$iv$iv = IrUtilsKt.getFile((IrDeclaration)it.getKey());
                $this$getOrPut$iv$iv$iv = destination$iv$iv;
                $i$f$getOrPut = false;
                value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    $i$a$-getOrPut-CollectionsKt___CollectionsKt$groupByTo$list$2$iv$iv = false;
                    answer$iv$iv$iv = new ArrayList<E>();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    v2 /* !! */  = answer$iv$iv$iv;
                } else {
                    v2 /* !! */  = value$iv$iv$iv;
                }
                list$iv$iv = (List)v2 /* !! */ ;
                $i$a$-groupBy-CacheUpdater$KLibCacheUpdater$buildCacheForModule$splitPerFiles$2 = (Map.Entry)element$iv$iv;
                var29_45 = list$iv$iv;
                $i$a$-groupBy-CacheUpdater$KLibCacheUpdater$buildCacheForModule$splitPerFiles$3 = false;
                if (((IrFunction)it.getKey()).getSymbol().getSignature() == null) {
                    throw new IllegalStateException(("Unexpected private inline fun " + RenderIrElementKt.render((IrElement)it.getKey())).toString());
                }
                var29_45.add(TuplesKt.to(signature, it.getValue()));
            }
            splitPerFiles = destination$iv$iv;
            inlineGraph = hashBuilder.buildInlineGraph(hashes);
            $this$forEach$iv = dirtyIrFiles;
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                irFile = (IrFile)element$iv;
                $i$a$-forEach-CacheUpdater$KLibCacheUpdater$buildCacheForModule$1 = false;
                fileName = irFile.getFileEntry().getName();
                v3 = fileFingerPrints.get(fileName);
                if (v3 == null) {
                    throw new IllegalStateException(("No fingerprint found for file " + fileName).toString());
                }
                v4 = (List)splitPerFiles.get(irFile);
                this.incrementalCache.updateHashes--BhkBBM(fileName, v3.unbox-impl(), inlineGraph.get(irFile), v4 != null ? MapsKt.toMap(v4) : null);
            }
            CacheUpdater.access$getExecutor$p(CacheUpdater.this).execute(irModule, dependencies, deserializer, CacheUpdater.access$getCompilerConfiguration$p(CacheUpdater.this), dirtyFiles, this.incrementalCache, SetsKt.emptySet(), CacheUpdater.access$getMainArguments$p(CacheUpdater.this));
        }

        public final boolean checkLibrariesHash() {
            long flatHash = HashCalculatorForICKt.fileHashForIC(new File(CacheUpdater.this.moduleCanonicalName(this.library)));
            List<KotlinLibrary> list2 = this.dependencyGraph.get(this.library);
            if (list2 == null) {
                throw new IllegalStateException(("Cannot find dependencies for " + this.library.getLibraryName()).toString());
            }
            List<KotlinLibrary> dependencies2 = list2;
            long transHash = flatHash;
            for (KotlinLibrary dep : dependencies2) {
                IncrementalCache depCache;
                if (this.klibIncrementalCaches.get(dep) == null) {
                    throw new IllegalStateException(("Cannot cache info for " + dep.getLibraryName()).toString());
                }
                transHash = ICHash.combineWith-egXBrMc(transHash, depCache.getKlibTransitiveHash-Yd-dAqs());
            }
            return this.incrementalCache.checkAndUpdateCacheFastInfo-VBntS4A(flatHash, transHash);
        }

        @NotNull
        public final CacheUpdateStatus actualizeCacheForModule() {
            Object it;
            List<KotlinLibrary> list2 = this.dependencyGraph.get(this.library);
            Intrinsics.checkNotNull(list2);
            List<KotlinLibrary> dependencies2 = list2;
            IncrementalCache incrementalCache = this.klibIncrementalCaches.get(this.library);
            if (incrementalCache == null) {
                throw new IllegalStateException(("No cache provider for " + this.library).toString());
            }
            IncrementalCache incrementalCache2 = incrementalCache;
            Map sigHashes = new LinkedHashMap();
            Iterable $this$forEach$iv = dependencies2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IncrementalCache libCache;
                KotlinLibrary lib = (KotlinLibrary)element$iv;
                boolean bl = false;
                if (this.klibIncrementalCaches.get(lib) == null) continue;
                boolean bl2 = false;
                libCache.fetchCacheDataForDependency();
                Iterable $this$forEach$iv2 = libCache.getImplementedFunctions();
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    it = (Map)element$iv2;
                    boolean bl3 = false;
                    sigHashes.putAll(it);
                }
            }
            incrementalCache2.fetchFullCacheData();
            Pair<Set<String>, Map<String, ICHash>> pair = this.invalidateCacheForModule(sigHashes);
            Set<String> dirtySet = pair.component1();
            Map<String, ICHash> fileFingerPrints = pair.component2();
            Set<String> removed2 = incrementalCache2.getDeletedSrcFiles();
            if (dirtySet.isEmpty()) {
                incrementalCache2.commitCacheForRemovedSrcFiles();
                return new CacheUpdateStatus.NoDirtyFiles(removed2);
            }
            JsIrLinkerLoader jsIrLinkerProcessor = new JsIrLinkerLoader(CacheUpdater.this.compilerConfiguration, this.library, this.getDependencySubGraph(), (IrFactory)CacheUpdater.this.irFactory.invoke());
            Triple<JsIrLinker, IrModuleFragment, Collection<IrModuleFragment>> triple = jsIrLinkerProcessor.processJsIrLinker((Collection<String>)dirtySet);
            JsIrLinker jsIrLinker = triple.component1();
            IrModuleFragment currentIrModule = triple.component2();
            Collection<IrModuleFragment> irModules = triple.component3();
            IrModuleDeserializer currentModuleDeserializer = jsIrLinker.moduleDeserializer(currentIrModule.getDescriptor());
            Iterable $this$forEach$iv3 = incrementalCache2.getImplementedFunctions();
            boolean $i$f$forEach3 = false;
            it = $this$forEach$iv3.iterator();
            while (it.hasNext()) {
                Object element$iv = it.next();
                Map it2 = (Map)element$iv;
                boolean bl = false;
                sigHashes.putAll(it2);
            }
            for (String dirtySrcFile : dirtySet) {
                Map<IdSignature, Integer> signatureMapping = currentModuleDeserializer.signatureDeserializerForFile(dirtySrcFile).signatureToIndexMapping();
                incrementalCache2.updateSignatureToIdMapping(dirtySrcFile, signatureMapping);
            }
            this.buildCacheForModule(currentIrModule, jsIrLinker, irModules, (Collection<String>)dirtySet, sigHashes, fileFingerPrints);
            boolean updatedAll = dirtySet.size() == incrementalCache2.getSrcFilesInOrderFromKLib().size();
            String string2 = currentIrModule.getName().asString();
            Intrinsics.checkNotNullExpressionValue(string2, "currentIrModule.name.asString()");
            incrementalCache2.commitCacheForRebuiltSrcFiles(string2);
            return new CacheUpdateStatus.Dirty(removed2, dirtySet, updatedAll);
        }

        private static final void getDependencySubGraph$addDependsFor(Map<KotlinLibrary, List<KotlinLibrary>> subGraph, KLibCacheUpdater this$0, KotlinLibrary library) {
            if (subGraph.containsKey(library)) {
                return;
            }
            List<KotlinLibrary> list2 = this$0.dependencyGraph.get(library);
            if (list2 == null) {
                throw new IllegalStateException(("Cannot find dependencies for " + library.getLibraryName()).toString());
            }
            List<KotlinLibrary> dependencies2 = list2;
            subGraph.put(library, dependencies2);
            for (KotlinLibrary dependency : dependencies2) {
                KLibCacheUpdater.getDependencySubGraph$addDependsFor(subGraph, this$0, dependency);
            }
        }
    }
}

