/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.library;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.library.KotlinAbiVersion;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.library.KotlinLibrarySearchPathResolver;
import org.jetbrains.kotlin.library.SearchPathResolver;
import org.jetbrains.kotlin.library.UnresolvedLibrary;
import org.jetbrains.kotlin.util.Logger;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004BS\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\u0010J\u001d\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00028\u00002\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/library/KotlinLibraryProperResolverWithAttributes;", "L", "Lorg/jetbrains/kotlin/library/KotlinLibrary;", "Lorg/jetbrains/kotlin/library/KotlinLibrarySearchPathResolver;", "Lorg/jetbrains/kotlin/library/SearchPathResolver;", "repositories", "", "", "directLibs", "distributionKlib", "localKotlinDir", "skipCurrentDir", "", "logger", "Lorg/jetbrains/kotlin/util/Logger;", "knownIrProviders", "(Ljava/util/List;Ljava/util/List;Ljava/lang/String;Ljava/lang/String;ZLorg/jetbrains/kotlin/util/Logger;Ljava/util/List;)V", "getLogger", "()Lorg/jetbrains/kotlin/util/Logger;", "libraryMatch", "candidate", "unresolved", "Lorg/jetbrains/kotlin/library/UnresolvedLibrary;", "(Lorg/jetbrains/kotlin/library/KotlinLibrary;Lorg/jetbrains/kotlin/library/UnresolvedLibrary;)Z", "kotlin-util-klib"})
public abstract class KotlinLibraryProperResolverWithAttributes<L extends KotlinLibrary>
extends KotlinLibrarySearchPathResolver<L>
implements SearchPathResolver<L> {
    @NotNull
    private final Logger logger;
    @NotNull
    private final List<String> knownIrProviders;

    public KotlinLibraryProperResolverWithAttributes(@NotNull List<String> repositories, @NotNull List<String> directLibs, @Nullable String distributionKlib, @Nullable String localKotlinDir, boolean skipCurrentDir, @NotNull Logger logger, @NotNull List<String> knownIrProviders) {
        Intrinsics.checkNotNullParameter(repositories, "repositories");
        Intrinsics.checkNotNullParameter(directLibs, "directLibs");
        Intrinsics.checkNotNullParameter(logger, "logger");
        Intrinsics.checkNotNullParameter(knownIrProviders, "knownIrProviders");
        super(repositories, directLibs, distributionKlib, localKotlinDir, skipCurrentDir, logger);
        this.logger = logger;
        this.knownIrProviders = knownIrProviders;
    }

    @Override
    @NotNull
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public boolean libraryMatch(@NotNull L candidate2, @NotNull UnresolvedLibrary unresolved) {
        Intrinsics.checkNotNullParameter(candidate2, "candidate");
        Intrinsics.checkNotNullParameter(unresolved, "unresolved");
        String candidatePath = candidate2.getLibraryFile().getAbsolutePath();
        String candidateCompilerVersion = candidate2.getVersions().getCompilerVersion();
        KotlinAbiVersion candidateAbiVersion = candidate2.getVersions().getAbiVersion();
        String candidateLibraryVersion = candidate2.getVersions().getLibraryVersion();
        KotlinAbiVersion kotlinAbiVersion = candidateAbiVersion;
        if (!(kotlinAbiVersion != null ? kotlinAbiVersion.isCompatible() : false)) {
            this.getLogger().warning("skipping " + candidatePath + ". Incompatible abi version. The current default is '" + KotlinAbiVersion.Companion.getCURRENT() + "', found '" + candidateAbiVersion + "'. The library produced by " + candidateCompilerVersion + " compiler");
            return false;
        }
        if (!Intrinsics.areEqual(candidateLibraryVersion, unresolved.getLibraryVersion()) && candidateLibraryVersion != null && unresolved.getLibraryVersion() != null) {
            this.getLogger().warning("skipping " + candidatePath + ". The library versions don't match. Expected '" + unresolved.getLibraryVersion() + "', found '" + candidateLibraryVersion + '\'');
            return false;
        }
        Object object = candidate2.getManifestProperties().get("ir_provider");
        if (object != null) {
            Object it = object;
            boolean bl = false;
            if (!CollectionsKt.contains((Iterable)this.knownIrProviders, it)) {
                this.getLogger().warning("skipping " + candidatePath + ". The library requires unknown IR provider " + it + '.');
                return false;
            }
        }
        return true;
    }
}

