/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.descriptors.annotations.KotlinRetention;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.name.JvmNames;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtAnnotationUseSiteTarget;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.AdditionalAnnotationChecker;
import org.jetbrains.kotlin.resolve.AnnotationChecker;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\n2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/FileClassAnnotationsChecker;", "Lorg/jetbrains/kotlin/resolve/AdditionalAnnotationChecker;", "()V", "alwaysApplicable", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/name/FqName;", "Lkotlin/collections/HashSet;", "checkEntries", "", "entries", "", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "actualTargets", "Lorg/jetbrains/kotlin/descriptors/annotations/KotlinTarget;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "annotated", "Lorg/jetbrains/kotlin/psi/KtAnnotated;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "frontend.java"})
public final class FileClassAnnotationsChecker
implements AdditionalAnnotationChecker {
    @NotNull
    public static final FileClassAnnotationsChecker INSTANCE = new FileClassAnnotationsChecker();
    @NotNull
    private static final HashSet<FqName> alwaysApplicable;

    private FileClassAnnotationsChecker() {
    }

    @Override
    public void checkEntries(@NotNull List<? extends KtAnnotationEntry> entries, @NotNull List<? extends KotlinTarget> actualTargets, @NotNull BindingTrace trace, @Nullable KtAnnotated annotated, @NotNull LanguageVersionSettings languageVersionSettings) {
        ClassDescriptor classDescriptor;
        KtAnnotationEntry entry;
        boolean isMultifileClass;
        ArrayList<Pair<KtAnnotationEntry, Object>> fileAnnotationsToCheck;
        block13: {
            boolean bl;
            Intrinsics.checkNotNullParameter(entries, "entries");
            Intrinsics.checkNotNullParameter(actualTargets, "actualTargets");
            Intrinsics.checkNotNullParameter(trace, "trace");
            Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
            fileAnnotationsToCheck = new ArrayList<Pair<KtAnnotationEntry, Object>>();
            for (KtAnnotationEntry ktAnnotationEntry : entries) {
                Object classDescriptor2;
                Set<KotlinTarget> applicableTargets;
                AnnotationDescriptor pair;
                KtAnnotationUseSiteTarget ktAnnotationUseSiteTarget = ktAnnotationEntry.getUseSiteTarget();
                if ((ktAnnotationUseSiteTarget != null ? ktAnnotationUseSiteTarget.getAnnotationUseSiteTarget() : null) != AnnotationUseSiteTarget.FILE || (AnnotationDescriptor)trace.get(BindingContext.ANNOTATION, ktAnnotationEntry) == null || DescriptorUtilsKt.getAnnotationClass(pair) == null || (applicableTargets = AnnotationChecker.Companion.applicableTargetSetFromTargetAnnotationOrNull((ClassDescriptor)classDescriptor2)) == null || !applicableTargets.contains((Object)KotlinTarget.FILE)) continue;
                fileAnnotationsToCheck.add(new Pair<KtAnnotationEntry, Object>(ktAnnotationEntry, classDescriptor2));
            }
            Iterable iterable = fileAnnotationsToCheck;
            boolean bl2 = false;
            if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : iterable) {
                    Pair it = (Pair)element$iv;
                    boolean bl22 = false;
                    if (!Intrinsics.areEqual(DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)it.getSecond()), JvmNames.INSTANCE.getJVM_MULTIFILE_CLASS())) continue;
                    bl = true;
                    break block13;
                }
                bl = isMultifileClass = false;
            }
        }
        if (isMultifileClass) {
            for (Pair pair : fileAnnotationsToCheck) {
                entry = (KtAnnotationEntry)pair.component1();
                classDescriptor = (ClassDescriptor)pair.component2();
                FqName classFqName = DescriptorUtilsKt.getFqNameSafe(classDescriptor);
                if (alwaysApplicable.contains(classFqName) || DescriptorUtilsKt.getAnnotationRetention(classDescriptor) == KotlinRetention.SOURCE) continue;
                trace.report(ErrorsJvm.ANNOTATION_IS_NOT_APPLICABLE_TO_MULTIFILE_CLASSES.on((KtAnnotationEntry)((PsiElement)entry), classFqName));
            }
        } else {
            for (Pair pair : fileAnnotationsToCheck) {
                boolean bl;
                block14: {
                    String value2;
                    KtStringTemplateEntry[] stringTemplateEntries;
                    entry = (KtAnnotationEntry)pair.component1();
                    classDescriptor = (ClassDescriptor)pair.component2();
                    if (!Intrinsics.areEqual(DescriptorUtilsKt.getFqNameSafe(classDescriptor), JvmNames.INSTANCE.getJVM_PACKAGE_NAME())) continue;
                    List<? extends ValueArgument> list2 = entry.getValueArguments();
                    Intrinsics.checkNotNullExpressionValue(list2, "entry.valueArguments");
                    Object object = CollectionsKt.firstOrNull(list2);
                    if (object == null || (object = object.getArgumentExpression()) == null) continue;
                    Object argumentExpression = object;
                    KtStringTemplateEntry[] ktStringTemplateEntryArray = argumentExpression instanceof KtStringTemplateExpression ? (KtStringTemplateEntry[])argumentExpression : null;
                    if (ktStringTemplateEntryArray == null) continue;
                    if ((ktStringTemplateEntryArray = ktStringTemplateEntryArray.getEntries()) == null || (stringTemplateEntries = ktStringTemplateEntryArray).length > 1) continue;
                    KtStringTemplateEntry ktStringTemplateEntry = ArraysKt.singleOrNull(stringTemplateEntries);
                    KtLiteralStringTemplateEntry ktLiteralStringTemplateEntry = ktStringTemplateEntry instanceof KtLiteralStringTemplateEntry ? (KtLiteralStringTemplateEntry)ktStringTemplateEntry : null;
                    String string2 = value2 = ktLiteralStringTemplateEntry != null ? ktLiteralStringTemplateEntry.getText() : null;
                    if (value2 == null) {
                        trace.report(ErrorsJvm.JVM_PACKAGE_NAME_CANNOT_BE_EMPTY.on((KtAnnotationEntry)((PsiElement)entry)));
                        continue;
                    }
                    if (!FqNamesUtilKt.isValidJavaFqName(value2)) {
                        trace.report(ErrorsJvm.JVM_PACKAGE_NAME_MUST_BE_VALID_NAME.on((KtAnnotationEntry)((PsiElement)entry)));
                        continue;
                    }
                    Iterable $this$any$iv = entry.getContainingKtFile().getDeclarations();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            KtDeclaration it = (KtDeclaration)element$iv;
                            boolean bl3 = false;
                            if (!(!(it instanceof KtFunction) && !(it instanceof KtProperty) && !(it instanceof KtTypeAlias))) continue;
                            bl = true;
                            break block14;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                trace.report(ErrorsJvm.JVM_PACKAGE_NAME_NOT_SUPPORTED_IN_FILES_WITH_CLASSES.on((KtAnnotationEntry)((PsiElement)entry)));
            }
        }
    }

    static {
        FqName[] fqNameArray = new FqName[]{JvmNames.JVM_NAME, JvmNames.INSTANCE.getJVM_MULTIFILE_CLASS()};
        alwaysApplicable = SetsKt.hashSetOf(fqNameArray);
    }
}

