/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.diagnostics.MutableDiagnosticContext;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.ClassSymbolAndProjections;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.collectors.AbstractDiagnosticCollector;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutorByMap;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.types.AbstractTypeChecker;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a8\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u001a\u0010\u0004\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0004\u0012\u00020\b0\u00060\u00052\u0006\u0010\t\u001a\u00020\nH\u0002\u001aD\u0010\u000b\u001a\u00020\f2\u001a\u0010\u0004\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0004\u0012\u00020\b0\u00060\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u00a8\u0006\u0013"}, d2={"buildDeepSubstitutionMultimap", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/ClassSymbolAndProjections;", "firTypeRefClasses", "", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "checkInconsistentTypeParameters", "", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "isValues", "", "checkers"})
public final class FirInconsistentTypeParameterHelpersKt {
    public static final void checkInconsistentTypeParameters(@NotNull List<? extends Pair<? extends FirTypeRef, FirRegularClassSymbol>> firTypeRefClasses, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @Nullable KtSourceElement source2, boolean isValues) {
        Intrinsics.checkNotNullParameter(firTypeRefClasses, "firTypeRefClasses");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Map<FirTypeParameterSymbol, ClassSymbolAndProjections> result2 = FirInconsistentTypeParameterHelpersKt.buildDeepSubstitutionMultimap(firTypeRefClasses, context);
        for (Map.Entry<FirTypeParameterSymbol, ClassSymbolAndProjections> entry : result2.entrySet()) {
            FirTypeParameterSymbol typeParameterSymbol = entry.getKey();
            ClassSymbolAndProjections typeAndProjections = entry.getValue();
            List<ConeKotlinType> projections = typeAndProjections.getProjections();
            if (projections.size() <= 1) continue;
            if (isValues) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source2, FirErrors.INSTANCE.getINCONSISTENT_TYPE_PARAMETER_VALUES(), (Object)typeParameterSymbol, (Object)typeAndProjections.getClassSymbol(), projections, (DiagnosticContext)context, null, 64, null);
                continue;
            }
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source2, FirErrors.INSTANCE.getINCONSISTENT_TYPE_PARAMETER_BOUNDS(), (Object)typeParameterSymbol, (Object)typeAndProjections.getClassSymbol(), projections, (DiagnosticContext)context, null, 64, null);
        }
    }

    private static final Map<FirTypeParameterSymbol, ClassSymbolAndProjections> buildDeepSubstitutionMultimap(List<? extends Pair<? extends FirTypeRef, FirRegularClassSymbol>> firTypeRefClasses, CheckerContext context) {
        Map result2 = new LinkedHashMap();
        Map substitution = new LinkedHashMap();
        Set visitedSupertypes = new LinkedHashSet();
        FirSession session2 = context.getSession();
        ConeInferenceContext typeContext2 = TypeComponentsKt.getTypeContext(session2);
        for (Pair<? extends FirTypeRef, FirRegularClassSymbol> pair : firTypeRefClasses) {
            Object object = pair.getFirst();
            FirInconsistentTypeParameterHelpersKt.buildDeepSubstitutionMultimap$fillInDeepSubstitutor(substitution, session2, result2, visitedSupertypes, typeContext2, object != null && (object = FirTypeUtilsKt.getConeType((FirTypeRef)object)) != null && (object = TypeExpansionUtilsKt.fullyExpandedType((ConeKotlinType)object, session2)) != null ? ((ConeKotlinType)object).getTypeArguments() : null, pair.getSecond(), context);
        }
        return result2;
    }

    private static final void buildDeepSubstitutionMultimap$fillInDeepSubstitutor(Map<FirTypeParameterSymbol, ConeKotlinType> substitution, FirSession session2, Map<FirTypeParameterSymbol, ClassSymbolAndProjections> result2, Set<ConeKotlinType> visitedSupertypes, ConeInferenceContext typeContext2, ConeTypeProjection[] typeArguments2, FirRegularClassSymbol classSymbol, CheckerContext context) {
        if (typeArguments2 != null) {
            List<FirTypeParameterSymbol> typeParameterSymbols = classSymbol.getTypeParameterSymbols();
            int count = Math.min(typeArguments2.length, typeParameterSymbols.size());
            for (int index2 = 0; index2 < count; ++index2) {
                boolean bl;
                List projections;
                ConeKotlinType substitutedType;
                block12: {
                    ConeTypeProjection substitutedArgument;
                    ConeTypeProjection typeArgument = typeArguments2[index2];
                    ConeTypeProjection coneTypeProjection = new ConeSubstitutorByMap(substitution, session2).substituteArgument(typeArgument, classSymbol.toLookupTag(), index2);
                    if (coneTypeProjection == null) {
                        coneTypeProjection = typeArgument;
                    }
                    if (ConeTypeProjectionKt.getType(substitutedArgument = coneTypeProjection) == null) continue;
                    FirTypeParameterSymbol typeParameterSymbol = typeParameterSymbols.get(index2);
                    substitution.put(typeParameterSymbol, substitutedType);
                    ClassSymbolAndProjections classSymbolAndProjections = result2.get(typeParameterSymbol);
                    projections = null;
                    if (classSymbolAndProjections == null) {
                        projections = new ArrayList();
                        classSymbolAndProjections = new ClassSymbolAndProjections(classSymbol, projections);
                        result2.put(typeParameterSymbol, classSymbolAndProjections);
                    } else {
                        projections = classSymbolAndProjections.getProjections();
                    }
                    Iterable $this$all$iv = projections;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            ConeKotlinType it = (ConeKotlinType)element$iv;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual(it, substitutedType) && !AbstractTypeChecker.equalTypes$default(AbstractTypeChecker.INSTANCE, typeContext2, it, substitutedType, false, 8, null)) continue;
                            bl = false;
                            break block12;
                        }
                        bl = true;
                    }
                }
                if (!bl) continue;
                projections.add(substitutedType);
            }
        }
        for (FirResolvedTypeRef superTypeRef : classSymbol.getResolvedSuperTypeRefs()) {
            boolean bl;
            CheckerContext it;
            ConeKotlinType fullyExpandedType2 = TypeExpansionUtilsKt.fullyExpandedType(FirTypeUtilsKt.getConeType(superTypeRef), session2);
            if (!visitedSupertypes.add(fullyExpandedType2)) {
                return;
            }
            FirRegularClassSymbol superClassSymbol = TypeUtilsKt.toRegularClassSymbol(fullyExpandedType2, session2);
            boolean $i$f$withSuppressedDiagnostics = false;
            List<String> arguments$iv = AbstractDiagnosticCollector.Companion.getDiagnosticsSuppressedForContainer(superTypeRef);
            if (arguments$iv != null) {
                DiagnosticContext diagnosticContext = ((MutableDiagnosticContext)context).addSuppressedDiagnostics((Collection<String>)arguments$iv, arguments$iv.contains("infos"), arguments$iv.contains("warnings"), arguments$iv.contains("errors"));
                if (diagnosticContext == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext");
                }
                it = (CheckerContext)((MutableDiagnosticContext)((CheckerContext)diagnosticContext));
                bl = false;
                if (ConeBuiltinTypeUtilsKt.isEnum(fullyExpandedType2) || superClassSymbol == null) continue;
                FirInconsistentTypeParameterHelpersKt.buildDeepSubstitutionMultimap$fillInDeepSubstitutor(substitution, session2, result2, visitedSupertypes, typeContext2, fullyExpandedType2.getTypeArguments(), superClassSymbol, it);
                continue;
            }
            it = (CheckerContext)((MutableDiagnosticContext)context);
            bl = false;
            if (ConeBuiltinTypeUtilsKt.isEnum(fullyExpandedType2) || superClassSymbol == null) continue;
            FirInconsistentTypeParameterHelpersKt.buildDeepSubstitutionMultimap$fillInDeepSubstitutor(substitution, session2, result2, visitedSupertypes, typeContext2, fullyExpandedType2.getTypeArguments(), superClassSymbol, it);
        }
    }
}

