/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.classpathDiff;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0000\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00072\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u0002H\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00050\u00070\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/incremental/classpathDiff/BreadthFirstSearch;", "", "()V", "findReachableNodes", "", "T", "nodes", "", "edgesProvider", "Lkotlin/Function1;", "incremental-compilation-impl"})
public final class BreadthFirstSearch {
    @NotNull
    public static final BreadthFirstSearch INSTANCE = new BreadthFirstSearch();

    private BreadthFirstSearch() {
    }

    @NotNull
    public final <T> Set<T> findReachableNodes(@NotNull Iterable<? extends T> nodes, @NotNull Function1<? super T, ? extends Iterable<? extends T>> edgesProvider) {
        Intrinsics.checkNotNullParameter(nodes, "nodes");
        Intrinsics.checkNotNullParameter(edgesProvider, "edgesProvider");
        Set<T> visitedAndToVisitNodes = CollectionsKt.toMutableSet(nodes);
        ArrayDeque nodesToVisit = new ArrayDeque(CollectionsKt.toSet(nodes));
        while (!((Collection)nodesToVisit).isEmpty()) {
            Object nodeToVisit = nodesToVisit.removeFirst();
            List<? extends T> nextNodesToVisit = CollectionsKt.minus(edgesProvider.invoke(nodeToVisit), (Iterable)visitedAndToVisitNodes);
            visitedAndToVisitNodes.addAll((Collection)nextNodesToVisit);
            nodesToVisit.addAll(nextNodesToVisit);
        }
        return visitedAndToVisitNodes;
    }
}

