/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.pipeline;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporterFactory;
import org.jetbrains.kotlin.diagnostics.KtDiagnostic;
import org.jetbrains.kotlin.diagnostics.impl.BaseDiagnosticsCollector;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.collectors.FirDiagnosticsCollector;
import org.jetbrains.kotlin.fir.analysis.collectors.SimpleDiagnosticsCollector;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.transformers.FirTotalResolveProcessor;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a2\u0010\u0000\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0001*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0003\u001a(\u0010\u0000\u001a\u00020\t*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b\u001a*\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00030\r*\u00020\u00052\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0003\u00a8\u0006\u000e"}, d2={"runCheckers", "", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnostic;", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "firFiles", "", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "runResolution", "Lkotlin/Pair;", "entrypoint"})
public final class AnalyseKt {
    @NotNull
    public static final Pair<ScopeSession, List<FirFile>> runResolution(@NotNull FirSession $this$runResolution, @NotNull List<? extends FirFile> firFiles) {
        Intrinsics.checkNotNullParameter($this$runResolution, "<this>");
        Intrinsics.checkNotNullParameter(firFiles, "firFiles");
        FirTotalResolveProcessor resolveProcessor = new FirTotalResolveProcessor($this$runResolution);
        resolveProcessor.process(firFiles);
        return TuplesKt.to(resolveProcessor.getScopeSession(), firFiles);
    }

    @NotNull
    public static final Map<FirFile, List<KtDiagnostic>> runCheckers(@NotNull FirSession $this$runCheckers, @NotNull ScopeSession scopeSession, @NotNull List<? extends FirFile> firFiles) {
        Map<FirFile, List<KtDiagnostic>> map;
        Intrinsics.checkNotNullParameter($this$runCheckers, "<this>");
        Intrinsics.checkNotNullParameter(scopeSession, "scopeSession");
        Intrinsics.checkNotNullParameter(firFiles, "firFiles");
        SimpleDiagnosticsCollector collector2 = FirDiagnosticsCollector.INSTANCE.create($this$runCheckers, scopeSession);
        Map<FirFile, List<KtDiagnostic>> $this$runCheckers_u24lambda_u240 = map = MapsKt.createMapBuilder();
        boolean bl = false;
        for (FirFile firFile : firFiles) {
            BaseDiagnosticsCollector reporter = DiagnosticReporterFactory.createReporter$default(DiagnosticReporterFactory.INSTANCE, false, 1, null);
            collector2.collectDiagnostics(firFile, reporter);
            $this$runCheckers_u24lambda_u240.put(firFile, reporter.getDiagnostics());
        }
        return MapsKt.build(map);
    }

    public static final void runCheckers(@NotNull FirSession $this$runCheckers, @NotNull ScopeSession scopeSession, @NotNull List<? extends FirFile> firFiles, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter($this$runCheckers, "<this>");
        Intrinsics.checkNotNullParameter(scopeSession, "scopeSession");
        Intrinsics.checkNotNullParameter(firFiles, "firFiles");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        SimpleDiagnosticsCollector collector2 = FirDiagnosticsCollector.INSTANCE.create($this$runCheckers, scopeSession);
        for (FirFile firFile : firFiles) {
            collector2.collectDiagnostics(firFile, reporter);
        }
    }
}

