/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve;

import com.intellij.openapi.util.Pair;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.ConstraintType;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.source.resolve.DefaultParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.PsiOldInferenceHelper;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.scope.MethodProcessorSetupFailedException;
import com.intellij.psi.scope.processor.MethodCandidatesProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtilRt;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ProcessCandidateParameterTypeInferencePolicy
extends DefaultParameterTypeInferencePolicy {
    public static final ProcessCandidateParameterTypeInferencePolicy INSTANCE = new ProcessCandidateParameterTypeInferencePolicy();

    @Override
    public Pair<PsiType, ConstraintType> inferTypeConstraintFromCallContext(PsiExpression innerMethodCall, PsiExpressionList expressionList, @NotNull PsiCallExpression contextCall, PsiTypeParameter typeParameter2) {
        if (contextCall == null) {
            ProcessCandidateParameterTypeInferencePolicy.$$$reportNull$$$0(0);
        }
        PsiExpression[] expressions = expressionList.getExpressions();
        PsiElement parent2 = innerMethodCall;
        while (parent2.getParent() instanceof PsiParenthesizedExpression) {
            parent2 = parent2.getParent();
        }
        int i = ArrayUtilRt.find(expressions, parent2);
        if (i < 0) {
            return null;
        }
        PsiMethod owner = (PsiMethod)typeParameter2.getOwner();
        if (owner == null) {
            return null;
        }
        try {
            JavaResolveResult[] results = this.getResults(contextCall, i);
            PsiType innerReturnType = owner.getReturnType();
            for (JavaResolveResult result2 : results) {
                PsiSubstitutor substitutor2;
                Pair<PsiType, ConstraintType> constraint2;
                if (result2 == null || (constraint2 = ProcessCandidateParameterTypeInferencePolicy.inferConstraint(typeParameter2, innerMethodCall, i, innerReturnType, result2, substitutor2 = this.getSubstitutor(contextCall, expressions, i, result2))) == null) continue;
                return constraint2;
            }
        }
        catch (MethodProcessorSetupFailedException ev) {
            return null;
        }
        return null;
    }

    protected PsiSubstitutor getSubstitutor(PsiCallExpression contextCall, PsiExpression[] expressions, int i, JavaResolveResult result2) {
        if (result2 instanceof MethodCandidateInfo) {
            List<PsiExpression> leftArgs = this.getExpressions(expressions, i);
            return ((MethodCandidateInfo)result2).inferSubstitutorFromArgs(this, leftArgs.toArray(PsiExpression.EMPTY_ARRAY));
        }
        return result2.getSubstitutor();
    }

    protected List<PsiExpression> getExpressions(PsiExpression[] expressions, int i) {
        return Arrays.asList(expressions).subList(0, i);
    }

    protected static Pair<PsiType, ConstraintType> inferConstraint(PsiTypeParameter typeParameter2, PsiExpression innerMethodCall, int parameterIdx, PsiType innerReturnType, JavaResolveResult result2, PsiSubstitutor substitutor2) {
        PsiElement element = result2.getElement();
        if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            PsiParameter[] parameters2 = method.getParameterList().getParameters();
            PsiParameter parameter = null;
            if (parameters2.length > parameterIdx) {
                parameter = parameters2[parameterIdx];
            } else if (method.isVarArgs()) {
                parameter = parameters2[parameters2.length - 1];
            }
            if (parameter != null) {
                PsiParameter finalParameter = parameter;
                PsiType type2 = PsiResolveHelper.ourGuard.doPreventingRecursion(innerMethodCall, true, () -> substitutor2.substitute(finalParameter.getType()));
                LanguageLevel languageLevel = PsiUtil.getLanguageLevel(finalParameter);
                Pair<PsiType, ConstraintType> constraint2 = new PsiOldInferenceHelper(element.getManager()).getSubstitutionForTypeParameterConstraint(typeParameter2, innerReturnType, type2, false, languageLevel);
                if (constraint2 != null) {
                    return constraint2;
                }
            }
        }
        return null;
    }

    protected JavaResolveResult @NotNull [] getResults(@NotNull PsiCallExpression contextCall, int exprIdx) throws MethodProcessorSetupFailedException {
        if (contextCall == null) {
            ProcessCandidateParameterTypeInferencePolicy.$$$reportNull$$$0(1);
        }
        PsiFile containingFile = contextCall.getContainingFile();
        MethodCandidatesProcessor processor2 = new MethodCandidatesProcessor(contextCall, containingFile);
        PsiScopesUtil.setupAndRunProcessor(processor2, contextCall, false);
        JavaResolveResult[] javaResolveResultArray = processor2.getResult();
        if (javaResolveResultArray == null) {
            ProcessCandidateParameterTypeInferencePolicy.$$$reportNull$$$0(2);
        }
        return javaResolveResultArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextCall";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/ProcessCandidateParameterTypeInferencePolicy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/ProcessCandidateParameterTypeInferencePolicy";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getResults";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "inferTypeConstraintFromCallContext";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getResults";
                break;
            }
            case 2: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

