/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.FieldDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.serialization.MutableVersionRequirementTable;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.protobuf.GeneratedMessageLite;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.NullValue;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.serialization.DescriptorSerializer;
import org.jetbrains.kotlin.serialization.SerializerExtension;
import org.jetbrains.kotlin.serialization.SerializerExtensionProtocol;
import org.jetbrains.kotlin.serialization.StringTableImpl;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0016\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0017H\u0016J*\u0010\u0018\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u001a2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\r\u001a\u00020\u001eH\u0016J*\u0010\u001f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020 2\u0006\u0010\r\u001a\u00020!2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020$2\u0006\u0010\r\u001a\u00020%H\u0016J\u0018\u0010&\u001a\u00020\n2\u0006\u0010'\u001a\u00020(2\u0006\u0010\r\u001a\u00020)H\u0016J\u0018\u0010*\u001a\u00020\n2\u0006\u0010+\u001a\u00020,2\u0006\u0010\r\u001a\u00020-H\u0016J\u0018\u0010.\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020/2\u0006\u0010\r\u001a\u000200H\u0016Jm\u00101\u001a\u00020\n\"\u000e\b\u0000\u00102*\b\u0012\u0004\u0012\u0002H203\"\u0014\b\u0001\u00104*\u000e\u0012\u0004\u0012\u0002H2\u0012\u0004\u0012\u0002H405\"\u0004\b\u0002\u00106*\u000e\u0012\u0004\u0012\u0002H2\u0012\u0004\u0012\u0002H4052\u0018\u00107\u001a\u0014\u0012\u0004\u0012\u0002H2\u0012\n\u0012\b\u0012\u0004\u0012\u0002H609082\b\u0010:\u001a\u0004\u0018\u0001H6H\u0002\u00a2\u0006\u0002\u0010;R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006<"}, d2={"Lorg/jetbrains/kotlin/serialization/KotlinSerializerExtensionBase;", "Lorg/jetbrains/kotlin/serialization/SerializerExtension;", "protocol", "Lorg/jetbrains/kotlin/serialization/SerializerExtensionProtocol;", "(Lorg/jetbrains/kotlin/serialization/SerializerExtensionProtocol;)V", "stringTable", "Lorg/jetbrains/kotlin/serialization/StringTableImpl;", "getStringTable", "()Lorg/jetbrains/kotlin/serialization/StringTableImpl;", "serializeClass", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "proto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Class$Builder;", "versionRequirementTable", "Lorg/jetbrains/kotlin/metadata/serialization/MutableVersionRequirementTable;", "childSerializer", "Lorg/jetbrains/kotlin/serialization/DescriptorSerializer;", "serializeConstructor", "Lorg/jetbrains/kotlin/descriptors/ConstructorDescriptor;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Constructor$Builder;", "serializeEnumEntry", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$EnumEntry$Builder;", "serializeFunction", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Function$Builder;", "serializePackage", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Package$Builder;", "serializeProperty", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Property$Builder;", "serializeType", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Type$Builder;", "serializeTypeAlias", "typeAlias", "Lorg/jetbrains/kotlin/descriptors/TypeAliasDescriptor;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$TypeAlias$Builder;", "serializeTypeParameter", "typeParameter", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$TypeParameter$Builder;", "serializeValueParameter", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$ValueParameter$Builder;", "addExtensionOrNull", "MessageType", "Lorg/jetbrains/kotlin/protobuf/GeneratedMessageLite$ExtendableMessage;", "BuilderType", "Lorg/jetbrains/kotlin/protobuf/GeneratedMessageLite$ExtendableBuilder;", "Type", "extension", "Lorg/jetbrains/kotlin/protobuf/GeneratedMessageLite$GeneratedExtension;", "", "value", "(Lorg/jetbrains/kotlin/protobuf/GeneratedMessageLite$ExtendableBuilder;Lorg/jetbrains/kotlin/protobuf/GeneratedMessageLite$GeneratedExtension;Ljava/lang/Object;)V", "serialization"})
public abstract class KotlinSerializerExtensionBase
extends SerializerExtension {
    @NotNull
    private final SerializerExtensionProtocol protocol;
    @NotNull
    private final StringTableImpl stringTable;

    public KotlinSerializerExtensionBase(@NotNull SerializerExtensionProtocol protocol) {
        Intrinsics.checkNotNullParameter(protocol, "protocol");
        this.protocol = protocol;
        this.stringTable = new StringTableImpl();
    }

    @Override
    @NotNull
    public StringTableImpl getStringTable() {
        return this.stringTable;
    }

    @Override
    public void serializeClass(@NotNull ClassDescriptor descriptor2, @NotNull ProtoBuf.Class.Builder proto, @NotNull MutableVersionRequirementTable versionRequirementTable, @NotNull DescriptorSerializer childSerializer) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(proto, "proto");
        Intrinsics.checkNotNullParameter(versionRequirementTable, "versionRequirementTable");
        Intrinsics.checkNotNullParameter(childSerializer, "childSerializer");
        for (AnnotationDescriptor annotation2 : DescriptorUtilsKt.getNonSourceAnnotations(descriptor2)) {
            this.addExtensionOrNull(proto, this.protocol.getClassAnnotation(), this.getAnnotationSerializer().serializeAnnotation(annotation2));
        }
    }

    @Override
    public void serializePackage(@NotNull FqName packageFqName, @NotNull ProtoBuf.Package.Builder proto) {
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        Intrinsics.checkNotNullParameter(proto, "proto");
        proto.setExtension(this.protocol.getPackageFqName(), this.getStringTable().getPackageFqNameIndex(packageFqName));
    }

    @Override
    public void serializeConstructor(@NotNull ConstructorDescriptor descriptor2, @NotNull ProtoBuf.Constructor.Builder proto, @NotNull DescriptorSerializer childSerializer) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(proto, "proto");
        Intrinsics.checkNotNullParameter(childSerializer, "childSerializer");
        for (AnnotationDescriptor annotation2 : DescriptorUtilsKt.getNonSourceAnnotations(descriptor2)) {
            this.addExtensionOrNull(proto, this.protocol.getConstructorAnnotation(), this.getAnnotationSerializer().serializeAnnotation(annotation2));
        }
    }

    @Override
    public void serializeFunction(@NotNull FunctionDescriptor descriptor2, @NotNull ProtoBuf.Function.Builder proto, @Nullable MutableVersionRequirementTable versionRequirementTable, @NotNull DescriptorSerializer childSerializer) {
        block5: {
            List<AnnotationDescriptor> list2;
            List<AnnotationDescriptor> list3;
            ReceiverParameterDescriptor receiverParameterDescriptor;
            Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
            Intrinsics.checkNotNullParameter(proto, "proto");
            Intrinsics.checkNotNullParameter(childSerializer, "childSerializer");
            for (AnnotationDescriptor annotation2 : DescriptorUtilsKt.getNonSourceAnnotations(descriptor2)) {
                this.addExtensionOrNull(proto, this.protocol.getFunctionAnnotation(), this.getAnnotationSerializer().serializeAnnotation(annotation2));
            }
            GeneratedMessageLite.GeneratedExtension<ProtoBuf.Function, List<ProtoBuf.Annotation>> generatedExtension = this.protocol.getFunctionExtensionReceiverAnnotation();
            if (generatedExtension == null) break block5;
            GeneratedMessageLite.GeneratedExtension<ProtoBuf.Function, List<ProtoBuf.Annotation>> extension = generatedExtension;
            boolean bl = false;
            ReceiverParameterDescriptor receiverParameterDescriptor2 = receiverParameterDescriptor = descriptor2.getExtensionReceiverParameter();
            if (receiverParameterDescriptor2 != null) {
                Intrinsics.checkNotNullExpressionValue(receiverParameterDescriptor2, "extensionReceiverParameter");
                list3 = DescriptorUtilsKt.getNonSourceAnnotations(receiverParameterDescriptor);
            } else {
                list3 = list2 = null;
            }
            if (list3 == null) {
                list2 = CollectionsKt.emptyList();
            }
            for (AnnotationDescriptor annotation3 : list2) {
                this.addExtensionOrNull(proto, extension, this.getAnnotationSerializer().serializeAnnotation(annotation3));
            }
        }
    }

    @Override
    public void serializeProperty(@NotNull PropertyDescriptor descriptor2, @NotNull ProtoBuf.Property.Builder proto, @Nullable MutableVersionRequirementTable versionRequirementTable, @NotNull DescriptorSerializer childSerializer) {
        boolean bl;
        GeneratedMessageLite.GeneratedExtension<ProtoBuf.Property, List<ProtoBuf.Annotation>> extension;
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(proto, "proto");
        Intrinsics.checkNotNullParameter(childSerializer, "childSerializer");
        for (AnnotationDescriptor annotation3 : DescriptorUtilsKt.getNonSourceAnnotations(descriptor2)) {
            this.addExtensionOrNull(proto, this.protocol.getPropertyAnnotation(), this.getAnnotationSerializer().serializeAnnotation(annotation3));
        }
        PropertyGetterDescriptor propertyGetterDescriptor = descriptor2.getGetter();
        List<AnnotationDescriptor> list2 = propertyGetterDescriptor != null ? DescriptorUtilsKt.getNonSourceAnnotations(propertyGetterDescriptor) : null;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        for (AnnotationDescriptor annotation2 : list2) {
            this.addExtensionOrNull(proto, this.protocol.getPropertyGetterAnnotation(), this.getAnnotationSerializer().serializeAnnotation(annotation2));
        }
        PropertySetterDescriptor propertySetterDescriptor = descriptor2.getSetter();
        List<AnnotationDescriptor> list3 = propertySetterDescriptor != null ? DescriptorUtilsKt.getNonSourceAnnotations(propertySetterDescriptor) : null;
        if (list3 == null) {
            list3 = CollectionsKt.emptyList();
        }
        for (AnnotationDescriptor annotation2 : list3) {
            this.addExtensionOrNull(proto, this.protocol.getPropertySetterAnnotation(), this.getAnnotationSerializer().serializeAnnotation(annotation2));
        }
        GeneratedMessageLite.GeneratedExtension<ProtoBuf.Property, List<ProtoBuf.Annotation>> generatedExtension = this.protocol.getPropertyExtensionReceiverAnnotation();
        if (generatedExtension != null) {
            List<AnnotationDescriptor> list4;
            List<AnnotationDescriptor> list5;
            ReceiverParameterDescriptor receiverParameterDescriptor;
            extension = generatedExtension;
            bl = false;
            ReceiverParameterDescriptor receiverParameterDescriptor2 = receiverParameterDescriptor = descriptor2.getExtensionReceiverParameter();
            if (receiverParameterDescriptor2 != null) {
                Intrinsics.checkNotNullExpressionValue(receiverParameterDescriptor2, "extensionReceiverParameter");
                list5 = DescriptorUtilsKt.getNonSourceAnnotations(receiverParameterDescriptor);
            } else {
                list5 = list4 = null;
            }
            if (list5 == null) {
                list4 = CollectionsKt.emptyList();
            }
            for (AnnotationDescriptor annotationDescriptor : list4) {
                this.addExtensionOrNull(proto, extension, this.getAnnotationSerializer().serializeAnnotation(annotationDescriptor));
            }
        }
        GeneratedMessageLite.GeneratedExtension<ProtoBuf.Property, List<ProtoBuf.Annotation>> generatedExtension2 = this.protocol.getPropertyBackingFieldAnnotation();
        if (generatedExtension2 != null) {
            List<AnnotationDescriptor> list6;
            List<AnnotationDescriptor> list7;
            FieldDescriptor fieldDescriptor;
            extension = generatedExtension2;
            bl = false;
            FieldDescriptor fieldDescriptor2 = fieldDescriptor = descriptor2.getBackingField();
            if (fieldDescriptor2 != null) {
                Intrinsics.checkNotNullExpressionValue(fieldDescriptor2, "backingField");
                list7 = DescriptorUtilsKt.getNonSourceAnnotations(fieldDescriptor);
            } else {
                list7 = list6 = null;
            }
            if (list7 == null) {
                list6 = CollectionsKt.emptyList();
            }
            for (AnnotationDescriptor annotationDescriptor : list6) {
                this.addExtensionOrNull(proto, extension, this.getAnnotationSerializer().serializeAnnotation(annotationDescriptor));
            }
        }
        GeneratedMessageLite.GeneratedExtension<ProtoBuf.Property, List<ProtoBuf.Annotation>> generatedExtension3 = this.protocol.getPropertyDelegatedFieldAnnotation();
        if (generatedExtension3 != null) {
            List<AnnotationDescriptor> list8;
            List<AnnotationDescriptor> list9;
            FieldDescriptor fieldDescriptor;
            extension = generatedExtension3;
            bl = false;
            FieldDescriptor fieldDescriptor3 = fieldDescriptor = descriptor2.getDelegateField();
            if (fieldDescriptor3 != null) {
                Intrinsics.checkNotNullExpressionValue(fieldDescriptor3, "delegateField");
                list9 = DescriptorUtilsKt.getNonSourceAnnotations(fieldDescriptor);
            } else {
                list9 = list8 = null;
            }
            if (list9 == null) {
                list8 = CollectionsKt.emptyList();
            }
            for (AnnotationDescriptor annotationDescriptor : list8) {
                this.addExtensionOrNull(proto, extension, this.getAnnotationSerializer().serializeAnnotation(annotationDescriptor));
            }
        }
        ConstantValue<?> constantValue = descriptor2.getCompileTimeInitializer();
        if (constantValue == null) {
            return;
        }
        ConstantValue<?> constantInitializer = constantValue;
        if (!(constantInitializer instanceof NullValue)) {
            proto.setExtension(this.protocol.getCompileTimeValue(), this.getAnnotationSerializer().valueProto(constantInitializer).build());
        }
    }

    @Override
    public void serializeEnumEntry(@NotNull ClassDescriptor descriptor2, @NotNull ProtoBuf.EnumEntry.Builder proto) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(proto, "proto");
        for (AnnotationDescriptor annotation2 : DescriptorUtilsKt.getNonSourceAnnotations(descriptor2)) {
            this.addExtensionOrNull(proto, this.protocol.getEnumEntryAnnotation(), this.getAnnotationSerializer().serializeAnnotation(annotation2));
        }
    }

    @Override
    public void serializeValueParameter(@NotNull ValueParameterDescriptor descriptor2, @NotNull ProtoBuf.ValueParameter.Builder proto) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(proto, "proto");
        for (AnnotationDescriptor annotation2 : DescriptorUtilsKt.getNonSourceAnnotations(descriptor2)) {
            this.addExtensionOrNull(proto, this.protocol.getParameterAnnotation(), this.getAnnotationSerializer().serializeAnnotation(annotation2));
        }
    }

    @Override
    public void serializeType(@NotNull KotlinType type2, @NotNull ProtoBuf.Type.Builder proto) {
        Intrinsics.checkNotNullParameter(type2, "type");
        Intrinsics.checkNotNullParameter(proto, "proto");
        for (AnnotationDescriptor annotation2 : DescriptorUtilsKt.getNonSourceAnnotations(type2)) {
            this.addExtensionOrNull(proto, this.protocol.getTypeAnnotation(), this.getAnnotationSerializer().serializeAnnotation(annotation2));
        }
    }

    @Override
    public void serializeTypeParameter(@NotNull TypeParameterDescriptor typeParameter2, @NotNull ProtoBuf.TypeParameter.Builder proto) {
        Intrinsics.checkNotNullParameter(typeParameter2, "typeParameter");
        Intrinsics.checkNotNullParameter(proto, "proto");
        for (AnnotationDescriptor annotation2 : DescriptorUtilsKt.getNonSourceAnnotations(typeParameter2)) {
            this.addExtensionOrNull(proto, this.protocol.getTypeParameterAnnotation(), this.getAnnotationSerializer().serializeAnnotation(annotation2));
        }
    }

    @Override
    public void serializeTypeAlias(@NotNull TypeAliasDescriptor typeAlias, @NotNull ProtoBuf.TypeAlias.Builder proto) {
        Intrinsics.checkNotNullParameter(typeAlias, "typeAlias");
        Intrinsics.checkNotNullParameter(proto, "proto");
    }

    private final <MessageType extends GeneratedMessageLite.ExtendableMessage<MessageType>, BuilderType extends GeneratedMessageLite.ExtendableBuilder<MessageType, BuilderType>, Type> void addExtensionOrNull(GeneratedMessageLite.ExtendableBuilder<MessageType, BuilderType> $this$addExtensionOrNull, GeneratedMessageLite.GeneratedExtension<MessageType, List<Type>> extension, Type value2) {
        if (value2 != null) {
            $this$addExtensionOrNull.addExtension(extension, value2);
        }
    }
}

