/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs.impl;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtModifierList;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006H\u0007J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0018\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0007H\u0007J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u0004H\u0007\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/psi/stubs/impl/ModifierMaskUtils;", "", "()V", "computeMask", "", "hasModifier", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "", "computeMaskFromModifierList", "modifierList", "Lorg/jetbrains/kotlin/psi/KtModifierList;", "maskHasModifier", "mask", "modifierToken", "maskToString", "", "psi"})
@SourceDebugExtension(value={"SMAP\nModifierMaskUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModifierMaskUtils.kt\norg/jetbrains/kotlin/psi/stubs/impl/ModifierMaskUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,69:1\n1#2:70\n*E\n"})
public final class ModifierMaskUtils {
    @NotNull
    public static final ModifierMaskUtils INSTANCE;

    private ModifierMaskUtils() {
    }

    @JvmStatic
    public static final long computeMaskFromModifierList(@NotNull KtModifierList modifierList2) {
        Intrinsics.checkNotNullParameter(modifierList2, "modifierList");
        return ModifierMaskUtils.computeMask((Function1<? super KtModifierKeywordToken, Boolean>)new Function1<KtModifierKeywordToken, Boolean>(modifierList2){
            final /* synthetic */ KtModifierList $modifierList;
            {
                this.$modifierList = $modifierList;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull KtModifierKeywordToken it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return this.$modifierList.hasModifier(it);
            }
        });
    }

    @JvmStatic
    public static final long computeMask(@NotNull Function1<? super KtModifierKeywordToken, Boolean> hasModifier) {
        Intrinsics.checkNotNullParameter(hasModifier, "hasModifier");
        long mask = 0L;
        Intrinsics.checkNotNullExpressionValue(KtTokens.MODIFIER_KEYWORDS_ARRAY, "MODIFIER_KEYWORDS_ARRAY");
        KtModifierKeywordToken[] ktModifierKeywordTokenArray = KtTokens.MODIFIER_KEYWORDS_ARRAY;
        int n = ktModifierKeywordTokenArray.length;
        for (int i = 0; i < n; ++i) {
            int index2 = i;
            KtModifierKeywordToken modifierKeywordToken = ktModifierKeywordTokenArray[i];
            Intrinsics.checkNotNullExpressionValue(modifierKeywordToken, "modifierKeywordToken");
            if (!hasModifier.invoke(modifierKeywordToken).booleanValue()) continue;
            mask |= 1L << index2;
        }
        return mask;
    }

    @JvmStatic
    public static final boolean maskHasModifier(long mask, @NotNull KtModifierKeywordToken modifierToken) {
        boolean bl;
        Intrinsics.checkNotNullParameter(modifierToken, "modifierToken");
        Intrinsics.checkNotNullExpressionValue(KtTokens.MODIFIER_KEYWORDS_ARRAY, "MODIFIER_KEYWORDS_ARRAY");
        int index2 = ArraysKt.indexOf((Object[])KtTokens.MODIFIER_KEYWORDS_ARRAY, modifierToken);
        boolean bl2 = bl = index2 >= 0;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "All KtModifierKeywordTokens should be present in MODIFIER_KEYWORDS_ARRAY";
            throw new AssertionError((Object)string2);
        }
        return (mask & 1L << index2) != 0L;
    }

    @JvmStatic
    @NotNull
    public static final String maskToString(long mask) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        boolean first = true;
        Intrinsics.checkNotNullExpressionValue(KtTokens.MODIFIER_KEYWORDS_ARRAY, "MODIFIER_KEYWORDS_ARRAY");
        for (KtModifierKeywordToken modifierKeyword : KtTokens.MODIFIER_KEYWORDS_ARRAY) {
            Intrinsics.checkNotNullExpressionValue(modifierKeyword, "modifierKeyword");
            if (!ModifierMaskUtils.maskHasModifier(mask, modifierKeyword)) continue;
            if (!first) {
                sb.append(" ");
            }
            sb.append(modifierKeyword.getValue());
            first = false;
        }
        sb.append("]");
        String string2 = sb.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "sb.toString()");
        return string2;
    }

    static {
        boolean bl;
        INSTANCE = new ModifierMaskUtils();
        boolean bl2 = bl = KtTokens.MODIFIER_KEYWORDS_ARRAY.length <= 64;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Current implementation depends on the ability to represent modifier list as bit mask";
            throw new AssertionError((Object)string2);
        }
    }
}

