/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.checkers.diagnostics.factories;

import com.intellij.psi.PsiElement;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.checkers.diagnostics.factories.DebugInfoDiagnosticFactory;
import org.jetbrains.kotlin.checkers.utils.CheckerTestUtil;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.diagnostics.PositioningStrategies;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.diagnostics.rendering.Renderers;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001e2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004:\u0001\u001eB\u0017\b\u0012\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u001f\b\u0012\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJD\u0010\u0011\u001a\u0010\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00020\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016R\u0014\u0010\u0005\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/checkers/diagnostics/factories/DebugInfoDiagnosticFactory1;", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory1;", "Lcom/intellij/psi/PsiElement;", "", "Lorg/jetbrains/kotlin/checkers/diagnostics/factories/DebugInfoDiagnosticFactory;", "name", "severity", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "(Ljava/lang/String;Lorg/jetbrains/kotlin/diagnostics/Severity;)V", "withExplicitDefinitionOnly", "", "(Ljava/lang/String;Lorg/jetbrains/kotlin/diagnostics/Severity;Z)V", "getName", "()Ljava/lang/String;", "privateName", "getWithExplicitDefinitionOnly", "()Z", "createDiagnostic", "Lorg/jetbrains/kotlin/diagnostics/ParametrizedDiagnostic;", "kotlin.jvm.PlatformType", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "dataFlowValueFactory", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/impl/ModuleDescriptorImpl;", "Companion", "frontend"})
public final class DebugInfoDiagnosticFactory1
extends DiagnosticFactory1<PsiElement, String>
implements DebugInfoDiagnosticFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String privateName;
    private final boolean withExplicitDefinitionOnly;
    @NotNull
    private static final DebugInfoDiagnosticFactory1 EXPRESSION_TYPE = Companion.create("EXPRESSION_TYPE", Severity.INFO, true);
    @NotNull
    private static final DebugInfoDiagnosticFactory1 CALLABLE_OWNER = Companion.create("CALLABLE_OWNER", Severity.INFO, true);
    @NotNull
    private static final DebugInfoDiagnosticFactory1 CALL = Companion.create("CALL", Severity.INFO, true);

    @Override
    @NotNull
    public String getName() {
        return "DEBUG_INFO_" + this.privateName;
    }

    @Override
    public boolean getWithExplicitDefinitionOnly() {
        return this.withExplicitDefinitionOnly;
    }

    @Override
    @NotNull
    public ParametrizedDiagnostic<PsiElement> createDiagnostic(@NotNull KtElement element, @NotNull BindingContext bindingContext, @Nullable DataFlowValueFactory dataFlowValueFactory, @Nullable LanguageVersionSettings languageVersionSettings2, @Nullable ModuleDescriptorImpl moduleDescriptor) {
        ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic;
        Pair<Object, Object> pair;
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter(bindingContext, "bindingContext");
        String string2 = this.privateName;
        if (Intrinsics.areEqual(string2, DebugInfoDiagnosticFactory1.EXPRESSION_TYPE.privateName)) {
            pair = CheckerTestUtil.INSTANCE.getTypeInfo(element, bindingContext, dataFlowValueFactory, languageVersionSettings2, moduleDescriptor);
            KotlinType type2 = pair.component1();
            Set dataFlowTypes = (Set)pair.component2();
            parametrizedDiagnostic = this.on((PsiElement)element, Renderers.INSTANCE.renderExpressionType(type2, dataFlowTypes));
        } else if (Intrinsics.areEqual(string2, DebugInfoDiagnosticFactory1.CALL.privateName)) {
            pair = CheckerTestUtil.INSTANCE.getCallDebugInfo(element, bindingContext);
            FqNameUnsafe fqName2 = (FqNameUnsafe)pair.component1();
            String typeCall = (String)pair.component2();
            parametrizedDiagnostic = this.on((PsiElement)element, Renderers.INSTANCE.renderCallInfo(fqName2, typeCall));
        } else if (Intrinsics.areEqual(string2, DebugInfoDiagnosticFactory1.CALLABLE_OWNER.privateName)) {
            ResolvedCall<? extends CallableDescriptor> resolvedCall2;
            Call call2 = CallUtilKt.getCall(element, bindingContext);
            ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2 = call2 != null ? CallUtilKt.getResolvedCall(call2, bindingContext) : null;
            if (resolvedCall2 != null) {
                CallableDescriptor callableDescriptor = resolvedCall2.getResultingDescriptor();
                FqName fqName3 = DescriptorUtilsKt.getFqNameSafe(callableDescriptor);
                DeclarationDescriptor declarationDescriptor = callableDescriptor.getContainingDeclaration();
                Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "callableDescriptor.containingDeclaration");
                String text2 = DebugInfoDiagnosticFactory1.Companion.renderCallableOwner(fqName3, DescriptorUtilsKt.fqNameOrNull(declarationDescriptor), false);
                parametrizedDiagnostic = this.on((PsiElement)element, text2);
            } else {
                parametrizedDiagnostic = this.on((PsiElement)element, "");
            }
        } else {
            throw new NotImplementedError("Creation diagnostic '" + this.getName() + "' isn't supported.");
        }
        ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic2 = parametrizedDiagnostic;
        Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic2, "when (privateName) {\n   \u2026 isn't supported.\")\n    }");
        return parametrizedDiagnostic2;
    }

    private DebugInfoDiagnosticFactory1(String name2, Severity severity) {
        super(severity, PositioningStrategies.DEFAULT);
        this.privateName = name2;
        this.withExplicitDefinitionOnly = false;
    }

    private DebugInfoDiagnosticFactory1(String name2, Severity severity, boolean withExplicitDefinitionOnly) {
        super(severity, PositioningStrategies.DEFAULT);
        this.privateName = name2;
        this.withExplicitDefinitionOnly = withExplicitDefinitionOnly;
    }

    public /* synthetic */ DebugInfoDiagnosticFactory1(String name2, Severity severity, DefaultConstructorMarker $constructor_marker) {
        this(name2, severity);
    }

    public /* synthetic */ DebugInfoDiagnosticFactory1(String name2, Severity severity, boolean withExplicitDefinitionOnly, DefaultConstructorMarker $constructor_marker) {
        this(name2, severity, withExplicitDefinitionOnly);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J \u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0011J\"\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001b\u001a\u00020\u0011H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/checkers/diagnostics/factories/DebugInfoDiagnosticFactory1$Companion;", "", "()V", "CALL", "Lorg/jetbrains/kotlin/checkers/diagnostics/factories/DebugInfoDiagnosticFactory1;", "getCALL", "()Lorg/jetbrains/kotlin/checkers/diagnostics/factories/DebugInfoDiagnosticFactory1;", "CALLABLE_OWNER", "getCALLABLE_OWNER", "EXPRESSION_TYPE", "getEXPRESSION_TYPE", "create", "name", "", "severity", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "withExplicitDefinitionOnly", "", "renderCallableOwner", "callableId", "Lorg/jetbrains/kotlin/name/CallableId;", "ownerId", "Lorg/jetbrains/kotlin/name/ClassId;", "isExplicit", "callableFqName", "Lorg/jetbrains/kotlin/name/FqName;", "ownerFqName", "isImplicit", "frontend"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DebugInfoDiagnosticFactory1 getEXPRESSION_TYPE() {
            return EXPRESSION_TYPE;
        }

        @NotNull
        public final DebugInfoDiagnosticFactory1 getCALLABLE_OWNER() {
            return CALLABLE_OWNER;
        }

        @NotNull
        public final DebugInfoDiagnosticFactory1 getCALL() {
            return CALL;
        }

        @NotNull
        public final DebugInfoDiagnosticFactory1 create(@NotNull String name2, @NotNull Severity severity) {
            Intrinsics.checkNotNullParameter(name2, "name");
            Intrinsics.checkNotNullParameter((Object)severity, "severity");
            return new DebugInfoDiagnosticFactory1(name2, severity, null);
        }

        @NotNull
        public final DebugInfoDiagnosticFactory1 create(@NotNull String name2, @NotNull Severity severity, boolean withExplicitDefinitionOnly) {
            Intrinsics.checkNotNullParameter(name2, "name");
            Intrinsics.checkNotNullParameter((Object)severity, "severity");
            return new DebugInfoDiagnosticFactory1(name2, severity, withExplicitDefinitionOnly, null);
        }

        @NotNull
        public final String renderCallableOwner(@NotNull CallableId callableId, @Nullable ClassId ownerId, boolean isExplicit) {
            Intrinsics.checkNotNullParameter(callableId, "callableId");
            ClassId classId = ownerId;
            return this.renderCallableOwner(callableId.asFqNameForDebugInfo(), classId != null ? classId.asSingleFqName() : null, isExplicit);
        }

        private final String renderCallableOwner(FqName callableFqName, FqName ownerFqName, boolean isImplicit) {
            Object object;
            StringBuilder stringBuilder2;
            StringBuilder $this$renderCallableOwner_u24lambda_u240 = stringBuilder2 = new StringBuilder();
            boolean bl = false;
            $this$renderCallableOwner_u24lambda_u240.append(callableFqName.asString());
            $this$renderCallableOwner_u24lambda_u240.append(" in ");
            if (isImplicit) {
                $this$renderCallableOwner_u24lambda_u240.append("implicit ");
            }
            if ((object = ownerFqName) == null || (object = ((FqName)object).asString()) == null) {
                object = "<unknown>";
            }
            $this$renderCallableOwner_u24lambda_u240.append((String)object);
            String string2 = stringBuilder2.toString();
            Intrinsics.checkNotNullExpressionValue(string2, "StringBuilder().apply(builderAction).toString()");
            return string2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

