/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend;

import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.serialization.mangle.KotlinExportChecker;
import org.jetbrains.kotlin.backend.common.serialization.mangle.MangleUtilsKt;
import org.jetbrains.kotlin.backend.common.serialization.mangle.SpecialDeclarationType;
import org.jetbrains.kotlin.backend.common.serialization.mangle.ir.IrExportCheckerVisitorKt;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.resolve.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.visitors.FirVisitor;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\b\u0012\u0004\u0012\u00020\u00050\u0004B\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u001d\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u000eJ\u001d\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u0012J\u001d\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u0016J\u001d\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u001d\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\r\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u001eJ\u001d\u0010\u001f\u001a\u00020\u00022\u0006\u0010 \u001a\u00020!2\u0006\u0010\r\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\"J\u001d\u0010#\u001a\u00020\u00022\u0006\u0010$\u001a\u00020%2\u0006\u0010\r\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010&J\u001b\u0010'\u001a\u00020\u0002\"\b\b\u0000\u0010(*\u00020)*\u0002H(H\u0002\u00a2\u0006\u0002\u0010*J\u001b\u0010+\u001a\u00020\u0002\"\b\b\u0000\u0010(*\u00020,*\u0002H(H\u0002\u00a2\u0006\u0002\u0010-J\u001b\u0010+\u001a\u00020\u0002\"\b\b\u0000\u0010(*\u00020.*\u0002H(H\u0002\u00a2\u0006\u0002\u0010/\u00a8\u00060"}, d2={"Lorg/jetbrains/kotlin/fir/backend/FirExportCheckerVisitor;", "Lorg/jetbrains/kotlin/fir/visitors/FirVisitor;", "", "Lorg/jetbrains/kotlin/backend/common/serialization/mangle/SpecialDeclarationType;", "Lorg/jetbrains/kotlin/backend/common/serialization/mangle/KotlinExportChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "()V", "check", "declaration", "type", "visitAnonymousFunction", "anonymousFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousFunction;", "data", "(Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousFunction;Lorg/jetbrains/kotlin/backend/common/serialization/mangle/SpecialDeclarationType;)Ljava/lang/Boolean;", "visitAnonymousObject", "anonymousObject", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousObject;", "(Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousObject;Lorg/jetbrains/kotlin/backend/common/serialization/mangle/SpecialDeclarationType;)Ljava/lang/Boolean;", "visitConstructor", "constructor", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "(Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;Lorg/jetbrains/kotlin/backend/common/serialization/mangle/SpecialDeclarationType;)Ljava/lang/Boolean;", "visitElement", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "(Lorg/jetbrains/kotlin/fir/FirElement;Lorg/jetbrains/kotlin/backend/common/serialization/mangle/SpecialDeclarationType;)Ljava/lang/Boolean;", "visitProperty", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "(Lorg/jetbrains/kotlin/fir/declarations/FirProperty;Lorg/jetbrains/kotlin/backend/common/serialization/mangle/SpecialDeclarationType;)Ljava/lang/Boolean;", "visitRegularClass", "regularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "(Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;Lorg/jetbrains/kotlin/backend/common/serialization/mangle/SpecialDeclarationType;)Ljava/lang/Boolean;", "visitSimpleFunction", "simpleFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "(Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;Lorg/jetbrains/kotlin/backend/common/serialization/mangle/SpecialDeclarationType;)Ljava/lang/Boolean;", "globalMemberIsExported", "D", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "(Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;)Z", "isExported", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "(Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;)Z", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "(Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;)Z", "fir2ir"})
@SourceDebugExtension(value={"SMAP\nFirExportCheckerVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirExportCheckerVisitor.kt\norg/jetbrains/kotlin/fir/backend/FirExportCheckerVisitor\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,67:1\n21#2:68\n21#2:69\n21#2:70\n*S KotlinDebug\n*F\n+ 1 FirExportCheckerVisitor.kt\norg/jetbrains/kotlin/fir/backend/FirExportCheckerVisitor\n*L\n30#1:68\n38#1:69\n44#1:70\n*E\n"})
public abstract class FirExportCheckerVisitor
extends FirVisitor<Boolean, SpecialDeclarationType>
implements KotlinExportChecker<FirDeclaration> {
    @Override
    public boolean check(@NotNull FirDeclaration declaration, @NotNull SpecialDeclarationType type2) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter((Object)type2, "type");
        return (Boolean)declaration.accept(this, type2);
    }

    @Override
    @NotNull
    public Boolean visitElement(@NotNull FirElement element, @NotNull SpecialDeclarationType data2) {
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter((Object)data2, "data");
        String string2 = "Should have not been reached";
        throw new NotImplementedError("An operation is not implemented: " + string2);
    }

    private final <D extends FirMemberDeclaration> boolean globalMemberIsExported(D $this$globalMemberIsExported) {
        D $this$visibility$iv = $this$globalMemberIsExported;
        boolean $i$f$getVisibility = false;
        Visibility visibility2 = $this$visibility$iv.getStatus().getVisibility();
        if (visibility2.isPublicAPI() || visibility2 == Visibilities.Internal.INSTANCE) {
            return true;
        }
        if (visibility2 == Visibilities.Local.INSTANCE) {
            return false;
        }
        List<FirAnnotation> list2 = $this$globalMemberIsExported.getAnnotations();
        ClassId classId = ClassId.topLevel(MangleUtilsKt.getPublishedApiAnnotation());
        Intrinsics.checkNotNullExpressionValue(classId, "topLevel(publishedApiAnnotation)");
        return FirAnnotationUtilsKt.hasAnnotation(list2, classId, $this$globalMemberIsExported.getModuleData().getSession()) || this.isPlatformSpecificExported($this$globalMemberIsExported);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final <D extends FirCallableDeclaration> boolean isExported(D $this$isExported) {
        ClassId classId = $this$isExported.getSymbol().getCallableId().getClassId();
        if (classId == null) {
            return this.globalMemberIsExported($this$isExported);
        }
        ClassId classId2 = classId;
        FirMemberDeclaration $this$visibility$iv = $this$isExported;
        boolean $i$f$getVisibility = false;
        if ($this$visibility$iv.getStatus().getVisibility() == Visibilities.Local.INSTANCE) return false;
        FirClassifierSymbol<?> firClassifierSymbol = FirSymbolProviderKt.toSymbol(classId2, $this$isExported.getModuleData().getSession());
        Intrinsics.checkNotNull(firClassifierSymbol);
        if ((Boolean)((FirDeclaration)firClassifierSymbol.getFir()).accept(this, (SpecialDeclarationType)SpecialDeclarationType.REGULAR) == false) return false;
        return true;
    }

    private final <D extends FirClassLikeDeclaration> boolean isExported(D $this$isExported) {
        FirClassLikeDeclaration firClassLikeDeclaration = DeclarationUtilsKt.getContainingDeclaration($this$isExported, $this$isExported.getModuleData().getSession());
        if (firClassLikeDeclaration == null) {
            return this.globalMemberIsExported($this$isExported);
        }
        FirClassLikeDeclaration containingDeclaration = firClassLikeDeclaration;
        FirMemberDeclaration $this$visibility$iv = $this$isExported;
        boolean $i$f$getVisibility = false;
        return $this$visibility$iv.getStatus().getVisibility() != Visibilities.Local.INSTANCE && (Boolean)containingDeclaration.accept(this, SpecialDeclarationType.REGULAR) != false;
    }

    @Override
    @NotNull
    public Boolean visitSimpleFunction(@NotNull FirSimpleFunction simpleFunction, @NotNull SpecialDeclarationType data2) {
        Intrinsics.checkNotNullParameter(simpleFunction, "simpleFunction");
        Intrinsics.checkNotNullParameter((Object)data2, "data");
        return !IrExportCheckerVisitorKt.isAnonymous(simpleFunction.getName()) && this.isExported((FirCallableDeclaration)simpleFunction);
    }

    @Override
    @NotNull
    public Boolean visitRegularClass(@NotNull FirRegularClass regularClass, @NotNull SpecialDeclarationType data2) {
        Intrinsics.checkNotNullParameter(regularClass, "regularClass");
        Intrinsics.checkNotNullParameter((Object)data2, "data");
        if (data2 == SpecialDeclarationType.ANON_INIT) {
            return false;
        }
        if (IrExportCheckerVisitorKt.isAnonymous(regularClass.getName())) {
            return false;
        }
        return this.isExported((FirClassLikeDeclaration)regularClass);
    }

    @Override
    @NotNull
    public Boolean visitConstructor(@NotNull FirConstructor constructor2, @NotNull SpecialDeclarationType data2) {
        Intrinsics.checkNotNullParameter(constructor2, "constructor");
        Intrinsics.checkNotNullParameter((Object)data2, "data");
        FirClassLikeDeclaration firClassLikeDeclaration = DeclarationUtilsKt.firClassLike(constructor2.getReturnTypeRef(), constructor2.getModuleData().getSession());
        Intrinsics.checkNotNull(firClassLikeDeclaration);
        return this.isExported(firClassLikeDeclaration);
    }

    @Override
    @NotNull
    public Boolean visitProperty(@NotNull FirProperty property, @NotNull SpecialDeclarationType data2) {
        Intrinsics.checkNotNullParameter(property, "property");
        Intrinsics.checkNotNullParameter((Object)data2, "data");
        return this.isExported((FirCallableDeclaration)property);
    }

    @Override
    @NotNull
    public Boolean visitAnonymousFunction(@NotNull FirAnonymousFunction anonymousFunction2, @NotNull SpecialDeclarationType data2) {
        Intrinsics.checkNotNullParameter(anonymousFunction2, "anonymousFunction");
        Intrinsics.checkNotNullParameter((Object)data2, "data");
        return false;
    }

    @Override
    @NotNull
    public Boolean visitAnonymousObject(@NotNull FirAnonymousObject anonymousObject, @NotNull SpecialDeclarationType data2) {
        Intrinsics.checkNotNullParameter(anonymousObject, "anonymousObject");
        Intrinsics.checkNotNullParameter((Object)data2, "data");
        return false;
    }
}

