/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.serialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.caches.FirCache;
import org.jetbrains.kotlin.fir.caches.FirCachesFactory;
import org.jetbrains.kotlin.fir.caches.FirCachesFactoryKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.extensions.FirDeclarationsForMetadataProviderExtension;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.serialization.FirProvidedDeclarationsForMetadataService;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001fB\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u001c\u0010\u0012\u001a\u00020\r2\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\u0014\u001a\u00020\u000eH\u0002J\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u00052\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u000eH\u0002J\"\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00052\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\u0014\u001a\u00020\u000eH\u0016J\"\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00052\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\u0014\u001a\u00020\u000eH\u0016J&\u0010\u001c\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001d0\u00052\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\u0014\u001a\u00020\u000eH\u0016J\u001e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00110\u00052\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u000eH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\n\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u000f\u001a\u001a\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u0005\u0012\u0004\u0012\u00020\u000e0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/fir/serialization/FirProvidedDeclarationsForMetadataServiceImpl;", "Lorg/jetbrains/kotlin/fir/serialization/FirProvidedDeclarationsForMetadataService;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "extensionDeclarationProviders", "", "Lorg/jetbrains/kotlin/fir/extensions/FirDeclarationsForMetadataProviderExtension;", "(Lorg/jetbrains/kotlin/fir/FirSession;Ljava/util/List;)V", "cachesFactory", "Lorg/jetbrains/kotlin/fir/caches/FirCachesFactory;", "membersCache", "Lorg/jetbrains/kotlin/fir/caches/FirCache;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "Lorg/jetbrains/kotlin/fir/serialization/FirProvidedDeclarationsForMetadataServiceImpl$ClassDeclarations;", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "topLevelsCache", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "computeMemberDeclarations", "symbol", "scopeSession", "computeTopLevelDeclarations", "packageFqName", "getProvidedCallables", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "owner", "getProvidedConstructors", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "getProvidedNestedClassifiers", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "getProvidedTopLevelDeclarations", "ClassDeclarations", "fir-serialization"})
final class FirProvidedDeclarationsForMetadataServiceImpl
extends FirProvidedDeclarationsForMetadataService {
    @NotNull
    private final List<FirDeclarationsForMetadataProviderExtension> extensionDeclarationProviders;
    @NotNull
    private final FirCachesFactory cachesFactory;
    @NotNull
    private final FirCache<FqName, List<FirDeclaration>, ScopeSession> topLevelsCache;
    @NotNull
    private final FirCache<FirClassSymbol<?>, ClassDeclarations, ScopeSession> membersCache;

    public FirProvidedDeclarationsForMetadataServiceImpl(@NotNull FirSession session, @NotNull List<? extends FirDeclarationsForMetadataProviderExtension> extensionDeclarationProviders) {
        Intrinsics.checkNotNullParameter(session, "session");
        Intrinsics.checkNotNullParameter(extensionDeclarationProviders, "extensionDeclarationProviders");
        this.extensionDeclarationProviders = extensionDeclarationProviders;
        this.cachesFactory = FirCachesFactoryKt.getFirCachesFactory(session);
        this.topLevelsCache = this.cachesFactory.createCache((Function2)new Function2<FqName, ScopeSession, List<? extends FirDeclaration>>((Object)this){

            @NotNull
            public final List<FirDeclaration> invoke(@NotNull FqName p0, @NotNull ScopeSession p1) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                Intrinsics.checkNotNullParameter(p1, "p1");
                return FirProvidedDeclarationsForMetadataServiceImpl.access$computeTopLevelDeclarations((FirProvidedDeclarationsForMetadataServiceImpl)this.receiver, p0, p1);
            }

            @NotNull
            public final String getSignature() {
                return "computeTopLevelDeclarations(Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;)Ljava/util/List;";
            }

            @NotNull
            public final String getName() {
                return "computeTopLevelDeclarations";
            }

            @NotNull
            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(FirProvidedDeclarationsForMetadataServiceImpl.class);
            }
        });
        this.membersCache = this.cachesFactory.createCache(new Function2<FirClassSymbol<?>, ScopeSession, ClassDeclarations>(this){

            @NotNull
            public final ClassDeclarations invoke(@NotNull FirClassSymbol<?> p0, @NotNull ScopeSession p1) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                Intrinsics.checkNotNullParameter(p1, "p1");
                return FirProvidedDeclarationsForMetadataServiceImpl.access$computeMemberDeclarations((FirProvidedDeclarationsForMetadataServiceImpl)this.receiver, p0, p1);
            }

            @NotNull
            public final String getSignature() {
                return "computeMemberDeclarations(Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;)Lorg/jetbrains/kotlin/fir/serialization/FirProvidedDeclarationsForMetadataServiceImpl$ClassDeclarations;";
            }

            @NotNull
            public final String getName() {
                return "computeMemberDeclarations";
            }

            @NotNull
            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(FirProvidedDeclarationsForMetadataServiceImpl.class);
            }
        });
    }

    private final List<FirDeclaration> computeTopLevelDeclarations(FqName packageFqName, ScopeSession scopeSession) {
        List<FirDeclaration> list2;
        List<FirDeclaration> $this$computeTopLevelDeclarations_u24lambda_u240 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        for (FirDeclarationsForMetadataProviderExtension extensionProvider : this.extensionDeclarationProviders) {
            for (FirDeclaration declaration : extensionProvider.provideTopLevelDeclarations(packageFqName, scopeSession)) {
                $this$computeTopLevelDeclarations_u24lambda_u240.add(declaration);
            }
        }
        return CollectionsKt.build(list2);
    }

    @Override
    @NotNull
    public List<FirDeclaration> getProvidedTopLevelDeclarations(@NotNull FqName packageFqName, @NotNull ScopeSession scopeSession) {
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        Intrinsics.checkNotNullParameter(scopeSession, "scopeSession");
        return this.topLevelsCache.getValue(packageFqName, scopeSession);
    }

    @Override
    @NotNull
    public List<FirConstructor> getProvidedConstructors(@NotNull FirClassSymbol<?> owner, @NotNull ScopeSession scopeSession) {
        Intrinsics.checkNotNullParameter(owner, "owner");
        Intrinsics.checkNotNullParameter(scopeSession, "scopeSession");
        return this.membersCache.getValue(owner, scopeSession).getProvidedConstructors();
    }

    @Override
    @NotNull
    public List<FirCallableDeclaration> getProvidedCallables(@NotNull FirClassSymbol<?> owner, @NotNull ScopeSession scopeSession) {
        Intrinsics.checkNotNullParameter(owner, "owner");
        Intrinsics.checkNotNullParameter(scopeSession, "scopeSession");
        return this.membersCache.getValue(owner, scopeSession).getProvidedCallables();
    }

    @Override
    @NotNull
    public List<FirClassLikeSymbol<?>> getProvidedNestedClassifiers(@NotNull FirClassSymbol<?> owner, @NotNull ScopeSession scopeSession) {
        Intrinsics.checkNotNullParameter(owner, "owner");
        Intrinsics.checkNotNullParameter(scopeSession, "scopeSession");
        return this.membersCache.getValue(owner, scopeSession).getProvidedNestedClasses();
    }

    private final ClassDeclarations computeMemberDeclarations(FirClassSymbol<?> symbol2, ScopeSession scopeSession) {
        List providedCallables = new ArrayList();
        List providedConstructors = new ArrayList();
        List providedNestedClassifiers = new ArrayList();
        for (FirDeclarationsForMetadataProviderExtension extensionProvider : this.extensionDeclarationProviders) {
            for (FirDeclaration declaration : extensionProvider.provideDeclarationsForClass((FirClass)symbol2.getFir(), scopeSession)) {
                FirDeclaration firDeclaration = declaration;
                if (firDeclaration instanceof FirConstructor) {
                    ((Collection)providedConstructors).add(declaration);
                    continue;
                }
                if (firDeclaration instanceof FirCallableDeclaration) {
                    ((Collection)providedCallables).add(declaration);
                    continue;
                }
                if (firDeclaration instanceof FirClassLikeDeclaration) {
                    ((Collection)providedNestedClassifiers).add(((FirClassLikeDeclaration)declaration).getSymbol());
                    continue;
                }
                throw new IllegalStateException(("Unsupported declaration type in: " + symbol2 + ' ' + UtilsKt.render(declaration)).toString());
            }
        }
        return new ClassDeclarations(providedCallables, providedConstructors, providedNestedClassifiers);
    }

    public static final /* synthetic */ List access$computeTopLevelDeclarations(FirProvidedDeclarationsForMetadataServiceImpl $this, FqName packageFqName, ScopeSession scopeSession) {
        return $this.computeTopLevelDeclarations(packageFqName, scopeSession);
    }

    public static final /* synthetic */ ClassDeclarations access$computeMemberDeclarations(FirProvidedDeclarationsForMetadataServiceImpl $this, FirClassSymbol symbol2, ScopeSession scopeSession) {
        return $this.computeMemberDeclarations(symbol2, scopeSession);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B3\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u0010\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0003\u00a2\u0006\u0002\u0010\tJ\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0003J\u0013\u0010\u0010\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0003H\u00c6\u0003J=\u0010\u0011\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u00032\u0012\b\u0002\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u001b\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/fir/serialization/FirProvidedDeclarationsForMetadataServiceImpl$ClassDeclarations;", "", "providedCallables", "", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "providedConstructors", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "providedNestedClasses", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getProvidedCallables", "()Ljava/util/List;", "getProvidedConstructors", "getProvidedNestedClasses", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "fir-serialization"})
    private static final class ClassDeclarations {
        @NotNull
        private final List<FirCallableDeclaration> providedCallables;
        @NotNull
        private final List<FirConstructor> providedConstructors;
        @NotNull
        private final List<FirClassLikeSymbol<?>> providedNestedClasses;

        public ClassDeclarations(@NotNull List<? extends FirCallableDeclaration> providedCallables, @NotNull List<? extends FirConstructor> providedConstructors, @NotNull List<? extends FirClassLikeSymbol<?>> providedNestedClasses) {
            Intrinsics.checkNotNullParameter(providedCallables, "providedCallables");
            Intrinsics.checkNotNullParameter(providedConstructors, "providedConstructors");
            Intrinsics.checkNotNullParameter(providedNestedClasses, "providedNestedClasses");
            this.providedCallables = providedCallables;
            this.providedConstructors = providedConstructors;
            this.providedNestedClasses = providedNestedClasses;
        }

        @NotNull
        public final List<FirCallableDeclaration> getProvidedCallables() {
            return this.providedCallables;
        }

        @NotNull
        public final List<FirConstructor> getProvidedConstructors() {
            return this.providedConstructors;
        }

        @NotNull
        public final List<FirClassLikeSymbol<?>> getProvidedNestedClasses() {
            return this.providedNestedClasses;
        }

        @NotNull
        public final List<FirCallableDeclaration> component1() {
            return this.providedCallables;
        }

        @NotNull
        public final List<FirConstructor> component2() {
            return this.providedConstructors;
        }

        @NotNull
        public final List<FirClassLikeSymbol<?>> component3() {
            return this.providedNestedClasses;
        }

        @NotNull
        public final ClassDeclarations copy(@NotNull List<? extends FirCallableDeclaration> providedCallables, @NotNull List<? extends FirConstructor> providedConstructors, @NotNull List<? extends FirClassLikeSymbol<?>> providedNestedClasses) {
            Intrinsics.checkNotNullParameter(providedCallables, "providedCallables");
            Intrinsics.checkNotNullParameter(providedConstructors, "providedConstructors");
            Intrinsics.checkNotNullParameter(providedNestedClasses, "providedNestedClasses");
            return new ClassDeclarations(providedCallables, providedConstructors, providedNestedClasses);
        }

        public static /* synthetic */ ClassDeclarations copy$default(ClassDeclarations classDeclarations, List list2, List list3, List list4, int n, Object object) {
            if ((n & 1) != 0) {
                list2 = classDeclarations.providedCallables;
            }
            if ((n & 2) != 0) {
                list3 = classDeclarations.providedConstructors;
            }
            if ((n & 4) != 0) {
                list4 = classDeclarations.providedNestedClasses;
            }
            return classDeclarations.copy(list2, list3, list4);
        }

        @NotNull
        public String toString() {
            return "ClassDeclarations(providedCallables=" + this.providedCallables + ", providedConstructors=" + this.providedConstructors + ", providedNestedClasses=" + this.providedNestedClasses + ')';
        }

        public int hashCode() {
            int result2 = ((Object)this.providedCallables).hashCode();
            result2 = result2 * 31 + ((Object)this.providedConstructors).hashCode();
            result2 = result2 * 31 + ((Object)this.providedNestedClasses).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ClassDeclarations)) {
                return false;
            }
            ClassDeclarations classDeclarations = (ClassDeclarations)other;
            if (!Intrinsics.areEqual(this.providedCallables, classDeclarations.providedCallables)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.providedConstructors, classDeclarations.providedConstructors)) {
                return false;
            }
            return Intrinsics.areEqual(this.providedNestedClasses, classDeclarations.providedNestedClasses);
        }
    }
}

