/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.classpathDiff;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.ChangesEither;
import org.jetbrains.kotlin.incremental.LookupSymbol;
import org.jetbrains.kotlin.incremental.classpathDiff.AccessibleClassSnapshot;
import org.jetbrains.kotlin.incremental.classpathDiff.ClassMember;
import org.jetbrains.kotlin.incremental.classpathDiff.ClassSymbol;
import org.jetbrains.kotlin.incremental.classpathDiff.JavaClassSnapshot;
import org.jetbrains.kotlin.incremental.classpathDiff.LookupSymbolSet;
import org.jetbrains.kotlin.incremental.classpathDiff.MultifileClassKotlinClassSnapshot;
import org.jetbrains.kotlin.incremental.classpathDiff.PackageFacadeKotlinClassSnapshot;
import org.jetbrains.kotlin.incremental.classpathDiff.PackageMember;
import org.jetbrains.kotlin.incremental.classpathDiff.ProgramSymbol;
import org.jetbrains.kotlin.incremental.classpathDiff.ProgramSymbolSet;
import org.jetbrains.kotlin.incremental.classpathDiff.RegularKotlinClassSnapshot;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\f\u0010\u0003\u001a\u00020\u0004*\u00020\u0005H\u0000\u001a \u0010\u0006\u001a\u00020\u0002*\b\u0012\u0004\u0012\u00020\u00040\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0000\u00a8\u0006\u000b"}, d2={"toChangesEither", "Lorg/jetbrains/kotlin/incremental/ChangesEither$Known;", "Lorg/jetbrains/kotlin/incremental/classpathDiff/ProgramSymbolSet;", "toLookupSymbol", "Lorg/jetbrains/kotlin/incremental/LookupSymbol;", "Lorg/jetbrains/kotlin/incremental/classpathDiff/ProgramSymbol;", "toProgramSymbolSet", "", "allClasses", "", "Lorg/jetbrains/kotlin/incremental/classpathDiff/AccessibleClassSnapshot;", "incremental-compilation-impl"})
@SourceDebugExtension(value={"SMAP\nProgramSymbol.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProgramSymbol.kt\norg/jetbrains/kotlin/incremental/classpathDiff/ProgramSymbolKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,197:1\n1855#2,2:198\n1313#3,2:200\n*S KotlinDebug\n*F\n+ 1 ProgramSymbol.kt\norg/jetbrains/kotlin/incremental/classpathDiff/ProgramSymbolKt\n*L\n151#1:198,2\n185#1:200,2\n*E\n"})
public final class ProgramSymbolKt {
    @NotNull
    public static final LookupSymbol toLookupSymbol(@NotNull ProgramSymbol $this$toLookupSymbol) {
        LookupSymbol lookupSymbol;
        Intrinsics.checkNotNullParameter($this$toLookupSymbol, "<this>");
        ProgramSymbol programSymbol = $this$toLookupSymbol;
        if (programSymbol instanceof ClassSymbol) {
            FqName it = ((ClassSymbol)$this$toLookupSymbol).getClassId().asSingleFqName();
            boolean bl = false;
            String string2 = it.shortName().asString();
            Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
            String string3 = it.parent().asString();
            Intrinsics.checkNotNullExpressionValue(string3, "asString(...)");
            lookupSymbol = new LookupSymbol(string2, string3);
        } else if (programSymbol instanceof ClassMember) {
            String string4 = ((ClassMember)$this$toLookupSymbol).getMemberName();
            String string5 = ((ClassMember)$this$toLookupSymbol).getClassId().asSingleFqName().asString();
            Intrinsics.checkNotNullExpressionValue(string5, "asString(...)");
            lookupSymbol = new LookupSymbol(string4, string5);
        } else if (programSymbol instanceof PackageMember) {
            String string6 = ((PackageMember)$this$toLookupSymbol).getMemberName();
            String string7 = ((PackageMember)$this$toLookupSymbol).getPackageFqName().asString();
            Intrinsics.checkNotNullExpressionValue(string7, "asString(...)");
            lookupSymbol = new LookupSymbol(string6, string7);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return lookupSymbol;
    }

    @NotNull
    public static final ProgramSymbolSet toProgramSymbolSet(@NotNull Collection<LookupSymbol> $this$toProgramSymbolSet, @NotNull Iterable<? extends AccessibleClassSnapshot> allClasses) {
        Intrinsics.checkNotNullParameter($this$toProgramSymbolSet, "<this>");
        Intrinsics.checkNotNullParameter(allClasses, "allClasses");
        LookupSymbolSet lookupSymbols2 = new LookupSymbolSet((Iterable<LookupSymbol>)$this$toProgramSymbolSet);
        ProgramSymbolSet.Collector collector2 = new ProgramSymbolSet.Collector();
        Iterable<? extends AccessibleClassSnapshot> $this$forEach$iv = allClasses;
        boolean $i$f$forEach = false;
        Iterator<? extends AccessibleClassSnapshot> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Set<String> set;
            Set<String> lookupNamesInScope;
            AccessibleClassSnapshot element$iv;
            AccessibleClassSnapshot clazz = element$iv = iterator2.next();
            boolean bl = false;
            AccessibleClassSnapshot accessibleClassSnapshot = clazz;
            if (accessibleClassSnapshot instanceof RegularKotlinClassSnapshot ? true : accessibleClassSnapshot instanceof JavaClassSnapshot) {
                if (lookupSymbols2.contains(ProgramSymbolKt.toLookupSymbol(new ClassSymbol(clazz.getClassId())))) {
                    collector2.addClass(clazz.getClassId());
                }
                FqName fqName2 = clazz.getClassId().asSingleFqName();
                Intrinsics.checkNotNullExpressionValue(fqName2, "asSingleFqName(...)");
                lookupNamesInScope = lookupSymbols2.getLookupNamesInScope(fqName2);
                collector2.addClassMembers(clazz.getClassId(), (Collection<String>)lookupNamesInScope);
                continue;
            }
            if (!(accessibleClassSnapshot instanceof PackageFacadeKotlinClassSnapshot ? true : accessibleClassSnapshot instanceof MultifileClassKotlinClassSnapshot)) continue;
            FqName fqName3 = clazz.getClassId().getPackageFqName();
            Intrinsics.checkNotNullExpressionValue(fqName3, "getPackageFqName(...)");
            lookupNamesInScope = lookupSymbols2.getLookupNamesInScope(fqName3);
            if (lookupNamesInScope.isEmpty()) continue;
            if (clazz instanceof PackageFacadeKotlinClassSnapshot) {
                set = ((PackageFacadeKotlinClassSnapshot)clazz).getPackageMemberNames();
            } else {
                Intrinsics.checkNotNull(clazz, "null cannot be cast to non-null type org.jetbrains.kotlin.incremental.classpathDiff.MultifileClassKotlinClassSnapshot");
                set = ((MultifileClassKotlinClassSnapshot)clazz).getConstantNames();
            }
            Set<String> packageMemberNames = set;
            FqName fqName4 = clazz.getClassId().getPackageFqName();
            Intrinsics.checkNotNullExpressionValue(fqName4, "getPackageFqName(...)");
            collector2.addPackageMembers(fqName4, CollectionsKt.intersect((Iterable)packageMemberNames, (Iterable)lookupNamesInScope));
        }
        return collector2.getResult();
    }

    @NotNull
    public static final ChangesEither.Known toChangesEither(@NotNull ProgramSymbolSet $this$toChangesEither) {
        Intrinsics.checkNotNullParameter($this$toChangesEither, "<this>");
        Set lookupSymbols2 = new LinkedHashSet();
        Set fqNames = new LinkedHashSet();
        Sequence<ProgramSymbol> $this$forEach$iv = $this$toChangesEither.asSequence();
        boolean $i$f$forEach = false;
        Iterator<ProgramSymbol> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            FqName fqName2;
            ProgramSymbol element$iv;
            ProgramSymbol it = element$iv = iterator2.next();
            boolean bl = false;
            lookupSymbols2.add(ProgramSymbolKt.toLookupSymbol(it));
            ProgramSymbol programSymbol = it;
            if (programSymbol instanceof ClassSymbol) {
                fqName2 = ((ClassSymbol)it).getClassId().asSingleFqName();
            } else if (programSymbol instanceof ClassMember) {
                fqName2 = ((ClassMember)it).getClassId().asSingleFqName();
            } else if (programSymbol instanceof PackageMember) {
                fqName2 = ((PackageMember)it).getPackageFqName();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            FqName fqName3 = fqName2;
            Intrinsics.checkNotNull(fqName3);
            FqName fqName4 = fqName3;
            fqNames.add(fqName4);
        }
        return new ChangesEither.Known(lookupSymbols2, fqNames);
    }
}

