/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.compiler.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.compiler.plugin.AbstractCliOption;
import org.jetbrains.kotlin.compiler.plugin.CliOptionValue;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001c\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u001a\u001e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u0001\u001a\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0001\u001a\u0010\u0010\f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0001\u00a8\u0006\r"}, d2={"cliPluginUsageString", "", "pluginId", "options", "", "Lorg/jetbrains/kotlin/compiler/plugin/AbstractCliOption;", "getPluginOptionString", "key", "value", "parseLegacyPluginOption", "Lorg/jetbrains/kotlin/compiler/plugin/CliOptionValue;", "argumentValue", "parseModernPluginOption", "plugin-api"})
@SourceDebugExtension(value={"SMAP\nCliOptions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CliOptions.kt\norg/jetbrains/kotlin/compiler/plugin/CliOptionsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,101:1\n1549#2:102\n1620#2,2:103\n1622#2:107\n226#3:105\n226#3:106\n*S KotlinDebug\n*F\n+ 1 CliOptions.kt\norg/jetbrains/kotlin/compiler/plugin/CliOptionsKt\n*L\n53#1:102\n53#1:103,2\n53#1:107\n60#1:105\n61#1:106\n*E\n"})
public final class CliOptionsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String cliPluginUsageString(@NotNull String pluginId, @NotNull Collection<? extends AbstractCliOption> options) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(pluginId, "pluginId");
        Intrinsics.checkNotNullParameter(options, "options");
        int LEFT_INDENT = 2;
        int MAX_OPTION_WIDTH = 26;
        Iterable $this$map$iv = options;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string2;
            String string3;
            String string4;
            String[] stringArray;
            int n;
            String[] stringArray2;
            void it;
            AbstractCliOption abstractCliOption = (AbstractCliOption)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String name2 = it.getOptionName() + ' ' + it.getValueDescription();
            String margin = name2.length() > MAX_OPTION_WIDTH ? '\n' + StringsKt.repeat(" ", MAX_OPTION_WIDTH + LEFT_INDENT + 1) : StringsKt.repeat(" ", 1 + MAX_OPTION_WIDTH - name2.length());
            String[] stringArray3 = stringArray2 = new String[2];
            int n2 = 0;
            boolean condition$iv = it.getRequired();
            boolean $i$f$runIf = false;
            if (condition$iv) {
                n = n2;
                stringArray = stringArray3;
                boolean bl2 = false;
                string4 = "required";
                stringArray3 = stringArray;
                n2 = n;
                string3 = string4;
            } else {
                string3 = null;
            }
            stringArray3[n2] = string3;
            String[] stringArray4 = stringArray2;
            int n3 = 1;
            condition$iv = it.getAllowMultipleOccurrences();
            $i$f$runIf = false;
            if (condition$iv) {
                n = n3;
                stringArray = stringArray4;
                boolean bl3 = false;
                string4 = "multiple";
                stringArray4 = stringArray;
                n3 = n;
                string2 = string4;
            } else {
                string2 = null;
            }
            stringArray4[n3] = string2;
            List<String> modifiers = CollectionsKt.listOfNotNull(stringArray2);
            String modifiersEnclosed = modifiers.isEmpty() ? "" : " (" + CollectionsKt.joinToString$default(modifiers, null, null, null, 0, null, null, 63, null) + ')';
            collection.add(StringsKt.repeat(" ", LEFT_INDENT) + name2 + margin + it.getDescription() + modifiersEnclosed);
        }
        List renderedOptions = (List)destination$iv$iv;
        return "Plugin \"" + pluginId + "\" usage:\n" + CollectionsKt.joinToString$default(renderedOptions, "\n", null, "\n", 0, null, null, 58, null);
    }

    @Nullable
    public static final CliOptionValue parseLegacyPluginOption(@NotNull String argumentValue) {
        Intrinsics.checkNotNullParameter(argumentValue, "argumentValue");
        Pattern pattern = Pattern.compile("^plugin:([^:]*):([^=]*)=(.*)$");
        Matcher matcher = pattern.matcher(argumentValue);
        if (matcher.matches()) {
            String string2 = matcher.group(1);
            Intrinsics.checkNotNullExpressionValue(string2, "group(...)");
            String string3 = matcher.group(2);
            Intrinsics.checkNotNullExpressionValue(string3, "group(...)");
            String string4 = matcher.group(3);
            Intrinsics.checkNotNullExpressionValue(string4, "group(...)");
            return new CliOptionValue(string2, string3, string4);
        }
        return null;
    }

    @Nullable
    public static final CliOptionValue parseModernPluginOption(@NotNull String argumentValue) {
        Intrinsics.checkNotNullParameter(argumentValue, "argumentValue");
        Pattern pattern = Pattern.compile("^([^=]*)=(.*)$");
        Matcher matcher = pattern.matcher(argumentValue);
        if (matcher.matches()) {
            String string2 = matcher.group(1);
            Intrinsics.checkNotNullExpressionValue(string2, "group(...)");
            String string3 = matcher.group(2);
            Intrinsics.checkNotNullExpressionValue(string3, "group(...)");
            return new CliOptionValue("<NO_ID>", string2, string3);
        }
        return null;
    }

    @NotNull
    public static final String getPluginOptionString(@NotNull String pluginId, @NotNull String key, @NotNull String value2) {
        Intrinsics.checkNotNullParameter(pluginId, "pluginId");
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(value2, "value");
        return "plugin:" + pluginId + ':' + key + '=' + value2;
    }
}

