/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.collectors;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.collectors.CheckerRunningDiagnosticCollectorVisitor;
import org.jetbrains.kotlin.fir.analysis.collectors.DiagnosticCollectorComponents;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirConstExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.SessionHolder;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolver;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\bJ\u000e\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\bJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\tH$R \u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/collectors/AbstractDiagnosticCollector;", "Lorg/jetbrains/kotlin/fir/resolve/SessionHolder;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "createComponents", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "Lorg/jetbrains/kotlin/fir/analysis/collectors/DiagnosticCollectorComponents;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;Lkotlin/jvm/functions/Function1;)V", "getCreateComponents", "()Lkotlin/jvm/functions/Function1;", "getScopeSession", "()Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "collectDiagnostics", "", "firDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "reporter", "collectDiagnosticsInSettings", "createVisitor", "Lorg/jetbrains/kotlin/fir/analysis/collectors/CheckerRunningDiagnosticCollectorVisitor;", "components", "Companion", "checkers"})
@SourceDebugExtension(value={"SMAP\nAbstractDiagnosticCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractDiagnosticCollector.kt\norg/jetbrains/kotlin/fir/analysis/collectors/AbstractDiagnosticCollector\n+ 2 FirLazyDeclarationResolver.kt\norg/jetbrains/kotlin/fir/symbols/FirLazyDeclarationResolver\n*L\n1#1,77:1\n34#2,6:78\n*S KotlinDebug\n*F\n+ 1 AbstractDiagnosticCollector.kt\norg/jetbrains/kotlin/fir/analysis/collectors/AbstractDiagnosticCollector\n*L\n36#1:78,6\n*E\n"})
public abstract class AbstractDiagnosticCollector
implements SessionHolder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FirSession session;
    @NotNull
    private final ScopeSession scopeSession;
    @NotNull
    private final Function1<DiagnosticReporter, DiagnosticCollectorComponents> createComponents;
    @NotNull
    public static final String SUPPRESS_ALL_INFOS = "infos";
    @NotNull
    public static final String SUPPRESS_ALL_WARNINGS = "warnings";
    @NotNull
    public static final String SUPPRESS_ALL_ERRORS = "errors";
    @NotNull
    private static final Name SUPPRESS_NAMES_NAME;

    public AbstractDiagnosticCollector(@NotNull FirSession session2, @NotNull ScopeSession scopeSession, @NotNull Function1<? super DiagnosticReporter, DiagnosticCollectorComponents> createComponents) {
        Intrinsics.checkNotNullParameter(session2, "session");
        Intrinsics.checkNotNullParameter(scopeSession, "scopeSession");
        Intrinsics.checkNotNullParameter(createComponents, "createComponents");
        this.session = session2;
        this.scopeSession = scopeSession;
        this.createComponents = createComponents;
    }

    public /* synthetic */ AbstractDiagnosticCollector(FirSession firSession, ScopeSession scopeSession, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            scopeSession = new ScopeSession();
        }
        this(firSession, scopeSession, function1);
    }

    @Override
    @NotNull
    public FirSession getSession() {
        return this.session;
    }

    @Override
    @NotNull
    public ScopeSession getScopeSession() {
        return this.scopeSession;
    }

    @NotNull
    protected final Function1<DiagnosticReporter, DiagnosticCollectorComponents> getCreateComponents() {
        return this.createComponents;
    }

    public final void collectDiagnosticsInSettings(@NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        CheckerRunningDiagnosticCollectorVisitor visitor2 = this.createVisitor(this.createComponents.invoke(reporter));
        visitor2.checkSettings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void collectDiagnostics(@NotNull FirDeclaration firDeclaration, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(firDeclaration, "firDeclaration");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        CheckerRunningDiagnosticCollectorVisitor visitor2 = this.createVisitor(this.createComponents.invoke(reporter));
        FirLazyDeclarationResolver this_$iv = FirLazyDeclarationResolverKt.getLazyDeclarationResolver(this.getSession());
        boolean $i$f$disableLazyResolveContractChecksInside = false;
        boolean current$iv = this_$iv.getLazyResolveContractChecksEnabled();
        this_$iv.setLazyResolveContractChecksEnabled(false);
        try {
            boolean bl = false;
            firDeclaration.accept(visitor2, null);
            Unit unit2 = Unit.INSTANCE;
        }
        finally {
            this_$iv.setLazyResolveContractChecksEnabled(current$iv);
        }
    }

    @NotNull
    protected abstract CheckerRunningDiagnosticCollectorVisitor createVisitor(@NotNull DiagnosticCollectorComponents var1);

    static {
        Name name2 = Name.identifier("names");
        Intrinsics.checkNotNullExpressionValue(name2, "identifier(...)");
        SUPPRESS_NAMES_NAME = name2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0002J\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/collectors/AbstractDiagnosticCollector$Companion;", "", "()V", "SUPPRESS_ALL_ERRORS", "", "SUPPRESS_ALL_INFOS", "SUPPRESS_ALL_WARNINGS", "SUPPRESS_NAMES_NAME", "Lorg/jetbrains/kotlin/name/Name;", "correctDiagnosticCase", "diagnostic", "getDiagnosticsSuppressedForContainer", "", "annotationContainer", "Lorg/jetbrains/kotlin/fir/FirAnnotationContainer;", "checkers"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Unable to fully structure code
         */
        private final String correctDiagnosticCase(String diagnostic) {
            block7: {
                var2_2 = diagnostic;
                switch (var2_2.hashCode()) {
                    case 498091095: {
                        if (!var2_2.equals("warnings")) {
                            break;
                        }
                        ** GOTO lbl13
                    }
                    case 100348293: {
                        if (!var2_2.equals("infos")) {
                            break;
                        }
                        ** GOTO lbl13
                    }
                    case -1294635157: {
                        if (!var2_2.equals("errors")) break;
lbl13:
                        // 3 sources

                        v0 = diagnostic;
                        break block7;
                    }
                }
                v1 = diagnostic.toUpperCase(Locale.ROOT);
                v0 = v1;
                Intrinsics.checkNotNullExpressionValue(v1, "toUpperCase(...)");
            }
            return v0;
        }

        @Nullable
        public final List<String> getDiagnosticsSuppressedForContainer(@NotNull FirAnnotationContainer annotationContainer) {
            Intrinsics.checkNotNullParameter(annotationContainer, "annotationContainer");
            List result2 = null;
            for (FirAnnotation annotation2 : annotationContainer.getAnnotations()) {
                Object object;
                ConeClassLikeType type2;
                Object object2 = FirTypeUtilsKt.getConeType(annotation2.getAnnotationTypeRef());
                ConeClassLikeType coneClassLikeType = object2 instanceof ConeClassLikeType ? (ConeClassLikeType)object2 : null;
                if (coneClassLikeType == null || !Intrinsics.areEqual((type2 = coneClassLikeType).getLookupTag().getClassId(), StandardClassIds.Annotations.INSTANCE.getSuppress()) || (object = FirAnnotationUtilsKt.findArgumentByName(annotation2, SUPPRESS_NAMES_NAME)) == null || (object = FirAnnotationUtilsKt.unwrapVarargValue((FirExpression)object)) == null) continue;
                Object argumentValues = object;
                object2 = argumentValues.iterator();
                while (object2.hasNext()) {
                    String value2;
                    FirExpression argumentValue = (FirExpression)object2.next();
                    FirConstExpression firConstExpression = argumentValue instanceof FirConstExpression ? (FirConstExpression)argumentValue : null;
                    Object object3 = firConstExpression != null ? firConstExpression.getValue() : null;
                    if ((object3 instanceof String ? (String)object3 : null) == null) continue;
                    value2 = value2;
                    if (result2 == null) {
                        result2 = new ArrayList();
                    }
                    result2.add(this.correctDiagnosticCase(value2));
                }
            }
            return result2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

