/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon.client;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.daemon.client.LimitedLinkedList;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\nH\u0002J\u0006\u0010\u0010\u001a\u00020\u0004R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/daemon/client/LastDaemonCliOutputs;", "", "()V", "ellipsisIfRequired", "", "getEllipsisIfRequired", "()Ljava/lang/String;", "lastPrintedLines", "", "totalCount", "", "add", "", "line", "calculateAbsoluteIndex", "relativeIndex", "getAsSingleString", "kotlin-daemon-client"})
@SourceDebugExtension(value={"SMAP\nLastDaemonCliOutputs.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LastDaemonCliOutputs.kt\norg/jetbrains/kotlin/daemon/client/LastDaemonCliOutputs\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,36:1\n1#2:37\n*E\n"})
public final class LastDaemonCliOutputs {
    @NotNull
    private final List<String> lastPrintedLines = new LimitedLinkedList(10);
    private int totalCount;

    public final void add(@NotNull String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        this.lastPrintedLines.add(line);
        int n = this.totalCount;
        this.totalCount = n + 1;
    }

    private final int calculateAbsoluteIndex(int relativeIndex) {
        return this.totalCount - this.lastPrintedLines.size() + relativeIndex;
    }

    private final String getEllipsisIfRequired() {
        return this.totalCount > 10 ? StringsKt.repeat((CharSequence)" ", (int)4) + "... (" + (this.totalCount - 10) + " more lines)" + System.lineSeparator() : "";
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final String getAsSingleString() {
        String string;
        Iterable iterable;
        List<String> list;
        List<String> list2;
        List<String> it = list2 = this.lastPrintedLines;
        boolean bl = false;
        List<String> list3 = list = !((Collection)it).isEmpty() ? list2 : null;
        if (list != null && (iterable = CollectionsKt.withIndex((Iterable)list)) != null) {
            String string2 = System.lineSeparator();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"lineSeparator()");
            String string3 = CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string2, (CharSequence)("The daemon process output:" + System.lineSeparator() + this.getEllipsisIfRequired()), null, (int)0, null, (Function1)((Function1)new Function1<IndexedValue<? extends String>, CharSequence>(this){
                final /* synthetic */ LastDaemonCliOutputs this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final CharSequence invoke(IndexedValue<String> indexedValue) {
                    Intrinsics.checkNotNullParameter(indexedValue, (String)"<name for destructuring parameter 0>");
                    int index = indexedValue.component1();
                    String line = (String)indexedValue.component2();
                    return StringsKt.repeat((CharSequence)" ", (int)4) + (LastDaemonCliOutputs.access$calculateAbsoluteIndex(this.this$0, index) + 1) + ". " + line;
                }
            }), (int)28, null);
            if (string3 != null) {
                string = string3;
                return string;
            }
        }
        string = StringsKt.repeat((CharSequence)" ", (int)4) + "The daemon process produced no output";
        return string;
    }

    public static final /* synthetic */ int access$calculateAbsoluteIndex(LastDaemonCliOutputs $this, int relativeIndex) {
        return $this.calculateAbsoluteIndex(relativeIndex);
    }
}

