/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirInlineCheckerPlatformSpecificComponent;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirScript;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J4\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150\u0014H\u0016\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/FirJvmInlineCheckerComponent;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/FirInlineCheckerPlatformSpecificComponent;", "<init>", "()V", "isGenerallyOk", "", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkSuspendFunctionalParameterWithDefaultValue", "", "param", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "checkFunctionalParametersWithInheritedDefaultValues", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "overriddenSymbols", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "checkers.jvm"})
@SourceDebugExtension(value={"SMAP\nFirJvmInlineCheckerComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJvmInlineCheckerComponent.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/FirJvmInlineCheckerComponent\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,67:1\n1368#2:68\n1454#2,2:69\n1577#2,11:71\n1872#2,2:82\n1874#2:86\n1588#2:87\n1456#2,3:88\n1872#2,3:91\n1#3:84\n1#3:85\n*S KotlinDebug\n*F\n+ 1 FirJvmInlineCheckerComponent.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/FirJvmInlineCheckerComponent\n*L\n49#1:68\n49#1:69,2\n51#1:71,11\n51#1:82,2\n51#1:86\n51#1:87\n49#1:88,3\n55#1:91,3\n51#1:85\n*E\n"})
public final class FirJvmInlineCheckerComponent
extends FirInlineCheckerPlatformSpecificComponent {
    @Override
    public boolean isGenerallyOk(@NotNull FirDeclaration declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        boolean bl;
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        if (DeclarationUtilsKt.isLocalMember(declaration) && !(CollectionsKt.lastOrNull(context.getContainingDeclarations()) instanceof FirScript)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirJvmErrors.INSTANCE.getNOT_YET_SUPPORTED_LOCAL_INLINE_FUNCTION(), (DiagnosticContext)context, null, 8, null);
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }

    @Override
    public void checkSuspendFunctionalParameterWithDefaultValue(@NotNull FirValueParameter param, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(param, "param");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)param.getSource(), FirErrors.INSTANCE.getNOT_YET_SUPPORTED_IN_INLINE(), (Object)"Suspend functional parameters with default values", (DiagnosticContext)context, null, 16, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void checkFunctionalParametersWithInheritedDefaultValues(@NotNull FirSimpleFunction function2, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @NotNull List<? extends FirCallableSymbol<? extends FirCallableDeclaration>> overriddenSymbols) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(function2, "function");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(overriddenSymbols, "overriddenSymbols");
        Iterable $this$flatMap$iv = overriddenSymbols;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Iterable iterable2;
            FirCallableSymbol it = (FirCallableSymbol)element$iv$iv;
            boolean bl = false;
            if (!(it instanceof FirFunctionSymbol)) {
                iterable2 = CollectionsKt.emptyList();
            } else {
                void $this$mapIndexedNotNullTo$iv$iv;
                Iterable $this$mapIndexedNotNull$iv = ((FirFunctionSymbol)it).getValueParameterSymbols();
                boolean $i$f$mapIndexedNotNull = false;
                Iterable iterable3 = $this$mapIndexedNotNull$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapIndexedNotNullTo = false;
                void $this$forEachIndexed$iv$iv$iv = $this$mapIndexedNotNullTo$iv$iv;
                boolean $i$f$forEachIndexed = false;
                int index$iv$iv$iv = 0;
                for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
                    Integer it$iv$iv;
                    void param;
                    void element$iv$iv2;
                    int n;
                    if ((n = index$iv$iv$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    Object t = item$iv$iv$iv;
                    int index$iv$iv = n;
                    boolean bl2 = false;
                    FirValueParameterSymbol firValueParameterSymbol = (FirValueParameterSymbol)element$iv$iv2;
                    int idx = index$iv$iv;
                    boolean bl3 = false;
                    Integer n2 = idx;
                    int it2 = ((Number)n2).intValue();
                    boolean bl4 = false;
                    if ((param.getHasDefaultValue() ? n2 : null) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl5 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                iterable2 = (List)destination$iv$iv2;
            }
            Iterable list$iv$iv = iterable2;
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        Set paramsWithDefaults = CollectionsKt.toSet((List)destination$iv$iv);
        Iterable $this$forEachIndexed$iv = function2.getValueParameters();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void param;
            int n;
            Object element$iv$iv;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            element$iv$iv = (FirValueParameter)item$iv;
            int idx = n;
            boolean bl = false;
            if (param.getDefaultValue() != null || !paramsWithDefaults.contains(idx)) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)param.getSource(), FirErrors.INSTANCE.getNOT_YET_SUPPORTED_IN_INLINE(), (Object)"Functional parameters with inherited default values", (DiagnosticContext)context, null, 16, null);
        }
    }
}

